/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.LineIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public abstract class Line2D
implements Shape,
Cloneable {
    protected Line2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(Point2D point2D, Point2D point2D2) {
        this.setLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setLine(Line2D line2D) {
        this.setLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public static int relativeCCW(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d5 -= d) * (d4 -= d2) - (d6 -= d2) * (d3 -= d);
        if (d7 == 0.0 && (d7 = d5 * d3 + d6 * d4) > 0.0 && (d7 = (d5 -= d3) * d3 + (d6 -= d4) * d4) < 0.0) {
            d7 = 0.0;
        }
        return d7 < 0.0 ? -1 : (d7 > 0.0 ? 1 : 0);
    }

    public int relativeCCW(double d, double d2) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public int relativeCCW(Point2D point2D) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public static boolean linesIntersect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return Line2D.relativeCCW(d, d2, d3, d4, d5, d6) * Line2D.relativeCCW(d, d2, d3, d4, d7, d8) <= 0 && Line2D.relativeCCW(d5, d6, d7, d8, d, d2) * Line2D.relativeCCW(d5, d6, d7, d8, d3, d4) <= 0;
    }

    public boolean intersectsLine(double d, double d2, double d3, double d4) {
        return Line2D.linesIntersect(d, d2, d3, d4, this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean intersectsLine(Line2D line2D) {
        return Line2D.linesIntersect(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public static double ptSegDistSq(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = (d5 -= d) * (d3 -= d) + (d6 -= d2) * (d4 -= d2);
        if ((d8 = d5 * d5 + d6 * d6 - (d7 = d9 <= 0.0 ? 0.0 : ((d9 = (d5 = d3 - d5) * d3 + (d6 = d4 - d6) * d4) <= 0.0 ? 0.0 : d9 * d9 / (d3 * d3 + d4 * d4)))) < 0.0) {
            d8 = 0.0;
        }
        return d8;
    }

    public static double ptSegDist(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.sqrt(Line2D.ptSegDistSq(d, d2, d3, d4, d5, d6));
    }

    public double ptSegDistSq(double d, double d2) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public double ptSegDistSq(Point2D point2D) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public double ptSegDist(double d, double d2) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public double ptSegDist(Point2D point2D) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public static double ptLineDistSq(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        if ((d9 = (d5 -= d) * d5 + (d6 -= d2) * d6 - (d8 = (d7 = d5 * (d3 -= d) + d6 * (d4 -= d2)) * d7 / (d3 * d3 + d4 * d4))) < 0.0) {
            d9 = 0.0;
        }
        return d9;
    }

    public static double ptLineDist(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.sqrt(Line2D.ptLineDistSq(d, d2, d3, d4, d5, d6));
    }

    public double ptLineDistSq(double d, double d2) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public double ptLineDistSq(Point2D point2D) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public double ptLineDist(double d, double d2) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public double ptLineDist(Point2D point2D) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    @Override
    public boolean contains(double d, double d2) {
        return false;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return false;
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.intersects(new Rectangle2D.Double(d, d2, d3, d4));
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return rectangle2D.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new LineIterator(this, affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new LineIterator(this, affineTransform);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    public static class Double
    extends Line2D
    implements Serializable {
        public double x1;
        public double y1;
        public double x2;
        public double y2;
        private static final long serialVersionUID = 7979627399746467499L;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4) {
            this.setLine(d, d2, d3, d4);
        }

        public Double(Point2D point2D, Point2D point2D2) {
            this.setLine(point2D, point2D2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        @Override
        public void setLine(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
        }

        @Override
        public Rectangle2D getBounds2D() {
            double d;
            double d2;
            double d3;
            double d4;
            if (this.x1 < this.x2) {
                d4 = this.x1;
                d3 = this.x2 - this.x1;
            } else {
                d4 = this.x2;
                d3 = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                d2 = this.y1;
                d = this.y2 - this.y1;
            } else {
                d2 = this.y2;
                d = this.y1 - this.y2;
            }
            return new Rectangle2D.Double(d4, d2, d3, d);
        }
    }

    public static class Float
    extends Line2D
    implements Serializable {
        public float x1;
        public float y1;
        public float x2;
        public float y2;
        private static final long serialVersionUID = 6161772511649436349L;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4) {
            this.setLine(f, f2, f3, f4);
        }

        public Float(Point2D point2D, Point2D point2D2) {
            this.setLine(point2D, point2D2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        @Override
        public void setLine(double d, double d2, double d3, double d4) {
            this.x1 = (float)d;
            this.y1 = (float)d2;
            this.x2 = (float)d3;
            this.y2 = (float)d4;
        }

        public void setLine(float f, float f2, float f3, float f4) {
            this.x1 = f;
            this.y1 = f2;
            this.x2 = f3;
            this.y2 = f4;
        }

        @Override
        public Rectangle2D getBounds2D() {
            float f;
            float f2;
            float f3;
            float f4;
            if (this.x1 < this.x2) {
                f4 = this.x1;
                f3 = this.x2 - this.x1;
            } else {
                f4 = this.x2;
                f3 = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                f2 = this.y1;
                f = this.y2 - this.y1;
            } else {
                f2 = this.y2;
                f = this.y1 - this.y2;
            }
            return new Rectangle2D.Float(f4, f2, f3, f);
        }
    }
}

