/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface Collector<T, A, R> {
    public Supplier<A> supplier();

    public BiConsumer<A, T> accumulator();

    public BinaryOperator<A> combiner();

    public Function<A, R> finisher();

    public Set<Characteristics> characteristics();

    public static <T, R> Collector<T, R, R> of(Supplier<R> supplier, BiConsumer<R, T> biConsumer, BinaryOperator<R> binaryOperator, Characteristics ... characteristicsArray) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(biConsumer);
        Objects.requireNonNull(binaryOperator);
        Objects.requireNonNull(characteristicsArray);
        Set<Characteristics> set = characteristicsArray.length == 0 ? Collectors.CH_ID : Collections.unmodifiableSet(EnumSet.of(Characteristics.IDENTITY_FINISH, characteristicsArray));
        return new Collectors.CollectorImpl(supplier, biConsumer, binaryOperator, set);
    }

    public static <T, A, R> Collector<T, A, R> of(Supplier<A> supplier, BiConsumer<A, T> biConsumer, BinaryOperator<A> binaryOperator, Function<A, R> function, Characteristics ... characteristicsArray) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(biConsumer);
        Objects.requireNonNull(binaryOperator);
        Objects.requireNonNull(function);
        Objects.requireNonNull(characteristicsArray);
        Set<Characteristics> set = Collectors.CH_NOID;
        if (characteristicsArray.length > 0) {
            set = EnumSet.noneOf(Characteristics.class);
            Collections.addAll(set, characteristicsArray);
            set = Collections.unmodifiableSet(set);
        }
        return new Collectors.CollectorImpl<T, A, R>(supplier, biConsumer, binaryOperator, function, set);
    }

    public static enum Characteristics {
        CONCURRENT,
        UNORDERED,
        IDENTITY_FINISH;

    }
}

