/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    transient Object[] table;
    int size;
    transient int modCount;
    static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 8188218128353913216L;

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    static final Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    public IdentityHashMap() {
        this.init(32);
    }

    public IdentityHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + n);
        }
        this.init(IdentityHashMap.capacity(n));
    }

    private static int capacity(int n) {
        return n > 0xAAAAAAA ? 0x20000000 : (n <= 2 ? 4 : Integer.highestOneBit(n + (n << 1)));
    }

    private void init(int n) {
        this.table = new Object[2 * n];
    }

    public IdentityHashMap(Map<? extends K, ? extends V> map) {
        this((int)((double)(1 + map.size()) * 1.1));
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object object, int n) {
        int n2 = System.identityHashCode(object);
        return (n2 << 1) - (n2 << 8) & n - 1;
    }

    private static int nextKeyIndex(int n, int n2) {
        return n + 2 < n2 ? n + 2 : 0;
    }

    @Override
    public V get(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        Object object3;
        while ((object3 = objectArray[n2]) != object2) {
            if (object3 == null) {
                return null;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return (V)objectArray[n2 + 1];
    }

    @Override
    public boolean containsKey(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        Object object3;
        while ((object3 = objectArray[n2]) != object2) {
            if (object3 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        Object[] objectArray = this.table;
        for (int i = 1; i < objectArray.length; i += 2) {
            if (objectArray[i] != object || objectArray[i - 1] == null) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object3, n);
        Object object4;
        while ((object4 = objectArray[n2]) != object3) {
            if (object4 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return objectArray[n2 + 1] == object2;
    }

    @Override
    public V put(K k, V v) {
        int n;
        int n2;
        Object object = IdentityHashMap.maskNull(k);
        do {
            Object object2;
            Object[] objectArray = this.table;
            n = objectArray.length;
            int n3 = IdentityHashMap.hash(object, n);
            while ((object2 = objectArray[n3]) != null) {
                if (object2 == object) {
                    Object object3 = objectArray[n3 + 1];
                    objectArray[n3 + 1] = v;
                    return (V)object3;
                }
                n3 = IdentityHashMap.nextKeyIndex(n3, n);
            }
        } while ((n2 = this.size + 1) + (n2 << 1) > n && this.resize(n));
        ++this.modCount;
        objectArray[n3] = object;
        objectArray[n3 + 1] = v;
        this.size = n2;
        return null;
    }

    private boolean resize(int n) {
        int n2 = n * 2;
        Object[] objectArray = this.table;
        int n3 = objectArray.length;
        if (n3 == 0x40000000) {
            if (this.size == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            return false;
        }
        if (n3 >= n2) {
            return false;
        }
        Object[] objectArray2 = new Object[n2];
        for (int i = 0; i < n3; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            Object object2 = objectArray[i + 1];
            objectArray[i] = null;
            objectArray[i + 1] = null;
            int n4 = IdentityHashMap.hash(object, n2);
            while (objectArray2[n4] != null) {
                n4 = IdentityHashMap.nextKeyIndex(n4, n2);
            }
            objectArray2[n4] = object;
            objectArray2[n4 + 1] = object2;
        }
        this.table = objectArray2;
        return true;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.size) {
            this.resize(IdentityHashMap.capacity(n));
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        while (true) {
            Object object3;
            if ((object3 = objectArray[n2]) == object2) {
                ++this.modCount;
                --this.size;
                Object object4 = objectArray[n2 + 1];
                objectArray[n2 + 1] = null;
                objectArray[n2] = null;
                this.closeDeletion(n2);
                return (V)object4;
            }
            if (object3 == null) {
                return null;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
    }

    private boolean removeMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object3, n);
        while (true) {
            Object object4;
            if ((object4 = objectArray[n2]) == object3) {
                if (objectArray[n2 + 1] != object2) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                objectArray[n2] = null;
                objectArray[n2 + 1] = null;
                this.closeDeletion(n2);
                return true;
            }
            if (object4 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
    }

    private void closeDeletion(int n) {
        Object object;
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.nextKeyIndex(n, n2);
        while ((object = objectArray[n3]) != null) {
            int n4 = IdentityHashMap.hash(object, n2);
            if (n3 < n4 && (n4 <= n || n <= n3) || n4 <= n && n <= n3) {
                objectArray[n] = object;
                objectArray[n + 1] = objectArray[n3 + 1];
                objectArray[n3] = null;
                objectArray[n3 + 1] = null;
                n = n3;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentityHashMap) {
            IdentityHashMap identityHashMap = (IdentityHashMap)object;
            if (identityHashMap.size() != this.size) {
                return false;
            }
            Object[] objectArray = identityHashMap.table;
            for (int i = 0; i < objectArray.length; i += 2) {
                Object object2 = objectArray[i];
                if (object2 == null || this.containsMapping(object2, objectArray[i + 1])) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            Object object2 = IdentityHashMap.unmaskNull(object);
            n += System.identityHashCode(object2) ^ System.identityHashCode(objectArray[i + 1]);
        }
        return n;
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.entrySet = null;
            identityHashMap.table = (Object[])this.table.clone();
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values();
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            objectOutputStream.writeObject(IdentityHashMap.unmaskNull(object));
            objectOutputStream.writeObject(objectArray[i + 1]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n < 0) {
            throw new StreamCorruptedException("Illegal mappings count: " + n);
        }
        this.init(IdentityHashMap.capacity(n));
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    private void putForCreate(K k, V v) throws StreamCorruptedException {
        Object object;
        Object object2 = IdentityHashMap.maskNull(k);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        while ((object = objectArray[n2]) != null) {
            if (object == object2) {
                throw new StreamCorruptedException();
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        objectArray[n2] = object2;
        objectArray[n2 + 1] = v;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Objects.requireNonNull(biConsumer);
        int n = this.modCount;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object != null) {
                biConsumer.accept(IdentityHashMap.unmaskNull(object), objectArray[i + 1]);
            }
            if (this.modCount == n) continue;
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        int n = this.modCount;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object != null) {
                objectArray[i + 1] = biFunction.apply(IdentityHashMap.unmaskNull(object), objectArray[i + 1]);
            }
            if (this.modCount == n) continue;
            throw new ConcurrentModificationException();
        }
    }

    static final class EntrySpliterator<K, V>
    extends IdentityHashMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(IdentityHashMap<K, V> identityHashMap, int n, int n2, int n3, int n4) {
            super(identityHashMap, n, n2, n3, n4);
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1 & 0xFFFFFFFE;
            if (n >= n3) {
                entrySpliterator = null;
            } else {
                this.index = n3;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, n, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            IdentityHashMap identityHashMap = this.map;
            if (identityHashMap != null) {
                int n;
                Object[] objectArray = identityHashMap.table;
                if (identityHashMap.table != null && (n = this.index) >= 0) {
                    int n2;
                    this.index = n2 = this.getFence();
                    if (n2 <= objectArray.length) {
                        while (n < n2) {
                            Object object = objectArray[n];
                            if (object != null) {
                                Object object2 = IdentityHashMap.unmaskNull(object);
                                Object object3 = objectArray[n + 1];
                                consumer.accept(new AbstractMap.SimpleImmutableEntry<Object, Object>(object2, object3));
                            }
                            n += 2;
                        }
                        if (identityHashMap.modCount == this.expectedModCount) {
                            return;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Object[] objectArray = this.map.table;
            int n = this.getFence();
            while (this.index < n) {
                Object object = objectArray[this.index];
                Object object2 = objectArray[this.index + 1];
                this.index += 2;
                if (object == null) continue;
                Object object3 = IdentityHashMap.unmaskNull(object);
                consumer.accept(new AbstractMap.SimpleImmutableEntry<Object, Object>(object3, object2));
                if (this.map.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static final class ValueSpliterator<K, V>
    extends IdentityHashMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(IdentityHashMap<K, V> identityHashMap, int n, int n2, int n3, int n4) {
            super(identityHashMap, n, n2, n3, n4);
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1 & 0xFFFFFFFE;
            if (n >= n3) {
                valueSpliterator = null;
            } else {
                this.index = n3;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, n, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            IdentityHashMap identityHashMap = this.map;
            if (identityHashMap != null) {
                int n;
                Object[] objectArray = identityHashMap.table;
                if (identityHashMap.table != null && (n = this.index) >= 0) {
                    int n2;
                    this.index = n2 = this.getFence();
                    if (n2 <= objectArray.length) {
                        while (n < n2) {
                            if (objectArray[n] != null) {
                                Object object = objectArray[n + 1];
                                consumer.accept(object);
                            }
                            n += 2;
                        }
                        if (identityHashMap.modCount == this.expectedModCount) {
                            return;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Object[] objectArray = this.map.table;
            int n = this.getFence();
            while (this.index < n) {
                Object object = objectArray[this.index];
                Object object2 = objectArray[this.index + 1];
                this.index += 2;
                if (object == null) continue;
                consumer.accept(object2);
                if (this.map.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return this.fence < 0 || this.est == this.map.size ? 64 : 0;
        }
    }

    static final class KeySpliterator<K, V>
    extends IdentityHashMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(IdentityHashMap<K, V> identityHashMap, int n, int n2, int n3, int n4) {
            super(identityHashMap, n, n2, n3, n4);
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1 & 0xFFFFFFFE;
            if (n >= n3) {
                keySpliterator = null;
            } else {
                this.index = n3;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, n, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            IdentityHashMap identityHashMap = this.map;
            if (identityHashMap != null) {
                int n;
                Object[] objectArray = identityHashMap.table;
                if (identityHashMap.table != null && (n = this.index) >= 0) {
                    int n2;
                    this.index = n2 = this.getFence();
                    if (n2 <= objectArray.length) {
                        while (n < n2) {
                            Object object = objectArray[n];
                            if (object != null) {
                                consumer.accept(IdentityHashMap.unmaskNull(object));
                            }
                            n += 2;
                        }
                        if (identityHashMap.modCount == this.expectedModCount) {
                            return;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Object[] objectArray = this.map.table;
            int n = this.getFence();
            while (this.index < n) {
                Object object = objectArray[this.index];
                this.index += 2;
                if (object == null) continue;
                consumer.accept(IdentityHashMap.unmaskNull(object));
                if (this.map.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static class IdentityHashMapSpliterator<K, V> {
        final IdentityHashMap<K, V> map;
        int index;
        int fence;
        int est;
        int expectedModCount;

        IdentityHashMapSpliterator(IdentityHashMap<K, V> identityHashMap, int n, int n2, int n3, int n4) {
            this.map = identityHashMap;
            this.index = n;
            this.fence = n2;
            this.est = n3;
            this.expectedModCount = n4;
        }

        final int getFence() {
            int n = this.fence;
            if (n < 0) {
                this.est = this.map.size;
                this.expectedModCount = this.map.modCount;
                n = this.fence = this.map.table.length;
            }
            return n;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Objects.requireNonNull(collection);
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = IdentityHashMap.this.modCount;
            int n2 = this.size();
            if (objectArray.length < n2) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
            }
            Object[] objectArray2 = IdentityHashMap.this.table;
            int n3 = 0;
            for (int i = 0; i < objectArray2.length; i += 2) {
                Object object = objectArray2[i];
                if (object == null) continue;
                if (n3 >= n2) {
                    throw new ConcurrentModificationException();
                }
                objectArray[n3++] = new AbstractMap.SimpleEntry<Object, Object>(IdentityHashMap.unmaskNull(object), objectArray2[i + 1]);
            }
            if (n3 < n2 || n != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (n3 < objectArray.length) {
                objectArray[n3] = null;
            }
            return objectArray;
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(IdentityHashMap.this, 0, -1, 0, 0);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return IdentityHashMap.this.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != object) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = IdentityHashMap.this.modCount;
            int n2 = this.size();
            if (objectArray.length < n2) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
            }
            Object[] objectArray2 = IdentityHashMap.this.table;
            int n3 = 0;
            for (int i = 0; i < objectArray2.length; i += 2) {
                if (objectArray2[i] == null) continue;
                if (n3 >= n2) {
                    throw new ConcurrentModificationException();
                }
                objectArray[n3++] = objectArray2[i + 1];
            }
            if (n3 < n2 || n != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (n3 < objectArray.length) {
                objectArray[n3] = null;
            }
            return objectArray;
        }

        @Override
        public Spliterator<V> spliterator() {
            return new ValueSpliterator(IdentityHashMap.this, 0, -1, 0, 0);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return IdentityHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n = IdentityHashMap.this.size;
            IdentityHashMap.this.remove(object);
            return IdentityHashMap.this.size != n;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Objects.requireNonNull(collection);
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (Object k : this) {
                n += System.identityHashCode(k);
            }
            return n;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = IdentityHashMap.this.modCount;
            int n2 = this.size();
            if (objectArray.length < n2) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
            }
            Object[] objectArray2 = IdentityHashMap.this.table;
            int n3 = 0;
            for (int i = 0; i < objectArray2.length; i += 2) {
                Object object = objectArray2[i];
                if (object == null) continue;
                if (n3 >= n2) {
                    throw new ConcurrentModificationException();
                }
                objectArray[n3++] = IdentityHashMap.unmaskNull(object);
            }
            if (n3 < n2 || n != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (n3 < objectArray.length) {
                objectArray[n3] = null;
            }
            return objectArray;
        }

        @Override
        public Spliterator<K> spliterator() {
            return new KeySpliterator(IdentityHashMap.this, 0, -1, 0, 0);
        }
    }

    private class EntryIterator
    extends IdentityHashMapIterator<Map.Entry<K, V>> {
        private java.util.IdentityHashMap$EntryIterator.Entry lastReturnedEntry;

        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.lastReturnedEntry = new Entry(this.nextIndex());
            return this.lastReturnedEntry;
        }

        @Override
        public void remove() {
            this.lastReturnedIndex = null == this.lastReturnedEntry ? -1 : ((Entry)this.lastReturnedEntry).index;
            super.remove();
            ((Entry)this.lastReturnedEntry).index = this.lastReturnedIndex;
            this.lastReturnedEntry = null;
        }

        private class Entry
        implements Map.Entry<K, V> {
            private int index;

            private Entry(int n) {
                this.index = n;
            }

            @Override
            public K getKey() {
                this.checkIndexForEntryUse();
                return IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index]);
            }

            @Override
            public V getValue() {
                this.checkIndexForEntryUse();
                return EntryIterator.this.traversalTable[this.index + 1];
            }

            @Override
            public V setValue(V v) {
                this.checkIndexForEntryUse();
                Object object = EntryIterator.this.traversalTable[this.index + 1];
                EntryIterator.this.traversalTable[this.index + 1] = v;
                if (EntryIterator.this.traversalTable != IdentityHashMap.this.table) {
                    IdentityHashMap.this.put(EntryIterator.this.traversalTable[this.index], v);
                }
                return object;
            }

            @Override
            public boolean equals(Object object) {
                if (this.index < 0) {
                    return super.equals(object);
                }
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return entry.getKey() == IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index]) && entry.getValue() == EntryIterator.this.traversalTable[this.index + 1];
            }

            @Override
            public int hashCode() {
                if (EntryIterator.this.lastReturnedIndex < 0) {
                    return super.hashCode();
                }
                return System.identityHashCode(IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index])) ^ System.identityHashCode(EntryIterator.this.traversalTable[this.index + 1]);
            }

            public String toString() {
                if (this.index < 0) {
                    return super.toString();
                }
                return IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index]) + "=" + EntryIterator.this.traversalTable[this.index + 1];
            }

            private void checkIndexForEntryUse() {
                if (this.index < 0) {
                    throw new IllegalStateException("Entry was removed");
                }
            }
        }
    }

    private class ValueIterator
    extends IdentityHashMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.traversalTable[this.nextIndex() + 1];
        }
    }

    private class KeyIterator
    extends IdentityHashMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return IdentityHashMap.unmaskNull(this.traversalTable[this.nextIndex()]);
        }
    }

    private abstract class IdentityHashMapIterator<T>
    implements Iterator<T> {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        private IdentityHashMapIterator() {
            this.index = IdentityHashMap.this.size != 0 ? 0 : IdentityHashMap.this.table.length;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            Object[] objectArray = this.traversalTable;
            for (int i = this.index; i < objectArray.length; i += 2) {
                Object object = objectArray[i];
                if (object == null) continue;
                this.index = i;
                this.indexValid = true;
                return true;
            }
            this.index = objectArray.length;
            return false;
        }

        protected int nextIndex() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        @Override
        public void remove() {
            Object object;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityHashMap.this.modCount;
            int n = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            this.index = n;
            this.indexValid = false;
            Object[] objectArray = this.traversalTable;
            int n2 = objectArray.length;
            int n3 = n;
            Object object2 = objectArray[n3];
            objectArray[n3] = null;
            objectArray[n3 + 1] = null;
            if (objectArray != IdentityHashMap.this.table) {
                IdentityHashMap.this.remove(object2);
                this.expectedModCount = IdentityHashMap.this.modCount;
                return;
            }
            --IdentityHashMap.this.size;
            int n4 = IdentityHashMap.nextKeyIndex(n3, n2);
            while ((object = objectArray[n4]) != null) {
                int n5 = IdentityHashMap.hash(object, n2);
                if (n4 < n5 && (n5 <= n3 || n3 <= n4) || n5 <= n3 && n3 <= n4) {
                    if (n4 < n && n3 >= n && this.traversalTable == IdentityHashMap.this.table) {
                        int n6 = n2 - n;
                        Object[] objectArray2 = new Object[n6];
                        System.arraycopy(objectArray, n, objectArray2, 0, n6);
                        this.traversalTable = objectArray2;
                        this.index = 0;
                    }
                    objectArray[n3] = object;
                    objectArray[n3 + 1] = objectArray[n4 + 1];
                    objectArray[n4] = null;
                    objectArray[n4 + 1] = null;
                    n3 = n4;
                }
                n4 = IdentityHashMap.nextKeyIndex(n4, n2);
            }
        }
    }
}

