/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.io.ByteArrayOutputStream;
import sun.font.GlyphList;
import sun.font.StrikeCache;

public class XRGlyphCacheEntry {
    long glyphInfoPtr;
    int lastUsed;
    boolean pinned;
    int xOff;
    int yOff;
    int glyphSet;

    public XRGlyphCacheEntry(long l, GlyphList glyphList) {
        this.glyphInfoPtr = l;
        this.xOff = Math.round(this.getXAdvance());
        this.yOff = Math.round(this.getYAdvance());
    }

    public int getXOff() {
        return this.xOff;
    }

    public int getYOff() {
        return this.yOff;
    }

    public void setGlyphSet(int n) {
        this.glyphSet = n;
    }

    public int getGlyphSet() {
        return this.glyphSet;
    }

    public static int getGlyphID(long l) {
        return (int)StrikeCache.unsafe.getAddress(l + (long)StrikeCache.cacheCellOffset);
    }

    public static void setGlyphID(long l, int n) {
        StrikeCache.unsafe.putAddress(l + (long)StrikeCache.cacheCellOffset, n);
    }

    public int getGlyphID() {
        return XRGlyphCacheEntry.getGlyphID(this.glyphInfoPtr);
    }

    public void setGlyphID(int n) {
        XRGlyphCacheEntry.setGlyphID(this.glyphInfoPtr, n);
    }

    public float getXAdvance() {
        return StrikeCache.unsafe.getFloat(this.glyphInfoPtr + (long)StrikeCache.xAdvanceOffset);
    }

    public float getYAdvance() {
        return StrikeCache.unsafe.getFloat(this.glyphInfoPtr + (long)StrikeCache.yAdvanceOffset);
    }

    public int getSourceRowBytes() {
        return StrikeCache.unsafe.getShort(this.glyphInfoPtr + (long)StrikeCache.rowBytesOffset);
    }

    public int getWidth() {
        return StrikeCache.unsafe.getShort(this.glyphInfoPtr + (long)StrikeCache.widthOffset);
    }

    public int getHeight() {
        return StrikeCache.unsafe.getShort(this.glyphInfoPtr + (long)StrikeCache.heightOffset);
    }

    public void writePixelData(ByteArrayOutputStream byteArrayOutputStream, boolean bl) {
        long l = StrikeCache.unsafe.getAddress(this.glyphInfoPtr + (long)StrikeCache.pixelDataOffset);
        if (l == 0L) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getSourceRowBytes();
        int n4 = this.getPaddedWidth(bl);
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n4; ++j) {
                    if (j < n) {
                        byteArrayOutputStream.write(StrikeCache.unsafe.getByte(l + (long)(i * n3 + j)));
                        continue;
                    }
                    byteArrayOutputStream.write(0);
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n5 = i * n3;
                int n6 = n * 3;
                for (int j = 0; j < n6; j += 3) {
                    byteArrayOutputStream.write(StrikeCache.unsafe.getByte(l + (long)(n5 + j + 2)));
                    byteArrayOutputStream.write(StrikeCache.unsafe.getByte(l + (long)(n5 + j + 1)));
                    byteArrayOutputStream.write(StrikeCache.unsafe.getByte(l + (long)(n5 + j + 0)));
                    byteArrayOutputStream.write(255);
                }
            }
        }
    }

    public float getTopLeftXOffset() {
        return StrikeCache.unsafe.getFloat(this.glyphInfoPtr + (long)StrikeCache.topLeftXOffset);
    }

    public float getTopLeftYOffset() {
        return StrikeCache.unsafe.getFloat(this.glyphInfoPtr + (long)StrikeCache.topLeftYOffset);
    }

    public long getGlyphInfoPtr() {
        return this.glyphInfoPtr;
    }

    public boolean isGrayscale(boolean bl) {
        return this.getSourceRowBytes() == this.getWidth() && (this.getWidth() != 0 || this.getHeight() != 0 || !bl);
    }

    public int getPaddedWidth(boolean bl) {
        int n = this.getWidth();
        return this.isGrayscale(bl) ? (int)Math.ceil((double)n / 4.0) * 4 : n;
    }

    public int getDestinationRowBytes(boolean bl) {
        boolean bl2 = this.isGrayscale(bl);
        return bl2 ? this.getPaddedWidth(bl2) : this.getWidth() * 4;
    }

    public int getGlyphDataLenth(boolean bl) {
        return this.getDestinationRowBytes(bl) * this.getHeight();
    }

    public void setPinned() {
        this.pinned = true;
    }

    public void setUnpinned() {
        this.pinned = false;
    }

    public int getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(int n) {
        this.lastUsed = n;
    }

    public int getPixelCnt() {
        return this.getWidth() * this.getHeight();
    }

    public boolean isPinned() {
        return this.pinned;
    }
}

