/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class CharsetDecoder {
    private final Charset charset;
    private final float averageCharsPerByte;
    private final float maxCharsPerByte;
    private String replacement;
    private CodingErrorAction malformedInputAction = CodingErrorAction.REPORT;
    private CodingErrorAction unmappableCharacterAction = CodingErrorAction.REPORT;
    private static final int ST_RESET = 0;
    private static final int ST_CODING = 1;
    private static final int ST_END = 2;
    private static final int ST_FLUSHED = 3;
    private int state = 0;
    private static String[] stateNames = new String[]{"RESET", "CODING", "CODING_END", "FLUSHED"};

    private CharsetDecoder(Charset charset, float f, float f2, String string) {
        this.charset = charset;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Non-positive averageCharsPerByte");
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Non-positive maxCharsPerByte");
        }
        if (!Charset.atBugLevel("1.4") && f > f2) {
            throw new IllegalArgumentException("averageCharsPerByte exceeds maxCharsPerByte");
        }
        this.replacement = string;
        this.averageCharsPerByte = f;
        this.maxCharsPerByte = f2;
        this.replaceWith(string);
    }

    protected CharsetDecoder(Charset charset, float f, float f2) {
        this(charset, f, f2, "\ufffd");
    }

    public final Charset charset() {
        return this.charset;
    }

    public final String replacement() {
        return this.replacement;
    }

    public final CharsetDecoder replaceWith(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null replacement");
        }
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException("Empty replacement");
        }
        if ((float)n > this.maxCharsPerByte) {
            throw new IllegalArgumentException("Replacement too long");
        }
        this.replacement = string;
        this.implReplaceWith(string);
        return this;
    }

    protected void implReplaceWith(String string) {
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final CharsetDecoder onMalformedInput(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.malformedInputAction = codingErrorAction;
        this.implOnMalformedInput(codingErrorAction);
        return this;
    }

    protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    public final CharsetDecoder onUnmappableCharacter(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.unmappableCharacterAction = codingErrorAction;
        this.implOnUnmappableCharacter(codingErrorAction);
        return this;
    }

    protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
    }

    public final float averageCharsPerByte() {
        return this.averageCharsPerByte;
    }

    public final float maxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public final CoderResult decode(ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        int n;
        int n2 = n = bl ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || bl && this.state == 2)) {
            this.throwIllegalStateException(this.state, n);
        }
        this.state = n;
        while (true) {
            CoderResult coderResult;
            try {
                coderResult = this.decodeLoop(byteBuffer, charBuffer);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw new CoderMalfunctionError(bufferUnderflowException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new CoderMalfunctionError(bufferOverflowException);
            }
            if (coderResult.isOverflow()) {
                return coderResult;
            }
            if (coderResult.isUnderflow()) {
                if (bl && byteBuffer.hasRemaining()) {
                    coderResult = CoderResult.malformedForLength(byteBuffer.remaining());
                } else {
                    return coderResult;
                }
            }
            CodingErrorAction codingErrorAction = null;
            if (coderResult.isMalformed()) {
                codingErrorAction = this.malformedInputAction;
            } else if (coderResult.isUnmappable()) {
                codingErrorAction = this.unmappableCharacterAction;
            } else assert (false) : coderResult.toString();
            if (codingErrorAction == CodingErrorAction.REPORT) {
                return coderResult;
            }
            if (codingErrorAction == CodingErrorAction.REPLACE) {
                if (charBuffer.remaining() < this.replacement.length()) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put(this.replacement);
            }
            if (codingErrorAction == CodingErrorAction.IGNORE || codingErrorAction == CodingErrorAction.REPLACE) {
                byteBuffer.position(byteBuffer.position() + coderResult.length());
                continue;
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    public final CoderResult flush(CharBuffer charBuffer) {
        if (this.state == 2) {
            CoderResult coderResult = this.implFlush(charBuffer);
            if (coderResult.isUnderflow()) {
                this.state = 3;
            }
            return coderResult;
        }
        if (this.state != 3) {
            this.throwIllegalStateException(this.state, 3);
        }
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult implFlush(CharBuffer charBuffer) {
        return CoderResult.UNDERFLOW;
    }

    public final CharsetDecoder reset() {
        this.implReset();
        this.state = 0;
        return this;
    }

    protected void implReset() {
    }

    protected abstract CoderResult decodeLoop(ByteBuffer var1, CharBuffer var2);

    public final CharBuffer decode(ByteBuffer byteBuffer) throws CharacterCodingException {
        int n = (int)((float)byteBuffer.remaining() * this.averageCharsPerByte());
        CharBuffer charBuffer = CharBuffer.allocate(n);
        if (n == 0 && byteBuffer.remaining() == 0) {
            return charBuffer;
        }
        this.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = byteBuffer.hasRemaining() ? this.decode(byteBuffer, charBuffer, true) : CoderResult.UNDERFLOW;
            if (coderResult.isUnderflow()) {
                coderResult = this.flush(charBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow()) {
                n = 2 * n + 1;
                CharBuffer charBuffer2 = CharBuffer.allocate(n);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            coderResult.throwException();
        }
        charBuffer.flip();
        return charBuffer;
    }

    public boolean isAutoDetecting() {
        return false;
    }

    public boolean isCharsetDetected() {
        throw new UnsupportedOperationException();
    }

    public Charset detectedCharset() {
        throw new UnsupportedOperationException();
    }

    private void throwIllegalStateException(int n, int n2) {
        throw new IllegalStateException("Current state = " + stateNames[n] + ", new state = " + stateNames[n2]);
    }
}

