/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;

class XAtomList {
    Set<XAtom> atoms = new HashSet<XAtom>();

    public XAtomList() {
    }

    public XAtomList(long l, int n) {
        this.init(l, n);
    }

    private void init(long l, int n) {
        for (int i = 0; i < n; ++i) {
            this.add(new XAtom(XToolkit.getDisplay(), XAtom.getAtom(l + (long)(n * XAtom.getAtomSize()))));
        }
    }

    public XAtomList(XAtom[] xAtomArray) {
        this.init(xAtomArray);
    }

    private void init(XAtom[] xAtomArray) {
        for (int i = 0; i < xAtomArray.length; ++i) {
            this.add(xAtomArray[i]);
        }
    }

    public XAtom[] getAtoms() {
        XAtom[] xAtomArray = new XAtom[this.size()];
        Iterator<XAtom> iterator = this.atoms.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            xAtomArray[n++] = iterator.next();
        }
        return xAtomArray;
    }

    public long getAtomsData() {
        return XAtom.toData(this.getAtoms());
    }

    public boolean contains(XAtom xAtom) {
        return this.atoms.contains(xAtom);
    }

    public void add(XAtom xAtom) {
        this.atoms.add(xAtom);
    }

    public void remove(XAtom xAtom) {
        this.atoms.remove(xAtom);
    }

    public int size() {
        return this.atoms.size();
    }

    public XAtomList subset(int n, Map<Integer, XAtom> map) {
        XAtomList xAtomList = new XAtomList();
        for (Integer n2 : map.keySet()) {
            XAtom xAtom;
            if ((n & n2) != n2 || !this.contains(xAtom = map.get(n2))) continue;
            xAtomList.add(xAtom);
        }
        return xAtomList;
    }

    public Iterator<XAtom> iterator() {
        return this.atoms.iterator();
    }

    public void addAll(XAtomList xAtomList) {
        Iterator<XAtom> iterator = xAtomList.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator<XAtom> iterator = this.atoms.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Object)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

