/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.View;
import sun.swing.MenuItemCheckIconFactory;
import sun.swing.StringUIClientPropertyKey;
import sun.swing.SwingUtilities2;

public class MenuItemLayoutHelper {
    public static final StringUIClientPropertyKey MAX_ARROW_WIDTH = new StringUIClientPropertyKey("maxArrowWidth");
    public static final StringUIClientPropertyKey MAX_CHECK_WIDTH = new StringUIClientPropertyKey("maxCheckWidth");
    public static final StringUIClientPropertyKey MAX_ICON_WIDTH = new StringUIClientPropertyKey("maxIconWidth");
    public static final StringUIClientPropertyKey MAX_TEXT_WIDTH = new StringUIClientPropertyKey("maxTextWidth");
    public static final StringUIClientPropertyKey MAX_ACC_WIDTH = new StringUIClientPropertyKey("maxAccWidth");
    public static final StringUIClientPropertyKey MAX_LABEL_WIDTH = new StringUIClientPropertyKey("maxLabelWidth");
    private JMenuItem mi;
    private JComponent miParent;
    private Font font;
    private Font accFont;
    private FontMetrics fm;
    private FontMetrics accFm;
    private Icon icon;
    private Icon checkIcon;
    private Icon arrowIcon;
    private String text;
    private String accText;
    private boolean isColumnLayout;
    private boolean useCheckAndArrow;
    private boolean isLeftToRight;
    private boolean isTopLevelMenu;
    private View htmlView;
    private int verticalAlignment;
    private int horizontalAlignment;
    private int verticalTextPosition;
    private int horizontalTextPosition;
    private int gap;
    private int leadingGap;
    private int afterCheckIconGap;
    private int minTextOffset;
    private int leftTextExtraWidth;
    private Rectangle viewRect;
    private RectSize iconSize;
    private RectSize textSize;
    private RectSize accSize;
    private RectSize checkSize;
    private RectSize arrowSize;
    private RectSize labelSize;

    protected MenuItemLayoutHelper() {
    }

    public MenuItemLayoutHelper(JMenuItem jMenuItem, Icon icon, Icon icon2, Rectangle rectangle, int n, String string, boolean bl, Font font, Font font2, boolean bl2, String string2) {
        this.reset(jMenuItem, icon, icon2, rectangle, n, string, bl, font, font2, bl2, string2);
    }

    protected void reset(JMenuItem jMenuItem, Icon icon, Icon icon2, Rectangle rectangle, int n, String string, boolean bl, Font font, Font font2, boolean bl2, String string2) {
        this.mi = jMenuItem;
        this.miParent = MenuItemLayoutHelper.getMenuItemParent(jMenuItem);
        this.accText = this.getAccText(string);
        this.verticalAlignment = jMenuItem.getVerticalAlignment();
        this.horizontalAlignment = jMenuItem.getHorizontalAlignment();
        this.verticalTextPosition = jMenuItem.getVerticalTextPosition();
        this.horizontalTextPosition = jMenuItem.getHorizontalTextPosition();
        this.useCheckAndArrow = bl2;
        this.font = font;
        this.accFont = font2;
        this.fm = jMenuItem.getFontMetrics(font);
        this.accFm = jMenuItem.getFontMetrics(font2);
        this.isLeftToRight = bl;
        this.isColumnLayout = MenuItemLayoutHelper.isColumnLayout(bl, this.horizontalAlignment, this.horizontalTextPosition, this.verticalTextPosition);
        this.isTopLevelMenu = this.miParent == null;
        this.checkIcon = icon;
        this.icon = this.getIcon(string2);
        this.arrowIcon = icon2;
        this.text = jMenuItem.getText();
        this.gap = n;
        this.afterCheckIconGap = this.getAfterCheckIconGap(string2);
        this.minTextOffset = this.getMinTextOffset(string2);
        this.htmlView = (View)jMenuItem.getClientProperty("html");
        this.viewRect = rectangle;
        this.iconSize = new RectSize();
        this.textSize = new RectSize();
        this.accSize = new RectSize();
        this.checkSize = new RectSize();
        this.arrowSize = new RectSize();
        this.labelSize = new RectSize();
        this.calcExtraWidths();
        this.calcWidthsAndHeights();
        this.setOriginalWidths();
        this.calcMaxWidths();
        this.leadingGap = this.getLeadingGap(string2);
        this.calcMaxTextOffset(rectangle);
    }

    private void calcExtraWidths() {
        this.leftTextExtraWidth = this.getLeftExtraWidth(this.text);
    }

    private int getLeftExtraWidth(String string) {
        int n = SwingUtilities2.getLeftSideBearing((JComponent)this.mi, this.fm, string);
        if (n < 0) {
            return -n;
        }
        return 0;
    }

    private void setOriginalWidths() {
        this.iconSize.origWidth = this.iconSize.width;
        this.textSize.origWidth = this.textSize.width;
        this.accSize.origWidth = this.accSize.width;
        this.checkSize.origWidth = this.checkSize.width;
        this.arrowSize.origWidth = this.arrowSize.width;
    }

    private String getAccText(String string) {
        String string2 = "";
        KeyStroke keyStroke = this.mi.getAccelerator();
        if (keyStroke != null) {
            int n;
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n2);
                string2 = string2 + string;
            }
            string2 = (n = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n) : string2 + keyStroke.getKeyChar();
        }
        return string2;
    }

    private Icon getIcon(String string) {
        Icon icon = null;
        MenuItemCheckIconFactory menuItemCheckIconFactory = (MenuItemCheckIconFactory)UIManager.get(string + ".checkIconFactory");
        if (!(this.isColumnLayout && this.useCheckAndArrow && menuItemCheckIconFactory != null && menuItemCheckIconFactory.isCompatible(this.checkIcon, string))) {
            icon = this.mi.getIcon();
        }
        return icon;
    }

    private int getMinTextOffset(String string) {
        int n = 0;
        Object object = UIManager.get(string + ".minimumTextOffset");
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    private int getAfterCheckIconGap(String string) {
        int n = this.gap;
        Object object = UIManager.get(string + ".afterCheckIconGap");
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    private int getLeadingGap(String string) {
        if (this.checkSize.getMaxWidth() > 0) {
            return this.getCheckOffset(string);
        }
        return this.gap;
    }

    private int getCheckOffset(String string) {
        int n = this.gap;
        Object object = UIManager.get(string + ".checkIconOffset");
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    protected void calcWidthsAndHeights() {
        if (this.icon != null) {
            this.iconSize.width = this.icon.getIconWidth();
            this.iconSize.height = this.icon.getIconHeight();
        }
        if (!this.accText.equals("")) {
            this.accSize.width = SwingUtilities2.stringWidth(this.mi, this.accFm, this.accText);
            this.accSize.height = this.accFm.getHeight();
        }
        if (this.text == null) {
            this.text = "";
        } else if (!this.text.equals("")) {
            if (this.htmlView != null) {
                this.textSize.width = (int)this.htmlView.getPreferredSpan(0);
                this.textSize.height = (int)this.htmlView.getPreferredSpan(1);
            } else {
                this.textSize.width = SwingUtilities2.stringWidth(this.mi, this.fm, this.text);
                this.textSize.height = this.fm.getHeight();
            }
        }
        if (this.useCheckAndArrow) {
            if (this.checkIcon != null) {
                this.checkSize.width = this.checkIcon.getIconWidth();
                this.checkSize.height = this.checkIcon.getIconHeight();
            }
            if (this.arrowIcon != null) {
                this.arrowSize.width = this.arrowIcon.getIconWidth();
                this.arrowSize.height = this.arrowIcon.getIconHeight();
            }
        }
        if (this.isColumnLayout) {
            this.labelSize.width = this.iconSize.width + this.textSize.width + this.gap;
            this.labelSize.height = MenuItemLayoutHelper.max(this.checkSize.height, this.iconSize.height, this.textSize.height, this.accSize.height, this.arrowSize.height);
        } else {
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            SwingUtilities.layoutCompoundLabel(this.mi, this.fm, this.text, this.icon, this.verticalAlignment, this.horizontalAlignment, this.verticalTextPosition, this.horizontalTextPosition, this.viewRect, rectangle2, rectangle, this.gap);
            rectangle.width += this.leftTextExtraWidth;
            Rectangle rectangle3 = rectangle2.union(rectangle);
            this.labelSize.height = rectangle3.height;
            this.labelSize.width = rectangle3.width;
        }
    }

    protected void calcMaxWidths() {
        this.calcMaxWidth(this.checkSize, MAX_CHECK_WIDTH);
        this.calcMaxWidth(this.arrowSize, MAX_ARROW_WIDTH);
        this.calcMaxWidth(this.accSize, MAX_ACC_WIDTH);
        if (this.isColumnLayout) {
            this.calcMaxWidth(this.iconSize, MAX_ICON_WIDTH);
            this.calcMaxWidth(this.textSize, MAX_TEXT_WIDTH);
            int n = this.gap;
            if (this.iconSize.getMaxWidth() == 0 || this.textSize.getMaxWidth() == 0) {
                n = 0;
            }
            this.labelSize.maxWidth = this.calcMaxValue(MenuItemLayoutHelper.MAX_LABEL_WIDTH, this.iconSize.maxWidth + this.textSize.maxWidth + n);
        } else {
            this.iconSize.maxWidth = this.getParentIntProperty(MenuItemLayoutHelper.MAX_ICON_WIDTH);
            this.calcMaxWidth(this.labelSize, MAX_LABEL_WIDTH);
            int n = this.labelSize.maxWidth - this.iconSize.maxWidth;
            if (this.iconSize.maxWidth > 0) {
                n -= this.gap;
            }
            this.textSize.maxWidth = this.calcMaxValue(MenuItemLayoutHelper.MAX_TEXT_WIDTH, n);
        }
    }

    protected void calcMaxWidth(RectSize rectSize, Object object) {
        rectSize.maxWidth = this.calcMaxValue(object, rectSize.width);
    }

    protected int calcMaxValue(Object object, int n) {
        int n2 = this.getParentIntProperty(object);
        if (n > n2) {
            if (this.miParent != null) {
                this.miParent.putClientProperty(object, n);
            }
            return n;
        }
        return n2;
    }

    protected int getParentIntProperty(Object object) {
        Object object2 = null;
        if (this.miParent != null) {
            object2 = this.miParent.getClientProperty(object);
        }
        if (object2 == null || !(object2 instanceof Integer)) {
            object2 = 0;
        }
        return (Integer)object2;
    }

    public static boolean isColumnLayout(boolean bl, JMenuItem jMenuItem) {
        assert (jMenuItem != null);
        return MenuItemLayoutHelper.isColumnLayout(bl, jMenuItem.getHorizontalAlignment(), jMenuItem.getHorizontalTextPosition(), jMenuItem.getVerticalTextPosition());
    }

    public static boolean isColumnLayout(boolean bl, int n, int n2, int n3) {
        if (n3 != 0) {
            return false;
        }
        if (bl) {
            if (n != 10 && n != 2) {
                return false;
            }
            if (n2 != 11 && n2 != 4) {
                return false;
            }
        } else {
            if (n != 10 && n != 4) {
                return false;
            }
            if (n2 != 11 && n2 != 2) {
                return false;
            }
        }
        return true;
    }

    private void calcMaxTextOffset(Rectangle rectangle) {
        if (!this.isColumnLayout || !this.isLeftToRight) {
            return;
        }
        int n = rectangle.x + this.leadingGap + this.checkSize.maxWidth + this.afterCheckIconGap + this.iconSize.maxWidth + this.gap;
        if (this.checkSize.maxWidth == 0) {
            n -= this.afterCheckIconGap;
        }
        if (this.iconSize.maxWidth == 0) {
            n -= this.gap;
        }
        if (n < this.minTextOffset) {
            n = this.minTextOffset;
        }
        this.calcMaxValue(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET, n);
    }

    public LayoutResult layoutMenuItem() {
        LayoutResult layoutResult = this.createLayoutResult();
        this.prepareForLayout(layoutResult);
        if (this.isColumnLayout()) {
            if (this.isLeftToRight()) {
                this.doLTRColumnLayout(layoutResult, this.getLTRColumnAlignment());
            } else {
                this.doRTLColumnLayout(layoutResult, this.getRTLColumnAlignment());
            }
        } else if (this.isLeftToRight()) {
            this.doLTRComplexLayout(layoutResult, this.getLTRColumnAlignment());
        } else {
            this.doRTLComplexLayout(layoutResult, this.getRTLColumnAlignment());
        }
        this.alignAccCheckAndArrowVertically(layoutResult);
        return layoutResult;
    }

    private LayoutResult createLayoutResult() {
        return new LayoutResult(new Rectangle(this.iconSize.width, this.iconSize.height), new Rectangle(this.textSize.width, this.textSize.height), new Rectangle(this.accSize.width, this.accSize.height), new Rectangle(this.checkSize.width, this.checkSize.height), new Rectangle(this.arrowSize.width, this.arrowSize.height), new Rectangle(this.labelSize.width, this.labelSize.height));
    }

    public ColumnAlignment getLTRColumnAlignment() {
        return ColumnAlignment.LEFT_ALIGNMENT;
    }

    public ColumnAlignment getRTLColumnAlignment() {
        return ColumnAlignment.RIGHT_ALIGNMENT;
    }

    protected void prepareForLayout(LayoutResult layoutResult) {
        ((LayoutResult)layoutResult).checkRect.width = this.checkSize.maxWidth;
        ((LayoutResult)layoutResult).accRect.width = this.accSize.maxWidth;
        ((LayoutResult)layoutResult).arrowRect.width = this.arrowSize.maxWidth;
    }

    private void alignAccCheckAndArrowVertically(LayoutResult layoutResult) {
        ((LayoutResult)layoutResult).accRect.y = (int)((float)((LayoutResult)layoutResult).labelRect.y + (float)((LayoutResult)layoutResult).labelRect.height / 2.0f - (float)((LayoutResult)layoutResult).accRect.height / 2.0f);
        this.fixVerticalAlignment(layoutResult, layoutResult.accRect);
        if (this.useCheckAndArrow) {
            ((LayoutResult)layoutResult).arrowRect.y = (int)((float)((LayoutResult)layoutResult).labelRect.y + (float)((LayoutResult)layoutResult).labelRect.height / 2.0f - (float)((LayoutResult)layoutResult).arrowRect.height / 2.0f);
            ((LayoutResult)layoutResult).checkRect.y = (int)((float)((LayoutResult)layoutResult).labelRect.y + (float)((LayoutResult)layoutResult).labelRect.height / 2.0f - (float)((LayoutResult)layoutResult).checkRect.height / 2.0f);
            this.fixVerticalAlignment(layoutResult, layoutResult.arrowRect);
            this.fixVerticalAlignment(layoutResult, layoutResult.checkRect);
        }
    }

    private void fixVerticalAlignment(LayoutResult layoutResult, Rectangle rectangle) {
        int n = 0;
        if (rectangle.y < this.viewRect.y) {
            n = this.viewRect.y - rectangle.y;
        } else if (rectangle.y + rectangle.height > this.viewRect.y + this.viewRect.height) {
            n = this.viewRect.y + this.viewRect.height - rectangle.y - rectangle.height;
        }
        if (n != 0) {
            ((LayoutResult)layoutResult).checkRect.y += n;
            ((LayoutResult)layoutResult).iconRect.y += n;
            ((LayoutResult)layoutResult).textRect.y += n;
            ((LayoutResult)layoutResult).accRect.y += n;
            ((LayoutResult)layoutResult).arrowRect.y += n;
            ((LayoutResult)layoutResult).labelRect.y += n;
        }
    }

    private void doLTRColumnLayout(LayoutResult layoutResult, ColumnAlignment columnAlignment) {
        ((LayoutResult)layoutResult).iconRect.width = this.iconSize.maxWidth;
        ((LayoutResult)layoutResult).textRect.width = this.textSize.maxWidth;
        this.calcXPositionsLTR(this.viewRect.x, this.leadingGap, this.gap, layoutResult.checkRect, layoutResult.iconRect, layoutResult.textRect);
        if (((LayoutResult)layoutResult).checkRect.width > 0) {
            ((LayoutResult)layoutResult).iconRect.x += this.afterCheckIconGap - this.gap;
            ((LayoutResult)layoutResult).textRect.x += this.afterCheckIconGap - this.gap;
        }
        this.calcXPositionsRTL(this.viewRect.x + this.viewRect.width, this.leadingGap, this.gap, layoutResult.arrowRect, layoutResult.accRect);
        int n = ((LayoutResult)layoutResult).textRect.x - this.viewRect.x;
        if (!this.isTopLevelMenu && n < this.minTextOffset) {
            ((LayoutResult)layoutResult).textRect.x += this.minTextOffset - n;
        }
        this.alignRects(layoutResult, columnAlignment);
        this.calcTextAndIconYPositions(layoutResult);
        layoutResult.setLabelRect(layoutResult.textRect.union(layoutResult.iconRect));
    }

    private void doLTRComplexLayout(LayoutResult layoutResult, ColumnAlignment columnAlignment) {
        ((LayoutResult)layoutResult).labelRect.width = this.labelSize.maxWidth;
        this.calcXPositionsLTR(this.viewRect.x, this.leadingGap, this.gap, layoutResult.checkRect, layoutResult.labelRect);
        if (((LayoutResult)layoutResult).checkRect.width > 0) {
            ((LayoutResult)layoutResult).labelRect.x += this.afterCheckIconGap - this.gap;
        }
        this.calcXPositionsRTL(this.viewRect.x + this.viewRect.width, this.leadingGap, this.gap, layoutResult.arrowRect, layoutResult.accRect);
        int n = ((LayoutResult)layoutResult).labelRect.x - this.viewRect.x;
        if (!this.isTopLevelMenu && n < this.minTextOffset) {
            ((LayoutResult)layoutResult).labelRect.x += this.minTextOffset - n;
        }
        this.alignRects(layoutResult, columnAlignment);
        this.calcLabelYPosition(layoutResult);
        this.layoutIconAndTextInLabelRect(layoutResult);
    }

    private void doRTLColumnLayout(LayoutResult layoutResult, ColumnAlignment columnAlignment) {
        ((LayoutResult)layoutResult).iconRect.width = this.iconSize.maxWidth;
        ((LayoutResult)layoutResult).textRect.width = this.textSize.maxWidth;
        this.calcXPositionsRTL(this.viewRect.x + this.viewRect.width, this.leadingGap, this.gap, layoutResult.checkRect, layoutResult.iconRect, layoutResult.textRect);
        if (((LayoutResult)layoutResult).checkRect.width > 0) {
            ((LayoutResult)layoutResult).iconRect.x -= this.afterCheckIconGap - this.gap;
            ((LayoutResult)layoutResult).textRect.x -= this.afterCheckIconGap - this.gap;
        }
        this.calcXPositionsLTR(this.viewRect.x, this.leadingGap, this.gap, layoutResult.arrowRect, layoutResult.accRect);
        int n = this.viewRect.x + this.viewRect.width - (((LayoutResult)layoutResult).textRect.x + ((LayoutResult)layoutResult).textRect.width);
        if (!this.isTopLevelMenu && n < this.minTextOffset) {
            ((LayoutResult)layoutResult).textRect.x -= this.minTextOffset - n;
        }
        this.alignRects(layoutResult, columnAlignment);
        this.calcTextAndIconYPositions(layoutResult);
        layoutResult.setLabelRect(layoutResult.textRect.union(layoutResult.iconRect));
    }

    private void doRTLComplexLayout(LayoutResult layoutResult, ColumnAlignment columnAlignment) {
        ((LayoutResult)layoutResult).labelRect.width = this.labelSize.maxWidth;
        this.calcXPositionsRTL(this.viewRect.x + this.viewRect.width, this.leadingGap, this.gap, layoutResult.checkRect, layoutResult.labelRect);
        if (((LayoutResult)layoutResult).checkRect.width > 0) {
            ((LayoutResult)layoutResult).labelRect.x -= this.afterCheckIconGap - this.gap;
        }
        this.calcXPositionsLTR(this.viewRect.x, this.leadingGap, this.gap, layoutResult.arrowRect, layoutResult.accRect);
        int n = this.viewRect.x + this.viewRect.width - (((LayoutResult)layoutResult).labelRect.x + ((LayoutResult)layoutResult).labelRect.width);
        if (!this.isTopLevelMenu && n < this.minTextOffset) {
            ((LayoutResult)layoutResult).labelRect.x -= this.minTextOffset - n;
        }
        this.alignRects(layoutResult, columnAlignment);
        this.calcLabelYPosition(layoutResult);
        this.layoutIconAndTextInLabelRect(layoutResult);
    }

    private void alignRects(LayoutResult layoutResult, ColumnAlignment columnAlignment) {
        this.alignRect(layoutResult.checkRect, columnAlignment.getCheckAlignment(), this.checkSize.getOrigWidth());
        this.alignRect(layoutResult.iconRect, columnAlignment.getIconAlignment(), this.iconSize.getOrigWidth());
        this.alignRect(layoutResult.textRect, columnAlignment.getTextAlignment(), this.textSize.getOrigWidth());
        this.alignRect(layoutResult.accRect, columnAlignment.getAccAlignment(), this.accSize.getOrigWidth());
        this.alignRect(layoutResult.arrowRect, columnAlignment.getArrowAlignment(), this.arrowSize.getOrigWidth());
    }

    private void alignRect(Rectangle rectangle, int n, int n2) {
        if (n == 4) {
            rectangle.x = rectangle.x + rectangle.width - n2;
        }
        rectangle.width = n2;
    }

    protected void layoutIconAndTextInLabelRect(LayoutResult layoutResult) {
        layoutResult.setTextRect(new Rectangle());
        layoutResult.setIconRect(new Rectangle());
        SwingUtilities.layoutCompoundLabel(this.mi, this.fm, this.text, this.icon, this.verticalAlignment, this.horizontalAlignment, this.verticalTextPosition, this.horizontalTextPosition, layoutResult.labelRect, layoutResult.iconRect, layoutResult.textRect, this.gap);
    }

    private void calcXPositionsLTR(int n, int n2, int n3, Rectangle ... rectangleArray) {
        int n4 = n + n2;
        for (Rectangle rectangle : rectangleArray) {
            rectangle.x = n4;
            if (rectangle.width <= 0) continue;
            n4 += rectangle.width + n3;
        }
    }

    private void calcXPositionsRTL(int n, int n2, int n3, Rectangle ... rectangleArray) {
        int n4 = n - n2;
        for (Rectangle rectangle : rectangleArray) {
            rectangle.x = n4 - rectangle.width;
            if (rectangle.width <= 0) continue;
            n4 -= rectangle.width + n3;
        }
    }

    private void calcTextAndIconYPositions(LayoutResult layoutResult) {
        if (this.verticalAlignment == 1) {
            ((LayoutResult)layoutResult).textRect.y = (int)((float)this.viewRect.y + (float)((LayoutResult)layoutResult).labelRect.height / 2.0f - (float)((LayoutResult)layoutResult).textRect.height / 2.0f);
            ((LayoutResult)layoutResult).iconRect.y = (int)((float)this.viewRect.y + (float)((LayoutResult)layoutResult).labelRect.height / 2.0f - (float)((LayoutResult)layoutResult).iconRect.height / 2.0f);
        } else if (this.verticalAlignment == 0) {
            ((LayoutResult)layoutResult).textRect.y = (int)((float)this.viewRect.y + (float)this.viewRect.height / 2.0f - (float)((LayoutResult)layoutResult).textRect.height / 2.0f);
            ((LayoutResult)layoutResult).iconRect.y = (int)((float)this.viewRect.y + (float)this.viewRect.height / 2.0f - (float)((LayoutResult)layoutResult).iconRect.height / 2.0f);
        } else if (this.verticalAlignment == 3) {
            ((LayoutResult)layoutResult).textRect.y = (int)((float)(this.viewRect.y + this.viewRect.height) - (float)((LayoutResult)layoutResult).labelRect.height / 2.0f - (float)((LayoutResult)layoutResult).textRect.height / 2.0f);
            ((LayoutResult)layoutResult).iconRect.y = (int)((float)(this.viewRect.y + this.viewRect.height) - (float)((LayoutResult)layoutResult).labelRect.height / 2.0f - (float)((LayoutResult)layoutResult).iconRect.height / 2.0f);
        }
    }

    private void calcLabelYPosition(LayoutResult layoutResult) {
        if (this.verticalAlignment == 1) {
            ((LayoutResult)layoutResult).labelRect.y = this.viewRect.y;
        } else if (this.verticalAlignment == 0) {
            ((LayoutResult)layoutResult).labelRect.y = (int)((float)this.viewRect.y + (float)this.viewRect.height / 2.0f - (float)((LayoutResult)layoutResult).labelRect.height / 2.0f);
        } else if (this.verticalAlignment == 3) {
            ((LayoutResult)layoutResult).labelRect.y = this.viewRect.y + this.viewRect.height - ((LayoutResult)layoutResult).labelRect.height;
        }
    }

    public static JComponent getMenuItemParent(JMenuItem jMenuItem) {
        Container container = jMenuItem.getParent();
        if (!(!(container instanceof JComponent) || jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu())) {
            return (JComponent)container;
        }
        return null;
    }

    public static void clearUsedParentClientProperties(JMenuItem jMenuItem) {
        MenuItemLayoutHelper.clearUsedClientProperties(MenuItemLayoutHelper.getMenuItemParent(jMenuItem));
    }

    public static void clearUsedClientProperties(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.putClientProperty(MAX_ARROW_WIDTH, null);
            jComponent.putClientProperty(MAX_CHECK_WIDTH, null);
            jComponent.putClientProperty(MAX_ACC_WIDTH, null);
            jComponent.putClientProperty(MAX_TEXT_WIDTH, null);
            jComponent.putClientProperty(MAX_ICON_WIDTH, null);
            jComponent.putClientProperty(MAX_LABEL_WIDTH, null);
            jComponent.putClientProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET, null);
        }
    }

    public static int max(int ... nArray) {
        int n = Integer.MIN_VALUE;
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static Rectangle createMaxRect() {
        return new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static void addMaxWidth(RectSize rectSize, int n, Dimension dimension) {
        if (rectSize.maxWidth > 0) {
            dimension.width += rectSize.maxWidth + n;
        }
    }

    public static void addWidth(int n, int n2, Dimension dimension) {
        if (n > 0) {
            dimension.width += n + n2;
        }
    }

    public JMenuItem getMenuItem() {
        return this.mi;
    }

    public JComponent getMenuItemParent() {
        return this.miParent;
    }

    public Font getFont() {
        return this.font;
    }

    public Font getAccFont() {
        return this.accFont;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public FontMetrics getAccFontMetrics() {
        return this.accFm;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getCheckIcon() {
        return this.checkIcon;
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public String getText() {
        return this.text;
    }

    public String getAccText() {
        return this.accText;
    }

    public boolean isColumnLayout() {
        return this.isColumnLayout;
    }

    public boolean useCheckAndArrow() {
        return this.useCheckAndArrow;
    }

    public boolean isLeftToRight() {
        return this.isLeftToRight;
    }

    public boolean isTopLevelMenu() {
        return this.isTopLevelMenu;
    }

    public View getHtmlView() {
        return this.htmlView;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public int getGap() {
        return this.gap;
    }

    public int getLeadingGap() {
        return this.leadingGap;
    }

    public int getAfterCheckIconGap() {
        return this.afterCheckIconGap;
    }

    public int getMinTextOffset() {
        return this.minTextOffset;
    }

    public Rectangle getViewRect() {
        return this.viewRect;
    }

    public RectSize getIconSize() {
        return this.iconSize;
    }

    public RectSize getTextSize() {
        return this.textSize;
    }

    public RectSize getAccSize() {
        return this.accSize;
    }

    public RectSize getCheckSize() {
        return this.checkSize;
    }

    public RectSize getArrowSize() {
        return this.arrowSize;
    }

    public RectSize getLabelSize() {
        return this.labelSize;
    }

    protected void setMenuItem(JMenuItem jMenuItem) {
        this.mi = jMenuItem;
    }

    protected void setMenuItemParent(JComponent jComponent) {
        this.miParent = jComponent;
    }

    protected void setFont(Font font) {
        this.font = font;
    }

    protected void setAccFont(Font font) {
        this.accFont = font;
    }

    protected void setFontMetrics(FontMetrics fontMetrics) {
        this.fm = fontMetrics;
    }

    protected void setAccFontMetrics(FontMetrics fontMetrics) {
        this.accFm = fontMetrics;
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected void setCheckIcon(Icon icon) {
        this.checkIcon = icon;
    }

    protected void setArrowIcon(Icon icon) {
        this.arrowIcon = icon;
    }

    protected void setText(String string) {
        this.text = string;
    }

    protected void setAccText(String string) {
        this.accText = string;
    }

    protected void setColumnLayout(boolean bl) {
        this.isColumnLayout = bl;
    }

    protected void setUseCheckAndArrow(boolean bl) {
        this.useCheckAndArrow = bl;
    }

    protected void setLeftToRight(boolean bl) {
        this.isLeftToRight = bl;
    }

    protected void setTopLevelMenu(boolean bl) {
        this.isTopLevelMenu = bl;
    }

    protected void setHtmlView(View view) {
        this.htmlView = view;
    }

    protected void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    protected void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    protected void setVerticalTextPosition(int n) {
        this.verticalTextPosition = n;
    }

    protected void setHorizontalTextPosition(int n) {
        this.horizontalTextPosition = n;
    }

    protected void setGap(int n) {
        this.gap = n;
    }

    protected void setLeadingGap(int n) {
        this.leadingGap = n;
    }

    protected void setAfterCheckIconGap(int n) {
        this.afterCheckIconGap = n;
    }

    protected void setMinTextOffset(int n) {
        this.minTextOffset = n;
    }

    protected void setViewRect(Rectangle rectangle) {
        this.viewRect = rectangle;
    }

    protected void setIconSize(RectSize rectSize) {
        this.iconSize = rectSize;
    }

    protected void setTextSize(RectSize rectSize) {
        this.textSize = rectSize;
    }

    protected void setAccSize(RectSize rectSize) {
        this.accSize = rectSize;
    }

    protected void setCheckSize(RectSize rectSize) {
        this.checkSize = rectSize;
    }

    protected void setArrowSize(RectSize rectSize) {
        this.arrowSize = rectSize;
    }

    protected void setLabelSize(RectSize rectSize) {
        this.labelSize = rectSize;
    }

    public int getLeftTextExtraWidth() {
        return this.leftTextExtraWidth;
    }

    public static boolean useCheckAndArrow(JMenuItem jMenuItem) {
        boolean bl = true;
        if (jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public static class RectSize {
        private int width;
        private int height;
        private int origWidth;
        private int maxWidth;

        public RectSize() {
        }

        public RectSize(int n, int n2, int n3, int n4) {
            this.width = n;
            this.height = n2;
            this.origWidth = n3;
            this.maxWidth = n4;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getOrigWidth() {
            return this.origWidth;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public void setHeight(int n) {
            this.height = n;
        }

        public void setOrigWidth(int n) {
            this.origWidth = n;
        }

        public void setMaxWidth(int n) {
            this.maxWidth = n;
        }

        public String toString() {
            return "[w=" + this.width + ",h=" + this.height + ",ow=" + this.origWidth + ",mw=" + this.maxWidth + "]";
        }
    }

    public static class ColumnAlignment {
        private int checkAlignment;
        private int iconAlignment;
        private int textAlignment;
        private int accAlignment;
        private int arrowAlignment;
        public static final ColumnAlignment LEFT_ALIGNMENT = new ColumnAlignment(2, 2, 2, 2, 2);
        public static final ColumnAlignment RIGHT_ALIGNMENT = new ColumnAlignment(4, 4, 4, 4, 4);

        public ColumnAlignment(int n, int n2, int n3, int n4, int n5) {
            this.checkAlignment = n;
            this.iconAlignment = n2;
            this.textAlignment = n3;
            this.accAlignment = n4;
            this.arrowAlignment = n5;
        }

        public int getCheckAlignment() {
            return this.checkAlignment;
        }

        public int getIconAlignment() {
            return this.iconAlignment;
        }

        public int getTextAlignment() {
            return this.textAlignment;
        }

        public int getAccAlignment() {
            return this.accAlignment;
        }

        public int getArrowAlignment() {
            return this.arrowAlignment;
        }
    }

    public static class LayoutResult {
        private Rectangle iconRect;
        private Rectangle textRect;
        private Rectangle accRect;
        private Rectangle checkRect;
        private Rectangle arrowRect;
        private Rectangle labelRect;

        public LayoutResult() {
            this.iconRect = new Rectangle();
            this.textRect = new Rectangle();
            this.accRect = new Rectangle();
            this.checkRect = new Rectangle();
            this.arrowRect = new Rectangle();
            this.labelRect = new Rectangle();
        }

        public LayoutResult(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6) {
            this.iconRect = rectangle;
            this.textRect = rectangle2;
            this.accRect = rectangle3;
            this.checkRect = rectangle4;
            this.arrowRect = rectangle5;
            this.labelRect = rectangle6;
        }

        public Rectangle getIconRect() {
            return this.iconRect;
        }

        public void setIconRect(Rectangle rectangle) {
            this.iconRect = rectangle;
        }

        public Rectangle getTextRect() {
            return this.textRect;
        }

        public void setTextRect(Rectangle rectangle) {
            this.textRect = rectangle;
        }

        public Rectangle getAccRect() {
            return this.accRect;
        }

        public void setAccRect(Rectangle rectangle) {
            this.accRect = rectangle;
        }

        public Rectangle getCheckRect() {
            return this.checkRect;
        }

        public void setCheckRect(Rectangle rectangle) {
            this.checkRect = rectangle;
        }

        public Rectangle getArrowRect() {
            return this.arrowRect;
        }

        public void setArrowRect(Rectangle rectangle) {
            this.arrowRect = rectangle;
        }

        public Rectangle getLabelRect() {
            return this.labelRect;
        }

        public void setLabelRect(Rectangle rectangle) {
            this.labelRect = rectangle;
        }

        public Map<String, Rectangle> getAllRects() {
            HashMap<String, Rectangle> hashMap = new HashMap<String, Rectangle>();
            hashMap.put("checkRect", this.checkRect);
            hashMap.put("iconRect", this.iconRect);
            hashMap.put("textRect", this.textRect);
            hashMap.put("accRect", this.accRect);
            hashMap.put("arrowRect", this.arrowRect);
            hashMap.put("labelRect", this.labelRect);
            return hashMap;
        }
    }
}

