/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathChecker;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXReason;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.security.provider.certpath.AdaptableX509CertSelector;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.ConstraintsChecker;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.PKIX;
import sun.security.provider.certpath.PKIXMasterCertPathValidator;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.RevocationChecker;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

public final class PKIXCertPathValidator
extends CertPathValidatorSpi {
    private static final Debug debug = Debug.getInstance("certpath");

    @Override
    public CertPathChecker engineGetRevocationChecker() {
        return new RevocationChecker();
    }

    @Override
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        PKIX.ValidatorParams validatorParams = PKIX.checkParams(certPath, certPathParameters);
        return PKIXCertPathValidator.validate(validatorParams);
    }

    private static PKIXCertPathValidatorResult validate(PKIX.ValidatorParams validatorParams) throws CertPathValidatorException {
        Serializable serializable;
        if (debug != null) {
            debug.println("PKIXCertPathValidator.engineValidate()...");
        }
        AdaptableX509CertSelector adaptableX509CertSelector = null;
        List<X509Certificate> list = validatorParams.certificates();
        if (!list.isEmpty()) {
            adaptableX509CertSelector = new AdaptableX509CertSelector();
            serializable = list.get(0);
            adaptableX509CertSelector.setSubject(serializable.getIssuerX500Principal());
            try {
                X509CertImpl x509CertImpl = X509CertImpl.toImpl(serializable);
                adaptableX509CertSelector.setSkiAndSerialNumber(x509CertImpl.getAuthorityKeyIdentifierExtension());
            }
            catch (IOException | CertificateException exception) {
                // empty catch block
            }
        }
        serializable = null;
        for (TrustAnchor trustAnchor : validatorParams.trustAnchors()) {
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (x509Certificate != null) {
                if (adaptableX509CertSelector != null && !adaptableX509CertSelector.match(x509Certificate)) {
                    if (debug == null) continue;
                    debug.println("NO - don't try this trustedCert");
                    continue;
                }
                if (debug != null) {
                    debug.println("YES - try this trustedCert");
                    debug.println("anchor.getTrustedCert().getSubjectX500Principal() = " + x509Certificate.getSubjectX500Principal());
                }
            } else if (debug != null) {
                debug.println("PKIXCertPathValidator.engineValidate(): anchor.getTrustedCert() == null");
            }
            try {
                return PKIXCertPathValidator.validate(trustAnchor, validatorParams);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                serializable = certPathValidatorException;
            }
        }
        if (serializable != null) {
            throw serializable;
        }
        throw new CertPathValidatorException("Path does not chain with any of the trust anchors", null, null, -1, PKIXReason.NO_TRUST_ANCHOR);
    }

    private static PKIXCertPathValidatorResult validate(TrustAnchor trustAnchor, PKIX.ValidatorParams validatorParams) throws CertPathValidatorException {
        UntrustedChecker untrustedChecker = new UntrustedChecker();
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate != null) {
            untrustedChecker.check(x509Certificate);
        }
        int n = validatorParams.certificates().size();
        ArrayList<PKIXCertPathChecker> arrayList = new ArrayList<PKIXCertPathChecker>();
        arrayList.add(untrustedChecker);
        arrayList.add(new AlgorithmChecker(trustAnchor));
        arrayList.add(new KeyChecker(n, validatorParams.targetCertConstraints()));
        arrayList.add(new ConstraintsChecker(n));
        PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, Collections.singleton("2.5.29.32.0"), false);
        PolicyChecker policyChecker = new PolicyChecker(validatorParams.initialPolicies(), n, validatorParams.explicitPolicyRequired(), validatorParams.policyMappingInhibited(), validatorParams.anyPolicyInhibited(), validatorParams.policyQualifiersRejected(), policyNodeImpl);
        arrayList.add(policyChecker);
        BasicChecker basicChecker = new BasicChecker(trustAnchor, validatorParams.date(), validatorParams.sigProvider(), false);
        arrayList.add(basicChecker);
        boolean bl = false;
        List<PKIXCertPathChecker> list = validatorParams.certPathCheckers();
        for (PKIXCertPathChecker pKIXCertPathChecker : list) {
            if (!(pKIXCertPathChecker instanceof PKIXRevocationChecker)) continue;
            if (bl) {
                throw new CertPathValidatorException("Only one PKIXRevocationChecker can be specified");
            }
            bl = true;
            if (!(pKIXCertPathChecker instanceof RevocationChecker)) continue;
            ((RevocationChecker)pKIXCertPathChecker).init(trustAnchor, validatorParams);
        }
        if (validatorParams.revocationEnabled() && !bl) {
            arrayList.add(new RevocationChecker(trustAnchor, validatorParams));
        }
        arrayList.addAll(list);
        PKIXMasterCertPathValidator.validate(validatorParams.certPath(), validatorParams.certificates(), arrayList);
        return new PKIXCertPathValidatorResult(trustAnchor, policyChecker.getPolicyTree(), basicChecker.getPublicKey());
    }
}

