/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.Ser;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ZoneRules
implements Serializable {
    private static final long serialVersionUID = 3044319355680032515L;
    private static final int LAST_CACHED_YEAR = 2100;
    private final long[] standardTransitions;
    private final ZoneOffset[] standardOffsets;
    private final long[] savingsInstantTransitions;
    private final LocalDateTime[] savingsLocalTransitions;
    private final ZoneOffset[] wallOffsets;
    private final ZoneOffsetTransitionRule[] lastRules;
    private final transient ConcurrentMap<Integer, ZoneOffsetTransition[]> lastRulesCache = new ConcurrentHashMap<Integer, ZoneOffsetTransition[]>();
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final ZoneOffsetTransitionRule[] EMPTY_LASTRULES = new ZoneOffsetTransitionRule[0];
    private static final LocalDateTime[] EMPTY_LDT_ARRAY = new LocalDateTime[0];

    public static ZoneRules of(ZoneOffset zoneOffset, ZoneOffset zoneOffset2, List<ZoneOffsetTransition> list, List<ZoneOffsetTransition> list2, List<ZoneOffsetTransitionRule> list3) {
        Objects.requireNonNull(zoneOffset, "baseStandardOffset");
        Objects.requireNonNull(zoneOffset2, "baseWallOffset");
        Objects.requireNonNull(list, "standardOffsetTransitionList");
        Objects.requireNonNull(list2, "transitionList");
        Objects.requireNonNull(list3, "lastRules");
        return new ZoneRules(zoneOffset, zoneOffset2, list, list2, list3);
    }

    public static ZoneRules of(ZoneOffset zoneOffset) {
        Objects.requireNonNull(zoneOffset, "offset");
        return new ZoneRules(zoneOffset);
    }

    ZoneRules(ZoneOffset zoneOffset, ZoneOffset zoneOffset2, List<ZoneOffsetTransition> list, List<ZoneOffsetTransition> list2, List<ZoneOffsetTransitionRule> list3) {
        this.standardTransitions = new long[list.size()];
        this.standardOffsets = new ZoneOffset[list.size() + 1];
        this.standardOffsets[0] = zoneOffset;
        for (int i = 0; i < list.size(); ++i) {
            this.standardTransitions[i] = list.get(i).toEpochSecond();
            this.standardOffsets[i + 1] = list.get(i).getOffsetAfter();
        }
        ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
        ArrayList<ZoneOffset> arrayList2 = new ArrayList<ZoneOffset>();
        arrayList2.add(zoneOffset2);
        for (ZoneOffsetTransition zoneOffsetTransition : list2) {
            if (zoneOffsetTransition.isGap()) {
                arrayList.add(zoneOffsetTransition.getDateTimeBefore());
                arrayList.add(zoneOffsetTransition.getDateTimeAfter());
            } else {
                arrayList.add(zoneOffsetTransition.getDateTimeAfter());
                arrayList.add(zoneOffsetTransition.getDateTimeBefore());
            }
            arrayList2.add(zoneOffsetTransition.getOffsetAfter());
        }
        this.savingsLocalTransitions = arrayList.toArray(new LocalDateTime[arrayList.size()]);
        this.wallOffsets = arrayList2.toArray(new ZoneOffset[arrayList2.size()]);
        this.savingsInstantTransitions = new long[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            this.savingsInstantTransitions[i] = list2.get(i).toEpochSecond();
        }
        if (list3.size() > 16) {
            throw new IllegalArgumentException("Too many transition rules");
        }
        this.lastRules = list3.toArray(new ZoneOffsetTransitionRule[list3.size()]);
    }

    private ZoneRules(long[] lArray, ZoneOffset[] zoneOffsetArray, long[] lArray2, ZoneOffset[] zoneOffsetArray2, ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray) {
        this.standardTransitions = lArray;
        this.standardOffsets = zoneOffsetArray;
        this.savingsInstantTransitions = lArray2;
        this.wallOffsets = zoneOffsetArray2;
        this.lastRules = zoneOffsetTransitionRuleArray;
        if (lArray2.length == 0) {
            this.savingsLocalTransitions = EMPTY_LDT_ARRAY;
        } else {
            ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
            for (int i = 0; i < lArray2.length; ++i) {
                ZoneOffset zoneOffset = zoneOffsetArray2[i];
                ZoneOffset zoneOffset2 = zoneOffsetArray2[i + 1];
                ZoneOffsetTransition zoneOffsetTransition = new ZoneOffsetTransition(lArray2[i], zoneOffset, zoneOffset2);
                if (zoneOffsetTransition.isGap()) {
                    arrayList.add(zoneOffsetTransition.getDateTimeBefore());
                    arrayList.add(zoneOffsetTransition.getDateTimeAfter());
                    continue;
                }
                arrayList.add(zoneOffsetTransition.getDateTimeAfter());
                arrayList.add(zoneOffsetTransition.getDateTimeBefore());
            }
            this.savingsLocalTransitions = arrayList.toArray(new LocalDateTime[arrayList.size()]);
        }
    }

    private ZoneRules(ZoneOffset zoneOffset) {
        this.standardOffsets = new ZoneOffset[1];
        this.standardOffsets[0] = zoneOffset;
        this.standardTransitions = EMPTY_LONG_ARRAY;
        this.savingsInstantTransitions = EMPTY_LONG_ARRAY;
        this.savingsLocalTransitions = EMPTY_LDT_ARRAY;
        this.wallOffsets = this.standardOffsets;
        this.lastRules = EMPTY_LASTRULES;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(1, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.standardTransitions.length);
        for (long l : this.standardTransitions) {
            Ser.writeEpochSec(l, dataOutput);
        }
        for (ZoneOffset zoneOffset : this.standardOffsets) {
            Ser.writeOffset(zoneOffset, dataOutput);
        }
        dataOutput.writeInt(this.savingsInstantTransitions.length);
        for (long l : this.savingsInstantTransitions) {
            Ser.writeEpochSec(l, dataOutput);
        }
        for (ZoneOffset zoneOffset : this.wallOffsets) {
            Ser.writeOffset(zoneOffset, dataOutput);
        }
        dataOutput.writeByte(this.lastRules.length);
        for (ZoneOffsetTransitionRule zoneOffsetTransitionRule : this.lastRules) {
            zoneOffsetTransitionRule.writeExternal(dataOutput);
        }
    }

    static ZoneRules readExternal(DataInput dataInput) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        int n3 = dataInput.readInt();
        long[] lArray = n3 == 0 ? EMPTY_LONG_ARRAY : new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray[i] = Ser.readEpochSec(dataInput);
        }
        ZoneOffset[] zoneOffsetArray = new ZoneOffset[n3 + 1];
        for (n2 = 0; n2 < zoneOffsetArray.length; ++n2) {
            zoneOffsetArray[n2] = Ser.readOffset(dataInput);
        }
        n2 = dataInput.readInt();
        long[] lArray2 = n2 == 0 ? EMPTY_LONG_ARRAY : new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray2[i] = Ser.readEpochSec(dataInput);
        }
        ZoneOffset[] zoneOffsetArray2 = new ZoneOffset[n2 + 1];
        for (n = 0; n < zoneOffsetArray2.length; ++n) {
            zoneOffsetArray2[n] = Ser.readOffset(dataInput);
        }
        n = dataInput.readByte();
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray = n == 0 ? EMPTY_LASTRULES : new ZoneOffsetTransitionRule[n];
        for (int i = 0; i < n; ++i) {
            zoneOffsetTransitionRuleArray[i] = ZoneOffsetTransitionRule.readExternal(dataInput);
        }
        return new ZoneRules(lArray, zoneOffsetArray, lArray2, zoneOffsetArray2, zoneOffsetTransitionRuleArray);
    }

    public boolean isFixedOffset() {
        return this.savingsInstantTransitions.length == 0;
    }

    public ZoneOffset getOffset(Instant instant) {
        if (this.savingsInstantTransitions.length == 0) {
            return this.standardOffsets[0];
        }
        long l = instant.getEpochSecond();
        if (this.lastRules.length > 0 && l > this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            int n = this.findYear(l, this.wallOffsets[this.wallOffsets.length - 1]);
            ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(n);
            ZoneOffsetTransition zoneOffsetTransition = null;
            for (int i = 0; i < zoneOffsetTransitionArray.length; ++i) {
                zoneOffsetTransition = zoneOffsetTransitionArray[i];
                if (l >= zoneOffsetTransition.toEpochSecond()) continue;
                return zoneOffsetTransition.getOffsetBefore();
            }
            return zoneOffsetTransition.getOffsetAfter();
        }
        int n = Arrays.binarySearch(this.savingsInstantTransitions, l);
        if (n < 0) {
            n = -n - 2;
        }
        return this.wallOffsets[n + 1];
    }

    public ZoneOffset getOffset(LocalDateTime localDateTime) {
        Object object = this.getOffsetInfo(localDateTime);
        if (object instanceof ZoneOffsetTransition) {
            return ((ZoneOffsetTransition)object).getOffsetBefore();
        }
        return (ZoneOffset)object;
    }

    public List<ZoneOffset> getValidOffsets(LocalDateTime localDateTime) {
        Object object = this.getOffsetInfo(localDateTime);
        if (object instanceof ZoneOffsetTransition) {
            return ((ZoneOffsetTransition)object).getValidOffsets();
        }
        return Collections.singletonList((ZoneOffset)object);
    }

    public ZoneOffsetTransition getTransition(LocalDateTime localDateTime) {
        Object object = this.getOffsetInfo(localDateTime);
        return object instanceof ZoneOffsetTransition ? (ZoneOffsetTransition)object : null;
    }

    private Object getOffsetInfo(LocalDateTime localDateTime) {
        if (this.savingsInstantTransitions.length == 0) {
            return this.standardOffsets[0];
        }
        if (this.lastRules.length > 0 && localDateTime.isAfter(this.savingsLocalTransitions[this.savingsLocalTransitions.length - 1])) {
            ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(localDateTime.getYear());
            Object object = null;
            for (ZoneOffsetTransition zoneOffsetTransition : zoneOffsetTransitionArray) {
                object = this.findOffsetInfo(localDateTime, zoneOffsetTransition);
                if (!(object instanceof ZoneOffsetTransition) && !object.equals(zoneOffsetTransition.getOffsetBefore())) continue;
                return object;
            }
            return object;
        }
        int n = Arrays.binarySearch(this.savingsLocalTransitions, localDateTime);
        if (n == -1) {
            return this.wallOffsets[0];
        }
        if (n < 0) {
            n = -n - 2;
        } else if (n < this.savingsLocalTransitions.length - 1 && this.savingsLocalTransitions[n].equals(this.savingsLocalTransitions[n + 1])) {
            ++n;
        }
        if ((n & 1) == 0) {
            LocalDateTime localDateTime2 = this.savingsLocalTransitions[n];
            LocalDateTime localDateTime3 = this.savingsLocalTransitions[n + 1];
            ZoneOffset zoneOffset = this.wallOffsets[n / 2];
            ZoneOffset zoneOffset2 = this.wallOffsets[n / 2 + 1];
            if (zoneOffset2.getTotalSeconds() > zoneOffset.getTotalSeconds()) {
                return new ZoneOffsetTransition(localDateTime2, zoneOffset, zoneOffset2);
            }
            return new ZoneOffsetTransition(localDateTime3, zoneOffset, zoneOffset2);
        }
        return this.wallOffsets[n / 2 + 1];
    }

    private Object findOffsetInfo(LocalDateTime localDateTime, ZoneOffsetTransition zoneOffsetTransition) {
        LocalDateTime localDateTime2 = zoneOffsetTransition.getDateTimeBefore();
        if (zoneOffsetTransition.isGap()) {
            if (localDateTime.isBefore(localDateTime2)) {
                return zoneOffsetTransition.getOffsetBefore();
            }
            if (localDateTime.isBefore(zoneOffsetTransition.getDateTimeAfter())) {
                return zoneOffsetTransition;
            }
            return zoneOffsetTransition.getOffsetAfter();
        }
        if (!localDateTime.isBefore(localDateTime2)) {
            return zoneOffsetTransition.getOffsetAfter();
        }
        if (localDateTime.isBefore(zoneOffsetTransition.getDateTimeAfter())) {
            return zoneOffsetTransition.getOffsetBefore();
        }
        return zoneOffsetTransition;
    }

    private ZoneOffsetTransition[] findTransitionArray(int n) {
        Integer n2 = n;
        ZoneOffsetTransition[] zoneOffsetTransitionArray = (ZoneOffsetTransition[])this.lastRulesCache.get(n2);
        if (zoneOffsetTransitionArray != null) {
            return zoneOffsetTransitionArray;
        }
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray = this.lastRules;
        zoneOffsetTransitionArray = new ZoneOffsetTransition[zoneOffsetTransitionRuleArray.length];
        for (int i = 0; i < zoneOffsetTransitionRuleArray.length; ++i) {
            zoneOffsetTransitionArray[i] = zoneOffsetTransitionRuleArray[i].createTransition(n);
        }
        if (n < 2100) {
            this.lastRulesCache.putIfAbsent(n2, zoneOffsetTransitionArray);
        }
        return zoneOffsetTransitionArray;
    }

    public ZoneOffset getStandardOffset(Instant instant) {
        if (this.savingsInstantTransitions.length == 0) {
            return this.standardOffsets[0];
        }
        long l = instant.getEpochSecond();
        int n = Arrays.binarySearch(this.standardTransitions, l);
        if (n < 0) {
            n = -n - 2;
        }
        return this.standardOffsets[n + 1];
    }

    public Duration getDaylightSavings(Instant instant) {
        if (this.savingsInstantTransitions.length == 0) {
            return Duration.ZERO;
        }
        ZoneOffset zoneOffset = this.getStandardOffset(instant);
        ZoneOffset zoneOffset2 = this.getOffset(instant);
        return Duration.ofSeconds(zoneOffset2.getTotalSeconds() - zoneOffset.getTotalSeconds());
    }

    public boolean isDaylightSavings(Instant instant) {
        return !this.getStandardOffset(instant).equals(this.getOffset(instant));
    }

    public boolean isValidOffset(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        return this.getValidOffsets(localDateTime).contains(zoneOffset);
    }

    public ZoneOffsetTransition nextTransition(Instant instant) {
        if (this.savingsInstantTransitions.length == 0) {
            return null;
        }
        long l = instant.getEpochSecond();
        if (l >= this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            ZoneOffsetTransition[] zoneOffsetTransitionArray;
            if (this.lastRules.length == 0) {
                return null;
            }
            int n = this.findYear(l, this.wallOffsets[this.wallOffsets.length - 1]);
            for (ZoneOffsetTransition zoneOffsetTransition : zoneOffsetTransitionArray = this.findTransitionArray(n)) {
                if (l >= zoneOffsetTransition.toEpochSecond()) continue;
                return zoneOffsetTransition;
            }
            if (n < 999999999) {
                zoneOffsetTransitionArray = this.findTransitionArray(n + 1);
                return zoneOffsetTransitionArray[0];
            }
            return null;
        }
        int n = Arrays.binarySearch(this.savingsInstantTransitions, l);
        n = n < 0 ? -n - 1 : ++n;
        return new ZoneOffsetTransition(this.savingsInstantTransitions[n], this.wallOffsets[n], this.wallOffsets[n + 1]);
    }

    public ZoneOffsetTransition previousTransition(Instant instant) {
        int n;
        if (this.savingsInstantTransitions.length == 0) {
            return null;
        }
        long l = instant.getEpochSecond();
        if (instant.getNano() > 0 && l < Long.MAX_VALUE) {
            ++l;
        }
        long l2 = this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1];
        if (this.lastRules.length > 0 && l > l2) {
            int n2;
            ZoneOffset zoneOffset = this.wallOffsets[this.wallOffsets.length - 1];
            int n3 = this.findYear(l, zoneOffset);
            ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(n3);
            for (n2 = zoneOffsetTransitionArray.length - 1; n2 >= 0; --n2) {
                if (l <= zoneOffsetTransitionArray[n2].toEpochSecond()) continue;
                return zoneOffsetTransitionArray[n2];
            }
            n2 = this.findYear(l2, zoneOffset);
            if (--n3 > n2) {
                zoneOffsetTransitionArray = this.findTransitionArray(n3);
                return zoneOffsetTransitionArray[zoneOffsetTransitionArray.length - 1];
            }
        }
        if ((n = Arrays.binarySearch(this.savingsInstantTransitions, l)) < 0) {
            n = -n - 1;
        }
        if (n <= 0) {
            return null;
        }
        return new ZoneOffsetTransition(this.savingsInstantTransitions[n - 1], this.wallOffsets[n - 1], this.wallOffsets[n]);
    }

    private int findYear(long l, ZoneOffset zoneOffset) {
        long l2 = l + (long)zoneOffset.getTotalSeconds();
        long l3 = Math.floorDiv(l2, 86400L);
        return LocalDate.ofEpochDay(l3).getYear();
    }

    public List<ZoneOffsetTransition> getTransitions() {
        ArrayList<ZoneOffsetTransition> arrayList = new ArrayList<ZoneOffsetTransition>();
        for (int i = 0; i < this.savingsInstantTransitions.length; ++i) {
            arrayList.add(new ZoneOffsetTransition(this.savingsInstantTransitions[i], this.wallOffsets[i], this.wallOffsets[i + 1]));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<ZoneOffsetTransitionRule> getTransitionRules() {
        return Collections.unmodifiableList(Arrays.asList(this.lastRules));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZoneRules) {
            ZoneRules zoneRules = (ZoneRules)object;
            return Arrays.equals(this.standardTransitions, zoneRules.standardTransitions) && Arrays.equals(this.standardOffsets, zoneRules.standardOffsets) && Arrays.equals(this.savingsInstantTransitions, zoneRules.savingsInstantTransitions) && Arrays.equals(this.wallOffsets, zoneRules.wallOffsets) && Arrays.equals(this.lastRules, zoneRules.lastRules);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.standardTransitions) ^ Arrays.hashCode(this.standardOffsets) ^ Arrays.hashCode(this.savingsInstantTransitions) ^ Arrays.hashCode(this.wallOffsets) ^ Arrays.hashCode(this.lastRules);
    }

    public String toString() {
        return "ZoneRules[currentStandardOffset=" + this.standardOffsets[this.standardOffsets.length - 1] + "]";
    }
}

