/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Authenticator {
    public int authenticator_vno;
    public PrincipalName cname;
    Checksum cksum;
    public int cusec;
    public KerberosTime ctime;
    EncryptionKey subKey;
    Integer seqNumber;
    public AuthorizationData authorizationData;

    public Authenticator(PrincipalName principalName, Checksum checksum, int n, KerberosTime kerberosTime, EncryptionKey encryptionKey, Integer n2, AuthorizationData authorizationData) {
        this.authenticator_vno = 5;
        this.cname = principalName;
        this.cksum = checksum;
        this.cusec = n;
        this.ctime = kerberosTime;
        this.subKey = encryptionKey;
        this.seqNumber = n2;
        this.authorizationData = authorizationData;
    }

    public Authenticator(byte[] byArray) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.init(new DerValue(byArray));
    }

    public Authenticator(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.init(derValue);
    }

    private void init(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        if ((derValue.getTag() & 0x1F) != 2 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.authenticator_vno = derValue3.getData().getBigInteger().intValue();
        if (this.authenticator_vno != 5) {
            throw new KrbApErrException(39);
        }
        Realm realm = Realm.parse(derValue2.getData(), (byte)1, false);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)2, false, realm);
        this.cksum = Checksum.parse(derValue2.getData(), (byte)3, true);
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        this.cusec = derValue3.getData().getBigInteger().intValue();
        this.ctime = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        if (derValue2.getData().available() > 0) {
            this.subKey = EncryptionKey.parse(derValue2.getData(), (byte)6, true);
        } else {
            this.subKey = null;
            this.seqNumber = null;
            this.authorizationData = null;
        }
        if (derValue2.getData().available() > 0) {
            if ((derValue2.getData().peekByte() & 0x1F) == 7 && ((derValue3 = derValue2.getData().getDerValue()).getTag() & 0x1F) == 7) {
                this.seqNumber = new Integer(derValue3.getData().getBigInteger().intValue());
            }
        } else {
            this.seqNumber = null;
            this.authorizationData = null;
        }
        this.authorizationData = derValue2.getData().available() > 0 ? AuthorizationData.parse(derValue2.getData(), (byte)8, true) : null;
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Vector<DerValue> vector = new Vector<DerValue>();
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.authenticator_vno));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream.toByteArray()));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)1), this.cname.getRealm().asn1Encode()));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)2), this.cname.asn1Encode()));
        if (this.cksum != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)3), this.cksum.asn1Encode()));
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.cusec));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)4), derOutputStream.toByteArray()));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)5), this.ctime.asn1Encode()));
        if (this.subKey != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)6), this.subKey.asn1Encode()));
        }
        if (this.seqNumber != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.seqNumber.longValue()));
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)7), derOutputStream.toByteArray()));
        }
        if (this.authorizationData != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)8), this.authorizationData.asn1Encode()));
        }
        Object[] objectArray = new DerValue[vector.size()];
        vector.copyInto(objectArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence((DerValue[])objectArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, true, (byte)2), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public final Checksum getChecksum() {
        return this.cksum;
    }

    public final Integer getSeqNumber() {
        return this.seqNumber;
    }

    public final EncryptionKey getSubKey() {
        return this.subKey;
    }
}

