/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public class Package
implements AnnotatedElement {
    private static Map<String, Package> pkgs = new HashMap<String, Package>(31);
    private static Map<String, URL> urls = new HashMap<String, URL>(10);
    private static Map<String, Manifest> mans = new HashMap<String, Manifest>(10);
    private final String pkgName;
    private final String specTitle;
    private final String specVersion;
    private final String specVendor;
    private final String implTitle;
    private final String implVersion;
    private final String implVendor;
    private final URL sealBase;
    private final transient ClassLoader loader;
    private transient Class packageInfo;

    public String getName() {
        return this.pkgName;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public boolean isSealed() {
        return this.sealBase != null;
    }

    public boolean isSealed(URL uRL) {
        return uRL.equals(this.sealBase);
    }

    public boolean isCompatibleWith(String string) throws NumberFormatException {
        int n;
        if (this.specVersion == null || this.specVersion.length() < 1) {
            throw new NumberFormatException("Empty version string");
        }
        String[] stringArray = this.specVersion.split("\\.", -1);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
            if (nArray[i] >= 0) continue;
            throw NumberFormatException.forInputString("" + nArray[i]);
        }
        String[] stringArray2 = string.split("\\.", -1);
        int[] nArray2 = new int[stringArray2.length];
        for (n = 0; n < stringArray2.length; ++n) {
            nArray2[n] = Integer.parseInt(stringArray2[n]);
            if (nArray2[n] >= 0) continue;
            throw NumberFormatException.forInputString("" + nArray2[n]);
        }
        n = Math.max(nArray2.length, nArray.length);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = i < nArray2.length ? nArray2[i] : 0;
            int n4 = n2 = i < nArray.length ? nArray[i] : 0;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    @CallerSensitive
    public static Package getPackage(String string) {
        ClassLoader classLoader = ClassLoader.getClassLoader(Reflection.getCallerClass());
        if (classLoader != null) {
            return classLoader.getPackage(string);
        }
        return Package.getSystemPackage(string);
    }

    @CallerSensitive
    public static Package[] getPackages() {
        ClassLoader classLoader = ClassLoader.getClassLoader(Reflection.getCallerClass());
        if (classLoader != null) {
            return classLoader.getPackages();
        }
        return Package.getSystemPackages();
    }

    static Package getPackage(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                return classLoader.getPackage(string);
            }
            return Package.getSystemPackage(string);
        }
        return null;
    }

    public int hashCode() {
        return this.pkgName.hashCode();
    }

    public String toString() {
        String string = this.specTitle;
        String string2 = this.specVersion;
        string = string != null && string.length() > 0 ? ", " + string : "";
        string2 = string2 != null && string2.length() > 0 ? ", version " + string2 : "";
        return "package " + this.pkgName + string + string2;
    }

    private Class<?> getPackageInfo() {
        if (this.packageInfo == null) {
            try {
                this.packageInfo = Class.forName(this.pkgName + ".package-info", false, this.loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                class PackageInfoProxy {
                    PackageInfoProxy() {
                    }
                }
                this.packageInfo = PackageInfoProxy.class;
            }
        }
        return this.packageInfo;
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.getPackageInfo().getAnnotation(clazz);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getPackageInfo().isAnnotationPresent(clazz);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getPackageInfo().getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getPackageInfo().getDeclaredAnnotations();
    }

    Package(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL, ClassLoader classLoader) {
        this.pkgName = string;
        this.implTitle = string5;
        this.implVersion = string6;
        this.implVendor = string7;
        this.specTitle = string2;
        this.specVersion = string3;
        this.specVendor = string4;
        this.sealBase = uRL;
        this.loader = classLoader;
    }

    private Package(String string, Manifest manifest, URL uRL, ClassLoader classLoader) {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string6 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string9 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string3)) {
            uRL2 = uRL;
        }
        this.pkgName = string;
        this.specTitle = string4;
        this.specVersion = string5;
        this.specVendor = string6;
        this.implTitle = string7;
        this.implVersion = string8;
        this.implVendor = string9;
        this.sealBase = uRL2;
        this.loader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Package getSystemPackage(String string) {
        Map<String, Package> map = pkgs;
        synchronized (map) {
            String string2;
            Package package_ = pkgs.get(string);
            if (package_ == null && (string2 = Package.getSystemPackage0(string = string.replace('.', '/').concat("/"))) != null) {
                package_ = Package.defineSystemPackage(string, string2);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Package[] getSystemPackages() {
        String[] stringArray = Package.getSystemPackages0();
        Map<String, Package> map = pkgs;
        synchronized (map) {
            for (int i = 0; i < stringArray.length; ++i) {
                Package.defineSystemPackage(stringArray[i], Package.getSystemPackage0(stringArray[i]));
            }
            return pkgs.values().toArray(new Package[pkgs.size()]);
        }
    }

    private static Package defineSystemPackage(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<Package>(){

            @Override
            public Package run() {
                Object object;
                String string3 = string;
                URL uRL = (URL)urls.get(string2);
                if (uRL == null) {
                    object = new File(string2);
                    try {
                        uRL = ParseUtil.fileToEncodedURL((File)object);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL != null) {
                        urls.put(string2, uRL);
                        if (((File)object).isFile()) {
                            mans.put(string2, Package.loadManifest(string2));
                        }
                    }
                }
                string3 = string3.substring(0, string3.length() - 1).replace('/', '.');
                Manifest manifest = (Manifest)mans.get(string2);
                object = manifest != null ? new Package(string3, manifest, uRL, null) : new Package(string3, null, null, null, null, null, null, null, null);
                pkgs.put(string3, object);
                return object;
            }
        });
    }

    /*
     * Exception decompiling
     */
    private static Manifest loadManifest(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static native String getSystemPackage0(String var0);

    private static native String[] getSystemPackages0();
}

