/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.SerialNumber;

public class CertId {
    private static final boolean debug = false;
    private static final AlgorithmId SHA1_ALGID = new AlgorithmId(AlgorithmId.SHA_oid);
    private final AlgorithmId hashAlgId;
    private final byte[] issuerNameHash;
    private final byte[] issuerKeyHash;
    private final SerialNumber certSerialNumber;
    private int myhash = -1;

    public CertId(X509Certificate x509Certificate, SerialNumber serialNumber) throws IOException {
        this(x509Certificate.getSubjectX500Principal(), x509Certificate.getPublicKey(), serialNumber);
    }

    public CertId(X500Principal x500Principal, PublicKey publicKey, SerialNumber serialNumber) throws IOException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Unable to create CertId", noSuchAlgorithmException);
        }
        this.hashAlgId = SHA1_ALGID;
        messageDigest.update(x500Principal.getEncoded());
        this.issuerNameHash = messageDigest.digest();
        byte[] byArray = publicKey.getEncoded();
        DerValue derValue = new DerValue(byArray);
        DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue()};
        byte[] byArray2 = derValueArray[1].getBitString();
        messageDigest.update(byArray2);
        this.issuerKeyHash = messageDigest.digest();
        this.certSerialNumber = serialNumber;
    }

    public CertId(DerInputStream derInputStream) throws IOException {
        this.hashAlgId = AlgorithmId.parse(derInputStream.getDerValue());
        this.issuerNameHash = derInputStream.getOctetString();
        this.issuerKeyHash = derInputStream.getOctetString();
        this.certSerialNumber = new SerialNumber(derInputStream);
    }

    public AlgorithmId getHashAlgorithm() {
        return this.hashAlgId;
    }

    public byte[] getIssuerNameHash() {
        return this.issuerNameHash;
    }

    public byte[] getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public BigInteger getSerialNumber() {
        return this.certSerialNumber.getNumber();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.hashAlgId.encode(derOutputStream2);
        derOutputStream2.putOctetString(this.issuerNameHash);
        derOutputStream2.putOctetString(this.issuerKeyHash);
        this.certSerialNumber.encode(derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public int hashCode() {
        if (this.myhash == -1) {
            int n;
            this.myhash = this.hashAlgId.hashCode();
            for (n = 0; n < this.issuerNameHash.length; ++n) {
                this.myhash += this.issuerNameHash[n] * n;
            }
            for (n = 0; n < this.issuerKeyHash.length; ++n) {
                this.myhash += this.issuerKeyHash[n] * n;
            }
            this.myhash += this.certSerialNumber.getNumber().hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof CertId)) {
            return false;
        }
        CertId certId = (CertId)object;
        return this.hashAlgId.equals(certId.getHashAlgorithm()) && Arrays.equals(this.issuerNameHash, certId.getIssuerNameHash()) && Arrays.equals(this.issuerKeyHash, certId.getIssuerKeyHash()) && this.certSerialNumber.getNumber().equals(certId.getSerialNumber());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CertId \n");
        stringBuilder.append("Algorithm: " + this.hashAlgId.toString() + "\n");
        stringBuilder.append("issuerNameHash \n");
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        stringBuilder.append(hexDumpEncoder.encode(this.issuerNameHash));
        stringBuilder.append("\nissuerKeyHash: \n");
        stringBuilder.append(hexDumpEncoder.encode(this.issuerKeyHash));
        stringBuilder.append("\n" + this.certSerialNumber.toString());
        return stringBuilder.toString();
    }
}

