/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import com.sun.imageio.stream.StreamFinalizer;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCache;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public class MemoryCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private MemoryCache cache = new MemoryCache();
    private final Object disposerReferent;
    private final DisposerRecord disposerRecord;

    public MemoryCacheImageInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.stream = inputStream;
        this.disposerRecord = new StreamDisposerRecord(this.cache);
        if (this.getClass() == MemoryCacheImageInputStream.class) {
            this.disposerReferent = new Object();
            Disposer.addRecord(this.disposerReferent, this.disposerRecord);
        } else {
            this.disposerReferent = new StreamFinalizer(this);
        }
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        long l = this.cache.loadFromStream(this.stream, this.streamPos + 1L);
        if (l >= this.streamPos + 1L) {
            return this.cache.read(this.streamPos++);
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off+len > b.length || off+len < 0!");
        }
        this.bitOffset = 0;
        if (n2 == 0) {
            return 0;
        }
        long l = this.cache.loadFromStream(this.stream, this.streamPos + (long)n2);
        if ((n2 = (int)(l - this.streamPos)) > 0) {
            this.cache.read(byArray, n, n2, this.streamPos);
            this.streamPos += (long)n2;
            return n2;
        }
        return -1;
    }

    @Override
    public void flushBefore(long l) throws IOException {
        super.flushBefore(l);
        this.cache.disposeBefore(l);
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.disposerRecord.dispose();
        this.stream = null;
        this.cache = null;
    }

    @Override
    protected void finalize() throws Throwable {
    }

    private static class StreamDisposerRecord
    implements DisposerRecord {
        private MemoryCache cache;

        public StreamDisposerRecord(MemoryCache memoryCache) {
            this.cache = memoryCache;
        }

        @Override
        public synchronized void dispose() {
            if (this.cache != null) {
                this.cache.reset();
                this.cache = null;
            }
        }
    }
}

