ZEN:begin(1)
request = [[
Feature: Produce a verifiable 'certificate' for a 'declaration'
  In order to have a 'declaration' certified
  As a 'participant' who knows an 'authority'
  Or as an 'authority' who is also a 'participant'
  I want to make a 'declaration' and request its 'certificate'
  I want to verify a 'declaration' using its 'certificate'
  I want to communicate privately with any other 'participant'

  Scenario 'request': Make my declaration and request certificate
    Given that I introduce myself as 'Alice'
    and I have the 'public' key 'Mad Hatter' in keyring
    When I declare to 'Mad Hatter' that I am 'lost in Wonderland'
    and I issue my declaration
    Then my 'declaration' should be valid

  Scenario 'issue': Receive a declaration request and issue a certificate
    Given that I am known as 'Mad Hatter'
    and I receive a 'declaration' from 'Alice'
    and I have my 'private' key in keyring
    When the 'declaration' by 'Alice' is true
    and I issue my certificate
    Then my 'certificate' should be valid

  Scenario 'save': Receive a certificate of a declaration and save it
    Given I receive a 'certificate' from 'Mad Hatter'
    and I have the 'private' key 'declaration' in keyring
    When I verify the 'declaration' with its 'certificate'
    Then my 'certificate' should be valid

  Scenario 'verify': Verify a declaration with its certificate
    Given I receive a 'declaration' from 'Alice'
    and I receive a 'certificate' from 'Mad Hatter'
    and I have the 'public' key 'Mad Hatter' in keyring
    When I verify the 'declaration' with its 'certificate'
    Then the 'certificate' should be valid

]]

ZEN:parse(request)

ZEN:run()
