/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.LastReqEntry;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class LastReq {
    private LastReqEntry[] entry = null;

    public LastReq(LastReqEntry[] lastReqEntryArray) throws IOException {
        if (lastReqEntryArray != null) {
            this.entry = new LastReqEntry[lastReqEntryArray.length];
            for (int i = 0; i < lastReqEntryArray.length; ++i) {
                if (lastReqEntryArray[i] == null) {
                    throw new IOException("Cannot create a LastReqEntry");
                }
                this.entry[i] = (LastReqEntry)lastReqEntryArray[i].clone();
            }
        }
    }

    public LastReq(DerValue derValue) throws Asn1Exception, IOException {
        Vector<LastReqEntry> vector = new Vector<LastReqEntry>();
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        while (derValue.getData().available() > 0) {
            vector.addElement(new LastReqEntry(derValue.getData().getDerValue()));
        }
        if (vector.size() > 0) {
            this.entry = new LastReqEntry[vector.size()];
            vector.copyInto(this.entry);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.entry != null && this.entry.length > 0) {
            DerOutputStream derOutputStream2 = new DerOutputStream();
            for (int i = 0; i < this.entry.length; ++i) {
                derOutputStream2.write(this.entry[i].asn1Encode());
            }
            derOutputStream.write((byte)48, derOutputStream2);
            return derOutputStream.toByteArray();
        }
        return null;
    }

    public static LastReq parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new LastReq(derValue2);
    }
}

