/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.ProfileDeferralMgr;
import sun.java2d.cmm.lcms.LCMS;
import sun.java2d.cmm.lcms.LCMSImageLayout;

public class LCMSTransform
implements ColorTransform {
    long ID;
    private int inFormatter;
    private int outFormatter;
    ICC_Profile[] profiles;
    long[] profileIDs;
    int renderType;
    int transformType;
    private int numInComponents = -1;
    private int numOutComponents = -1;
    private Object disposerReferent = new Object();

    public LCMSTransform(ICC_Profile iCC_Profile, int n, int n2) {
        this.profiles = new ICC_Profile[1];
        this.profiles[0] = iCC_Profile;
        this.profileIDs = new long[1];
        this.profileIDs[0] = LCMS.getProfileID(iCC_Profile);
        this.renderType = n == -1 ? 0 : n;
        this.transformType = n2;
        this.numInComponents = this.profiles[0].getNumComponents();
        this.numOutComponents = this.profiles[this.profiles.length - 1].getNumComponents();
    }

    public LCMSTransform(ColorTransform[] colorTransformArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < colorTransformArray.length; ++n) {
            n2 += ((LCMSTransform)colorTransformArray[n]).profiles.length;
        }
        this.profiles = new ICC_Profile[n2];
        this.profileIDs = new long[n2];
        n = 0;
        for (int i = 0; i < colorTransformArray.length; ++i) {
            LCMSTransform lCMSTransform = (LCMSTransform)colorTransformArray[i];
            System.arraycopy(lCMSTransform.profiles, 0, this.profiles, n, lCMSTransform.profiles.length);
            System.arraycopy(lCMSTransform.profileIDs, 0, this.profileIDs, n, lCMSTransform.profileIDs.length);
            n += lCMSTransform.profiles.length;
        }
        this.renderType = ((LCMSTransform)colorTransformArray[0]).renderType;
        this.numInComponents = this.profiles[0].getNumComponents();
        this.numOutComponents = this.profiles[this.profiles.length - 1].getNumComponents();
    }

    @Override
    public int getNumInComponents() {
        return this.numInComponents;
    }

    @Override
    public int getNumOutComponents() {
        return this.numOutComponents;
    }

    private synchronized void doTransform(LCMSImageLayout lCMSImageLayout, LCMSImageLayout lCMSImageLayout2) {
        if (this.ID == 0L || this.inFormatter != lCMSImageLayout.pixelType || this.outFormatter != lCMSImageLayout2.pixelType) {
            if (this.ID != 0L) {
                this.disposerReferent = new Object();
            }
            this.inFormatter = lCMSImageLayout.pixelType;
            this.outFormatter = lCMSImageLayout2.pixelType;
            this.ID = LCMS.createNativeTransform(this.profileIDs, this.renderType, this.inFormatter, this.outFormatter, this.disposerReferent);
        }
        LCMS.colorConvert(this, lCMSImageLayout, lCMSImageLayout2);
    }

    @Override
    public void colorConvert(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int n2;
        if (LCMSImageLayout.isSupported(bufferedImage) && LCMSImageLayout.isSupported(bufferedImage2)) {
            try {
                this.doTransform(new LCMSImageLayout(bufferedImage), new LCMSImageLayout(bufferedImage2));
                return;
            }
            catch (LCMSImageLayout.ImageLayoutException imageLayoutException) {
                throw new CMMException("Unable to convert images");
            }
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorModel colorModel2 = bufferedImage2.getColorModel();
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = colorModel.getNumColorComponents();
        int n6 = colorModel2.getNumColorComponents();
        int n7 = 8;
        float f = 255.0f;
        for (n2 = 0; n2 < n5; ++n2) {
            if (colorModel.getComponentSize(n2) <= 8) continue;
            n7 = 16;
            f = 65535.0f;
        }
        for (n2 = 0; n2 < n6; ++n2) {
            if (colorModel2.getComponentSize(n2) <= 8) continue;
            n7 = 16;
            f = 65535.0f;
        }
        float[] fArray = new float[n5];
        float[] fArray2 = new float[n5];
        ColorSpace colorSpace = colorModel.getColorSpace();
        for (int i = 0; i < n5; ++i) {
            fArray[i] = colorSpace.getMinValue(i);
            fArray2[i] = f / (colorSpace.getMaxValue(i) - fArray[i]);
        }
        colorSpace = colorModel2.getColorSpace();
        float[] fArray3 = new float[n6];
        float[] fArray4 = new float[n6];
        for (n = 0; n < n6; ++n) {
            fArray3[n] = colorSpace.getMinValue(n);
            fArray4[n] = (colorSpace.getMaxValue(n) - fArray3[n]) / f;
        }
        n = colorModel2.hasAlpha() ? 1 : 0;
        boolean bl = colorModel.hasAlpha() && n != 0;
        float[] fArray5 = n != 0 ? new float[n6 + 1] : new float[n6];
        if (n7 == 8) {
            LCMSImageLayout lCMSImageLayout;
            LCMSImageLayout lCMSImageLayout2;
            byte[] byArray = new byte[n3 * n5];
            byte[] byArray2 = new byte[n3 * n6];
            float[] fArray6 = null;
            if (bl) {
                fArray6 = new float[n3];
            }
            try {
                lCMSImageLayout2 = new LCMSImageLayout(byArray, byArray.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumInComponents());
                lCMSImageLayout = new LCMSImageLayout(byArray2, byArray2.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumOutComponents());
            }
            catch (LCMSImageLayout.ImageLayoutException imageLayoutException) {
                throw new CMMException("Unable to convert images");
            }
            for (int i = 0; i < n4; ++i) {
                int n8;
                int n9;
                Object object = null;
                float[] fArray7 = null;
                int n10 = 0;
                for (n9 = 0; n9 < n3; ++n9) {
                    object = writableRaster.getDataElements(n9, i, object);
                    fArray7 = colorModel.getNormalizedComponents(object, fArray7, 0);
                    for (n8 = 0; n8 < n5; ++n8) {
                        byArray[n10++] = (byte)((fArray7[n8] - fArray[n8]) * fArray2[n8] + 0.5f);
                    }
                    if (!bl) continue;
                    fArray6[n9] = fArray7[n5];
                }
                this.doTransform(lCMSImageLayout2, lCMSImageLayout);
                object = null;
                n10 = 0;
                for (n9 = 0; n9 < n3; ++n9) {
                    for (n8 = 0; n8 < n6; ++n8) {
                        fArray5[n8] = (float)(byArray2[n10++] & 0xFF) * fArray4[n8] + fArray3[n8];
                    }
                    if (bl) {
                        fArray5[n6] = fArray6[n9];
                    } else if (n != 0) {
                        fArray5[n6] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n9, i, object);
                }
            }
        } else {
            LCMSImageLayout lCMSImageLayout;
            LCMSImageLayout lCMSImageLayout3;
            short[] sArray = new short[n3 * n5];
            short[] sArray2 = new short[n3 * n6];
            float[] fArray8 = null;
            if (bl) {
                fArray8 = new float[n3];
            }
            try {
                lCMSImageLayout3 = new LCMSImageLayout(sArray, sArray.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumInComponents() * 2);
                lCMSImageLayout = new LCMSImageLayout(sArray2, sArray2.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumOutComponents() * 2);
            }
            catch (LCMSImageLayout.ImageLayoutException imageLayoutException) {
                throw new CMMException("Unable to convert images");
            }
            for (int i = 0; i < n4; ++i) {
                int n11;
                int n12;
                Object object = null;
                float[] fArray9 = null;
                int n13 = 0;
                for (n12 = 0; n12 < n3; ++n12) {
                    object = writableRaster.getDataElements(n12, i, object);
                    fArray9 = colorModel.getNormalizedComponents(object, fArray9, 0);
                    for (n11 = 0; n11 < n5; ++n11) {
                        sArray[n13++] = (short)((fArray9[n11] - fArray[n11]) * fArray2[n11] + 0.5f);
                    }
                    if (!bl) continue;
                    fArray8[n12] = fArray9[n5];
                }
                this.doTransform(lCMSImageLayout3, lCMSImageLayout);
                object = null;
                n13 = 0;
                for (n12 = 0; n12 < n3; ++n12) {
                    for (n11 = 0; n11 < n6; ++n11) {
                        fArray5[n11] = (float)(sArray2[n13++] & 0xFFFF) * fArray4[n11] + fArray3[n11];
                    }
                    if (bl) {
                        fArray5[n6] = fArray8[n12];
                    } else if (n != 0) {
                        fArray5[n6] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n12, i, object);
                }
            }
        }
    }

    @Override
    public void colorConvert(Raster raster, WritableRaster writableRaster, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        LCMSImageLayout lCMSImageLayout;
        LCMSImageLayout lCMSImageLayout2;
        int n;
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n2 = raster.getTransferType();
        int n3 = writableRaster.getTransferType();
        boolean bl = n2 == 4 || n2 == 5;
        boolean bl2 = n3 == 4 || n3 == 5;
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getNumBands();
        int n7 = writableRaster.getNumBands();
        float[] fArray5 = new float[n6];
        float[] fArray6 = new float[n7];
        float[] fArray7 = new float[n6];
        float[] fArray8 = new float[n7];
        for (n = 0; n < n6; ++n) {
            if (bl) {
                fArray5[n] = 65535.0f / (fArray2[n] - fArray[n]);
                fArray7[n] = fArray[n];
                continue;
            }
            fArray5[n] = n2 == 2 ? 2.0000305f : 65535.0f / (float)((1 << sampleModel.getSampleSize(n)) - 1);
            fArray7[n] = 0.0f;
        }
        for (n = 0; n < n7; ++n) {
            if (bl2) {
                fArray6[n] = (fArray4[n] - fArray3[n]) / 65535.0f;
                fArray8[n] = fArray3[n];
                continue;
            }
            fArray6[n] = n3 == 2 ? 0.49999237f : (float)((1 << sampleModel2.getSampleSize(n)) - 1) / 65535.0f;
            fArray8[n] = 0.0f;
        }
        n = raster.getMinY();
        int n8 = writableRaster.getMinY();
        short[] sArray = new short[n4 * n6];
        short[] sArray2 = new short[n4 * n7];
        try {
            lCMSImageLayout2 = new LCMSImageLayout(sArray, sArray.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumInComponents() * 2);
            lCMSImageLayout = new LCMSImageLayout(sArray2, sArray2.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumOutComponents() * 2);
        }
        catch (LCMSImageLayout.ImageLayoutException imageLayoutException) {
            throw new CMMException("Unable to convert rasters");
        }
        int n9 = 0;
        while (n9 < n5) {
            float f;
            int n10;
            int n11 = raster.getMinX();
            int n12 = 0;
            int n13 = 0;
            while (n13 < n4) {
                for (n10 = 0; n10 < n6; ++n10) {
                    f = raster.getSampleFloat(n11, n, n10);
                    sArray[n12++] = (short)((f - fArray7[n10]) * fArray5[n10] + 0.5f);
                }
                ++n13;
                ++n11;
            }
            this.doTransform(lCMSImageLayout2, lCMSImageLayout);
            int n14 = writableRaster.getMinX();
            n12 = 0;
            n13 = 0;
            while (n13 < n4) {
                for (n10 = 0; n10 < n7; ++n10) {
                    f = (float)(sArray2[n12++] & 0xFFFF) * fArray6[n10] + fArray8[n10];
                    writableRaster.setSample(n14, n8, n10, f);
                }
                ++n13;
                ++n14;
            }
            ++n9;
            ++n;
            ++n8;
        }
    }

    @Override
    public void colorConvert(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n3 = raster.getTransferType();
        int n4 = writableRaster.getTransferType();
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = raster.getNumBands();
        int n8 = writableRaster.getNumBands();
        int n9 = 8;
        float f = 255.0f;
        for (n2 = 0; n2 < n7; ++n2) {
            if (sampleModel.getSampleSize(n2) <= 8) continue;
            n9 = 16;
            f = 65535.0f;
        }
        for (n2 = 0; n2 < n8; ++n2) {
            if (sampleModel2.getSampleSize(n2) <= 8) continue;
            n9 = 16;
            f = 65535.0f;
        }
        float[] fArray = new float[n7];
        float[] fArray2 = new float[n8];
        for (n = 0; n < n7; ++n) {
            fArray[n] = n3 == 2 ? f / 32767.0f : f / (float)((1 << sampleModel.getSampleSize(n)) - 1);
        }
        for (n = 0; n < n8; ++n) {
            fArray2[n] = n4 == 2 ? 32767.0f / f : (float)((1 << sampleModel2.getSampleSize(n)) - 1) / f;
        }
        n = raster.getMinY();
        int n10 = writableRaster.getMinY();
        if (n9 == 8) {
            LCMSImageLayout lCMSImageLayout;
            LCMSImageLayout lCMSImageLayout2;
            byte[] byArray = new byte[n5 * n7];
            byte[] byArray2 = new byte[n5 * n8];
            try {
                lCMSImageLayout2 = new LCMSImageLayout(byArray, byArray.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumInComponents());
                lCMSImageLayout = new LCMSImageLayout(byArray2, byArray2.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumOutComponents());
            }
            catch (LCMSImageLayout.ImageLayoutException imageLayoutException) {
                throw new CMMException("Unable to convert rasters");
            }
            int n11 = 0;
            while (n11 < n6) {
                int n12;
                int n13;
                int n14 = raster.getMinX();
                int n15 = 0;
                int n16 = 0;
                while (n16 < n5) {
                    for (n13 = 0; n13 < n7; ++n13) {
                        n12 = raster.getSample(n14, n, n13);
                        byArray[n15++] = (byte)((float)n12 * fArray[n13] + 0.5f);
                    }
                    ++n16;
                    ++n14;
                }
                this.doTransform(lCMSImageLayout2, lCMSImageLayout);
                int n17 = writableRaster.getMinX();
                n15 = 0;
                n16 = 0;
                while (n16 < n5) {
                    for (n13 = 0; n13 < n8; ++n13) {
                        n12 = (int)((float)(byArray2[n15++] & 0xFF) * fArray2[n13] + 0.5f);
                        writableRaster.setSample(n17, n10, n13, n12);
                    }
                    ++n16;
                    ++n17;
                }
                ++n11;
                ++n;
                ++n10;
            }
        } else {
            LCMSImageLayout lCMSImageLayout;
            LCMSImageLayout lCMSImageLayout3;
            short[] sArray = new short[n5 * n7];
            short[] sArray2 = new short[n5 * n8];
            try {
                lCMSImageLayout3 = new LCMSImageLayout(sArray, sArray.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumInComponents() * 2);
                lCMSImageLayout = new LCMSImageLayout(sArray2, sArray2.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumOutComponents() * 2);
            }
            catch (LCMSImageLayout.ImageLayoutException imageLayoutException) {
                throw new CMMException("Unable to convert rasters");
            }
            int n18 = 0;
            while (n18 < n6) {
                int n19;
                int n20;
                int n21 = raster.getMinX();
                int n22 = 0;
                int n23 = 0;
                while (n23 < n5) {
                    for (n20 = 0; n20 < n7; ++n20) {
                        n19 = raster.getSample(n21, n, n20);
                        sArray[n22++] = (short)((float)n19 * fArray[n20] + 0.5f);
                    }
                    ++n23;
                    ++n21;
                }
                this.doTransform(lCMSImageLayout3, lCMSImageLayout);
                int n24 = writableRaster.getMinX();
                n22 = 0;
                n23 = 0;
                while (n23 < n5) {
                    for (n20 = 0; n20 < n8; ++n20) {
                        n19 = (int)((float)(sArray2[n22++] & 0xFFFF) * fArray2[n20] + 0.5f);
                        writableRaster.setSample(n24, n10, n20, n19);
                    }
                    ++n23;
                    ++n24;
                }
                ++n18;
                ++n;
                ++n10;
            }
        }
    }

    @Override
    public short[] colorConvert(short[] sArray, short[] sArray2) {
        if (sArray2 == null) {
            sArray2 = new short[sArray.length / this.getNumInComponents() * this.getNumOutComponents()];
        }
        try {
            LCMSImageLayout lCMSImageLayout = new LCMSImageLayout(sArray, sArray.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumInComponents() * 2);
            LCMSImageLayout lCMSImageLayout2 = new LCMSImageLayout(sArray2, sArray2.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumOutComponents() * 2);
            this.doTransform(lCMSImageLayout, lCMSImageLayout2);
            return sArray2;
        }
        catch (LCMSImageLayout.ImageLayoutException imageLayoutException) {
            throw new CMMException("Unable to convert data");
        }
    }

    @Override
    public byte[] colorConvert(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            byArray2 = new byte[byArray.length / this.getNumInComponents() * this.getNumOutComponents()];
        }
        try {
            LCMSImageLayout lCMSImageLayout = new LCMSImageLayout(byArray, byArray.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumInComponents());
            LCMSImageLayout lCMSImageLayout2 = new LCMSImageLayout(byArray2, byArray2.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumOutComponents());
            this.doTransform(lCMSImageLayout, lCMSImageLayout2);
            return byArray2;
        }
        catch (LCMSImageLayout.ImageLayoutException imageLayoutException) {
            throw new CMMException("Unable to convert data");
        }
    }

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }
}

