/* Software floating-point emulation.
   Generated tables for computing of powers of 10 into _BitInt.

   Copyright (C) 2023 Free Software Foundation, Inc.

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 3, or (at your option) any later
version.

GCC is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

/* The following tables have been generated using GMP library and
   following helper linked with -lgmp.  The tables omit least significant
   limbs which contain just 0 bits (for 32-bit limbs only pairs of them) to
   save space and because shifting left by bits in a limb is cheap.

#include <gmp.h>
#include <stdlib.h>
#include <stdio.h>

int
main ()
{
  mpz_t a, b, c;
  mpz_init2 (a, 65);
  mpz_init2 (b, 2048);
  mpz_init2 (c, 22000);
  mpz_set_ui (b, 1);
  mpz_set_ui (a, 0x10000L);
  mpz_mul (a, a, a);
  mpz_mul (a, a, a);
  char buf[8192];
  int l = 0;
  unsigned short offs32[280], offs64[280];
  printf ("static UBILtype pow10_limbs[] = {\n");
  offs32[0] = 0;
  offs64[0] = 0;
  for (int i = 0; i <= 256; ++i)
    {
      size_t s = mpz_sizeinbase (b, 2);
      size_t s2 = (s + 63) / 64;
      size_t s3 = ((s - 1) % 64) + 1;
      size_t s4 = (s3 + 3) / 4;
      char *p = buf;
      offs32[l + 1] = offs32[l] + 2 * s2 - (s3 <= 32);
      offs64[l + 1] = offs64[l] + s2;
      ++l;
      gmp_sprintf (buf, "%Zx", b);
      printf ("  /%c %d %c/\n  ", '*', i, '*');
      int indent = 2;
      if (s2 > 1)
	{
	  printf ("BIL_SET%d (", (int) s2);
	  indent += 10 + (s2 >= 10);
	}
      if (s3 > 32)
	printf ("BIL_PAIR (BIL_VAL (0x%.*s), BIL_VAL (0x%.8s))",
		(int) s4 - 8, p, p + (s4 - 8));
      else
	printf ("BIL_VAL (0x%.*s)", (int) s4, p);
      p += s4;
      for (size_t j = 1; j < s2; ++j, p += 16)
	printf (",\n%*sBIL_PAIR (BIL_VAL (0x%.8s), BIL_VAL (0x%.8s))",
		indent, "", p, p + 8);
      if (i >= 64)
	printf ("\n%*s/%c And implicit %d 0 bits.  %c/",
		indent, "", '*', i - (i % 64), '*');
      printf ("%s,\n", s2 > 1 ? ")" : "");
      if (*p != '\0')
	abort ();
      if (i != 256)
	mpz_mul_ui (b, b, 10);
      if ((i % 64) == 63)
	mpz_divexact (b, b, a);
    }
  mpz_mul (c, b, b);
  for (int i = 512; i <= 6111; i += 256)
    {
      size_t s = mpz_sizeinbase (c, 2);
      size_t s2 = (s + 63) / 64;
      size_t s3 = ((s - 1) % 64) + 1;
      size_t s4 = (s3 + 3) / 4;
      size_t s5 = (s2 + 14) / 15;
      size_t s6 = s2 % 15;
      if (s6 == 0)
	s6 = 15;
      offs32[l + 1] = offs32[l] + 2 * s2 - (s3 <= 32);
      offs64[l + 1] = offs64[l] + s2;
      ++l;
      gmp_sprintf (buf, "%Zx", c);
      printf ("  /%c %d %c/\n  ", '*', i, '*');
      int indent = 2;
      if (s6 == 1)
	{
	  printf ("BIL_SET%d (", (int) s5);
	  indent += 10 + (s5 >= 10);
	}
      else
	{
	  printf ("BIL_SET%d (BIL_SET%d (", (int) s5, (int) s6);
	  indent += 20 + (s5 >= 10) + (s6 >= 10);
	}
      if (s3 > 32)
	printf ("BIL_PAIR (BIL_VAL (0x%.*s), BIL_VAL (0x%.8s))",
		(int) s4 - 8, buf, buf + (s4 - 8));
      else
	printf ("BIL_VAL (0x%.*s)", (int) s4, buf);
      for (size_t j = 1; j < s2; ++j)
	{
	  if (j == s6)
	    {
	      if (j != 1)
		printf (")");
	      printf (",\n%*sBIL_SET15 (", 12 + (s5 >= 10), "");
	      s6 += 15;
	      indent = 23 + (s5 >= 10);
	    }
	  else
	    printf (",\n%*s", indent, "");
	  printf ("BIL_PAIR (BIL_VAL (0x%.8s), BIL_VAL (0x%.8s))",
		  buf + s4 + ((j - 1) * 16),
		  buf + s4 + ((j - 1) * 16) + 8);
	}
      printf ("\n%*s/%c And implicit %d 0 bits.  %c/))%s\n",
	      indent, "", '*', i, '*', i + 256 <= 6111 ? "," : "");
      mpz_mul (c, c, b);
    }
  if (l != 279)
    abort ();
  printf ("};\n\nstatic unsigned short pow10_offs[] = {\n");
  for (l = 0; l <= 278; ++l)
    printf ("  /%c %d %c/ BIL_OFF (%d, %d),\n",
	    '*', l <= 256 ? l : (l - 255) * 256, '*', offs64[l], offs32[l]);
  printf ("  /%c End %c/ BIL_OFF (%d, %d)\n};\n",
	  '*', '*', offs64[l], offs32[l]);
}  */

static UBILtype pow10_limbs[] = {
  /* 0 */
  BIL_VAL (0x1),
  /* 1 */
  BIL_VAL (0xa),
  /* 2 */
  BIL_VAL (0x64),
  /* 3 */
  BIL_VAL (0x3e8),
  /* 4 */
  BIL_VAL (0x2710),
  /* 5 */
  BIL_VAL (0x186a0),
  /* 6 */
  BIL_VAL (0xf4240),
  /* 7 */
  BIL_VAL (0x989680),
  /* 8 */
  BIL_VAL (0x5f5e100),
  /* 9 */
  BIL_VAL (0x3b9aca00),
  /* 10 */
  BIL_PAIR (BIL_VAL (0x2), BIL_VAL (0x540be400)),
  /* 11 */
  BIL_PAIR (BIL_VAL (0x17), BIL_VAL (0x4876e800)),
  /* 12 */
  BIL_PAIR (BIL_VAL (0xe8), BIL_VAL (0xd4a51000)),
  /* 13 */
  BIL_PAIR (BIL_VAL (0x918), BIL_VAL (0x4e72a000)),
  /* 14 */
  BIL_PAIR (BIL_VAL (0x5af3), BIL_VAL (0x107a4000)),
  /* 15 */
  BIL_PAIR (BIL_VAL (0x38d7e), BIL_VAL (0xa4c68000)),
  /* 16 */
  BIL_PAIR (BIL_VAL (0x2386f2), BIL_VAL (0x6fc10000)),
  /* 17 */
  BIL_PAIR (BIL_VAL (0x1634578), BIL_VAL (0x5d8a0000)),
  /* 18 */
  BIL_PAIR (BIL_VAL (0xde0b6b3), BIL_VAL (0xa7640000)),
  /* 19 */
  BIL_PAIR (BIL_VAL (0x8ac72304), BIL_VAL (0x89e80000)),
  /* 20 */
  BIL_SET2 (BIL_VAL (0x5),
	    BIL_PAIR (BIL_VAL (0x6bc75e2d), BIL_VAL (0x63100000))),
  /* 21 */
  BIL_SET2 (BIL_VAL (0x36),
	    BIL_PAIR (BIL_VAL (0x35c9adc5), BIL_VAL (0xdea00000))),
  /* 22 */
  BIL_SET2 (BIL_VAL (0x21e),
	    BIL_PAIR (BIL_VAL (0x19e0c9ba), BIL_VAL (0xb2400000))),
  /* 23 */
  BIL_SET2 (BIL_VAL (0x152d),
	    BIL_PAIR (BIL_VAL (0x02c7e14a), BIL_VAL (0xf6800000))),
  /* 24 */
  BIL_SET2 (BIL_VAL (0xd3c2),
	    BIL_PAIR (BIL_VAL (0x1bcecced), BIL_VAL (0xa1000000))),
  /* 25 */
  BIL_SET2 (BIL_VAL (0x84595),
	    BIL_PAIR (BIL_VAL (0x16140148), BIL_VAL (0x4a000000))),
  /* 26 */
  BIL_SET2 (BIL_VAL (0x52b7d2),
	    BIL_PAIR (BIL_VAL (0xdcc80cd2), BIL_VAL (0xe4000000))),
  /* 27 */
  BIL_SET2 (BIL_VAL (0x33b2e3c),
	    BIL_PAIR (BIL_VAL (0x9fd0803c), BIL_VAL (0xe8000000))),
  /* 28 */
  BIL_SET2 (BIL_VAL (0x204fce5e),
	    BIL_PAIR (BIL_VAL (0x3e250261), BIL_VAL (0x10000000))),
  /* 29 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0x1), BIL_VAL (0x431e0fae)),
	    BIL_PAIR (BIL_VAL (0x6d7217ca), BIL_VAL (0xa0000000))),
  /* 30 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0xc), BIL_VAL (0x9f2c9cd0)),
	    BIL_PAIR (BIL_VAL (0x4674edea), BIL_VAL (0x40000000))),
  /* 31 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0x7e), BIL_VAL (0x37be2022)),
	    BIL_PAIR (BIL_VAL (0xc0914b26), BIL_VAL (0x80000000))),
  /* 32 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0x4ee), BIL_VAL (0x2d6d415b)),
	    BIL_PAIR (BIL_VAL (0x85acef81), BIL_VAL (0x00000000))),
  /* 33 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0x314d), BIL_VAL (0xc6448d93)),
	    BIL_PAIR (BIL_VAL (0x38c15b0a), BIL_VAL (0x00000000))),
  /* 34 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0x1ed09), BIL_VAL (0xbead87c0)),
	    BIL_PAIR (BIL_VAL (0x378d8e64), BIL_VAL (0x00000000))),
  /* 35 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0x134261), BIL_VAL (0x72c74d82)),
	    BIL_PAIR (BIL_VAL (0x2b878fe8), BIL_VAL (0x00000000))),
  /* 36 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0xc097ce), BIL_VAL (0x7bc90715)),
	    BIL_PAIR (BIL_VAL (0xb34b9f10), BIL_VAL (0x00000000))),
  /* 37 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0x785ee10), BIL_VAL (0xd5da46d9)),
	    BIL_PAIR (BIL_VAL (0x00f436a0), BIL_VAL (0x00000000))),
  /* 38 */
  BIL_SET2 (BIL_PAIR (BIL_VAL (0x4b3b4ca8), BIL_VAL (0x5a86c47a)),
	    BIL_PAIR (BIL_VAL (0x098a2240), BIL_VAL (0x00000000))),
  /* 39 */
  BIL_SET3 (BIL_VAL (0x2),
	    BIL_PAIR (BIL_VAL (0xf050fe93), BIL_VAL (0x8943acc4)),
	    BIL_PAIR (BIL_VAL (0x5f655680), BIL_VAL (0x00000000))),
  /* 40 */
  BIL_SET3 (BIL_VAL (0x1d),
	    BIL_PAIR (BIL_VAL (0x6329f1c3), BIL_VAL (0x5ca4bfab)),
	    BIL_PAIR (BIL_VAL (0xb9f56100), BIL_VAL (0x00000000))),
  /* 41 */
  BIL_SET3 (BIL_VAL (0x125),
	    BIL_PAIR (BIL_VAL (0xdfa371a1), BIL_VAL (0x9e6f7cb5)),
	    BIL_PAIR (BIL_VAL (0x4395ca00), BIL_VAL (0x00000000))),
  /* 42 */
  BIL_SET3 (BIL_VAL (0xb7a),
	    BIL_PAIR (BIL_VAL (0xbc627050), BIL_VAL (0x305adf14)),
	    BIL_PAIR (BIL_VAL (0xa3d9e400), BIL_VAL (0x00000000))),
  /* 43 */
  BIL_SET3 (BIL_VAL (0x72cb),
	    BIL_PAIR (BIL_VAL (0x5bd86321), BIL_VAL (0xe38cb6ce)),
	    BIL_PAIR (BIL_VAL (0x6682e800), BIL_VAL (0x00000000))),
  /* 44 */
  BIL_SET3 (BIL_VAL (0x47bf1),
	    BIL_PAIR (BIL_VAL (0x9673df52), BIL_VAL (0xe37f2410)),
	    BIL_PAIR (BIL_VAL (0x011d1000), BIL_VAL (0x00000000))),
  /* 45 */
  BIL_SET3 (BIL_VAL (0x2cd76f),
	    BIL_PAIR (BIL_VAL (0xe086b93c), BIL_VAL (0xe2f768a0)),
	    BIL_PAIR (BIL_VAL (0x0b22a000), BIL_VAL (0x00000000))),
  /* 46 */
  BIL_SET3 (BIL_VAL (0x1c06a5e),
	    BIL_PAIR (BIL_VAL (0xc5433c60), BIL_VAL (0xddaa1640)),
	    BIL_PAIR (BIL_VAL (0x6f5a4000), BIL_VAL (0x00000000))),
  /* 47 */
  BIL_SET3 (BIL_VAL (0x118427b3),
	    BIL_PAIR (BIL_VAL (0xb4a05bc8), BIL_VAL (0xa8a4de84)),
	    BIL_PAIR (BIL_VAL (0x59868000), BIL_VAL (0x00000000))),
  /* 48 */
  BIL_SET3 (BIL_VAL (0xaf298d05),
	    BIL_PAIR (BIL_VAL (0x0e4395d6), BIL_VAL (0x9670b12b)),
	    BIL_PAIR (BIL_VAL (0x7f410000), BIL_VAL (0x00000000))),
  /* 49 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x6), BIL_VAL (0xd79f8232)),
	    BIL_PAIR (BIL_VAL (0x8ea3da61), BIL_VAL (0xe066ebb2)),
	    BIL_PAIR (BIL_VAL (0xf88a0000), BIL_VAL (0x00000000))),
  /* 50 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x44), BIL_VAL (0x6c3b15f9)),
	    BIL_PAIR (BIL_VAL (0x926687d2), BIL_VAL (0xc40534fd)),
	    BIL_PAIR (BIL_VAL (0xb5640000), BIL_VAL (0x00000000))),
  /* 51 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x2ac), BIL_VAL (0x3a4edbbf)),
	    BIL_PAIR (BIL_VAL (0xb8014e3b), BIL_VAL (0xa83411e9)),
	    BIL_PAIR (BIL_VAL (0x15e80000), BIL_VAL (0x00000000))),
  /* 52 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x1aba), BIL_VAL (0x4714957d)),
	    BIL_PAIR (BIL_VAL (0x300d0e54), BIL_VAL (0x9208b31a)),
	    BIL_PAIR (BIL_VAL (0xdb100000), BIL_VAL (0x00000000))),
  /* 53 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x10b46), BIL_VAL (0xc6cdd6e3)),
	    BIL_PAIR (BIL_VAL (0xe0828f4d), BIL_VAL (0xb456ff0c)),
	    BIL_PAIR (BIL_VAL (0x8ea00000), BIL_VAL (0x00000000))),
  /* 54 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0xa70c3), BIL_VAL (0xc40a64e6)),
	    BIL_PAIR (BIL_VAL (0xc5199909), BIL_VAL (0x0b65f67d)),
	    BIL_PAIR (BIL_VAL (0x92400000), BIL_VAL (0x00000000))),
  /* 55 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x6867a5), BIL_VAL (0xa867f103)),
	    BIL_PAIR (BIL_VAL (0xb2fffa5a), BIL_VAL (0x71fba0e7)),
	    BIL_PAIR (BIL_VAL (0xb6800000), BIL_VAL (0x00000000))),
  /* 56 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x4140c78), BIL_VAL (0x940f6a24)),
	    BIL_PAIR (BIL_VAL (0xfdffc788), BIL_VAL (0x73d4490d)),
	    BIL_PAIR (BIL_VAL (0x21000000), BIL_VAL (0x00000000))),
  /* 57 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x28c87cb5), BIL_VAL (0xc89a2571)),
	    BIL_PAIR (BIL_VAL (0xebfdcb54), BIL_VAL (0x864ada83)),
	    BIL_PAIR (BIL_VAL (0x4a000000), BIL_VAL (0x00000000))),
  /* 58 */
  BIL_SET4 (BIL_VAL (0x1),
	    BIL_PAIR (BIL_VAL (0x97d4df19), BIL_VAL (0xd6057673)),
	    BIL_PAIR (BIL_VAL (0x37e9f14d), BIL_VAL (0x3eec8920)),
	    BIL_PAIR (BIL_VAL (0xe4000000), BIL_VAL (0x00000000))),
  /* 59 */
  BIL_SET4 (BIL_VAL (0xf),
	    BIL_PAIR (BIL_VAL (0xee50b702), BIL_VAL (0x5c36a080)),
	    BIL_PAIR (BIL_VAL (0x2f236d04), BIL_VAL (0x753d5b48)),
	    BIL_PAIR (BIL_VAL (0xe8000000), BIL_VAL (0x00000000))),
  /* 60 */
  BIL_SET4 (BIL_VAL (0x9f),
	    BIL_PAIR (BIL_VAL (0x4f272617), BIL_VAL (0x9a224501)),
	    BIL_PAIR (BIL_VAL (0xd762422c), BIL_VAL (0x946590d9)),
	    BIL_PAIR (BIL_VAL (0x10000000), BIL_VAL (0x00000000))),
  /* 61 */
  BIL_SET4 (BIL_VAL (0x639),
	    BIL_PAIR (BIL_VAL (0x17877cec), BIL_VAL (0x0556b212)),
	    BIL_PAIR (BIL_VAL (0x69d695bd), BIL_VAL (0xcbf7a87a)),
	    BIL_PAIR (BIL_VAL (0xa0000000), BIL_VAL (0x00000000))),
  /* 62 */
  BIL_SET4 (BIL_VAL (0x3e3a),
	    BIL_PAIR (BIL_VAL (0xeb4ae138), BIL_VAL (0x3562f4b8)),
	    BIL_PAIR (BIL_VAL (0x2261d969), BIL_VAL (0xf7ac94ca)),
	    BIL_PAIR (BIL_VAL (0x40000000), BIL_VAL (0x00000000))),
  /* 63 */
  BIL_SET4 (BIL_VAL (0x26e4d),
	    BIL_PAIR (BIL_VAL (0x30eccc32), BIL_VAL (0x15dd8f31)),
	    BIL_PAIR (BIL_VAL (0x57d27e23), BIL_VAL (0xacbdcfe6)),
	    BIL_PAIR (BIL_VAL (0x80000000), BIL_VAL (0x00000000))),
  /* 64 */
  BIL_SET3 (BIL_VAL (0x184f03),
	    BIL_PAIR (BIL_VAL (0xe93ff9f4), BIL_VAL (0xdaa797ed)),
	    BIL_PAIR (BIL_VAL (0x6e38ed64), BIL_VAL (0xbf6a1f01))
	    /* And implicit 64 0 bits.  */),
  /* 65 */
  BIL_SET3 (BIL_VAL (0xf31627),
	    BIL_PAIR (BIL_VAL (0x1c7fc390), BIL_VAL (0x8a8bef46)),
	    BIL_PAIR (BIL_VAL (0x4e3945ef), BIL_VAL (0x7a25360a))
	    /* And implicit 64 0 bits.  */),
  /* 66 */
  BIL_SET3 (BIL_VAL (0x97edd87),
	    BIL_PAIR (BIL_VAL (0x1cfda3a5), BIL_VAL (0x697758bf)),
	    BIL_PAIR (BIL_VAL (0x0e3cbb5a), BIL_VAL (0xc5741c64))
	    /* And implicit 64 0 bits.  */),
  /* 67 */
  BIL_SET3 (BIL_VAL (0x5ef4a747),
	    BIL_PAIR (BIL_VAL (0x21e86476), BIL_VAL (0x1ea97776)),
	    BIL_PAIR (BIL_VAL (0x8e5f518b), BIL_VAL (0xb6891be8))
	    /* And implicit 64 0 bits.  */),
  /* 68 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x3), BIL_VAL (0xb58e88c7)),
	    BIL_PAIR (BIL_VAL (0x5313ec9d), BIL_VAL (0x329eaaa1)),
	    BIL_PAIR (BIL_VAL (0x8fb92f75), BIL_VAL (0x215b1710))
	    /* And implicit 64 0 bits.  */),
  /* 69 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x25), BIL_VAL (0x179157c9)),
	    BIL_PAIR (BIL_VAL (0x3ec73e23), BIL_VAL (0xfa32aa4f)),
	    BIL_PAIR (BIL_VAL (0x9d3bda93), BIL_VAL (0x4d8ee6a0))
	    /* And implicit 64 0 bits.  */),
  /* 70 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x172), BIL_VAL (0xebad6ddc)),
	    BIL_PAIR (BIL_VAL (0x73c86d67), BIL_VAL (0xc5faa71c)),
	    BIL_PAIR (BIL_VAL (0x245689c1), BIL_VAL (0x07950240))
	    /* And implicit 64 0 bits.  */),
  /* 71 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0xe7d), BIL_VAL (0x34c64a9c)),
	    BIL_PAIR (BIL_VAL (0x85d4460d), BIL_VAL (0xbbca8719)),
	    BIL_PAIR (BIL_VAL (0x6b61618a), BIL_VAL (0x4bd21680))
	    /* And implicit 64 0 bits.  */),
  /* 72 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x90e4), BIL_VAL (0x0fbeea1d)),
	    BIL_PAIR (BIL_VAL (0x3a4abc89), BIL_VAL (0x55e946fe)),
	    BIL_PAIR (BIL_VAL (0x31cdcf66), BIL_VAL (0xf634e100))
	    /* And implicit 64 0 bits.  */),
  /* 73 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x5a8e8), BIL_VAL (0x9d752524)),
	    BIL_PAIR (BIL_VAL (0x46eb5d5d), BIL_VAL (0x5b1cc5ed)),
	    BIL_PAIR (BIL_VAL (0xf20a1a05), BIL_VAL (0x9e10ca00))
	    /* And implicit 64 0 bits.  */),
  /* 74 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x389916), BIL_VAL (0x2693736a)),
	    BIL_PAIR (BIL_VAL (0xc531a5a5), BIL_VAL (0x8f1fbb4b)),
	    BIL_PAIR (BIL_VAL (0x74650438), BIL_VAL (0x2ca7e400))
	    /* And implicit 64 0 bits.  */),
  /* 75 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x235fadd), BIL_VAL (0x81c2822b)),
	    BIL_PAIR (BIL_VAL (0xb3f07877), BIL_VAL (0x973d50f2)),
	    BIL_PAIR (BIL_VAL (0x8bf22a31), BIL_VAL (0xbe8ee800))
	    /* And implicit 64 0 bits.  */),
  /* 76 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0x161bcca7), BIL_VAL (0x119915b5)),
	    BIL_PAIR (BIL_VAL (0x0764b4ab), BIL_VAL (0xe8652979)),
	    BIL_PAIR (BIL_VAL (0x7775a5f1), BIL_VAL (0x71951000))
	    /* And implicit 64 0 bits.  */),
  /* 77 */
  BIL_SET3 (BIL_PAIR (BIL_VAL (0xdd15fe86), BIL_VAL (0xaffad912)),
	    BIL_PAIR (BIL_VAL (0x49ef0eb7), BIL_VAL (0x13f39ebe)),
	    BIL_PAIR (BIL_VAL (0xaa987b6e), BIL_VAL (0x6fd2a000))
	    /* And implicit 64 0 bits.  */),
  /* 78 */
  BIL_SET4 (BIL_VAL (0x8),
	    BIL_PAIR (BIL_VAL (0xa2dbf142), BIL_VAL (0xdfcc7ab6)),
	    BIL_PAIR (BIL_VAL (0xe3569326), BIL_VAL (0xc7843372)),
	    BIL_PAIR (BIL_VAL (0xa9f4d250), BIL_VAL (0x5e3a4000))
	    /* And implicit 64 0 bits.  */),
  /* 79 */
  BIL_SET4 (BIL_VAL (0x56),
	    BIL_PAIR (BIL_VAL (0x5c976c9c), BIL_VAL (0xbdfccb24)),
	    BIL_PAIR (BIL_VAL (0xe161bf83), BIL_VAL (0xcb2a027a)),
	    BIL_PAIR (BIL_VAL (0xa3903723), BIL_VAL (0xae468000))
	    /* And implicit 64 0 bits.  */),
  /* 80 */
  BIL_SET4 (BIL_VAL (0x35f),
	    BIL_PAIR (BIL_VAL (0x9dea3e1f), BIL_VAL (0x6bdfef70)),
	    BIL_PAIR (BIL_VAL (0xcdd17b25), BIL_VAL (0xefa418ca)),
	    BIL_PAIR (BIL_VAL (0x63a22764), BIL_VAL (0xcec10000))
	    /* And implicit 64 0 bits.  */),
  /* 81 */
  BIL_SET4 (BIL_VAL (0x21bc),
	    BIL_PAIR (BIL_VAL (0x2b266d3a), BIL_VAL (0x36bf5a68)),
	    BIL_PAIR (BIL_VAL (0x0a2ecf7b), BIL_VAL (0x5c68f7e7)),
	    BIL_PAIR (BIL_VAL (0xe45589f0), BIL_VAL (0x138a0000))
	    /* And implicit 64 0 bits.  */),
  /* 82 */
  BIL_SET4 (BIL_VAL (0x15159),
	    BIL_PAIR (BIL_VAL (0xaf804446), BIL_VAL (0x23798810)),
	    BIL_PAIR (BIL_VAL (0x65d41ad1), BIL_VAL (0x9c19af0e)),
	    BIL_PAIR (BIL_VAL (0xeb576360), BIL_VAL (0xc3640000))
	    /* And implicit 64 0 bits.  */),
  /* 83 */
  BIL_SET4 (BIL_VAL (0xd2d80),
	    BIL_PAIR (BIL_VAL (0xdb02aabd), BIL_VAL (0x62bf50a3)),
	    BIL_PAIR (BIL_VAL (0xfa490c30), BIL_VAL (0x1900d695)),
	    BIL_PAIR (BIL_VAL (0x3169e1c7), BIL_VAL (0xa1e80000))
	    /* And implicit 64 0 bits.  */),
  /* 84 */
  BIL_SET4 (BIL_VAL (0x83c708),
	    BIL_PAIR (BIL_VAL (0x8e1aab65), BIL_VAL (0xdb792667)),
	    BIL_PAIR (BIL_VAL (0xc6da79e0), BIL_VAL (0xfa0861d3)),
	    BIL_PAIR (BIL_VAL (0xee22d1cc), BIL_VAL (0x53100000))
	    /* And implicit 64 0 bits.  */),
  /* 85 */
  BIL_SET4 (BIL_VAL (0x525c655),
	    BIL_PAIR (BIL_VAL (0x8d0ab1fa), BIL_VAL (0x92bb800d)),
	    BIL_PAIR (BIL_VAL (0xc488c2c9), BIL_VAL (0xc453d247)),
	    BIL_PAIR (BIL_VAL (0x4d5c31fb), BIL_VAL (0x3ea00000))
	    /* And implicit 64 0 bits.  */),
  /* 86 */
  BIL_SET4 (BIL_VAL (0x3379bf57),
	    BIL_PAIR (BIL_VAL (0x826af3c9), BIL_VAL (0xbb530089)),
	    BIL_PAIR (BIL_VAL (0xad579be1), BIL_VAL (0xab4636c9)),
	    BIL_PAIR (BIL_VAL (0x0599f3d0), BIL_VAL (0x72400000))
	    /* And implicit 64 0 bits.  */),
  /* 87 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0x2), BIL_VAL (0x02c1796b)),
	    BIL_PAIR (BIL_VAL (0x182d85e1), BIL_VAL (0x513e0560)),
	    BIL_PAIR (BIL_VAL (0xc56c16d0), BIL_VAL (0xb0be23da)),
	    BIL_PAIR (BIL_VAL (0x38038624), BIL_VAL (0x76800000))
	    /* And implicit 64 0 bits.  */),
  /* 88 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0x14), BIL_VAL (0x1b8ebe2e)),
	    BIL_PAIR (BIL_VAL (0xf1c73acd), BIL_VAL (0x2c6c35c7)),
	    BIL_PAIR (BIL_VAL (0xb638e426), BIL_VAL (0xe76d6686)),
	    BIL_PAIR (BIL_VAL (0x30233d6c), BIL_VAL (0xa1000000))
	    /* And implicit 64 0 bits.  */),
  /* 89 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0xc9), BIL_VAL (0x13936dd5)),
	    BIL_PAIR (BIL_VAL (0x71c84c03), BIL_VAL (0xbc3a19cd)),
	    BIL_PAIR (BIL_VAL (0x1e38e985), BIL_VAL (0x0a46013d)),
	    BIL_PAIR (BIL_VAL (0xe160663e), BIL_VAL (0x4a000000))
	    /* And implicit 64 0 bits.  */),
  /* 90 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0x7da), BIL_VAL (0xc3c24a56)),
	    BIL_PAIR (BIL_VAL (0x71d2f825), BIL_VAL (0x5a450203)),
	    BIL_PAIR (BIL_VAL (0x2e391f32), BIL_VAL (0x66bc0c6a)),
	    BIL_PAIR (BIL_VAL (0xcdc3fe6e), BIL_VAL (0xe4000000))
	    /* And implicit 64 0 bits.  */),
  /* 91 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0x4e8b), BIL_VAL (0xa596e760)),
	    BIL_PAIR (BIL_VAL (0x723db175), BIL_VAL (0x86b2141f)),
	    BIL_PAIR (BIL_VAL (0xce3b37f8), BIL_VAL (0x03587c2c)),
	    BIL_PAIR (BIL_VAL (0x09a7f054), BIL_VAL (0xe8000000))
	    /* And implicit 64 0 bits.  */),
  /* 92 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0x31174), BIL_VAL (0x77e509c4)),
	    BIL_PAIR (BIL_VAL (0x7668ee97), BIL_VAL (0x42f4c93e)),
	    BIL_PAIR (BIL_VAL (0x0e502fb0), BIL_VAL (0x2174d9b8)),
	    BIL_PAIR (BIL_VAL (0x608f6351), BIL_VAL (0x10000000))
	    /* And implicit 64 0 bits.  */),
  /* 93 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0x1eae8c), BIL_VAL (0xaef261ac)),
	    BIL_PAIR (BIL_VAL (0xa01951e8), BIL_VAL (0x9d8fdc6c)),
	    BIL_PAIR (BIL_VAL (0x8f21dce1), BIL_VAL (0x4e908133)),
	    BIL_PAIR (BIL_VAL (0xc599e12a), BIL_VAL (0xa0000000))
	    /* And implicit 64 0 bits.  */),
  /* 94 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0x132d17e), BIL_VAL (0xd577d0be)),
	    BIL_PAIR (BIL_VAL (0x40fd3316), BIL_VAL (0x279e9c3d)),
	    BIL_PAIR (BIL_VAL (0x9752a0cd), BIL_VAL (0x11a50c05)),
	    BIL_PAIR (BIL_VAL (0xb802cbaa), BIL_VAL (0x40000000))
	    /* And implicit 64 0 bits.  */),
  /* 95 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0xbfc2ef4), BIL_VAL (0x56ae276e)),
	    BIL_PAIR (BIL_VAL (0x89e3fedd), BIL_VAL (0x8c321a67)),
	    BIL_PAIR (BIL_VAL (0xe93a4802), BIL_VAL (0xb0727839)),
	    BIL_PAIR (BIL_VAL (0x301bf4a6), BIL_VAL (0x80000000))
	    /* And implicit 64 0 bits.  */),
  /* 96 */
  BIL_SET4 (BIL_PAIR (BIL_VAL (0x77d9d58b), BIL_VAL (0x62cd8a51)),
	    BIL_PAIR (BIL_VAL (0x62e7f4a7), BIL_VAL (0x79f5080f)),
	    BIL_PAIR (BIL_VAL (0x1c46d01a), BIL_VAL (0xe478b23b)),
	    BIL_PAIR (BIL_VAL (0xe1178e81), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 97 */
  BIL_SET5 (BIL_VAL (0x4),
	    BIL_PAIR (BIL_VAL (0xae825771), BIL_VAL (0xdc07672d)),
	    BIL_PAIR (BIL_VAL (0xdd0f8e8a), BIL_VAL (0xc3925097)),
	    BIL_PAIR (BIL_VAL (0x1ac4210c), BIL_VAL (0xecb6f656)),
	    BIL_PAIR (BIL_VAL (0xcaeb910a), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 98 */
  BIL_SET5 (BIL_VAL (0x2e),
	    BIL_PAIR (BIL_VAL (0xd1176a72), BIL_VAL (0x984a07ca)),
	    BIL_PAIR (BIL_VAL (0xa29b916b), BIL_VAL (0xa3b725e7)),
	    BIL_PAIR (BIL_VAL (0x0ba94a81), BIL_VAL (0x3f259f63)),
	    BIL_PAIR (BIL_VAL (0xed33aa64), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 99 */
  BIL_SET5 (BIL_VAL (0x1d4),
	    BIL_PAIR (BIL_VAL (0x2aea2879), BIL_VAL (0xf2e44dea)),
	    BIL_PAIR (BIL_VAL (0x5a13ae34), BIL_VAL (0x65277b06)),
	    BIL_PAIR (BIL_VAL (0x749ce90c), BIL_VAL (0x777839e7)),
	    BIL_PAIR (BIL_VAL (0x4404a7e8), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 100 */
  BIL_SET5 (BIL_VAL (0x1249),
	    BIL_PAIR (BIL_VAL (0xad2594c3), BIL_VAL (0x7ceb0b27)),
	    BIL_PAIR (BIL_VAL (0x84c4ce0b), BIL_VAL (0xf38ace40)),
	    BIL_PAIR (BIL_VAL (0x8e211a7c), BIL_VAL (0xaab24308)),
	    BIL_PAIR (BIL_VAL (0xa82e8f10), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 101 */
  BIL_SET5 (BIL_VAL (0xb6e0),
	    BIL_PAIR (BIL_VAL (0xc377cfa2), BIL_VAL (0xe12e6f8b)),
	    BIL_PAIR (BIL_VAL (0x2fb00c77), BIL_VAL (0x836c0e85)),
	    BIL_PAIR (BIL_VAL (0x8d4b08de), BIL_VAL (0xaaf69e56)),
	    BIL_PAIR (BIL_VAL (0x91d196a0), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 102 */
  BIL_SET5 (BIL_VAL (0x724c7),
	    BIL_PAIR (BIL_VAL (0xa2ae1c5c), BIL_VAL (0xcbd05b6f)),
	    BIL_PAIR (BIL_VAL (0xdce07cab), BIL_VAL (0x22389137)),
	    BIL_PAIR (BIL_VAL (0x84ee58b2), BIL_VAL (0xada22f61)),
	    BIL_PAIR (BIL_VAL (0xb22fe240), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 103 */
  BIL_SET5 (BIL_VAL (0x476fcc),
	    BIL_PAIR (BIL_VAL (0x5acd1b9f), BIL_VAL (0xf623925e)),
	    BIL_PAIR (BIL_VAL (0xa0c4deaf), BIL_VAL (0x5635ac2b)),
	    BIL_PAIR (BIL_VAL (0x314f76fa), BIL_VAL (0xc855d9d0)),
	    BIL_PAIR (BIL_VAL (0xf5ded680), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 104 */
  BIL_SET5 (BIL_VAL (0x2ca5dfb),
	    BIL_PAIR (BIL_VAL (0x8c03143f), BIL_VAL (0x9d63b7b2)),
	    BIL_PAIR (BIL_VAL (0x47b0b2d9), BIL_VAL (0x5e18b9af)),
	    BIL_PAIR (BIL_VAL (0xed1aa5cb), BIL_VAL (0xd35a8229)),
	    BIL_PAIR (BIL_VAL (0x9ab46100), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 105 */
  BIL_SET5 (BIL_VAL (0x1be7abd3),
	    BIL_PAIR (BIL_VAL (0x781eca7c), BIL_VAL (0x25e52cf6)),
	    BIL_PAIR (BIL_VAL (0xcce6fc7d), BIL_VAL (0xacf740df)),
	    BIL_PAIR (BIL_VAL (0x430a79f6), BIL_VAL (0x418915a0)),
	    BIL_PAIR (BIL_VAL (0x0b0bca00), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 106 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x1), BIL_VAL (0x170cb642)),
	    BIL_PAIR (BIL_VAL (0xb133e8d9), BIL_VAL (0x7af3c1a4)),
	    BIL_PAIR (BIL_VAL (0x0105dce8), BIL_VAL (0xc1a888b8)),
	    BIL_PAIR (BIL_VAL (0x9e68c39e), BIL_VAL (0x8f5ad840)),
	    BIL_PAIR (BIL_VAL (0x6e75e400), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 107 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0xa), BIL_VAL (0xe67f1e9a)),
	    BIL_PAIR (BIL_VAL (0xec07187e), BIL_VAL (0xcd859068)),
	    BIL_PAIR (BIL_VAL (0x0a3aa117), BIL_VAL (0x90955736)),
	    BIL_PAIR (BIL_VAL (0x3017a431), BIL_VAL (0x998c7284)),
	    BIL_PAIR (BIL_VAL (0x509ae800), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 108 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x6d), BIL_VAL (0x00f7320d)),
	    BIL_PAIR (BIL_VAL (0x3846f4f4), BIL_VAL (0x0737a410)),
	    BIL_PAIR (BIL_VAL (0x664a4aeb), BIL_VAL (0xa5d5681d)),
	    BIL_PAIR (BIL_VAL (0xe0ec69ef), BIL_VAL (0xff7c792b)),
	    BIL_PAIR (BIL_VAL (0x260d1000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 109 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x442), BIL_VAL (0x09a7f484)),
	    BIL_PAIR (BIL_VAL (0x32c59188), BIL_VAL (0x482c68a3)),
	    BIL_PAIR (BIL_VAL (0xfee6ed34), BIL_VAL (0x7a56112a)),
	    BIL_PAIR (BIL_VAL (0xc93c235f), BIL_VAL (0xfadcbbaf)),
	    BIL_PAIR (BIL_VAL (0x7c82a000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 110 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x2a94), BIL_VAL (0x608f8d29)),
	    BIL_PAIR (BIL_VAL (0xfbb7af52), BIL_VAL (0xd1bc1667)),
	    BIL_PAIR (BIL_VAL (0xf505440c), BIL_VAL (0xc75cabab)),
	    BIL_PAIR (BIL_VAL (0xdc5961bf), BIL_VAL (0xcc9f54da)),
	    BIL_PAIR (BIL_VAL (0xdd1a4000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 111 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x1a9cb), BIL_VAL (0xc59b83a3)),
	    BIL_PAIR (BIL_VAL (0xd52cd93c), BIL_VAL (0x3158e00f)),
	    BIL_PAIR (BIL_VAL (0x9234a87f), BIL_VAL (0xc99eb4b6)),
	    BIL_PAIR (BIL_VAL (0x9b7dd17d), BIL_VAL (0xfe39508c)),
	    BIL_PAIR (BIL_VAL (0xa3068000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 112 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x10a1f5), BIL_VAL (0xb8132466)),
	    BIL_PAIR (BIL_VAL (0x53c07c59), BIL_VAL (0xed78c09b)),
	    BIL_PAIR (BIL_VAL (0xb60e94fd), BIL_VAL (0xe0330f22)),
	    BIL_PAIR (BIL_VAL (0x12ea2eeb), BIL_VAL (0xee3d257e)),
	    BIL_PAIR (BIL_VAL (0x5e410000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 113 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0xa65399), BIL_VAL (0x30bf6bff)),
	    BIL_PAIR (BIL_VAL (0x4584db83), BIL_VAL (0x46b78615)),
	    BIL_PAIR (BIL_VAL (0x1c91d1ea), BIL_VAL (0xc1fe9754)),
	    BIL_PAIR (BIL_VAL (0xbd25d537), BIL_VAL (0x4e6376ef)),
	    BIL_PAIR (BIL_VAL (0xae8a0000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 114 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x67f43fb), BIL_VAL (0xe77a37f8)),
	    BIL_PAIR (BIL_VAL (0xb7309320), BIL_VAL (0xc32b3cd3)),
	    BIL_PAIR (BIL_VAL (0x1db2332b), BIL_VAL (0x93f1e94f)),
	    BIL_PAIR (BIL_VAL (0x637a5429), BIL_VAL (0x0fe2a55c)),
	    BIL_PAIR (BIL_VAL (0xd1640000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 115 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x40f8a7d7), BIL_VAL (0x0ac62fb7)),
	    BIL_PAIR (BIL_VAL (0x27e5bf47), BIL_VAL (0x9fb0603f)),
	    BIL_PAIR (BIL_VAL (0x28f5ffb3), BIL_VAL (0xc7731d19)),
	    BIL_PAIR (BIL_VAL (0xe2c7499a), BIL_VAL (0x9eda75a0)),
	    BIL_PAIR (BIL_VAL (0x2de80000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 116 */
  BIL_SET6 (BIL_VAL (0x2),
	    BIL_PAIR (BIL_VAL (0x89b68e66), BIL_VAL (0x6bbddd27)),
	    BIL_PAIR (BIL_VAL (0x8ef978cc), BIL_VAL (0x3ce3c277)),
	    BIL_PAIR (BIL_VAL (0x999bfd05), BIL_VAL (0xca7f2302)),
	    BIL_PAIR (BIL_VAL (0xdbc8e00a), BIL_VAL (0x34889841)),
	    BIL_PAIR (BIL_VAL (0xcb100000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 117 */
  BIL_SET6 (BIL_VAL (0x19),
	    BIL_PAIR (BIL_VAL (0x61219000), BIL_VAL (0x356aa38b)),
	    BIL_PAIR (BIL_VAL (0x95beb7fa), BIL_VAL (0x60e598ac)),
	    BIL_PAIR (BIL_VAL (0x0017e239), BIL_VAL (0xe8f75e1c)),
	    BIL_PAIR (BIL_VAL (0x95d8c066), BIL_VAL (0x0d55f291)),
	    BIL_PAIR (BIL_VAL (0xeea00000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 118 */
  BIL_SET6 (BIL_VAL (0xfd),
	    BIL_PAIR (BIL_VAL (0xcb4fa002), BIL_VAL (0x162a6373)),
	    BIL_PAIR (BIL_VAL (0xd9732fc7), BIL_VAL (0xc8f7f6b8)),
	    BIL_PAIR (BIL_VAL (0x00eed643), BIL_VAL (0x19a9ad1d)),
	    BIL_PAIR (BIL_VAL (0xda7783fc), BIL_VAL (0x855b79b3)),
	    BIL_PAIR (BIL_VAL (0x52400000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 119 */
  BIL_SET6 (BIL_VAL (0x9e9),
	    BIL_PAIR (BIL_VAL (0xf11c4014), BIL_VAL (0xdda7e286)),
	    BIL_PAIR (BIL_VAL (0x7e7fddcd), BIL_VAL (0xd9afa330)),
	    BIL_PAIR (BIL_VAL (0x09545e9f), BIL_VAL (0x00a0c32a)),
	    BIL_PAIR (BIL_VAL (0x88ab27dd), BIL_VAL (0x3592c101)),
	    BIL_PAIR (BIL_VAL (0x36800000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 120 */
  BIL_SET6 (BIL_VAL (0x6323),
	    BIL_PAIR (BIL_VAL (0x6b1a80d0), BIL_VAL (0xa88ed940)),
	    BIL_PAIR (BIL_VAL (0xf0feaa0a), BIL_VAL (0x80dc5fe0)),
	    BIL_PAIR (BIL_VAL (0x5d4bb236), BIL_VAL (0x06479fa9)),
	    BIL_PAIR (BIL_VAL (0x56af8ea4), BIL_VAL (0x17bb8a0c)),
	    BIL_PAIR (BIL_VAL (0x21000000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 121 */
  BIL_SET6 (BIL_VAL (0x3df62),
	    BIL_PAIR (BIL_VAL (0x2f090826), BIL_VAL (0x95947c89)),
	    BIL_PAIR (BIL_VAL (0x69f2a469), BIL_VAL (0x089bbec3)),
	    BIL_PAIR (BIL_VAL (0xa4f4f61c), BIL_VAL (0x3ecc3c9d)),
	    BIL_PAIR (BIL_VAL (0x62db9268), BIL_VAL (0xed536479)),
	    BIL_PAIR (BIL_VAL (0x4a000000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 122 */
  BIL_SET6 (BIL_VAL (0x26b9d5),
	    BIL_PAIR (BIL_VAL (0xd65a5181), BIL_VAL (0xd7ccdd5e)),
	    BIL_PAIR (BIL_VAL (0x237a6c1a), BIL_VAL (0x561573a4)),
	    BIL_PAIR (BIL_VAL (0x71919d1a), BIL_VAL (0x73fa5e25)),
	    BIL_PAIR (BIL_VAL (0xdc93b819), BIL_VAL (0x4541ecbc)),
	    BIL_PAIR (BIL_VAL (0xe4000000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 123 */
  BIL_SET6 (BIL_VAL (0x183425a),
	    BIL_PAIR (BIL_VAL (0x5f872f12), BIL_VAL (0x6e00a5ad)),
	    BIL_PAIR (BIL_VAL (0x62c83907), BIL_VAL (0x5cd6846c)),
	    BIL_PAIR (BIL_VAL (0x6fb02308), BIL_VAL (0x87c7ad7a)),
	    BIL_PAIR (BIL_VAL (0x9dc530fc), BIL_VAL (0xb4933f60)),
	    BIL_PAIR (BIL_VAL (0xe8000000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 124 */
  BIL_SET6 (BIL_VAL (0xf209787),
	    BIL_PAIR (BIL_VAL (0xbb47d6b8), BIL_VAL (0x4c0678c5)),
	    BIL_PAIR (BIL_VAL (0xdbd23a49), BIL_VAL (0xa0612c3c)),
	    BIL_PAIR (BIL_VAL (0x5ce15e55), BIL_VAL (0x4dccc6ca)),
	    BIL_PAIR (BIL_VAL (0x29b3e9df), BIL_VAL (0x0dc079c9)),
	    BIL_PAIR (BIL_VAL (0x10000000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 125 */
  BIL_SET6 (BIL_VAL (0x9745eb4d),
	    BIL_PAIR (BIL_VAL (0x50ce6332), BIL_VAL (0xf840b7ba)),
	    BIL_PAIR (BIL_VAL (0x963646e0), BIL_VAL (0x43cbba5b)),
	    BIL_PAIR (BIL_VAL (0xa0cdaf55), BIL_VAL (0x09ffc3e5)),
	    BIL_PAIR (BIL_VAL (0xa10722b6), BIL_VAL (0x8984c1da)),
	    BIL_PAIR (BIL_VAL (0xa0000000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 126 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x5), BIL_VAL (0xe8bb3105)),
	    BIL_PAIR (BIL_VAL (0x280fdffd), BIL_VAL (0xb2872d49)),
	    BIL_PAIR (BIL_VAL (0xde1ec4c2), BIL_VAL (0xa5f54794)),
	    BIL_PAIR (BIL_VAL (0x4808d952), BIL_VAL (0x63fda6f8)),
	    BIL_PAIR (BIL_VAL (0x4a475b21), BIL_VAL (0x5f2f928a)),
	    BIL_PAIR (BIL_VAL (0x40000000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 127 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x3b), BIL_VAL (0x174fea33)),
	    BIL_PAIR (BIL_VAL (0x909ebfe8), BIL_VAL (0xf947c4e2)),
	    BIL_PAIR (BIL_VAL (0xad33af9a), BIL_VAL (0x7b94cbca)),
	    BIL_PAIR (BIL_VAL (0xd0587d37), BIL_VAL (0xe7e885b2)),
	    BIL_PAIR (BIL_VAL (0xe6c98f4d), BIL_VAL (0xb7dbb966)),
	    BIL_PAIR (BIL_VAL (0x80000000), BIL_VAL (0x00000000))
	    /* And implicit 64 0 bits.  */),
  /* 128 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x24e), BIL_VAL (0xe91f2603)),
	    BIL_PAIR (BIL_VAL (0xa6337f19), BIL_VAL (0xbccdb0da)),
	    BIL_PAIR (BIL_VAL (0xc404dc08), BIL_VAL (0xd3cff5ec)),
	    BIL_PAIR (BIL_VAL (0x2374e42f), BIL_VAL (0x0f1538fd)),
	    BIL_PAIR (BIL_VAL (0x03df9909), BIL_VAL (0x2e953e01))
	    /* And implicit 128 0 bits.  */),
  /* 129 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x1715), BIL_VAL (0x1b377c24)),
	    BIL_PAIR (BIL_VAL (0x7e02f701), BIL_VAL (0x6008e88b)),
	    BIL_PAIR (BIL_VAL (0xa8309858), BIL_VAL (0x461f9b39)),
	    BIL_PAIR (BIL_VAL (0x6290e9d6), BIL_VAL (0x96d439e2)),
	    BIL_PAIR (BIL_VAL (0x26bbfa5b), BIL_VAL (0xd1d46c0a))
	    /* And implicit 128 0 bits.  */),
  /* 130 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0xe6d3), BIL_VAL (0x102ad96c)),
	    BIL_PAIR (BIL_VAL (0xec1da60d), BIL_VAL (0xc0591574)),
	    BIL_PAIR (BIL_VAL (0x91e5f372), BIL_VAL (0xbd3c103d)),
	    BIL_PAIR (BIL_VAL (0xd9a92261), BIL_VAL (0xe44a42d5)),
	    BIL_PAIR (BIL_VAL (0x8357c796), BIL_VAL (0x324c3864))
	    /* And implicit 128 0 bits.  */),
  /* 131 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x9043e), BIL_VAL (0xa1ac7e41)),
	    BIL_PAIR (BIL_VAL (0x39287c89), BIL_VAL (0x837ad68d)),
	    BIL_PAIR (BIL_VAL (0xb2fb827b), BIL_VAL (0x6458a26a)),
	    BIL_PAIR (BIL_VAL (0x809b57d2), BIL_VAL (0xeae69c57)),
	    BIL_PAIR (BIL_VAL (0x216dcbdd), BIL_VAL (0xf6fa33e8))
	    /* And implicit 128 0 bits.  */),
  /* 132 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x5a2a72), BIL_VAL (0x50bcee8c)),
	    BIL_PAIR (BIL_VAL (0x3b94dd5f), BIL_VAL (0x22cc6188)),
	    BIL_PAIR (BIL_VAL (0xfdd318d1), BIL_VAL (0xeb765829)),
	    BIL_PAIR (BIL_VAL (0x06116e3d), BIL_VAL (0x2d021b67)),
	    BIL_PAIR (BIL_VAL (0x4e49f6ab), BIL_VAL (0xa5c60710))
	    /* And implicit 128 0 bits.  */),
  /* 133 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x385a877), BIL_VAL (0x2761517a)),
	    BIL_PAIR (BIL_VAL (0x53d0a5b7), BIL_VAL (0x5bfbcf59)),
	    BIL_PAIR (BIL_VAL (0xea3ef833), BIL_VAL (0x329f719a)),
	    BIL_PAIR (BIL_VAL (0x3cae4e63), BIL_VAL (0xc2151209)),
	    BIL_PAIR (BIL_VAL (0x0ee3a2b4), BIL_VAL (0x79bc46a0))
	    /* And implicit 128 0 bits.  */),
  /* 134 */
  BIL_SET5 (BIL_PAIR (BIL_VAL (0x233894a7), BIL_VAL (0x89cd2ec7)),
	    BIL_PAIR (BIL_VAL (0x46267929), BIL_VAL (0x97d61983)),
	    BIL_PAIR (BIL_VAL (0x2675b1ff), BIL_VAL (0xfa3a7006)),
	    BIL_PAIR (BIL_VAL (0x5ecf0fe5), BIL_VAL (0x94d2b45a)),
	    BIL_PAIR (BIL_VAL (0x94e45b0c), BIL_VAL (0xc15ac240))
	    /* And implicit 128 0 bits.  */),
  /* 135 */
  BIL_SET6 (BIL_VAL (0x1),
	    BIL_PAIR (BIL_VAL (0x6035ce8b), BIL_VAL (0x6203d3c8)),
	    BIL_PAIR (BIL_VAL (0xbd80bb9f), BIL_VAL (0xee5cff1f)),
	    BIL_PAIR (BIL_VAL (0x8098f3ff), BIL_VAL (0xc648603f)),
	    BIL_PAIR (BIL_VAL (0xb4169ef7), BIL_VAL (0xd03b0b89)),
	    BIL_PAIR (BIL_VAL (0xd0eb8e7f), BIL_VAL (0x8d8b9680))
	    /* And implicit 128 0 bits.  */),
  /* 136 */
  BIL_SET6 (BIL_VAL (0xd),
	    BIL_PAIR (BIL_VAL (0xc21a1171), BIL_VAL (0xd42645d7)),
	    BIL_PAIR (BIL_VAL (0x6707543f), BIL_VAL (0x4fa1f73b)),
	    BIL_PAIR (BIL_VAL (0x05f987fd), BIL_VAL (0xbed3c27d)),
	    BIL_PAIR (BIL_VAL (0x08e235ae), BIL_VAL (0x224e7362)),
	    BIL_PAIR (BIL_VAL (0x293390fb), BIL_VAL (0x8773e100))
	    /* And implicit 128 0 bits.  */),
  /* 137 */
  BIL_SET6 (BIL_VAL (0x89),
	    BIL_PAIR (BIL_VAL (0x9504ae72), BIL_VAL (0x497eba6a)),
	    BIL_PAIR (BIL_VAL (0x06494a79), BIL_VAL (0x1c53a84e)),
	    BIL_PAIR (BIL_VAL (0x3bbf4fe9), BIL_VAL (0x744598e2)),
	    BIL_PAIR (BIL_VAL (0x58d618cd), BIL_VAL (0x571081d5)),
	    BIL_PAIR (BIL_VAL (0x9c03a9d3), BIL_VAL (0x4a86ca00))
	    /* And implicit 128 0 bits.  */),
  /* 138 */
  BIL_SET6 (BIL_VAL (0x55f),
	    BIL_PAIR (BIL_VAL (0xd22ed076), BIL_VAL (0xdef34824)),
	    BIL_PAIR (BIL_VAL (0x3edce8bb), BIL_VAL (0x1b44930e)),
	    BIL_PAIR (BIL_VAL (0x55791f1e), BIL_VAL (0x8ab7f8d7)),
	    BIL_PAIR (BIL_VAL (0x785cf805), BIL_VAL (0x66a51258)),
	    BIL_PAIR (BIL_VAL (0x1824a240), BIL_VAL (0xe943e400))
	    /* And implicit 128 0 bits.  */),
  /* 139 */
  BIL_SET6 (BIL_VAL (0x35be),
	    BIL_PAIR (BIL_VAL (0x35d424a4), BIL_VAL (0xb580d16a)),
	    BIL_PAIR (BIL_VAL (0x74a1174f), BIL_VAL (0x10adbe8f)),
	    BIL_PAIR (BIL_VAL (0x56bb3731), BIL_VAL (0x6b2fb86a)),
	    BIL_PAIR (BIL_VAL (0xb3a1b036), BIL_VAL (0x0272b770)),
	    BIL_PAIR (BIL_VAL (0xf16e5689), BIL_VAL (0x1ca6e800))
	    /* And implicit 128 0 bits.  */),
  /* 140 */
  BIL_SET6 (BIL_VAL (0x2196e),
	    BIL_PAIR (BIL_VAL (0x1a496e6f), BIL_VAL (0x17082e28)),
	    BIL_PAIR (BIL_VAL (0x8e4ae916), BIL_VAL (0xa6c97199)),
	    BIL_PAIR (BIL_VAL (0x635027ee), BIL_VAL (0x2fdd342b)),
	    BIL_PAIR (BIL_VAL (0x0450e21c), BIL_VAL (0x187b2a69)),
	    BIL_PAIR (BIL_VAL (0x6e4f615b), BIL_VAL (0x1e851000))
	    /* And implicit 128 0 bits.  */),
  /* 141 */
  BIL_SET6 (BIL_VAL (0x14fe4d),
	    BIL_PAIR (BIL_VAL (0x06de5056), BIL_VAL (0xe651cd95)),
	    BIL_PAIR (BIL_VAL (0x8eed1ae2), BIL_VAL (0x83de6ffd)),
	    BIL_PAIR (BIL_VAL (0xe1218f4d), BIL_VAL (0xdea409ae)),
	    BIL_PAIR (BIL_VAL (0x2b28d518), BIL_VAL (0xf4cfa81e)),
	    BIL_PAIR (BIL_VAL (0x4f19cd8f), BIL_VAL (0x3132a000))
	    /* And implicit 128 0 bits.  */),
  /* 142 */
  BIL_SET6 (BIL_VAL (0xd1ef02),
	    BIL_PAIR (BIL_VAL (0x44af2364), BIL_VAL (0xff3207d7)),
	    BIL_PAIR (BIL_VAL (0x95430cd9), BIL_VAL (0x26b05fea)),
	    BIL_PAIR (BIL_VAL (0xcb4f990a), BIL_VAL (0xb26860cd)),
	    BIL_PAIR (BIL_VAL (0xaf9852f9), BIL_VAL (0x901c912f)),
	    BIL_PAIR (BIL_VAL (0x17020797), BIL_VAL (0xebfa4000))
	    /* And implicit 128 0 bits.  */),
  /* 143 */
  BIL_SET6 (BIL_VAL (0x8335616),
	    BIL_PAIR (BIL_VAL (0xaed761f1), BIL_VAL (0xf7f44e6b)),
	    BIL_PAIR (BIL_VAL (0xd49e807b), BIL_VAL (0x82e3bf2b)),
	    BIL_PAIR (BIL_VAL (0xf11bfa6a), BIL_VAL (0xf813c808)),
	    BIL_PAIR (BIL_VAL (0xdbf33dbf), BIL_VAL (0xa11dabd6)),
	    BIL_PAIR (BIL_VAL (0xe6144bef), BIL_VAL (0x37c68000))
	    /* And implicit 128 0 bits.  */),
  /* 144 */
  BIL_SET6 (BIL_VAL (0x52015ce2),
	    BIL_PAIR (BIL_VAL (0xd469d373), BIL_VAL (0xaf8b1036)),
	    BIL_PAIR (BIL_VAL (0x4e3104d3), BIL_VAL (0x1ce577b7)),
	    BIL_PAIR (BIL_VAL (0x6b17c82d), BIL_VAL (0xb0c5d058)),
	    BIL_PAIR (BIL_VAL (0x9780697c), BIL_VAL (0x4b28b664)),
	    BIL_PAIR (BIL_VAL (0xfccaf758), BIL_VAL (0x2dc10000))
	    /* And implicit 128 0 bits.  */),
  /* 145 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x3), BIL_VAL (0x340da0dc)),
	    BIL_PAIR (BIL_VAL (0x4c224284), BIL_VAL (0xdb6ea21f)),
	    BIL_PAIR (BIL_VAL (0x0dea303f), BIL_VAL (0x20f6ad2a)),
	    BIL_PAIR (BIL_VAL (0x2eedd1c8), BIL_VAL (0xe7ba2375)),
	    BIL_PAIR (BIL_VAL (0xeb041eda), BIL_VAL (0xef971ff1)),
	    BIL_PAIR (BIL_VAL (0xdfeda971), BIL_VAL (0xc98a0000))
	    /* And implicit 128 0 bits.  */),
  /* 146 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x20), BIL_VAL (0x0888489a)),
	    BIL_PAIR (BIL_VAL (0xf9569930), BIL_VAL (0x92525536)),
	    BIL_PAIR (BIL_VAL (0x8b25e277), BIL_VAL (0x49a2c3a5)),
	    BIL_PAIR (BIL_VAL (0xd54a31d9), BIL_VAL (0x0d45629b)),
	    BIL_PAIR (BIL_VAL (0x2e29348d), BIL_VAL (0x5be73f72)),
	    BIL_PAIR (BIL_VAL (0xbf489e71), BIL_VAL (0xdf640000))
	    /* And implicit 128 0 bits.  */),
  /* 147 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x140), BIL_VAL (0x5552d60d)),
	    BIL_PAIR (BIL_VAL (0xbd61fbe5), BIL_VAL (0xb7375421)),
	    BIL_PAIR (BIL_VAL (0x6f7ad8a8), BIL_VAL (0xe05ba47a)),
	    BIL_PAIR (BIL_VAL (0x54e5f27a), BIL_VAL (0x84b5da0f)),
	    BIL_PAIR (BIL_VAL (0xcd9c0d85), BIL_VAL (0x97087a7b)),
	    BIL_PAIR (BIL_VAL (0x78d63072), BIL_VAL (0xb9e80000))
	    /* And implicit 128 0 bits.  */),
  /* 148 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0xc83), BIL_VAL (0x553c5c89)),
	    BIL_PAIR (BIL_VAL (0x65d3d6f9), BIL_VAL (0x2829494e)),
	    BIL_PAIR (BIL_VAL (0x5acc7698), BIL_VAL (0xc3946cc7)),
	    BIL_PAIR (BIL_VAL (0x50fb78c9), BIL_VAL (0x2f1a849e)),
	    BIL_PAIR (BIL_VAL (0x08188737), BIL_VAL (0xe654c8d2)),
	    BIL_PAIR (BIL_VAL (0xb85de47b), BIL_VAL (0x43100000))
	    /* And implicit 128 0 bits.  */),
  /* 149 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x7d21), BIL_VAL (0x545b9d5d)),
	    BIL_PAIR (BIL_VAL (0xfa4665bb), BIL_VAL (0x919cdd0f)),
	    BIL_PAIR (BIL_VAL (0x8bfca1f7), BIL_VAL (0xa3cc3fc9)),
	    BIL_PAIR (BIL_VAL (0x29d2b7db), BIL_VAL (0xd7092e2c)),
	    BIL_PAIR (BIL_VAL (0x50f5482e), BIL_VAL (0xff4fd83b)),
	    BIL_PAIR (BIL_VAL (0x33aaecd0), BIL_VAL (0x9ea00000))
	    /* And implicit 128 0 bits.  */),
  /* 150 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x4e34d), BIL_VAL (0x4b9425ab)),
	    BIL_PAIR (BIL_VAL (0xc6bff953), BIL_VAL (0xb020a29b)),
	    BIL_PAIR (BIL_VAL (0x77de53ac), BIL_VAL (0x65fa7ddb)),
	    BIL_PAIR (BIL_VAL (0xa23b2e96), BIL_VAL (0x665bcdbb)),
	    BIL_PAIR (BIL_VAL (0x2994d1d5), BIL_VAL (0xf91e7250)),
	    BIL_PAIR (BIL_VAL (0x04ad4026), BIL_VAL (0x32400000))
	    /* And implicit 128 0 bits.  */),
  /* 151 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x30e104), BIL_VAL (0xf3c978b5)),
	    BIL_PAIR (BIL_VAL (0xc37fbd44), BIL_VAL (0xe1465a12)),
	    BIL_PAIR (BIL_VAL (0xaeaf44bb), BIL_VAL (0xfbc8ea94)),
	    BIL_PAIR (BIL_VAL (0x564fd1df), BIL_VAL (0xff96094f)),
	    BIL_PAIR (BIL_VAL (0x9fd0325b), BIL_VAL (0xbb307720)),
	    BIL_PAIR (BIL_VAL (0x2ec4817d), BIL_VAL (0xf6800000))
	    /* And implicit 128 0 bits.  */),
  /* 152 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x1e8ca31), BIL_VAL (0x85deb719)),
	    BIL_PAIR (BIL_VAL (0xa2fd64b0), BIL_VAL (0xccbf84ba)),
	    BIL_PAIR (BIL_VAL (0xd2d8af57), BIL_VAL (0xd5d929cb)),
	    BIL_PAIR (BIL_VAL (0x5f1e32bf), BIL_VAL (0xfbdc5d1c)),
	    BIL_PAIR (BIL_VAL (0x3e21f795), BIL_VAL (0x4fe4a741)),
	    BIL_PAIR (BIL_VAL (0xd3ad0eeb), BIL_VAL (0xa1000000))
	    /* And implicit 128 0 bits.  */),
  /* 153 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0x1317e5ef), BIL_VAL (0x3ab32700)),
	    BIL_PAIR (BIL_VAL (0x5de5eee7), BIL_VAL (0xff7b2f4c)),
	    BIL_PAIR (BIL_VAL (0x3c76d96e), BIL_VAL (0x5a7ba1f1)),
	    BIL_PAIR (BIL_VAL (0xb72dfb7f), BIL_VAL (0xd69ba31a)),
	    BIL_PAIR (BIL_VAL (0x6d53abd5), BIL_VAL (0x1eee8892)),
	    BIL_PAIR (BIL_VAL (0x44c29534), BIL_VAL (0x4a000000))
	    /* And implicit 128 0 bits.  */),
  /* 154 */
  BIL_SET6 (BIL_PAIR (BIL_VAL (0xbeeefb58), BIL_VAL (0x4aff8603)),
	    BIL_PAIR (BIL_VAL (0xaafb550f), BIL_VAL (0xfacfd8fa)),
	    BIL_PAIR (BIL_VAL (0x5ca47e4f), BIL_VAL (0x88d45371)),
	    BIL_PAIR (BIL_VAL (0x27cbd2fe), BIL_VAL (0x62145f08)),
	    BIL_PAIR (BIL_VAL (0x4544b653), BIL_VAL (0x355155b6)),
	    BIL_PAIR (BIL_VAL (0xaf99d40a), BIL_VAL (0xe4000000))
	    /* And implicit 128 0 bits.  */),
  /* 155 */
  BIL_SET7 (BIL_VAL (0x7),
	    BIL_PAIR (BIL_VAL (0x7555d172), BIL_VAL (0xedfb3c24)),
	    BIL_PAIR (BIL_VAL (0xadd1529f), BIL_VAL (0xcc1e79c7)),
	    BIL_PAIR (BIL_VAL (0x9e6cef1b), BIL_VAL (0x584b426b)),
	    BIL_PAIR (BIL_VAL (0x8df63def), BIL_VAL (0xd4cbb652)),
	    BIL_PAIR (BIL_VAL (0xb4af1f40), BIL_VAL (0x152d5922)),
	    BIL_PAIR (BIL_VAL (0xdc02486c), BIL_VAL (0xe8000000))
	    /* And implicit 128 0 bits.  */),
  /* 156 */
  BIL_SET7 (BIL_VAL (0x4a),
	    BIL_PAIR (BIL_VAL (0x955a2e7d), BIL_VAL (0x4bd0596e)),
	    BIL_PAIR (BIL_VAL (0xca2d3a3d), BIL_VAL (0xf930c1cc)),
	    BIL_PAIR (BIL_VAL (0x30415711), BIL_VAL (0x72f09833)),
	    BIL_PAIR (BIL_VAL (0x8b9e6b5e), BIL_VAL (0x4ff51f3b)),
	    BIL_PAIR (BIL_VAL (0x0ed73880), BIL_VAL (0xd3c57b5c)),
	    BIL_PAIR (BIL_VAL (0x9816d441), BIL_VAL (0x10000000))
	    /* And implicit 128 0 bits.  */),
  /* 157 */
  BIL_SET7 (BIL_VAL (0x2e9),
	    BIL_PAIR (BIL_VAL (0xd585d0e4), BIL_VAL (0xf6237e53)),
	    BIL_PAIR (BIL_VAL (0xe5c4466b), BIL_VAL (0xbbe791f9)),
	    BIL_PAIR (BIL_VAL (0xe28d66ae), BIL_VAL (0x7d65f203)),
	    BIL_PAIR (BIL_VAL (0x743031af), BIL_VAL (0x1f93384e)),
	    BIL_PAIR (BIL_VAL (0x94683508), BIL_VAL (0x45b6d19d)),
	    BIL_PAIR (BIL_VAL (0xf0e44a8a), BIL_VAL (0xa0000000))
	    /* And implicit 128 0 bits.  */),
  /* 158 */
  BIL_SET7 (BIL_VAL (0x1d22),
	    BIL_PAIR (BIL_VAL (0x573a28f1), BIL_VAL (0x9d62ef46)),
	    BIL_PAIR (BIL_VAL (0xf9aac035), BIL_VAL (0x570bb3c2)),
	    BIL_PAIR (BIL_VAL (0xd98602d0), BIL_VAL (0xe5fb7422)),
	    BIL_PAIR (BIL_VAL (0x89e1f0d7), BIL_VAL (0x3bc03311)),
	    BIL_PAIR (BIL_VAL (0xcc121252), BIL_VAL (0xb924302b)),
	    BIL_PAIR (BIL_VAL (0x68eae96a), BIL_VAL (0x40000000))
	    /* And implicit 128 0 bits.  */),
  /* 159 */
  BIL_SET7 (BIL_VAL (0x12357),
	    BIL_PAIR (BIL_VAL (0x68459970), BIL_VAL (0x25dd58c5)),
	    BIL_PAIR (BIL_VAL (0xc0ab8215), BIL_VAL (0x6675059c)),
	    BIL_PAIR (BIL_VAL (0x7f3c1c28), BIL_VAL (0xfbd28959)),
	    BIL_PAIR (BIL_VAL (0x62d36868), BIL_VAL (0x5581feb1)),
	    BIL_PAIR (BIL_VAL (0xf8b4b73b), BIL_VAL (0x3b69e1b2)),
	    BIL_PAIR (BIL_VAL (0x192d1e26), BIL_VAL (0x80000000))
	    /* And implicit 128 0 bits.  */),
  /* 160 */
  BIL_SET7 (BIL_VAL (0xb616a),
	    BIL_PAIR (BIL_VAL (0x12b7fe61), BIL_VAL (0x7aa577b9)),
	    BIL_PAIR (BIL_VAL (0x86b314d6), BIL_VAL (0x0092381c)),
	    BIL_PAIR (BIL_VAL (0xf8591999), BIL_VAL (0xd6395d7d)),
	    BIL_PAIR (BIL_VAL (0xdc421413), BIL_VAL (0x5713f2f3)),
	    BIL_PAIR (BIL_VAL (0xb70f2850), BIL_VAL (0x5222d0f4)),
	    BIL_PAIR (BIL_VAL (0xfbc32d81), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 161 */
  BIL_SET7 (BIL_VAL (0x71ce24),
	    BIL_PAIR (BIL_VAL (0xbb2fefce), BIL_VAL (0xca76ad3f)),
	    BIL_PAIR (BIL_VAL (0x42fed05c), BIL_VAL (0x05b63121)),
	    BIL_PAIR (BIL_VAL (0xb37b0002), BIL_VAL (0x5e3da6ea)),
	    BIL_PAIR (BIL_VAL (0x9a94c8c1), BIL_VAL (0x66c77d85)),
	    BIL_PAIR (BIL_VAL (0x26979323), BIL_VAL (0x355c2991)),
	    BIL_PAIR (BIL_VAL (0xd59fc70a), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 162 */
  BIL_SET7 (BIL_VAL (0x4720d6f),
	    BIL_PAIR (BIL_VAL (0x4fdf5e13), BIL_VAL (0xe8a2c478)),
	    BIL_PAIR (BIL_VAL (0x9df42398), BIL_VAL (0x391deb51)),
	    BIL_PAIR (BIL_VAL (0x02ce0017), BIL_VAL (0xae68852a)),
	    BIL_PAIR (BIL_VAL (0x09cfd78e), BIL_VAL (0x03cae733)),
	    BIL_PAIR (BIL_VAL (0x81ebbf60), BIL_VAL (0x15999fb2)),
	    BIL_PAIR (BIL_VAL (0x583dc664), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 163 */
  BIL_SET7 (BIL_VAL (0x2c748659),
	    BIL_PAIR (BIL_VAL (0x1eb9acc7), BIL_VAL (0x165bacb6)),
	    BIL_PAIR (BIL_VAL (0x2b8963f2), BIL_VAL (0x3b2b312a)),
	    BIL_PAIR (BIL_VAL (0x1c0c00ec), BIL_VAL (0xd01533a4)),
	    BIL_PAIR (BIL_VAL (0x621e6b8c), BIL_VAL (0x25ed0803)),
	    BIL_PAIR (BIL_VAL (0x133579c0), BIL_VAL (0xd8003cf7)),
	    BIL_PAIR (BIL_VAL (0x7269bfe8), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 164 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0x1), BIL_VAL (0xbc8d3f7b)),
	    BIL_PAIR (BIL_VAL (0x3340bfc6), BIL_VAL (0xdf94bf1d)),
	    BIL_PAIR (BIL_VAL (0xb35de776), BIL_VAL (0x4fafeba5)),
	    BIL_PAIR (BIL_VAL (0x18780940), BIL_VAL (0x20d4046b)),
	    BIL_PAIR (BIL_VAL (0xd5303379), BIL_VAL (0x7b42501e)),
	    BIL_PAIR (BIL_VAL (0xc016c188), BIL_VAL (0x700261aa)),
	    BIL_PAIR (BIL_VAL (0x78217f10), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 165 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0x11), BIL_VAL (0x5d847ad0)),
	    BIL_PAIR (BIL_VAL (0x00877dc4), BIL_VAL (0xbbcf7729)),
	    BIL_PAIR (BIL_VAL (0x01ab0a9f), BIL_VAL (0x1cdf3472)),
	    BIL_PAIR (BIL_VAL (0xf4b05c81), BIL_VAL (0x48482c36)),
	    BIL_PAIR (BIL_VAL (0x53e202be), BIL_VAL (0xd0972133)),
	    BIL_PAIR (BIL_VAL (0x80e38f54), BIL_VAL (0x6017d0a8)),
	    BIL_PAIR (BIL_VAL (0xb14ef6a0), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 166 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0xad), BIL_VAL (0xa72ccc20)),
	    BIL_PAIR (BIL_VAL (0x054ae9af), BIL_VAL (0x561aa79a)),
	    BIL_PAIR (BIL_VAL (0x10ae6a37), BIL_VAL (0x20b80c7d)),
	    BIL_PAIR (BIL_VAL (0x8ee39d0c), BIL_VAL (0xd2d1ba1f)),
	    BIL_PAIR (BIL_VAL (0x46d41b74), BIL_VAL (0x25e74c03)),
	    BIL_PAIR (BIL_VAL (0x08e3994b), BIL_VAL (0xc0ee2696)),
	    BIL_PAIR (BIL_VAL (0xed15a240), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 167 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0x6c8), BIL_VAL (0x87bff940)),
	    BIL_PAIR (BIL_VAL (0x34ed20d9), BIL_VAL (0x5d0a8c04)),
	    BIL_PAIR (BIL_VAL (0xa6d02627), BIL_VAL (0x47307ce7)),
	    BIL_PAIR (BIL_VAL (0x94e42280), BIL_VAL (0x3c314538)),
	    BIL_PAIR (BIL_VAL (0xc4491289), BIL_VAL (0x7b08f81e)),
	    BIL_PAIR (BIL_VAL (0x58e3fcf5), BIL_VAL (0x894d81e5)),
	    BIL_PAIR (BIL_VAL (0x42d85680), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 168 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0x43d5), BIL_VAL (0x4d7fbc82)),
	    BIL_PAIR (BIL_VAL (0x1143487d), BIL_VAL (0xa269782e)),
	    BIL_PAIR (BIL_VAL (0x84217d88), BIL_VAL (0xc7e4e10b)),
	    BIL_PAIR (BIL_VAL (0xd0e95902), BIL_VAL (0x59ecb437)),
	    BIL_PAIR (BIL_VAL (0xaadab95e), BIL_VAL (0xce59b12f)),
	    BIL_PAIR (BIL_VAL (0x78e7e197), BIL_VAL (0x5d0712f4)),
	    BIL_PAIR (BIL_VAL (0x9c736100), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 169 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0x2a655), BIL_VAL (0x06fd5d14)),
	    BIL_PAIR (BIL_VAL (0xaca0d4e8), BIL_VAL (0x581eb1d1)),
	    BIL_PAIR (BIL_VAL (0x294ee757), BIL_VAL (0xcef0ca76)),
	    BIL_PAIR (BIL_VAL (0x291d7a17), BIL_VAL (0x833f0a2c)),
	    BIL_PAIR (BIL_VAL (0xac8b3db4), BIL_VAL (0x0f80ebda)),
	    BIL_PAIR (BIL_VAL (0xb90ecfe9), BIL_VAL (0xa246bd8e)),
	    BIL_PAIR (BIL_VAL (0x1c81ca00), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 170 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0x1a7f52), BIL_VAL (0x45e5a2ce)),
	    BIL_PAIR (BIL_VAL (0xbe485113), BIL_VAL (0x7132f22b)),
	    BIL_PAIR (BIL_VAL (0x9d15096e), BIL_VAL (0x1567e89d)),
	    BIL_PAIR (BIL_VAL (0x9b26c4eb), BIL_VAL (0x207665be)),
	    BIL_PAIR (BIL_VAL (0xbd706908), BIL_VAL (0x9b09368b)),
	    BIL_PAIR (BIL_VAL (0x3a941f20), BIL_VAL (0x56c3678d)),
	    BIL_PAIR (BIL_VAL (0x1d11e400), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 171 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0x108f936), BIL_VAL (0xbaf85c13)),
	    BIL_PAIR (BIL_VAL (0x6ed32ac2), BIL_VAL (0x6bfd75b4)),
	    BIL_PAIR (BIL_VAL (0x22d25e4c), BIL_VAL (0xd60f1628)),
	    BIL_PAIR (BIL_VAL (0x0f83b12f), BIL_VAL (0x449ff973)),
	    BIL_PAIR (BIL_VAL (0x66641a56), BIL_VAL (0x0e5c2170)),
	    BIL_PAIR (BIL_VAL (0x49c93743), BIL_VAL (0x63a20b83)),
	    BIL_PAIR (BIL_VAL (0x22b2e800), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 172 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0xa59bc23), BIL_VAL (0x4db398c2)),
	    BIL_PAIR (BIL_VAL (0x543fab98), BIL_VAL (0x37e69909)),
	    BIL_PAIR (BIL_VAL (0x5c37af00), BIL_VAL (0x5c96dd90)),
	    BIL_PAIR (BIL_VAL (0x9b24ebd8), BIL_VAL (0xae3fbe81)),
	    BIL_PAIR (BIL_VAL (0xffe9075c), BIL_VAL (0x8f994e62)),
	    BIL_PAIR (BIL_VAL (0xe1dc28a1), BIL_VAL (0xe454731f)),
	    BIL_PAIR (BIL_VAL (0x5afd1000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 173 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0x67815961), BIL_VAL (0x0903f797)),
	    BIL_PAIR (BIL_VAL (0x4a7cb3f2), BIL_VAL (0x2f01fa5d)),
	    BIL_PAIR (BIL_VAL (0x9a2cd603), BIL_VAL (0x9de4a7a6)),
	    BIL_PAIR (BIL_VAL (0x0f713676), BIL_VAL (0xce7d7113)),
	    BIL_PAIR (BIL_VAL (0xff1a499d), BIL_VAL (0x9bfd0fdc)),
	    BIL_PAIR (BIL_VAL (0xd2999652), BIL_VAL (0xeb4c7f39)),
	    BIL_PAIR (BIL_VAL (0x8de2a000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 174 */
  BIL_SET8 (BIL_VAL (0x4),
	    BIL_PAIR (BIL_VAL (0x0b0d7dca), BIL_VAL (0x5a27abe8)),
	    BIL_PAIR (BIL_VAL (0xe8df0775), BIL_VAL (0xd613c7a8)),
	    BIL_PAIR (BIL_VAL (0x05c05c24), BIL_VAL (0x2aee8c7c)),
	    BIL_PAIR (BIL_VAL (0x9a6c20a4), BIL_VAL (0x10e66ac7)),
	    BIL_PAIR (BIL_VAL (0xf706e028), BIL_VAL (0x17e29ea0)),
	    BIL_PAIR (BIL_VAL (0x39ffdf3d), BIL_VAL (0x30fcf83f)),
	    BIL_PAIR (BIL_VAL (0x8ada4000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 175 */
  BIL_SET8 (BIL_VAL (0x28),
	    BIL_PAIR (BIL_VAL (0x6e86e9e7), BIL_VAL (0x858cb719)),
	    BIL_PAIR (BIL_VAL (0x18b64a9a), BIL_VAL (0x5cc5cc90)),
	    BIL_PAIR (BIL_VAL (0x39839969), BIL_VAL (0xad517cde)),
	    BIL_PAIR (BIL_VAL (0x08394668), BIL_VAL (0xa9002bcf)),
	    BIL_PAIR (BIL_VAL (0xa644c190), BIL_VAL (0xeeda3242)),
	    BIL_PAIR (BIL_VAL (0x43feb863), BIL_VAL (0xe9e1b27b)),
	    BIL_PAIR (BIL_VAL (0x6c868000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 176 */
  BIL_SET8 (BIL_VAL (0x194),
	    BIL_PAIR (BIL_VAL (0x5145230b), BIL_VAL (0x377f26fa)),
	    BIL_PAIR (BIL_VAL (0xf71eea07), BIL_VAL (0x9fb9fda2)),
	    BIL_PAIR (BIL_VAL (0x3f23fe20), BIL_VAL (0xc52ee0ac)),
	    BIL_PAIR (BIL_VAL (0x523cc016), BIL_VAL (0x9a01b61c)),
	    BIL_PAIR (BIL_VAL (0x7eaf8fa9), BIL_VAL (0x5485f696)),
	    BIL_PAIR (BIL_VAL (0xa7f333e7), BIL_VAL (0x22d0f8d2)),
	    BIL_PAIR (BIL_VAL (0x3d410000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 177 */
  BIL_SET8 (BIL_VAL (0xfcb),
	    BIL_PAIR (BIL_VAL (0x2cb35e70), BIL_VAL (0x2af785cd)),
	    BIL_PAIR (BIL_VAL (0xa735244c), BIL_VAL (0x3d43e856)),
	    BIL_PAIR (BIL_VAL (0x7767ed47), BIL_VAL (0xb3d4c6bb)),
	    BIL_PAIR (BIL_VAL (0x365f80e2), BIL_VAL (0x04111d1c)),
	    BIL_PAIR (BIL_VAL (0xf2db9c9d), BIL_VAL (0x4d3ba1e2)),
	    BIL_PAIR (BIL_VAL (0x8f800707), BIL_VAL (0x5c29b836)),
	    BIL_PAIR (BIL_VAL (0x648a0000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 178 */
  BIL_SET8 (BIL_VAL (0x9def),
	    BIL_PAIR (BIL_VAL (0xbf01b061), BIL_VAL (0xadab3a08)),
	    BIL_PAIR (BIL_VAL (0x88136afa), BIL_VAL (0x64a71360)),
	    BIL_PAIR (BIL_VAL (0xaa0f44cd), BIL_VAL (0x064fc350)),
	    BIL_PAIR (BIL_VAL (0x1fbb08d4), BIL_VAL (0x28ab2321)),
	    BIL_PAIR (BIL_VAL (0x7c941e25), BIL_VAL (0x045452d9)),
	    BIL_PAIR (BIL_VAL (0x9b004649), BIL_VAL (0x99a1321f)),
	    BIL_PAIR (BIL_VAL (0xed640000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 179 */
  BIL_SET8 (BIL_VAL (0x62b5d),
	    BIL_PAIR (BIL_VAL (0x7610e3d0), BIL_VAL (0xc8b04455)),
	    BIL_PAIR (BIL_VAL (0x50c22dc7), BIL_VAL (0xee86c1c6)),
	    BIL_PAIR (BIL_VAL (0xa498b002), BIL_VAL (0x3f1da121)),
	    BIL_PAIR (BIL_VAL (0x3d4e5849), BIL_VAL (0x96af5f4e)),
	    BIL_PAIR (BIL_VAL (0xddc92d72), BIL_VAL (0x2b4b3c80)),
	    BIL_PAIR (BIL_VAL (0x0e02bee0), BIL_VAL (0x004bf53f)),
	    BIL_PAIR (BIL_VAL (0x45e80000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 180 */
  BIL_SET8 (BIL_VAL (0x3db1a6),
	    BIL_PAIR (BIL_VAL (0x9ca8e627), BIL_VAL (0xd6e2ab55)),
	    BIL_PAIR (BIL_VAL (0x2795c9cf), BIL_VAL (0x514391c2)),
	    BIL_PAIR (BIL_VAL (0x6df6e016), BIL_VAL (0x77284b4c)),
	    BIL_PAIR (BIL_VAL (0x650f72df), BIL_VAL (0xe2d9b914)),
	    BIL_PAIR (BIL_VAL (0xa9dbc675), BIL_VAL (0xb0f05d00)),
	    BIL_PAIR (BIL_VAL (0x8c1b74c0), BIL_VAL (0x02f79478)),
	    BIL_PAIR (BIL_VAL (0xbb100000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 181 */
  BIL_SET8 (BIL_VAL (0x268f082),
	    BIL_PAIR (BIL_VAL (0x1e98fd8e), BIL_VAL (0x64dab153)),
	    BIL_PAIR (BIL_VAL (0x8bd9e219), BIL_VAL (0x2ca3b198)),
	    BIL_PAIR (BIL_VAL (0x4ba4c0e0), BIL_VAL (0xa792f0fb)),
	    BIL_PAIR (BIL_VAL (0xf29a7cbe), BIL_VAL (0xdc813ace)),
	    BIL_PAIR (BIL_VAL (0xa295c098), BIL_VAL (0xe963a205)),
	    BIL_PAIR (BIL_VAL (0x79128f80), BIL_VAL (0x1dabccb7)),
	    BIL_PAIR (BIL_VAL (0x4ea00000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 182 */
  BIL_SET8 (BIL_VAL (0x18196515),
	    BIL_PAIR (BIL_VAL (0x31f9e78f), BIL_VAL (0xf08aed43)),
	    BIL_PAIR (BIL_VAL (0x7682d4fb), BIL_VAL (0xbe64eff2)),
	    BIL_PAIR (BIL_VAL (0xf46f88c6), BIL_VAL (0x8bbd69d7)),
	    BIL_PAIR (BIL_VAL (0x7a08df74), BIL_VAL (0x9d0c4c12)),
	    BIL_PAIR (BIL_VAL (0x59d985f9), BIL_VAL (0x1de45436)),
	    BIL_PAIR (BIL_VAL (0xbab99b01), BIL_VAL (0x28b5ff29)),
	    BIL_PAIR (BIL_VAL (0x12400000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 183 */
  BIL_SET8 (BIL_VAL (0xf0fdf2d3),
	    BIL_PAIR (BIL_VAL (0xf3c30b9f), BIL_VAL (0x656d44a2)),
	    BIL_PAIR (BIL_VAL (0xa11c51d5), BIL_VAL (0x6ff15f7d)),
	    BIL_PAIR (BIL_VAL (0x8c5b57c1), BIL_VAL (0x7566226a)),
	    BIL_PAIR (BIL_VAL (0xc458ba8e), BIL_VAL (0x227af8b7)),
	    BIL_PAIR (BIL_VAL (0x827f3bbb), BIL_VAL (0x2aeb4a23)),
	    BIL_PAIR (BIL_VAL (0x4b400e0b), BIL_VAL (0x971bf79a)),
	    BIL_PAIR (BIL_VAL (0xb6800000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 184 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x9), BIL_VAL (0x69eb7c47)),
	    BIL_PAIR (BIL_VAL (0x859e7439), BIL_VAL (0xf644ae5a)),
	    BIL_PAIR (BIL_VAL (0x4b1b3256), BIL_VAL (0x5f6dbae7)),
	    BIL_PAIR (BIL_VAL (0x7b916d8e), BIL_VAL (0x95fd582b)),
	    BIL_PAIR (BIL_VAL (0xab77498d), BIL_VAL (0x58cdb72b)),
	    BIL_PAIR (BIL_VAL (0x18f8554f), BIL_VAL (0xad30e560)),
	    BIL_PAIR (BIL_VAL (0xf0808c73), BIL_VAL (0xe717ac0b)),
	    BIL_PAIR (BIL_VAL (0x21000000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 185 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x5e), BIL_VAL (0x2332dacb)),
	    BIL_PAIR (BIL_VAL (0x38308a43), BIL_VAL (0x9eaecf86)),
	    BIL_PAIR (BIL_VAL (0xef0ff75f), BIL_VAL (0xba494d0a)),
	    BIL_PAIR (BIL_VAL (0xd3ae4791), BIL_VAL (0xdbe571b4)),
	    BIL_PAIR (BIL_VAL (0xb2a8df85), BIL_VAL (0x780927ae)),
	    BIL_PAIR (BIL_VAL (0xf9b3551c), BIL_VAL (0xc3e8f5c9)),
	    BIL_PAIR (BIL_VAL (0x65057c87), BIL_VAL (0x06ecb86f)),
	    BIL_PAIR (BIL_VAL (0x4a000000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 186 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x3ad), BIL_VAL (0x5ffc8bf0)),
	    BIL_PAIR (BIL_VAL (0x31e566a4), BIL_VAL (0x32d41b45)),
	    BIL_PAIR (BIL_VAL (0x569fa9bd), BIL_VAL (0x46dd026c)),
	    BIL_PAIR (BIL_VAL (0x44cecbb2), BIL_VAL (0x96f6710e)),
	    BIL_PAIR (BIL_VAL (0xfa98bb36), BIL_VAL (0xb05b8cd5)),
	    BIL_PAIR (BIL_VAL (0xc101531f), BIL_VAL (0xa71999dd)),
	    BIL_PAIR (BIL_VAL (0xf236dd46), BIL_VAL (0x453f3458)),
	    BIL_PAIR (BIL_VAL (0xe4000000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 187 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x24c5), BIL_VAL (0xbfdd7761)),
	    BIL_PAIR (BIL_VAL (0xf2f60269), BIL_VAL (0xfc4910b5)),
	    BIL_PAIR (BIL_VAL (0x623ca164), BIL_VAL (0xc4a2183a)),
	    BIL_PAIR (BIL_VAL (0xb013f4f9), BIL_VAL (0xe5a06a95)),
	    BIL_PAIR (BIL_VAL (0xc9f75022), BIL_VAL (0xe3938059)),
	    BIL_PAIR (BIL_VAL (0x8a0d3f3c), BIL_VAL (0x870002ab)),
	    BIL_PAIR (BIL_VAL (0x7624a4be), BIL_VAL (0xb4780b78)),
	    BIL_PAIR (BIL_VAL (0xe8000000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 188 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x16fb9), BIL_VAL (0x7ea6a9d3)),
	    BIL_PAIR (BIL_VAL (0x7d9c1823), BIL_VAL (0xdadaa715)),
	    BIL_PAIR (BIL_VAL (0xd65e4def), BIL_VAL (0xae54f24a)),
	    BIL_PAIR (BIL_VAL (0xe0c791c2), BIL_VAL (0xf84429d9)),
	    BIL_PAIR (BIL_VAL (0xe3a9215c), BIL_VAL (0xe3c3037f)),
	    BIL_PAIR (BIL_VAL (0x6484785d), BIL_VAL (0x46001ab2)),
	    BIL_PAIR (BIL_VAL (0x9d6e6f73), BIL_VAL (0x0cb072b9)),
	    BIL_PAIR (BIL_VAL (0x10000000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 189 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0xe5d3e), BIL_VAL (0xf282a242)),
	    BIL_PAIR (BIL_VAL (0xe818f166), BIL_VAL (0x8c8a86da)),
	    BIL_PAIR (BIL_VAL (0x5faf0b5c), BIL_VAL (0xcf5176ec)),
	    BIL_PAIR (BIL_VAL (0xc7cbb19d), BIL_VAL (0xb2a9a282)),
	    BIL_PAIR (BIL_VAL (0xe49b4da0), BIL_VAL (0xe59e22f9)),
	    BIL_PAIR (BIL_VAL (0xed2cb3a4), BIL_VAL (0xbc010afa)),
	    BIL_PAIR (BIL_VAL (0x26505a7e), BIL_VAL (0x7ee47b3a)),
	    BIL_PAIR (BIL_VAL (0xa0000000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 190 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x8fa475), BIL_VAL (0x791a569d)),
	    BIL_PAIR (BIL_VAL (0x10f96e01), BIL_VAL (0x7d694487)),
	    BIL_PAIR (BIL_VAL (0xbcd671a0), BIL_VAL (0x192ea53f)),
	    BIL_PAIR (BIL_VAL (0xcdf4f028), BIL_VAL (0xfaa0591c)),
	    BIL_PAIR (BIL_VAL (0xee110848), BIL_VAL (0xf82d5dc3)),
	    BIL_PAIR (BIL_VAL (0x43bf046f), BIL_VAL (0x580a6dc5)),
	    BIL_PAIR (BIL_VAL (0x7f2388f0), BIL_VAL (0xf4ecd04a)),
	    BIL_PAIR (BIL_VAL (0x40000000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 191 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x59c6c96), BIL_VAL (0xbb076222)),
	    BIL_PAIR (BIL_VAL (0xa9be4c0e), BIL_VAL (0xe61cad4d)),
	    BIL_PAIR (BIL_VAL (0x60607040), BIL_VAL (0xfbd2747e)),
	    BIL_PAIR (BIL_VAL (0x0b916199), BIL_VAL (0xca437b21)),
	    BIL_PAIR (BIL_VAL (0x4caa52d9), BIL_VAL (0xb1c5a9a0)),
	    BIL_PAIR (BIL_VAL (0xa5762c59), BIL_VAL (0x706849b6)),
	    BIL_PAIR (BIL_VAL (0xf7635969), BIL_VAL (0x914022e6)),
	    BIL_PAIR (BIL_VAL (0x80000000), BIL_VAL (0x00000000))
	    /* And implicit 128 0 bits.  */),
  /* 192 */
  BIL_SET7 (BIL_PAIR (BIL_VAL (0x381c3de3), BIL_VAL (0x4e49d55a)),
	    BIL_PAIR (BIL_VAL (0xa16ef894), BIL_VAL (0xfd1ec505)),
	    BIL_PAIR (BIL_VAL (0xc3c46289), BIL_VAL (0xd6388cec)),
	    BIL_PAIR (BIL_VAL (0x73add001), BIL_VAL (0xe6a2cf4c)),
	    BIL_PAIR (BIL_VAL (0xfea73c80), BIL_VAL (0xf1b8a046)),
	    BIL_PAIR (BIL_VAL (0x769dbb7e), BIL_VAL (0x6412e125)),
	    BIL_PAIR (BIL_VAL (0xa9e17e1f), BIL_VAL (0xac815d01))
	    /* And implicit 192 0 bits.  */),
  /* 193 */
  BIL_SET8 (BIL_VAL (0x2),
	    BIL_PAIR (BIL_VAL (0x311a6ae1), BIL_VAL (0x0ee2558a)),
	    BIL_PAIR (BIL_VAL (0x4e55b5d1), BIL_VAL (0xe333b239)),
	    BIL_PAIR (BIL_VAL (0xa5abd962), BIL_VAL (0x5e35813c)),
	    BIL_PAIR (BIL_VAL (0x84ca2013), BIL_VAL (0x025c1901)),
	    BIL_PAIR (BIL_VAL (0xf2885d09), BIL_VAL (0x713642c0)),
	    BIL_PAIR (BIL_VAL (0xa22952ef), BIL_VAL (0xe8bccb78)),
	    BIL_PAIR (BIL_VAL (0xa2ceed3c), BIL_VAL (0xbd0da20a))
	    /* And implicit 192 0 bits.  */),
  /* 194 */
  BIL_SET8 (BIL_VAL (0x15),
	    BIL_PAIR (BIL_VAL (0xeb082cca), BIL_VAL (0x94d75767)),
	    BIL_PAIR (BIL_VAL (0x0f591a32), BIL_VAL (0xe004f640)),
	    BIL_PAIR (BIL_VAL (0x78b67dd7), BIL_VAL (0xae170c5d)),
	    BIL_PAIR (BIL_VAL (0x2fe540be), BIL_VAL (0x1798fa13)),
	    BIL_PAIR (BIL_VAL (0x7953a25e), BIL_VAL (0x6c1e9b86)),
	    BIL_PAIR (BIL_VAL (0x559d3d5f), BIL_VAL (0x175ff2b6)),
	    BIL_PAIR (BIL_VAL (0x5c15445f), BIL_VAL (0x62885464))
	    /* And implicit 192 0 bits.  */),
  /* 195 */
  BIL_SET8 (BIL_VAL (0xdb),
	    BIL_PAIR (BIL_VAL (0x2e51bfe9), BIL_VAL (0xd0696a06)),
	    BIL_PAIR (BIL_VAL (0x997b05fc), BIL_VAL (0xc0319e84)),
	    BIL_PAIR (BIL_VAL (0xb720ea6c), BIL_VAL (0xcce67ba3)),
	    BIL_PAIR (BIL_VAL (0xdef4876c), BIL_VAL (0xebf9c4c2)),
	    BIL_PAIR (BIL_VAL (0xbd4457b0), BIL_VAL (0x3932133f)),
	    BIL_PAIR (BIL_VAL (0x582465b6), BIL_VAL (0xe9bf7b1f)),
	    BIL_PAIR (BIL_VAL (0x98d4abb9), BIL_VAL (0xd9534be8))
	    /* And implicit 192 0 bits.  */),
  /* 196 */
  BIL_SET8 (BIL_VAL (0x88f),
	    BIL_PAIR (BIL_VAL (0xcf317f22), BIL_VAL (0x241e2441)),
	    BIL_PAIR (BIL_VAL (0xfece3bdf), BIL_VAL (0x81f0312f)),
	    BIL_PAIR (BIL_VAL (0x27492840), BIL_VAL (0x0100d466)),
	    BIL_PAIR (BIL_VAL (0xb58d4a41), BIL_VAL (0x37c1af9b)),
	    BIL_PAIR (BIL_VAL (0x64ab6ce2), BIL_VAL (0x3bf4c079)),
	    BIL_PAIR (BIL_VAL (0x716bf925), BIL_VAL (0x217acf3b)),
	    BIL_PAIR (BIL_VAL (0xf84eb542), BIL_VAL (0x7d40f710))
	    /* And implicit 192 0 bits.  */),
  /* 197 */
  BIL_SET8 (BIL_VAL (0x559e),
	    BIL_PAIR (BIL_VAL (0x17eef755), BIL_VAL (0x692d6a93)),
	    BIL_PAIR (BIL_VAL (0xf40e56bb), BIL_VAL (0x1361ebd7)),
	    BIL_PAIR (BIL_VAL (0x88db9280), BIL_VAL (0x0a084c03)),
	    BIL_PAIR (BIL_VAL (0x1784e68c), BIL_VAL (0x2d90dc11)),
	    BIL_PAIR (BIL_VAL (0xeeb240d6), BIL_VAL (0x578f84be)),
	    BIL_PAIR (BIL_VAL (0x6e37bb73), BIL_VAL (0x4ecc1857)),
	    BIL_PAIR (BIL_VAL (0xb3131498), BIL_VAL (0xe489a6a0))
	    /* And implicit 192 0 bits.  */),
  /* 198 */
  BIL_SET8 (BIL_VAL (0x3582c),
	    BIL_PAIR (BIL_VAL (0xef55a956), BIL_VAL (0x1bc629c7)),
	    BIL_PAIR (BIL_VAL (0x888f634e), BIL_VAL (0xc1d3366b)),
	    BIL_PAIR (BIL_VAL (0x5893b900), BIL_VAL (0x6452f81e)),
	    BIL_PAIR (BIL_VAL (0xeb310179), BIL_VAL (0xc7a898b3)),
	    BIL_PAIR (BIL_VAL (0x52f6885f), BIL_VAL (0x6b9b2f70)),
	    BIL_PAIR (BIL_VAL (0x4e2d5281), BIL_VAL (0x13f8f36c)),
	    BIL_PAIR (BIL_VAL (0xfebecdf8), BIL_VAL (0xed608240))
	    /* And implicit 192 0 bits.  */),
  /* 199 */
  BIL_SET8 (BIL_VAL (0x2171c1),
	    BIL_PAIR (BIL_VAL (0x59589d5d), BIL_VAL (0x15bda1cb)),
	    BIL_PAIR (BIL_VAL (0x5599e113), BIL_VAL (0x92402031)),
	    BIL_PAIR (BIL_VAL (0x75c53a03), BIL_VAL (0xeb3db135)),
	    BIL_PAIR (BIL_VAL (0x2fea0ec1), BIL_VAL (0xcc95f701)),
	    BIL_PAIR (BIL_VAL (0x3da153ba), BIL_VAL (0x340fda63)),
	    BIL_PAIR (BIL_VAL (0x0dc5390a), BIL_VAL (0xc7b98241)),
	    BIL_PAIR (BIL_VAL (0xf3740bb9), BIL_VAL (0x45c51680))
	    /* And implicit 192 0 bits.  */),
  /* 200 */
  BIL_SET8 (BIL_VAL (0x14e718d),
	    BIL_PAIR (BIL_VAL (0x7d7625a2), BIL_VAL (0xd96851f1)),
	    BIL_PAIR (BIL_VAL (0x5802cac3), BIL_VAL (0xb68141ee)),
	    BIL_PAIR (BIL_VAL (0x99b44427), BIL_VAL (0x3068ec13)),
	    BIL_PAIR (BIL_VAL (0xdf249391), BIL_VAL (0xfddba60c)),
	    BIL_PAIR (BIL_VAL (0x684d4546), BIL_VAL (0x089e87de)),
	    BIL_PAIR (BIL_VAL (0x89b43a6b), BIL_VAL (0xcd3f1693)),
	    BIL_PAIR (BIL_VAL (0x8288753c), BIL_VAL (0xb9b2e100))
	    /* And implicit 192 0 bits.  */),
  /* 201 */
  BIL_SET8 (BIL_VAL (0xd106f86),
	    BIL_PAIR (BIL_VAL (0xe69d785c), BIL_VAL (0x7e13336d)),
	    BIL_PAIR (BIL_VAL (0x701beba5), BIL_VAL (0x210c9352)),
	    BIL_PAIR (BIL_VAL (0x010aa987), BIL_VAL (0xe41938c6)),
	    BIL_PAIR (BIL_VAL (0xb76dc3b3), BIL_VAL (0xea947c7c)),
	    BIL_PAIR (BIL_VAL (0x1304b4bc), BIL_VAL (0x56314eb1)),
	    BIL_PAIR (BIL_VAL (0x610a4836), BIL_VAL (0x0476e1c3)),
	    BIL_PAIR (BIL_VAL (0x1954945f), BIL_VAL (0x40fcca00))
	    /* And implicit 192 0 bits.  */),
  /* 202 */
  BIL_SET8 (BIL_VAL (0x82a45b45),
	    BIL_PAIR (BIL_VAL (0x0226b39c), BIL_VAL (0xecc00246)),
	    BIL_PAIR (BIL_VAL (0x61173473), BIL_VAL (0x4a7dc134)),
	    BIL_PAIR (BIL_VAL (0x0a6a9f4e), BIL_VAL (0xe8fc37c3)),
	    BIL_PAIR (BIL_VAL (0x2a49a507), BIL_VAL (0x29ccdcd8)),
	    BIL_PAIR (BIL_VAL (0xbe2f0f5b), BIL_VAL (0x5ded12ed)),
	    BIL_PAIR (BIL_VAL (0xca66d21c), BIL_VAL (0x2ca4d19e)),
	    BIL_PAIR (BIL_VAL (0xfd4dcbb8), BIL_VAL (0x89dfe400))
	    /* And implicit 192 0 bits.  */),
  /* 203 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x5), BIL_VAL (0x1a6b90b2)),
	    BIL_PAIR (BIL_VAL (0x15830421), BIL_VAL (0x3f8016bf)),
	    BIL_PAIR (BIL_VAL (0xcae80c80), BIL_VAL (0xe8e98c08)),
	    BIL_PAIR (BIL_VAL (0x682a3915), BIL_VAL (0x19da2d9f)),
	    BIL_PAIR (BIL_VAL (0xa6e07247), BIL_VAL (0xa200a077)),
	    BIL_PAIR (BIL_VAL (0x6dd69991), BIL_VAL (0xab42bd49)),
	    BIL_PAIR (BIL_VAL (0xe8043519), BIL_VAL (0xbe703035)),
	    BIL_PAIR (BIL_VAL (0xe509f535), BIL_VAL (0x62bee800))
	    /* And implicit 192 0 bits.  */),
  /* 204 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x33), BIL_VAL (0x0833a6f4)),
	    BIL_PAIR (BIL_VAL (0xd71e294c), BIL_VAL (0x7b00e37d)),
	    BIL_PAIR (BIL_VAL (0xed107d09), BIL_VAL (0x191f7854)),
	    BIL_PAIR (BIL_VAL (0x11a63ad3), BIL_VAL (0x0285c83c)),
	    BIL_PAIR (BIL_VAL (0x84c476cc), BIL_VAL (0x540644aa)),
	    BIL_PAIR (BIL_VAL (0x4a61ffb0), BIL_VAL (0xb09b64e3)),
	    BIL_PAIR (BIL_VAL (0x102a1301), BIL_VAL (0x7061e21a)),
	    BIL_PAIR (BIL_VAL (0xf2639415), BIL_VAL (0xdb751000))
	    /* And implicit 192 0 bits.  */),
  /* 205 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x1fe), BIL_VAL (0x52048590)),
	    BIL_PAIR (BIL_VAL (0x672d9cfc), BIL_VAL (0xce08e2eb)),
	    BIL_PAIR (BIL_VAL (0x42a4e25a), BIL_VAL (0xfb3ab348)),
	    BIL_PAIR (BIL_VAL (0xb07e4c3e), BIL_VAL (0x1939d25d)),
	    BIL_PAIR (BIL_VAL (0x2faca3fb), BIL_VAL (0x483eaea6)),
	    BIL_PAIR (BIL_VAL (0xe7d3fce6), BIL_VAL (0xe611f0de)),
	    BIL_PAIR (BIL_VAL (0xa1a4be0e), BIL_VAL (0x63d2d50d)),
	    BIL_PAIR (BIL_VAL (0x77e3c8da), BIL_VAL (0x9292a000))
	    /* And implicit 192 0 bits.  */),
  /* 206 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x13ef), BIL_VAL (0x342d37a4)),
	    BIL_PAIR (BIL_VAL (0x07c821e0), BIL_VAL (0x0c58dd30)),
	    BIL_PAIR (BIL_VAL (0x9a70d78d), BIL_VAL (0xd04b00d6)),
	    BIL_PAIR (BIL_VAL (0xe4eefa6c), BIL_VAL (0xfc4237a3)),
	    BIL_PAIR (BIL_VAL (0xdcbe67d0), BIL_VAL (0xd272d285)),
	    BIL_PAIR (BIL_VAL (0x0e47e104), BIL_VAL (0xfcb368b2)),
	    BIL_PAIR (BIL_VAL (0x506f6c8f), BIL_VAL (0xe63c5286)),
	    BIL_PAIR (BIL_VAL (0xaee5d889), BIL_VAL (0xb9ba4000))
	    /* And implicit 192 0 bits.  */),
  /* 207 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0xc758), BIL_VAL (0x09c42c68)),
	    BIL_PAIR (BIL_VAL (0x4dd152c0), BIL_VAL (0x7b78a3e6)),
	    BIL_PAIR (BIL_VAL (0x08686b8a), BIL_VAL (0x22ee0864)),
	    BIL_PAIR (BIL_VAL (0xf155c841), BIL_VAL (0xda962c66)),
	    BIL_PAIR (BIL_VAL (0x9f700e28), BIL_VAL (0x387c3932)),
	    BIL_PAIR (BIL_VAL (0x8ececa31), BIL_VAL (0xdf0216f7)),
	    BIL_PAIR (BIL_VAL (0x245a3d9e), BIL_VAL (0xfe5b3942)),
	    BIL_PAIR (BIL_VAL (0xd4fa7561), BIL_VAL (0x41468000))
	    /* And implicit 192 0 bits.  */),
  /* 208 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x7c970), BIL_VAL (0x61a9bc13)),
	    BIL_PAIR (BIL_VAL (0x0a2d3b84), BIL_VAL (0xd2b666fc)),
	    BIL_PAIR (BIL_VAL (0x54143365), BIL_VAL (0x5d4c53f1)),
	    BIL_PAIR (BIL_VAL (0x6d59d292), BIL_VAL (0x89ddbc02)),
	    BIL_PAIR (BIL_VAL (0x3a608d92), BIL_VAL (0x34da3bf9)),
	    BIL_PAIR (BIL_VAL (0x9413e5f2), BIL_VAL (0xb614e5a7)),
	    BIL_PAIR (BIL_VAL (0x6b866835), BIL_VAL (0xef903c9c)),
	    BIL_PAIR (BIL_VAL (0x51c895cc), BIL_VAL (0x8cc10000))
	    /* And implicit 192 0 bits.  */),
  /* 209 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x4dde63), BIL_VAL (0xd0a158be)),
	    BIL_PAIR (BIL_VAL (0x65c45330), BIL_VAL (0x3b2005db)),
	    BIL_PAIR (BIL_VAL (0x48ca01f5), BIL_VAL (0xa4fb476e)),
	    BIL_PAIR (BIL_VAL (0x458239b9), BIL_VAL (0x62a95816)),
	    BIL_PAIR (BIL_VAL (0x47c587b6), BIL_VAL (0x108657bf)),
	    BIL_PAIR (BIL_VAL (0xc8c6fb7b), BIL_VAL (0x1cd0f88a)),
	    BIL_PAIR (BIL_VAL (0x3340121b), BIL_VAL (0x5ba25e1b)),
	    BIL_PAIR (BIL_VAL (0x31d5d9fd), BIL_VAL (0x7f8a0000))
	    /* And implicit 192 0 bits.  */),
  /* 210 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x30aafe6), BIL_VAL (0x264d776f)),
	    BIL_PAIR (BIL_VAL (0xf9ab3fe2), BIL_VAL (0x4f403a90)),
	    BIL_PAIR (BIL_VAL (0xd7e41398), BIL_VAL (0x71d0ca4e)),
	    BIL_PAIR (BIL_VAL (0xb716413d), BIL_VAL (0xda9d70de)),
	    BIL_PAIR (BIL_VAL (0xcdb74d1c), BIL_VAL (0xa53f6d7d)),
	    BIL_PAIR (BIL_VAL (0xd7c5d2cf), BIL_VAL (0x2029b566)),
	    BIL_PAIR (BIL_VAL (0x0080b511), BIL_VAL (0x9457ad0f)),
	    BIL_PAIR (BIL_VAL (0xf25a83e6), BIL_VAL (0xfb640000))
	    /* And implicit 192 0 bits.  */),
  /* 211 */
  BIL_SET8 (BIL_PAIR (BIL_VAL (0x1e6adefd), BIL_VAL (0x7f06aa5f)),
	    BIL_PAIR (BIL_VAL (0xc0b07ed7), BIL_VAL (0x188249a8)),
	    BIL_PAIR (BIL_VAL (0x6ee8c3f4), BIL_VAL (0x7227e713)),
	    BIL_PAIR (BIL_VAL (0x26de8c6a), BIL_VAL (0x8a2668b4)),
	    BIL_PAIR (BIL_VAL (0x0929031e), BIL_VAL (0x747a46ea)),
	    BIL_PAIR (BIL_VAL (0x6dba3c17), BIL_VAL (0x41a115fc)),
	    BIL_PAIR (BIL_VAL (0x050712af), BIL_VAL (0xcb6cc29f)),
	    BIL_PAIR (BIL_VAL (0x77892705), BIL_VAL (0xd1e80000))
	    /* And implicit 192 0 bits.  */),
  /* 212 */
  BIL_SET9 (BIL_VAL (0x1),
	    BIL_PAIR (BIL_VAL (0x302cb5e6), BIL_VAL (0xf642a7bd)),
	    BIL_PAIR (BIL_VAL (0x86e4f466), BIL_VAL (0xf516e094)),
	    BIL_PAIR (BIL_VAL (0x5517a78c), BIL_VAL (0x758f06bf)),
	    BIL_PAIR (BIL_VAL (0x84b17c29), BIL_VAL (0x65801708)),
	    BIL_PAIR (BIL_VAL (0x5b9a1f30), BIL_VAL (0x8cc6c528)),
	    BIL_PAIR (BIL_VAL (0x494658e8), BIL_VAL (0x904adbd8)),
	    BIL_PAIR (BIL_VAL (0x3246badd), BIL_VAL (0xf23f9a3a)),
	    BIL_PAIR (BIL_VAL (0xab5b863a), BIL_VAL (0x33100000))
	    /* And implicit 192 0 bits.  */),
  /* 213 */
  BIL_SET9 (BIL_VAL (0xb),
	    BIL_PAIR (BIL_VAL (0xe1bf1b05), BIL_VAL (0x9e9a8d67)),
	    BIL_PAIR (BIL_VAL (0x44f18c05), BIL_VAL (0x92e4c5cb)),
	    BIL_PAIR (BIL_VAL (0x52ec8b7c), BIL_VAL (0x9796437b)),
	    BIL_PAIR (BIL_VAL (0x2eeed99d), BIL_VAL (0xf700e653)),
	    BIL_PAIR (BIL_VAL (0x940537e5), BIL_VAL (0x7fc3b392)),
	    BIL_PAIR (BIL_VAL (0xdcbf7915), BIL_VAL (0xa2ec9671)),
	    BIL_PAIR (BIL_VAL (0xf6c34cab), BIL_VAL (0x767c064a)),
	    BIL_PAIR (BIL_VAL (0xb1933e45), BIL_VAL (0xfea00000))
	    /* And implicit 192 0 bits.  */),
  /* 214 */
  BIL_SET9 (BIL_VAL (0x76),
	    BIL_PAIR (BIL_VAL (0xd1770e38), BIL_VAL (0x32098608)),
	    BIL_PAIR (BIL_VAL (0xb16f7837), BIL_VAL (0xbcefb9f1)),
	    BIL_PAIR (BIL_VAL (0x3d3d72dd), BIL_VAL (0xebdea2cf)),
	    BIL_PAIR (BIL_VAL (0xd554802b), BIL_VAL (0xa608ff43)),
	    BIL_PAIR (BIL_VAL (0xc8342ef6), BIL_VAL (0xfda503bc)),
	    BIL_PAIR (BIL_VAL (0x9f7abad8), BIL_VAL (0x5d3de073)),
	    BIL_PAIR (BIL_VAL (0xa3a0feb2), BIL_VAL (0xa0d83eea)),
	    BIL_PAIR (BIL_VAL (0xefc06ebb), BIL_VAL (0xf2400000))
	    /* And implicit 192 0 bits.  */),
  /* 215 */
  BIL_SET9 (BIL_VAL (0x4a4),
	    BIL_PAIR (BIL_VAL (0x2ea68e31), BIL_VAL (0xf45f3c56)),
	    BIL_PAIR (BIL_VAL (0xee5ab22d), BIL_VAL (0x615d436c)),
	    BIL_PAIR (BIL_VAL (0x64667cab), BIL_VAL (0x36b25c1e)),
	    BIL_PAIR (BIL_VAL (0x554d01b4), BIL_VAL (0x7c59f8a5)),
	    BIL_PAIR (BIL_VAL (0xd209d5a5), BIL_VAL (0xe872255e)),
	    BIL_PAIR (BIL_VAL (0x3acb4c73), BIL_VAL (0xa46ac484)),
	    BIL_PAIR (BIL_VAL (0x6449f2fa), BIL_VAL (0x4872752d)),
	    BIL_PAIR (BIL_VAL (0x5d845357), BIL_VAL (0x76800000))
	    /* And implicit 192 0 bits.  */),
  /* 216 */
  BIL_SET9 (BIL_VAL (0x2e69),
	    BIL_PAIR (BIL_VAL (0xd2818df3), BIL_VAL (0x8bb85b65)),
	    BIL_PAIR (BIL_VAL (0x4f8af5c5), BIL_VAL (0xcda4a23b)),
	    BIL_PAIR (BIL_VAL (0xec00deb0), BIL_VAL (0x22f7992f)),
	    BIL_PAIR (BIL_VAL (0x5502110c), BIL_VAL (0xdb83b67a)),
	    BIL_PAIR (BIL_VAL (0x3462587b), BIL_VAL (0x147575ae)),
	    BIL_PAIR (BIL_VAL (0x4bf0fc84), BIL_VAL (0x6c2bad2b)),
	    BIL_PAIR (BIL_VAL (0xeae37dc6), BIL_VAL (0xd47893c5)),
	    BIL_PAIR (BIL_VAL (0xa72b416a), BIL_VAL (0xa1000000))
	    /* And implicit 192 0 bits.  */),
  /* 217 */
  BIL_SET9 (BIL_VAL (0x1d022),
	    BIL_PAIR (BIL_VAL (0x390f8b83), BIL_VAL (0x753391f5)),
	    BIL_PAIR (BIL_VAL (0x1b6d99ba), BIL_VAL (0x086e5657)),
	    BIL_PAIR (BIL_VAL (0x3808b2e1), BIL_VAL (0x5dabfbd9)),
	    BIL_PAIR (BIL_VAL (0x5214aa80), BIL_VAL (0x932520c6)),
	    BIL_PAIR (BIL_VAL (0x0bd774ce), BIL_VAL (0xcc9698ce)),
	    BIL_PAIR (BIL_VAL (0xf769dd2c), BIL_VAL (0x39b4c3b7)),
	    BIL_PAIR (BIL_VAL (0x2ce2e9c4), BIL_VAL (0x4cb5c5b8)),
	    BIL_PAIR (BIL_VAL (0x87b08e2a), BIL_VAL (0x4a000000))
	    /* And implicit 192 0 bits.  */),
  /* 218 */
  BIL_SET9 (BIL_VAL (0x122156),
	    BIL_PAIR (BIL_VAL (0x3a9b7322), BIL_VAL (0x9403b393)),
	    BIL_PAIR (BIL_VAL (0x12480144), BIL_VAL (0x544f5f68)),
	    BIL_PAIR (BIL_VAL (0x3056fccd), BIL_VAL (0xa8b7d67d)),
	    BIL_PAIR (BIL_VAL (0x34cea905), BIL_VAL (0xbf7347bc)),
	    BIL_PAIR (BIL_VAL (0x766a9013), BIL_VAL (0xfde1f815)),
	    BIL_PAIR (BIL_VAL (0xaa22a3ba), BIL_VAL (0x410fa527)),
	    BIL_PAIR (BIL_VAL (0xc0dd21aa), BIL_VAL (0xff19b935)),
	    BIL_PAIR (BIL_VAL (0x4ce58da6), BIL_VAL (0xe4000000))
	    /* And implicit 192 0 bits.  */),
  /* 219 */
  BIL_SET9 (BIL_VAL (0xb54d5e),
	    BIL_PAIR (BIL_VAL (0x4a127f59), BIL_VAL (0xc82503be)),
	    BIL_PAIR (BIL_VAL (0xb6d00cab), BIL_VAL (0x4b19ba11)),
	    BIL_PAIR (BIL_VAL (0xe365e008), BIL_VAL (0x972e60e4)),
	    BIL_PAIR (BIL_VAL (0x10129a39), BIL_VAL (0x7a80cd5c)),
	    BIL_PAIR (BIL_VAL (0xa029a0c7), BIL_VAL (0xead3b0d8)),
	    BIL_PAIR (BIL_VAL (0xa55a6546), BIL_VAL (0x8a9c738d)),
	    BIL_PAIR (BIL_VAL (0x88a350ad), BIL_VAL (0xf7013c15)),
	    BIL_PAIR (BIL_VAL (0x00f78884), BIL_VAL (0xe8000000))
	    /* And implicit 192 0 bits.  */),
  /* 220 */
  BIL_SET9 (BIL_VAL (0x71505ae),
	    BIL_PAIR (BIL_VAL (0xe4b8f981), BIL_VAL (0xd1722573)),
	    BIL_PAIR (BIL_VAL (0x24207eb0), BIL_VAL (0xef0144b2)),
	    BIL_PAIR (BIL_VAL (0xe1fac055), BIL_VAL (0xe7cfc8e8)),
	    BIL_PAIR (BIL_VAL (0xa0ba063e), BIL_VAL (0xc908059e)),
	    BIL_PAIR (BIL_VAL (0x41a047cf), BIL_VAL (0x2c44e876)),
	    BIL_PAIR (BIL_VAL (0x7587f4c1), BIL_VAL (0x6a1c8387)),
	    BIL_PAIR (BIL_VAL (0x566126cb), BIL_VAL (0xa60c58d2)),
	    BIL_PAIR (BIL_VAL (0x09ab5531), BIL_VAL (0x10000000))
	    /* And implicit 192 0 bits.  */),
  /* 221 */
  BIL_SET9 (BIL_VAL (0x46d238d4),
	    BIL_PAIR (BIL_VAL (0xef39bf12), BIL_VAL (0x2e75767f)),
	    BIL_PAIR (BIL_VAL (0x6944f2e9), BIL_VAL (0x560caefc)),
	    BIL_PAIR (BIL_VAL (0xd3cb835b), BIL_VAL (0x0e1dd916)),
	    BIL_PAIR (BIL_VAL (0x47443e73), BIL_VAL (0xda50382e)),
	    BIL_PAIR (BIL_VAL (0x9042ce17), BIL_VAL (0xbab114a0)),
	    BIL_PAIR (BIL_VAL (0x974f8f8e), BIL_VAL (0x251d2349)),
	    BIL_PAIR (BIL_VAL (0x5fcb83f4), BIL_VAL (0x7c7b7834)),
	    BIL_PAIR (BIL_VAL (0x60b153ea), BIL_VAL (0xa0000000))
	    /* And implicit 192 0 bits.  */),
  /* 222 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0x2), BIL_VAL (0xc4363851)),
	    BIL_PAIR (BIL_VAL (0x584176b5), BIL_VAL (0xd096a0fa)),
	    BIL_PAIR (BIL_VAL (0x1cb17d1d), BIL_VAL (0x5c7ed5e0)),
	    BIL_PAIR (BIL_VAL (0x45f3218e), BIL_VAL (0x8d2a7ade)),
	    BIL_PAIR (BIL_VAL (0xc8aa7086), BIL_VAL (0x872231d1)),
	    BIL_PAIR (BIL_VAL (0xa29c0ced), BIL_VAL (0x4aeace45)),
	    BIL_PAIR (BIL_VAL (0xe91b9b8d), BIL_VAL (0x732360dd)),
	    BIL_PAIR (BIL_VAL (0xbdf3278c), BIL_VAL (0xdcd2b20b)),
	    BIL_PAIR (BIL_VAL (0xc6ed472a), BIL_VAL (0x40000000))
	    /* And implicit 192 0 bits.  */),
  /* 223 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0x1b), BIL_VAL (0xaa1e332d)),
	    BIL_PAIR (BIL_VAL (0x728ea31a), BIL_VAL (0x25e249c5)),
	    BIL_PAIR (BIL_VAL (0x1eeee325), BIL_VAL (0x9cf45ac2)),
	    BIL_PAIR (BIL_VAL (0xbb7f4f91), BIL_VAL (0x83a8ccb3)),
	    BIL_PAIR (BIL_VAL (0xd6a86541), BIL_VAL (0x4755f230)),
	    BIL_PAIR (BIL_VAL (0x5a188144), BIL_VAL (0xed2c0ebb)),
	    BIL_PAIR (BIL_VAL (0x1b141386), BIL_VAL (0x7f61c8a9)),
	    BIL_PAIR (BIL_VAL (0x6b7f8b80), BIL_VAL (0xa03af475)),
	    BIL_PAIR (BIL_VAL (0xc544c7a6), BIL_VAL (0x80000000))
	    /* And implicit 192 0 bits.  */),
  /* 224 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0x114), BIL_VAL (0xa52dffc6)),
	    BIL_PAIR (BIL_VAL (0x79925f05), BIL_VAL (0x7ad6e1b3)),
	    BIL_PAIR (BIL_VAL (0x3554df78), BIL_VAL (0x218b8b9b)),
	    BIL_PAIR (BIL_VAL (0x52f91baf), BIL_VAL (0x2497ff06)),
	    BIL_PAIR (BIL_VAL (0x6293f48c), BIL_VAL (0xc95b75e3)),
	    BIL_PAIR (BIL_VAL (0x84f50cb1), BIL_VAL (0x43b8934f)),
	    BIL_PAIR (BIL_VAL (0x0ec8c340), BIL_VAL (0xf9d1d69e)),
	    BIL_PAIR (BIL_VAL (0x32fb7306), BIL_VAL (0x424d8c99)),
	    BIL_PAIR (BIL_VAL (0xb4afcc81), BIL_VAL (0x00000000))
	    /* And implicit 192 0 bits.  */),
  /* 225 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0xace), BIL_VAL (0x73cbfdc0)),
	    BIL_PAIR (BIL_VAL (0xbfb7b636), BIL_VAL (0xcc64d100)),
	    BIL_PAIR (BIL_VAL (0x1550bab1), BIL_VAL (0x4f737411)),
	    BIL_PAIR (BIL_VAL (0x3dbb14d7), BIL_VAL (0x6deff63f)),
	    BIL_PAIR (BIL_VAL (0xd9c78d7f), BIL_VAL (0xdd929ae3)),
	    BIL_PAIR (BIL_VAL (0x31927eec), BIL_VAL (0xa535c116)),
	    BIL_PAIR (BIL_VAL (0x93d7a089), BIL_VAL (0xc232622d)),
	    BIL_PAIR (BIL_VAL (0xfdd27e3e), BIL_VAL (0x97077e01)),
	    BIL_PAIR (BIL_VAL (0x0eddfd0a), BIL_VAL (0x00000000))
	    /* And implicit 192 0 bits.  */),
  /* 226 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0x6c10), BIL_VAL (0x85f7e987)),
	    BIL_PAIR (BIL_VAL (0x7d2d1e23), BIL_VAL (0xfbf02a00)),
	    BIL_PAIR (BIL_VAL (0xd5274aed), BIL_VAL (0x1a8288ac)),
	    BIL_PAIR (BIL_VAL (0x694ed06a), BIL_VAL (0x4b5f9e7e)),
	    BIL_PAIR (BIL_VAL (0x81cb86fe), BIL_VAL (0xa7ba0cdf)),
	    BIL_PAIR (BIL_VAL (0xefb8f53e), BIL_VAL (0x74198ae1)),
	    BIL_PAIR (BIL_VAL (0xc66c4561), BIL_VAL (0x95f7d5cb)),
	    BIL_PAIR (BIL_VAL (0xea38ee71), BIL_VAL (0xe64aec0a)),
	    BIL_PAIR (BIL_VAL (0x94abe264), BIL_VAL (0x00000000))
	    /* And implicit 192 0 bits.  */),
  /* 227 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0x438a5), BIL_VAL (0x3baf1f4a)),
	    BIL_PAIR (BIL_VAL (0xe3c32d67), BIL_VAL (0xd761a408)),
	    BIL_PAIR (BIL_VAL (0x5388ed43), BIL_VAL (0x091956bc)),
	    BIL_PAIR (BIL_VAL (0x1d142426), BIL_VAL (0xf1bc30f1)),
	    BIL_PAIR (BIL_VAL (0x11f345f2), BIL_VAL (0x8d4480bf)),
	    BIL_PAIR (BIL_VAL (0x5d399470), BIL_VAL (0x88ff6cd1)),
	    BIL_PAIR (BIL_VAL (0xc03ab5cf), BIL_VAL (0xdbae59f7)),
	    BIL_PAIR (BIL_VAL (0x26395072), BIL_VAL (0xfeed3869)),
	    BIL_PAIR (BIL_VAL (0xceb6d7e8), BIL_VAL (0x00000000))
	    /* And implicit 192 0 bits.  */),
  /* 228 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0x2a3674), BIL_VAL (0x54d738ec)),
	    BIL_PAIR (BIL_VAL (0xe59fc60e), BIL_VAL (0x69d06853)),
	    BIL_PAIR (BIL_VAL (0x4359449e), BIL_VAL (0x5afd6359)),
	    BIL_PAIR (BIL_VAL (0x22c96985), BIL_VAL (0x7159e96a)),
	    BIL_PAIR (BIL_VAL (0xb380bb79), BIL_VAL (0x84ad0779)),
	    BIL_PAIR (BIL_VAL (0xa43fcc65), BIL_VAL (0x59fa4031)),
	    BIL_PAIR (BIL_VAL (0x824b1a1e), BIL_VAL (0x94cf83a7)),
	    BIL_PAIR (BIL_VAL (0x7e3d247d), BIL_VAL (0xf5443422)),
	    BIL_PAIR (BIL_VAL (0x13246f10), BIL_VAL (0x00000000))
	    /* And implicit 192 0 bits.  */),
  /* 229 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0x1a6208b), BIL_VAL (0x50683940)),
	    BIL_PAIR (BIL_VAL (0xf83dbc90), BIL_VAL (0x22241340)),
	    BIL_PAIR (BIL_VAL (0xa17cae2f), BIL_VAL (0x8de5e17b)),
	    BIL_PAIR (BIL_VAL (0x5bde1f36), BIL_VAL (0x6d831e2b)),
	    BIL_PAIR (BIL_VAL (0x030752bf), BIL_VAL (0x2ec24ac0)),
	    BIL_PAIR (BIL_VAL (0x6a7dfbf5), BIL_VAL (0x83c681ef)),
	    BIL_PAIR (BIL_VAL (0x16ef0531), BIL_VAL (0xd01b248a)),
	    BIL_PAIR (BIL_VAL (0xee636ceb), BIL_VAL (0x94aa0954)),
	    BIL_PAIR (BIL_VAL (0xbf6c56a0), BIL_VAL (0x00000000))
	    /* And implicit 192 0 bits.  */),
  /* 230 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0x107d4571), BIL_VAL (0x24123c89)),
	    BIL_PAIR (BIL_VAL (0xb2695da1), BIL_VAL (0x5568c086)),
	    BIL_PAIR (BIL_VAL (0x4edecddb), BIL_VAL (0x8afaced1)),
	    BIL_PAIR (BIL_VAL (0x96ad3820), BIL_VAL (0x471f2dae)),
	    BIL_PAIR (BIL_VAL (0x1e493b77), BIL_VAL (0xd396eb84)),
	    BIL_PAIR (BIL_VAL (0x28ebd797), BIL_VAL (0x25c11356)),
	    BIL_PAIR (BIL_VAL (0xe55633f2), BIL_VAL (0x210f6d6d)),
	    BIL_PAIR (BIL_VAL (0x4fe24133), BIL_VAL (0xcea45d4f)),
	    BIL_PAIR (BIL_VAL (0x7a3b6240), BIL_VAL (0x00000000))
	    /* And implicit 192 0 bits.  */),
  /* 231 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0xa4e4b66b), BIL_VAL (0x68b65d60)),
	    BIL_PAIR (BIL_VAL (0xf81da84d), BIL_VAL (0x5617853f)),
	    BIL_PAIR (BIL_VAL (0x14b40a93), BIL_VAL (0x6dcc142f)),
	    BIL_PAIR (BIL_VAL (0xe2c43142), BIL_VAL (0xc737c8cd)),
	    BIL_PAIR (BIL_VAL (0x2edc52ae), BIL_VAL (0x43e53329)),
	    BIL_PAIR (BIL_VAL (0x99366be7), BIL_VAL (0x798ac164)),
	    BIL_PAIR (BIL_VAL (0xf55e0775), BIL_VAL (0x4a9a4645)),
	    BIL_PAIR (BIL_VAL (0x1ed68c06), BIL_VAL (0x126ba51a)),
	    BIL_PAIR (BIL_VAL (0xc651d680), BIL_VAL (0x00000000))
	    /* And implicit 192 0 bits.  */),
  /* 232 */
  BIL_SET10 (BIL_VAL (0x6),
	     BIL_PAIR (BIL_VAL (0x70ef2032), BIL_VAL (0x171fa5c9)),
	     BIL_PAIR (BIL_VAL (0xb1289305), BIL_VAL (0x5ceb3476)),
	     BIL_PAIR (BIL_VAL (0xcf0869c2), BIL_VAL (0x49f8c9de)),
	     BIL_PAIR (BIL_VAL (0xdba9ec9b), BIL_VAL (0xc82dd803)),
	     BIL_PAIR (BIL_VAL (0xd49b3ace), BIL_VAL (0xa6f3ff9f)),
	     BIL_PAIR (BIL_VAL (0xfc20370a), BIL_VAL (0xbf6b8df1)),
	     BIL_PAIR (BIL_VAL (0x95ac4a94), BIL_VAL (0xea06beb3)),
	     BIL_PAIR (BIL_VAL (0x3461783c), BIL_VAL (0xb834730b)),
	     BIL_PAIR (BIL_VAL (0xbf326100), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 233 */
  BIL_SET10 (BIL_VAL (0x40),
	     BIL_PAIR (BIL_VAL (0x695741f4), BIL_VAL (0xe73c79e0)),
	     BIL_PAIR (BIL_VAL (0xeb95be35), BIL_VAL (0xa1300ca4)),
	     BIL_PAIR (BIL_VAL (0x16542196), BIL_VAL (0xe3b7e2b4)),
	     BIL_PAIR (BIL_VAL (0x94a33e15), BIL_VAL (0xd1ca7026)),
	     BIL_PAIR (BIL_VAL (0x4e104c12), BIL_VAL (0x8587fc3f)),
	     BIL_PAIR (BIL_VAL (0xd942266b), BIL_VAL (0x7a338b6f)),
	     BIL_PAIR (BIL_VAL (0xd8bae9d1), BIL_VAL (0x24437300)),
	     BIL_PAIR (BIL_VAL (0x0bceb25f), BIL_VAL (0x320c7e75)),
	     BIL_PAIR (BIL_VAL (0x77f7ca00), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 234 */
  BIL_SET10 (BIL_VAL (0x284),
	     BIL_PAIR (BIL_VAL (0x1d689391), BIL_VAL (0x085cc2c9)),
	     BIL_PAIR (BIL_VAL (0x33d96e18), BIL_VAL (0x4be07e68)),
	     BIL_PAIR (BIL_VAL (0xdf494fe4), BIL_VAL (0xe52edb0d)),
	     BIL_PAIR (BIL_VAL (0xce606cda), BIL_VAL (0x31e8617f)),
	     BIL_PAIR (BIL_VAL (0x0ca2f8b9), BIL_VAL (0x374fda7e)),
	     BIL_PAIR (BIL_VAL (0x7c958032), BIL_VAL (0xc603725e)),
	     BIL_PAIR (BIL_VAL (0x774d222b), BIL_VAL (0x6aa27e00)),
	     BIL_PAIR (BIL_VAL (0x7612f7b7), BIL_VAL (0xf47cf096)),
	     BIL_PAIR (BIL_VAL (0xafade400), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 235 */
  BIL_SET10 (BIL_VAL (0x1929),
	     BIL_PAIR (BIL_VAL (0x2615c3aa), BIL_VAL (0x539f9bdc)),
	     BIL_PAIR (BIL_VAL (0x067e4cf2), BIL_VAL (0xf6c4f018)),
	     BIL_PAIR (BIL_VAL (0xb8dd1ef0), BIL_VAL (0xf3d48e8a)),
	     BIL_PAIR (BIL_VAL (0x0fc44085), BIL_VAL (0xf313cef6)),
	     BIL_PAIR (BIL_VAL (0x7e5db73c), BIL_VAL (0x291e88f0)),
	     BIL_PAIR (BIL_VAL (0xddd701fb), BIL_VAL (0xbc2277b0)),
	     BIL_PAIR (BIL_VAL (0xa90355b2), BIL_VAL (0x2a58ec04)),
	     BIL_PAIR (BIL_VAL (0x9cbdad2f), BIL_VAL (0x8ce165e2)),
	     BIL_PAIR (BIL_VAL (0xdccae800), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 236 */
  BIL_SET10 (BIL_VAL (0xfb9b),
	     BIL_PAIR (BIL_VAL (0x7cd9a4a7), BIL_VAL (0x443c1698)),
	     BIL_PAIR (BIL_VAL (0x40ef017d), BIL_VAL (0xa3b160f7)),
	     BIL_PAIR (BIL_VAL (0x38a33569), BIL_VAL (0x864d9164)),
	     BIL_PAIR (BIL_VAL (0x9daa853b), BIL_VAL (0x7ec615a0)),
	     BIL_PAIR (BIL_VAL (0xefa92859), BIL_VAL (0x9b315968)),
	     BIL_PAIR (BIL_VAL (0xaa6613d5), BIL_VAL (0x5958ace6)),
	     BIL_PAIR (BIL_VAL (0x9a2158f5), BIL_VAL (0xa779382e)),
	     BIL_PAIR (BIL_VAL (0x1f68c3db), BIL_VAL (0x80cdfadc)),
	     BIL_PAIR (BIL_VAL (0x9fed1000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 237 */
  BIL_SET10 (BIL_VAL (0x9d412),
	     BIL_PAIR (BIL_VAL (0xe0806e88), BIL_VAL (0xaa58e1f2)),
	     BIL_PAIR (BIL_VAL (0x89560ee8), BIL_VAL (0x64edc9a8)),
	     BIL_PAIR (BIL_VAL (0x3660161f), BIL_VAL (0x3f07adee)),
	     BIL_PAIR (BIL_VAL (0x28a93452), BIL_VAL (0xf3bcd849)),
	     BIL_PAIR (BIL_VAL (0x5c9b9380), BIL_VAL (0x0fed7e16)),
	     BIL_PAIR (BIL_VAL (0xa7fcc655), BIL_VAL (0x7d76c102)),
	     BIL_PAIR (BIL_VAL (0x054d7998), BIL_VAL (0x8abc31cd)),
	     BIL_PAIR (BIL_VAL (0x3a17a693), BIL_VAL (0x080bcc9e)),
	     BIL_PAIR (BIL_VAL (0x3f42a000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 238 */
  BIL_SET10 (BIL_VAL (0x6248bc),
	     BIL_PAIR (BIL_VAL (0xc5045156), BIL_VAL (0xa778d379)),
	     BIL_PAIR (BIL_VAL (0x5d5c9513), BIL_VAL (0xf149e092)),
	     BIL_PAIR (BIL_VAL (0x1fc0dd38), BIL_VAL (0x764ccb4d)),
	     BIL_PAIR (BIL_VAL (0x969c0b3d), BIL_VAL (0x856072dd)),
	     BIL_PAIR (BIL_VAL (0x9e13c300), BIL_VAL (0x9f46ece2)),
	     BIL_PAIR (BIL_VAL (0x8fdfbf56), BIL_VAL (0xe6a38a14)),
	     BIL_PAIR (BIL_VAL (0x3506bff5), BIL_VAL (0x6b59f204)),
	     BIL_PAIR (BIL_VAL (0x44ec81be), BIL_VAL (0x5075fe2e)),
	     BIL_PAIR (BIL_VAL (0x789a4000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 239 */
  BIL_SET10 (BIL_VAL (0x3d6d75f),
	     BIL_PAIR (BIL_VAL (0xb22b2d62), BIL_VAL (0x8ab842bd)),
	     BIL_PAIR (BIL_VAL (0xa59dd2c7), BIL_VAL (0x6ce2c5b5)),
	     BIL_PAIR (BIL_VAL (0x3d88a434), BIL_VAL (0x9efff107)),
	     BIL_PAIR (BIL_VAL (0xe2187067), BIL_VAL (0x35c47ca8)),
	     BIL_PAIR (BIL_VAL (0x2cc59e06), BIL_VAL (0x38c540d9)),
	     BIL_PAIR (BIL_VAL (0x9ebd7965), BIL_VAL (0x026364ca)),
	     BIL_PAIR (BIL_VAL (0x12437f96), BIL_VAL (0x3183742a)),
	     BIL_PAIR (BIL_VAL (0xb13d116f), BIL_VAL (0x249bedd0)),
	     BIL_PAIR (BIL_VAL (0xb6068000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 240 */
  BIL_SET10 (BIL_VAL (0x266469bc),
	     BIL_PAIR (BIL_VAL (0xf5afc5d9), BIL_VAL (0x6b329b68)),
	     BIL_PAIR (BIL_VAL (0x782a3bca), BIL_VAL (0x40dbb914)),
	     BIL_PAIR (BIL_VAL (0x67566a0e), BIL_VAL (0x35ff6a4e)),
	     BIL_PAIR (BIL_VAL (0xd4f46408), BIL_VAL (0x19acde91)),
	     BIL_PAIR (BIL_VAL (0xbfb82c3e), BIL_VAL (0x37b48880)),
	     BIL_PAIR (BIL_VAL (0x3366bdf2), BIL_VAL (0x17e1efe4)),
	     BIL_PAIR (BIL_VAL (0xb6a2fbdd), BIL_VAL (0xef2289aa)),
	     BIL_PAIR (BIL_VAL (0xec62ae57), BIL_VAL (0x6e174a27)),
	     BIL_PAIR (BIL_VAL (0x1c410000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 241 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0x1), BIL_VAL (0x7fec2161)),
	     BIL_PAIR (BIL_VAL (0x98ddba7e), BIL_VAL (0x2ffa1214)),
	     BIL_PAIR (BIL_VAL (0xb1a655e6), BIL_VAL (0x88953acc)),
	     BIL_PAIR (BIL_VAL (0x0960248e), BIL_VAL (0x1bfa2714)),
	     BIL_PAIR (BIL_VAL (0x518be851), BIL_VAL (0x00c0b1b1)),
	     BIL_PAIR (BIL_VAL (0x7d31ba6e), BIL_VAL (0x2d0d5502)),
	     BIL_PAIR (BIL_VAL (0x02036b74), BIL_VAL (0xeed35eef)),
	     BIL_PAIR (BIL_VAL (0x225dd6ab), BIL_VAL (0x575960ad)),
	     BIL_PAIR (BIL_VAL (0x3bdacf6a), BIL_VAL (0x4ce8e587)),
	     BIL_PAIR (BIL_VAL (0x1a8a0000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 242 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0xe), BIL_VAL (0xff394dcf)),
	     BIL_PAIR (BIL_VAL (0xf8a948ed), BIL_VAL (0xdfc4b4ce)),
	     BIL_PAIR (BIL_VAL (0xf07f5b01), BIL_VAL (0x55d44bf8)),
	     BIL_PAIR (BIL_VAL (0x5dc16d8d), BIL_VAL (0x17c586cb)),
	     BIL_PAIR (BIL_VAL (0x2f77132a), BIL_VAL (0x0786f0ee)),
	     BIL_PAIR (BIL_VAL (0xe3f1484d), BIL_VAL (0xc2855214)),
	     BIL_PAIR (BIL_VAL (0x14223291), BIL_VAL (0x5441b557)),
	     BIL_PAIR (BIL_VAL (0x57aa62b1), BIL_VAL (0x697dc6c4)),
	     BIL_PAIR (BIL_VAL (0x568c1a27), BIL_VAL (0x0118f747)),
	     BIL_PAIR (BIL_VAL (0x09640000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 243 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0x95), BIL_VAL (0xf83d0a1f)),
	     BIL_PAIR (BIL_VAL (0xb69cd94a), BIL_VAL (0xbdaf1015)),
	     BIL_PAIR (BIL_VAL (0x64f98e0d), BIL_VAL (0x5a4af7b3)),
	     BIL_PAIR (BIL_VAL (0xa98e4782), BIL_VAL (0xedb743ef)),
	     BIL_PAIR (BIL_VAL (0xdaa6bfa4), BIL_VAL (0x4b456954)),
	     BIL_PAIR (BIL_VAL (0xe76cd309), BIL_VAL (0x993534c8)),
	     BIL_PAIR (BIL_VAL (0xc955f9ad), BIL_VAL (0x4a911569)),
	     BIL_PAIR (BIL_VAL (0x6ca7daee), BIL_VAL (0x1ee9c3ab)),
	     BIL_PAIR (BIL_VAL (0x61790586), BIL_VAL (0x0af9a8c6)),
	     BIL_PAIR (BIL_VAL (0x5de80000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 244 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0x5db), BIL_VAL (0xb262653d)),
	     BIL_PAIR (BIL_VAL (0x22207ceb), BIL_VAL (0x68d6a0d5)),
	     BIL_PAIR (BIL_VAL (0xf1bf8c85), BIL_VAL (0x86edad04)),
	     BIL_PAIR (BIL_VAL (0x9f8ecb1d), BIL_VAL (0x4928a75e)),
	     BIL_PAIR (BIL_VAL (0x8a837c6a), BIL_VAL (0xf0b61d51)),
	     BIL_PAIR (BIL_VAL (0x0a403e5f), BIL_VAL (0xfc140fd7)),
	     BIL_PAIR (BIL_VAL (0xdd5bc0c4), BIL_VAL (0xe9aad61e)),
	     BIL_PAIR (BIL_VAL (0x3e8e8d4d), BIL_VAL (0x3521a4b1)),
	     BIL_PAIR (BIL_VAL (0xceba373c), BIL_VAL (0x6dc097bf)),
	     BIL_PAIR (BIL_VAL (0xab100000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 245 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0x3a94), BIL_VAL (0xf7d7f463)),
	     BIL_PAIR (BIL_VAL (0x5544e132), BIL_VAL (0x1862485b)),
	     BIL_PAIR (BIL_VAL (0x717b7d37), BIL_VAL (0x4548c22e)),
	     BIL_PAIR (BIL_VAL (0x3b93ef24), BIL_VAL (0xdb9689b1)),
	     BIL_PAIR (BIL_VAL (0x6922dc2d), BIL_VAL (0x671d252a)),
	     BIL_PAIR (BIL_VAL (0x66826fbf), BIL_VAL (0xd8c89e6e)),
	     BIL_PAIR (BIL_VAL (0xa59587b1), BIL_VAL (0x20ac5d2e)),
	     BIL_PAIR (BIL_VAL (0x71918504), BIL_VAL (0x13506ef2)),
	     BIL_PAIR (BIL_VAL (0x1346285c), BIL_VAL (0x4985ed7c)),
	     BIL_PAIR (BIL_VAL (0xaea00000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 246 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0x249d1), BIL_VAL (0xae6f8be1)),
	     BIL_PAIR (BIL_VAL (0x54b0cbf4), BIL_VAL (0xf3d6d392)),
	     BIL_PAIR (BIL_VAL (0x6ed2e428), BIL_VAL (0xb4d795ce)),
	     BIL_PAIR (BIL_VAL (0x53c75770), BIL_VAL (0x93e160ee)),
	     BIL_PAIR (BIL_VAL (0x1b5c99c6), BIL_VAL (0x072373a8)),
	     BIL_PAIR (BIL_VAL (0x01185d7e), BIL_VAL (0x77d63052)),
	     BIL_PAIR (BIL_VAL (0x77d74ceb), BIL_VAL (0x46bba3d0)),
	     BIL_PAIR (BIL_VAL (0x6faf3228), BIL_VAL (0xc1245574)),
	     BIL_PAIR (BIL_VAL (0xc0bd939a), BIL_VAL (0xdf3b46de)),
	     BIL_PAIR (BIL_VAL (0xd2400000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 247 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0x16e230), BIL_VAL (0xd05b76cd)),
	     BIL_PAIR (BIL_VAL (0x4ee7f791), BIL_VAL (0x866443b8)),
	     BIL_PAIR (BIL_VAL (0x543ce997), BIL_VAL (0x106bda0f)),
	     BIL_PAIR (BIL_VAL (0x45c96a65), BIL_VAL (0xc6cdc94d)),
	     BIL_PAIR (BIL_VAL (0x119e01bc), BIL_VAL (0x47628490)),
	     BIL_PAIR (BIL_VAL (0x0af3a6f0), BIL_VAL (0xae5de338)),
	     BIL_PAIR (BIL_VAL (0xae690130), BIL_VAL (0xc3546624)),
	     BIL_PAIR (BIL_VAL (0x5cd7f597), BIL_VAL (0x8b6b568f)),
	     BIL_PAIR (BIL_VAL (0x8767c40c), BIL_VAL (0xb850c4b4)),
	     BIL_PAIR (BIL_VAL (0x36800000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 248 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0xe4d5e8), BIL_VAL (0x2392a405)),
	     BIL_PAIR (BIL_VAL (0x150fabaf), BIL_VAL (0x3feaa533)),
	     BIL_PAIR (BIL_VAL (0x4a611fe6), BIL_VAL (0xa4368498)),
	     BIL_PAIR (BIL_VAL (0xb9de27f9), BIL_VAL (0xc409dd02)),
	     BIL_PAIR (BIL_VAL (0xb02c115a), BIL_VAL (0xc9d92da0)),
	     BIL_PAIR (BIL_VAL (0x6d848566), BIL_VAL (0xcfaae036)),
	     BIL_PAIR (BIL_VAL (0xd01a0be7), BIL_VAL (0xa14bfd6b)),
	     BIL_PAIR (BIL_VAL (0xa06f97eb), BIL_VAL (0x7231619b)),
	     BIL_PAIR (BIL_VAL (0x4a0da87f), BIL_VAL (0x3327af0a)),
	     BIL_PAIR (BIL_VAL (0x21000000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 249 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0x8f05b11), BIL_VAL (0x63ba6832)),
	     BIL_PAIR (BIL_VAL (0xd29cb4d8), BIL_VAL (0x7f2a7400)),
	     BIL_PAIR (BIL_VAL (0xe7cb3f02), BIL_VAL (0x6a212df7)),
	     BIL_PAIR (BIL_VAL (0x42ad8fc1), BIL_VAL (0xa862a21a)),
	     BIL_PAIR (BIL_VAL (0xe1b8ad8b), BIL_VAL (0xe27bc844)),
	     BIL_PAIR (BIL_VAL (0x472d3604), BIL_VAL (0x1cacc224)),
	     BIL_PAIR (BIL_VAL (0x2104770c), BIL_VAL (0x4cf7e634)),
	     BIL_PAIR (BIL_VAL (0x445bef32), BIL_VAL (0x75edd010)),
	     BIL_PAIR (BIL_VAL (0xe48894f7), BIL_VAL (0xff8cd665)),
	     BIL_PAIR (BIL_VAL (0x4a000000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 250 */
  BIL_SET10 (BIL_PAIR (BIL_VAL (0x59638ead), BIL_VAL (0xe54811fc)),
	     BIL_PAIR (BIL_VAL (0x3a1f1074), BIL_VAL (0xf7a88809)),
	     BIL_PAIR (BIL_VAL (0x0df07618), BIL_VAL (0x254bcba8)),
	     BIL_PAIR (BIL_VAL (0x9ac79d90), BIL_VAL (0x93da550c)),
	     BIL_PAIR (BIL_VAL (0xd136c776), BIL_VAL (0xd8d5d2aa)),
	     BIL_PAIR (BIL_VAL (0xc7c41c29), BIL_VAL (0x1ebf9569)),
	     BIL_PAIR (BIL_VAL (0x4a2ca67b), BIL_VAL (0x01aefe0a)),
	     BIL_PAIR (BIL_VAL (0xab9757f8), BIL_VAL (0x9b4a20a8)),
	     BIL_PAIR (BIL_VAL (0xed55d1af), BIL_VAL (0xfb805ff4)),
	     BIL_PAIR (BIL_VAL (0xe4000000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 251 */
  BIL_SET11 (BIL_VAL (0x3),
	     BIL_PAIR (BIL_VAL (0x7de392ca), BIL_VAL (0xf4d0b3da)),
	     BIL_PAIR (BIL_VAL (0x4536a491), BIL_VAL (0xac95505a)),
	     BIL_PAIR (BIL_VAL (0x8b649cf1), BIL_VAL (0x74f5f496)),
	     BIL_PAIR (BIL_VAL (0x0bcc27a5), BIL_VAL (0xc6875280)),
	     BIL_PAIR (BIL_VAL (0x2c23caa4), BIL_VAL (0x785a3aab)),
	     BIL_PAIR (BIL_VAL (0xcda9199b), BIL_VAL (0x337bd61c)),
	     BIL_PAIR (BIL_VAL (0xe5be80ce), BIL_VAL (0x10d5ec6a)),
	     BIL_PAIR (BIL_VAL (0xb3e96fb6), BIL_VAL (0x10e54699)),
	     BIL_PAIR (BIL_VAL (0x455a30df), BIL_VAL (0xd303bf90)),
	     BIL_PAIR (BIL_VAL (0xe8000000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 252 */
  BIL_SET11 (BIL_VAL (0x22),
	     BIL_PAIR (BIL_VAL (0xeae3bbed), BIL_VAL (0x90270686)),
	     BIL_PAIR (BIL_VAL (0xb4226db0), BIL_VAL (0xbdd52389)),
	     BIL_PAIR (BIL_VAL (0x71ee216e), BIL_VAL (0x919b8ddc)),
	     BIL_PAIR (BIL_VAL (0x75f98c79), BIL_VAL (0xc1493901)),
	     BIL_PAIR (BIL_VAL (0xb965ea6c), BIL_VAL (0xb3864ab6)),
	     BIL_PAIR (BIL_VAL (0x089b0010), BIL_VAL (0x02d65d20)),
	     BIL_PAIR (BIL_VAL (0xf971080c), BIL_VAL (0xa85b3c2b)),
	     BIL_PAIR (BIL_VAL (0x071e5d1c), BIL_VAL (0xa8f4c1fc)),
	     BIL_PAIR (BIL_VAL (0xb585e8be), BIL_VAL (0x3e257ba9)),
	     BIL_PAIR (BIL_VAL (0x10000000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 253 */
  BIL_SET11 (BIL_VAL (0x15d),
	     BIL_PAIR (BIL_VAL (0x2ce55747), BIL_VAL (0xa1864143)),
	     BIL_PAIR (BIL_VAL (0x095848e7), BIL_VAL (0x6a53635e)),
	     BIL_PAIR (BIL_VAL (0x734d4e51), BIL_VAL (0xb0138a9c)),
	     BIL_PAIR (BIL_VAL (0x9bbf7cc1), BIL_VAL (0x8cdc3a11)),
	     BIL_PAIR (BIL_VAL (0x3dfb283f), BIL_VAL (0x033eeb1c)),
	     BIL_PAIR (BIL_VAL (0x560e00a0), BIL_VAL (0x1c5fa349)),
	     BIL_PAIR (BIL_VAL (0xbe6a507e), BIL_VAL (0x939059ae)),
	     BIL_PAIR (BIL_VAL (0x472fa31e), BIL_VAL (0x998f93df)),
	     BIL_PAIR (BIL_VAL (0x173b176e), BIL_VAL (0x6d76d49a)),
	     BIL_PAIR (BIL_VAL (0xa0000000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 254 */
  BIL_SET11 (BIL_VAL (0xda3),
	     BIL_PAIR (BIL_VAL (0xc0f568cc), BIL_VAL (0x4f3e8c9e)),
	     BIL_PAIR (BIL_VAL (0x5d72d90a), BIL_VAL (0x2741e1b0)),
	     BIL_PAIR (BIL_VAL (0x81050f30), BIL_VAL (0xe0c36a1e)),
	     BIL_PAIR (BIL_VAL (0x157adf8f), BIL_VAL (0x809a44ac)),
	     BIL_PAIR (BIL_VAL (0x6bcf9276), BIL_VAL (0x20752f1b)),
	     BIL_PAIR (BIL_VAL (0x5c8c0641), BIL_VAL (0x1bbc60e1)),
	     BIL_PAIR (BIL_VAL (0x702724f1), BIL_VAL (0xc3a380ce)),
	     BIL_PAIR (BIL_VAL (0xc7dc5f31), BIL_VAL (0xff9bc6b6)),
	     BIL_PAIR (BIL_VAL (0xe84eea50), BIL_VAL (0x46a44e0a)),
	     BIL_PAIR (BIL_VAL (0x40000000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 255 */
  BIL_SET11 (BIL_VAL (0x8865),
	     BIL_PAIR (BIL_VAL (0x899617fb), BIL_VAL (0x18717e2f)),
	     BIL_PAIR (BIL_VAL (0xa67c7a65), BIL_VAL (0x8892d0e5)),
	     BIL_PAIR (BIL_VAL (0x0a3297e8), BIL_VAL (0xc7a2252c)),
	     BIL_PAIR (BIL_VAL (0xd6ccbb9b), BIL_VAL (0x0606aebc)),
	     BIL_PAIR (BIL_VAL (0x361bb89d), BIL_VAL (0x4493d711)),
	     BIL_PAIR (BIL_VAL (0x9d783e8b), BIL_VAL (0x155bc8ce)),
	     BIL_PAIR (BIL_VAL (0x61877171), BIL_VAL (0xa4630813)),
	     BIL_PAIR (BIL_VAL (0xce9bb7f3), BIL_VAL (0xfc15c325)),
	     BIL_PAIR (BIL_VAL (0x13152722), BIL_VAL (0xc26b0c66)),
	     BIL_PAIR (BIL_VAL (0x80000000), BIL_VAL (0x00000000))
	     /* And implicit 192 0 bits.  */),
  /* 256 */
  BIL_SET10 (BIL_VAL (0x553f7),
	     BIL_PAIR (BIL_VAL (0x5fdcefce), BIL_VAL (0xf46eeddc)),
	     BIL_PAIR (BIL_VAL (0x80dcc7f7), BIL_VAL (0x55bc28f2)),
	     BIL_PAIR (BIL_VAL (0x65f9ef17), BIL_VAL (0xcc5573c0)),
	     BIL_PAIR (BIL_VAL (0x63ff540e), BIL_VAL (0x3c42d35a)),
	     BIL_PAIR (BIL_VAL (0x1d153624), BIL_VAL (0xadc666b0)),
	     BIL_PAIR (BIL_VAL (0x26b2716e), BIL_VAL (0xd595d80f)),
	     BIL_PAIR (BIL_VAL (0xcf4a6e70), BIL_VAL (0x6bde50c6)),
	     BIL_PAIR (BIL_VAL (0x12152f87), BIL_VAL (0xd8d99f72)),
	     BIL_PAIR (BIL_VAL (0xbed3875b), BIL_VAL (0x982e7c01))
	     /* And implicit 256 0 bits.  */),
  /* 512 */
  BIL_SET2 (BIL_SET4 (BIL_PAIR (BIL_VAL (0x1c), BIL_VAL (0x633415d4)),
		      BIL_PAIR (BIL_VAL (0xc1d238d9), BIL_VAL (0x8cab8a97)),
		      BIL_PAIR (BIL_VAL (0x8a0b1f13), BIL_VAL (0x8cb07303)),
		      BIL_PAIR (BIL_VAL (0xa2699748), BIL_VAL (0x45a71d46))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xb099bc81), BIL_VAL (0x7343afac)),
		       BIL_PAIR (BIL_VAL (0x69be5b0e), BIL_VAL (0x9449775c)),
		       BIL_PAIR (BIL_VAL (0x1366732a), BIL_VAL (0x93abade4)),
		       BIL_PAIR (BIL_VAL (0xb2908ee0), BIL_VAL (0xf95f635e)),
		       BIL_PAIR (BIL_VAL (0x85a91924), BIL_VAL (0xc3fc0695)),
		       BIL_PAIR (BIL_VAL (0xe7fc7153), BIL_VAL (0x329c57ae)),
		       BIL_PAIR (BIL_VAL (0xbfa3edac), BIL_VAL (0x96e14f5d)),
		       BIL_PAIR (BIL_VAL (0xbc51fb2e), BIL_VAL (0xb21a2f22)),
		       BIL_PAIR (BIL_VAL (0x1e25cfea), BIL_VAL (0x703ed321)),
		       BIL_PAIR (BIL_VAL (0xaa1da1bf), BIL_VAL (0x28f8733b)),
		       BIL_PAIR (BIL_VAL (0x4475b579), BIL_VAL (0xc88976c1)),
		       BIL_PAIR (BIL_VAL (0x94e65747), BIL_VAL (0x46c40513)),
		       BIL_PAIR (BIL_VAL (0xc31e1ad9), BIL_VAL (0xb83a8a97)),
		       BIL_PAIR (BIL_VAL (0x5d96976f), BIL_VAL (0x8f9546dc)),
		       BIL_PAIR (BIL_VAL (0x77f27267), BIL_VAL (0xfc6cf801))
		       /* And implicit 512 0 bits.  */)),
  /* 768 */
  BIL_SET2 (BIL_SET13 (BIL_PAIR (BIL_VAL (0x973f9c), BIL_VAL (0xa8cd00a6)),
		       BIL_PAIR (BIL_VAL (0x8c6c8d3f), BIL_VAL (0xca02ca6d)),
		       BIL_PAIR (BIL_VAL (0xe6b0d7ba), BIL_VAL (0x42677734)),
		       BIL_PAIR (BIL_VAL (0x4d7ced4b), BIL_VAL (0xde6b3671)),
		       BIL_PAIR (BIL_VAL (0x55790955), BIL_VAL (0xdebadbbb)),
		       BIL_PAIR (BIL_VAL (0x834d963d), BIL_VAL (0x164f3474)),
		       BIL_PAIR (BIL_VAL (0x76fef8bc), BIL_VAL (0xb0c43b21)),
		       BIL_PAIR (BIL_VAL (0x6f8a2c7d), BIL_VAL (0xc42b346b)),
		       BIL_PAIR (BIL_VAL (0x54ccec04), BIL_VAL (0x0ff24f6f)),
		       BIL_PAIR (BIL_VAL (0xa522c4f7), BIL_VAL (0xef1410dd)),
		       BIL_PAIR (BIL_VAL (0x3f150b6e), BIL_VAL (0x3177669a)),
		       BIL_PAIR (BIL_VAL (0x57104362), BIL_VAL (0x749594d7)),
		       BIL_PAIR (BIL_VAL (0x6c1e29ba), BIL_VAL (0xd03661bb))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x93909c54), BIL_VAL (0x1485f9df)),
		       BIL_PAIR (BIL_VAL (0x5edf1c46), BIL_VAL (0xe9de83ee)),
		       BIL_PAIR (BIL_VAL (0x7fed8a55), BIL_VAL (0xfcd28d3a)),
		       BIL_PAIR (BIL_VAL (0x4451c6ee), BIL_VAL (0xe349bfe2)),
		       BIL_PAIR (BIL_VAL (0x1c032744), BIL_VAL (0x8f28e71a)),
		       BIL_PAIR (BIL_VAL (0xcc270307), BIL_VAL (0x64597e3b)),
		       BIL_PAIR (BIL_VAL (0xe35d8a93), BIL_VAL (0xd1493ca6)),
		       BIL_PAIR (BIL_VAL (0x32b304b8), BIL_VAL (0x9e54d463)),
		       BIL_PAIR (BIL_VAL (0x1b59b9a3), BIL_VAL (0x1371f8ae)),
		       BIL_PAIR (BIL_VAL (0x86d95826), BIL_VAL (0x69e1b7e9)),
		       BIL_PAIR (BIL_VAL (0xcd00c670), BIL_VAL (0xf4bf365f)),
		       BIL_PAIR (BIL_VAL (0x74269c7a), BIL_VAL (0xb3172816)),
		       BIL_PAIR (BIL_VAL (0x7a4ce4de), BIL_VAL (0x1f6387f2)),
		       BIL_PAIR (BIL_VAL (0xcca2ba7a), BIL_VAL (0x9eb710db)),
		       BIL_PAIR (BIL_VAL (0x8c448edc), BIL_VAL (0xecbb7401))
		       /* And implicit 768 0 bits.  */)),
  /* 1024 */
  BIL_SET3 (BIL_SET8 (BIL_VAL (0x325),
		      BIL_PAIR (BIL_VAL (0xd9d61a05), BIL_VAL (0xd4305d94)),
		      BIL_PAIR (BIL_VAL (0x34f4a3c6), BIL_VAL (0x2d433949)),
		      BIL_PAIR (BIL_VAL (0xae6209d4), BIL_VAL (0x926c3f5b)),
		      BIL_PAIR (BIL_VAL (0xd2db49ef), BIL_VAL (0x47187094)),
		      BIL_PAIR (BIL_VAL (0xc1a6970c), BIL_VAL (0xa7e6bd2a)),
		      BIL_PAIR (BIL_VAL (0x73c55349), BIL_VAL (0x36a8de06)),
		      BIL_PAIR (BIL_VAL (0x1e8d4649), BIL_VAL (0xf4f3235e))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x005b8041), BIL_VAL (0x1640114a)),
		       BIL_PAIR (BIL_VAL (0x88bc491b), BIL_VAL (0x9fc4ed52)),
		       BIL_PAIR (BIL_VAL (0x0190fba0), BIL_VAL (0x35faaba6)),
		       BIL_PAIR (BIL_VAL (0xc356e38a), BIL_VAL (0x31b5653f)),
		       BIL_PAIR (BIL_VAL (0x44597583), BIL_VAL (0x6cb0b6c9)),
		       BIL_PAIR (BIL_VAL (0x75a351a2), BIL_VAL (0x8e4262ce)),
		       BIL_PAIR (BIL_VAL (0x3ce3a0b8), BIL_VAL (0xdf68368a)),
		       BIL_PAIR (BIL_VAL (0xe26a7b7e), BIL_VAL (0x976a3310)),
		       BIL_PAIR (BIL_VAL (0xfc8f1f90), BIL_VAL (0x31eb0f66)),
		       BIL_PAIR (BIL_VAL (0x9a202882), BIL_VAL (0x80bda5a5)),
		       BIL_PAIR (BIL_VAL (0x80d98089), BIL_VAL (0xdc1a47fe)),
		       BIL_PAIR (BIL_VAL (0x6b7595fb), BIL_VAL (0x101a3616)),
		       BIL_PAIR (BIL_VAL (0xb6f4654b), BIL_VAL (0x31fb6bfd)),
		       BIL_PAIR (BIL_VAL (0xf56deeec), BIL_VAL (0xb1b896bc)),
		       BIL_PAIR (BIL_VAL (0x8fc51a16), BIL_VAL (0xbf3fdeb3))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xd814b505), BIL_VAL (0xba34c411)),
		       BIL_PAIR (BIL_VAL (0x8ad822a5), BIL_VAL (0x1abe1de3)),
		       BIL_PAIR (BIL_VAL (0x045b7a74), BIL_VAL (0x8e1042c4)),
		       BIL_PAIR (BIL_VAL (0x62be695a), BIL_VAL (0x9f9f2a07)),
		       BIL_PAIR (BIL_VAL (0xa7e89431), BIL_VAL (0x922bbb9f)),
		       BIL_PAIR (BIL_VAL (0xc9635986), BIL_VAL (0x1c5cd134)),
		       BIL_PAIR (BIL_VAL (0xf451218b), BIL_VAL (0x65dc60d7)),
		       BIL_PAIR (BIL_VAL (0x233e55c7), BIL_VAL (0x231d2b9c)),
		       BIL_PAIR (BIL_VAL (0x9fce837d), BIL_VAL (0x1e43f61f)),
		       BIL_PAIR (BIL_VAL (0x7de16cfb), BIL_VAL (0x896634ee)),
		       BIL_PAIR (BIL_VAL (0x0ed1440e), BIL_VAL (0xcc2cd819)),
		       BIL_PAIR (BIL_VAL (0x4c7d1e1a), BIL_VAL (0x140ac535)),
		       BIL_PAIR (BIL_VAL (0x15c51a88), BIL_VAL (0x991c4e87)),
		       BIL_PAIR (BIL_VAL (0x1ec29f86), BIL_VAL (0x6e7c215b)),
		       BIL_PAIR (BIL_VAL (0xf55b2b72), BIL_VAL (0x2919f001))
		       /* And implicit 1024 0 bits.  */)),
  /* 1280 */
  BIL_SET4 (BIL_SET2 (BIL_VAL (0x10c59181),
		      BIL_PAIR (BIL_VAL (0xdd70add9), BIL_VAL (0x610b799a))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xb80bdd3f), BIL_VAL (0x3d9fe5c5)),
		       BIL_PAIR (BIL_VAL (0x83d5d3b7), BIL_VAL (0x371513e4)),
		       BIL_PAIR (BIL_VAL (0x883c0107), BIL_VAL (0xf8f65567)),
		       BIL_PAIR (BIL_VAL (0xc8a367c1), BIL_VAL (0x0d64aee5)),
		       BIL_PAIR (BIL_VAL (0xd5bcbdc5), BIL_VAL (0xe396703b)),
		       BIL_PAIR (BIL_VAL (0xf1cfc4c4), BIL_VAL (0x4b1dfee7)),
		       BIL_PAIR (BIL_VAL (0x0dc9dd4f), BIL_VAL (0x50d66022)),
		       BIL_PAIR (BIL_VAL (0x134517fd), BIL_VAL (0x22930096)),
		       BIL_PAIR (BIL_VAL (0xc3b7fcb6), BIL_VAL (0x89db4eb6)),
		       BIL_PAIR (BIL_VAL (0x32d109db), BIL_VAL (0xad462aab)),
		       BIL_PAIR (BIL_VAL (0x64d409c4), BIL_VAL (0xf3ef8c70)),
		       BIL_PAIR (BIL_VAL (0xd1855279), BIL_VAL (0xc9d4d249)),
		       BIL_PAIR (BIL_VAL (0x63cc5cd4), BIL_VAL (0xa8d14110)),
		       BIL_PAIR (BIL_VAL (0x267fb1db), BIL_VAL (0xdbcc5054)),
		       BIL_PAIR (BIL_VAL (0x973e4aae), BIL_VAL (0xcfb84a2d))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x18b37933), BIL_VAL (0xe8fa4935)),
		       BIL_PAIR (BIL_VAL (0xef3e6880), BIL_VAL (0x80107131)),
		       BIL_PAIR (BIL_VAL (0x3d2fdd8e), BIL_VAL (0xaeeeab7e)),
		       BIL_PAIR (BIL_VAL (0x37265f3b), BIL_VAL (0x409864d6)),
		       BIL_PAIR (BIL_VAL (0x11356488), BIL_VAL (0xb53d435a)),
		       BIL_PAIR (BIL_VAL (0xb98d07ca), BIL_VAL (0x42051e0d)),
		       BIL_PAIR (BIL_VAL (0x816a6e36), BIL_VAL (0xb6819682)),
		       BIL_PAIR (BIL_VAL (0x599f657d), BIL_VAL (0xc22e435e)),
		       BIL_PAIR (BIL_VAL (0x251d8be5), BIL_VAL (0x8e3ab5b6)),
		       BIL_PAIR (BIL_VAL (0xd63e3cf0), BIL_VAL (0x654f6df8)),
		       BIL_PAIR (BIL_VAL (0x72eee183), BIL_VAL (0xeb14fec0)),
		       BIL_PAIR (BIL_VAL (0xb53c65a4), BIL_VAL (0x9875999e)),
		       BIL_PAIR (BIL_VAL (0x965d81a8), BIL_VAL (0xca32cea9)),
		       BIL_PAIR (BIL_VAL (0xfa3b5ac5), BIL_VAL (0xbca7743a)),
		       BIL_PAIR (BIL_VAL (0x2d69db2b), BIL_VAL (0x2c27a900))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xf9920410), BIL_VAL (0x7c9312a2)),
		       BIL_PAIR (BIL_VAL (0xee4b6b02), BIL_VAL (0x6b5f999a)),
		       BIL_PAIR (BIL_VAL (0x77d26ff1), BIL_VAL (0xb7bed96d)),
		       BIL_PAIR (BIL_VAL (0x29aa58aa), BIL_VAL (0xc47cf9ed)),
		       BIL_PAIR (BIL_VAL (0x7e324c4b), BIL_VAL (0x41bc7aaa)),
		       BIL_PAIR (BIL_VAL (0xd934ee1a), BIL_VAL (0xbc41c255)),
		       BIL_PAIR (BIL_VAL (0x2ed7093b), BIL_VAL (0xf3ba0de1)),
		       BIL_PAIR (BIL_VAL (0xeca83ce4), BIL_VAL (0xb18bfc3b)),
		       BIL_PAIR (BIL_VAL (0xb6edeb73), BIL_VAL (0xddf99bf5)),
		       BIL_PAIR (BIL_VAL (0x659e6c34), BIL_VAL (0x6eb076d4)),
		       BIL_PAIR (BIL_VAL (0x93a66b2f), BIL_VAL (0x51763512)),
		       BIL_PAIR (BIL_VAL (0xcd629969), BIL_VAL (0xd1041ba2)),
		       BIL_PAIR (BIL_VAL (0x3c14aec7), BIL_VAL (0xcb008209)),
		       BIL_PAIR (BIL_VAL (0x954042ff), BIL_VAL (0xae3a2996)),
		       BIL_PAIR (BIL_VAL (0x8ded17df), BIL_VAL (0x71886c01))
		       /* And implicit 1280 0 bits.  */)),
  /* 1536 */
  BIL_SET4 (BIL_SET11 (BIL_PAIR (BIL_VAL (0x595c), BIL_VAL (0x1a9d9cc9)),
		       BIL_PAIR (BIL_VAL (0xd3f2212b), BIL_VAL (0xd61da60e)),
		       BIL_PAIR (BIL_VAL (0xbbca3b82), BIL_VAL (0x5e8ddad2)),
		       BIL_PAIR (BIL_VAL (0xc01785d6), BIL_VAL (0xda8272b9)),
		       BIL_PAIR (BIL_VAL (0x465a2786), BIL_VAL (0x5adc10ed)),
		       BIL_PAIR (BIL_VAL (0x6bc748ca), BIL_VAL (0xfafccbd2)),
		       BIL_PAIR (BIL_VAL (0x1d2c6a5a), BIL_VAL (0xa16609a8)),
		       BIL_PAIR (BIL_VAL (0x21555039), BIL_VAL (0xbce02c3d)),
		       BIL_PAIR (BIL_VAL (0x660eedff), BIL_VAL (0x45c9c9c4)),
		       BIL_PAIR (BIL_VAL (0x331400ab), BIL_VAL (0xcab57dcc)),
		       BIL_PAIR (BIL_VAL (0x4b089367), BIL_VAL (0x523d5057))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x4ff1285a), BIL_VAL (0x2f67aff0)),
		       BIL_PAIR (BIL_VAL (0xd4195511), BIL_VAL (0x59b823bb)),
		       BIL_PAIR (BIL_VAL (0x19d73342), BIL_VAL (0x1bf420c7)),
		       BIL_PAIR (BIL_VAL (0xf6b23243), BIL_VAL (0x8443b49d)),
		       BIL_PAIR (BIL_VAL (0x71c5be22), BIL_VAL (0x50d79fbb)),
		       BIL_PAIR (BIL_VAL (0xdb51ff85), BIL_VAL (0xdaa93dbb)),
		       BIL_PAIR (BIL_VAL (0x034016f5), BIL_VAL (0xf8923717)),
		       BIL_PAIR (BIL_VAL (0xf1326909), BIL_VAL (0x8529e182)),
		       BIL_PAIR (BIL_VAL (0xf7f9a141), BIL_VAL (0x63123520)),
		       BIL_PAIR (BIL_VAL (0xec51ca9a), BIL_VAL (0x4261532c)),
		       BIL_PAIR (BIL_VAL (0xe6fd4da4), BIL_VAL (0x781cb057)),
		       BIL_PAIR (BIL_VAL (0x4a77c2f7), BIL_VAL (0xb5fe8bbe)),
		       BIL_PAIR (BIL_VAL (0xbe6ed841), BIL_VAL (0x6cb40380)),
		       BIL_PAIR (BIL_VAL (0xc178d552), BIL_VAL (0xd88ac34a)),
		       BIL_PAIR (BIL_VAL (0x23130207), BIL_VAL (0xb0d2deff))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x2f5c7bc8), BIL_VAL (0xb26d13e5)),
		       BIL_PAIR (BIL_VAL (0x658be27c), BIL_VAL (0xe4d851fc)),
		       BIL_PAIR (BIL_VAL (0x37b3020f), BIL_VAL (0xf82954ec)),
		       BIL_PAIR (BIL_VAL (0xa20352b7), BIL_VAL (0x55ccc3ad)),
		       BIL_PAIR (BIL_VAL (0xd931feaa), BIL_VAL (0x0759d813)),
		       BIL_PAIR (BIL_VAL (0xe3ced57f), BIL_VAL (0x0275cd92)),
		       BIL_PAIR (BIL_VAL (0x84d08c94), BIL_VAL (0x26b4841c)),
		       BIL_PAIR (BIL_VAL (0x5347cf73), BIL_VAL (0xadbc560e)),
		       BIL_PAIR (BIL_VAL (0x1f850ea2), BIL_VAL (0xb01ea870)),
		       BIL_PAIR (BIL_VAL (0xa87cc14e), BIL_VAL (0xd98ef8c5)),
		       BIL_PAIR (BIL_VAL (0x0bf83be8), BIL_VAL (0x58aed8ce)),
		       BIL_PAIR (BIL_VAL (0x9a25e7f4), BIL_VAL (0xcfa2c80c)),
		       BIL_PAIR (BIL_VAL (0xe555a98e), BIL_VAL (0x41167a97)),
		       BIL_PAIR (BIL_VAL (0x2cf7521b), BIL_VAL (0x6c58353f)),
		       BIL_PAIR (BIL_VAL (0x5b28e888), BIL_VAL (0xf9f22db2))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xe25776c4), BIL_VAL (0x1881c757)),
		       BIL_PAIR (BIL_VAL (0x7adf29d7), BIL_VAL (0xa759c1b1)),
		       BIL_PAIR (BIL_VAL (0x94e3bc1d), BIL_VAL (0x830a1c52)),
		       BIL_PAIR (BIL_VAL (0x8c50a295), BIL_VAL (0x8814f90e)),
		       BIL_PAIR (BIL_VAL (0x6f253848), BIL_VAL (0x5c011a38)),
		       BIL_PAIR (BIL_VAL (0x2bbc1158), BIL_VAL (0x5763837f)),
		       BIL_PAIR (BIL_VAL (0x7c9db37b), BIL_VAL (0x2b16dfcd)),
		       BIL_PAIR (BIL_VAL (0x639deb34), BIL_VAL (0x48beb84e)),
		       BIL_PAIR (BIL_VAL (0xb887f267), BIL_VAL (0x8254b63d)),
		       BIL_PAIR (BIL_VAL (0x6b9db411), BIL_VAL (0xaf5660cf)),
		       BIL_PAIR (BIL_VAL (0x4cf14e53), BIL_VAL (0xcd80e78d)),
		       BIL_PAIR (BIL_VAL (0x4c4bb9d9), BIL_VAL (0xa07c5774)),
		       BIL_PAIR (BIL_VAL (0xbba2f36f), BIL_VAL (0x938148c5)),
		       BIL_PAIR (BIL_VAL (0x4094f657), BIL_VAL (0x64ab3974)),
		       BIL_PAIR (BIL_VAL (0x6a52a4dc), BIL_VAL (0x8606e801))
		       /* And implicit 1536 0 bits.  */)),
  /* 1792 */
  BIL_SET5 (BIL_SET6 (BIL_VAL (0x1),
		      BIL_PAIR (BIL_VAL (0xdc1bbb09), BIL_VAL (0x24957118)),
		      BIL_PAIR (BIL_VAL (0x5a80e1e6), BIL_VAL (0x764356f7)),
		      BIL_PAIR (BIL_VAL (0x840af1f4), BIL_VAL (0x70a29117)),
		      BIL_PAIR (BIL_VAL (0x7e69fef2), BIL_VAL (0xc60519b3)),
		      BIL_PAIR (BIL_VAL (0x41e2e9c6), BIL_VAL (0x4f243a06))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x77291135), BIL_VAL (0xf0896552)),
		       BIL_PAIR (BIL_VAL (0x0681fded), BIL_VAL (0x9b535585)),
		       BIL_PAIR (BIL_VAL (0xfc7f722c), BIL_VAL (0xca5c1d4e)),
		       BIL_PAIR (BIL_VAL (0xc2f32e86), BIL_VAL (0x2421497a)),
		       BIL_PAIR (BIL_VAL (0x9f8a5a96), BIL_VAL (0xb699c6e3)),
		       BIL_PAIR (BIL_VAL (0xa69870dd), BIL_VAL (0xacf128fb)),
		       BIL_PAIR (BIL_VAL (0x13a7d8a4), BIL_VAL (0x15f7b3cb)),
		       BIL_PAIR (BIL_VAL (0xcaab90fd), BIL_VAL (0x799ae3ea)),
		       BIL_PAIR (BIL_VAL (0x966e83ee), BIL_VAL (0xde72a194)),
		       BIL_PAIR (BIL_VAL (0xa590a43e), BIL_VAL (0x3dd3ea15)),
		       BIL_PAIR (BIL_VAL (0x77d5b4c5), BIL_VAL (0x4740a6da)),
		       BIL_PAIR (BIL_VAL (0x06af50c7), BIL_VAL (0x8d39bb66)),
		       BIL_PAIR (BIL_VAL (0x882a24cb), BIL_VAL (0xb77504aa)),
		       BIL_PAIR (BIL_VAL (0xcd53a736), BIL_VAL (0x4dd80d9e)),
		       BIL_PAIR (BIL_VAL (0x9800bd51), BIL_VAL (0x5abae213))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xba04b294), BIL_VAL (0x54f225eb)),
		       BIL_PAIR (BIL_VAL (0xdedb5441), BIL_VAL (0x890e8e9c)),
		       BIL_PAIR (BIL_VAL (0x887d03eb), BIL_VAL (0x04af9d30)),
		       BIL_PAIR (BIL_VAL (0x393a13ab), BIL_VAL (0xc9d6c043)),
		       BIL_PAIR (BIL_VAL (0xf14385f0), BIL_VAL (0x98507ef1)),
		       BIL_PAIR (BIL_VAL (0x3e7db987), BIL_VAL (0xcc59b9d7)),
		       BIL_PAIR (BIL_VAL (0x2076657b), BIL_VAL (0x41e617ad)),
		       BIL_PAIR (BIL_VAL (0x8886d66d), BIL_VAL (0x6d0cccc9)),
		       BIL_PAIR (BIL_VAL (0xbb99d446), BIL_VAL (0xdc4f3d43)),
		       BIL_PAIR (BIL_VAL (0x507a6039), BIL_VAL (0xbde76912)),
		       BIL_PAIR (BIL_VAL (0xc81f2d12), BIL_VAL (0xafe967d0)),
		       BIL_PAIR (BIL_VAL (0x5741f945), BIL_VAL (0x47392392)),
		       BIL_PAIR (BIL_VAL (0x48b686e8), BIL_VAL (0xec840f90)),
		       BIL_PAIR (BIL_VAL (0xc484b647), BIL_VAL (0x65bcc8b0)),
		       BIL_PAIR (BIL_VAL (0xefe49809), BIL_VAL (0x50480fcb))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x8a91e2f6), BIL_VAL (0xb3aabd03)),
		       BIL_PAIR (BIL_VAL (0x5e7b98a8), BIL_VAL (0x4a39f2cd)),
		       BIL_PAIR (BIL_VAL (0xa7cf610f), BIL_VAL (0x1a860260)),
		       BIL_PAIR (BIL_VAL (0x645b7335), BIL_VAL (0xf07624f3)),
		       BIL_PAIR (BIL_VAL (0xa7f0074c), BIL_VAL (0xf8654078)),
		       BIL_PAIR (BIL_VAL (0xfed255ef), BIL_VAL (0x4b05d940)),
		       BIL_PAIR (BIL_VAL (0xf96239d8), BIL_VAL (0x6e65540f)),
		       BIL_PAIR (BIL_VAL (0x9c3687c7), BIL_VAL (0xc400ae50)),
		       BIL_PAIR (BIL_VAL (0x3b2966b1), BIL_VAL (0x2beeef97)),
		       BIL_PAIR (BIL_VAL (0x432c1bcf), BIL_VAL (0x0fff4f16)),
		       BIL_PAIR (BIL_VAL (0x6c8e53b4), BIL_VAL (0x4f44dd2b)),
		       BIL_PAIR (BIL_VAL (0xdc23ee61), BIL_VAL (0xdcd06a8b)),
		       BIL_PAIR (BIL_VAL (0xeaaa6c26), BIL_VAL (0xf2cb5ad8)),
		       BIL_PAIR (BIL_VAL (0x7a2cbe56), BIL_VAL (0x66c5622b)),
		       BIL_PAIR (BIL_VAL (0x1d080031), BIL_VAL (0x69703559))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xd9079398), BIL_VAL (0x52e8b4ea)),
		       BIL_PAIR (BIL_VAL (0x260a6a2a), BIL_VAL (0x705fe634)),
		       BIL_PAIR (BIL_VAL (0x78d28936), BIL_VAL (0x1d79ed44)),
		       BIL_PAIR (BIL_VAL (0xe5201baf), BIL_VAL (0xd9771c73)),
		       BIL_PAIR (BIL_VAL (0x3a9f308d), BIL_VAL (0xf96573a8)),
		       BIL_PAIR (BIL_VAL (0xa4508e52), BIL_VAL (0x5a041b4d)),
		       BIL_PAIR (BIL_VAL (0xf4af167d), BIL_VAL (0x173fb3a9)),
		       BIL_PAIR (BIL_VAL (0xde656fab), BIL_VAL (0x826ee460)),
		       BIL_PAIR (BIL_VAL (0xd116c951), BIL_VAL (0xa4926c87)),
		       BIL_PAIR (BIL_VAL (0x1f6cb347), BIL_VAL (0xae03bff9)),
		       BIL_PAIR (BIL_VAL (0xd07c3b80), BIL_VAL (0xe2880b83)),
		       BIL_PAIR (BIL_VAL (0x0db842d7), BIL_VAL (0x37180f76)),
		       BIL_PAIR (BIL_VAL (0x90f06449), BIL_VAL (0x9b8afd96)),
		       BIL_PAIR (BIL_VAL (0xeeef2d7d), BIL_VAL (0x2e1d3616)),
		       BIL_PAIR (BIL_VAL (0x4101a421), BIL_VAL (0x26956401))
		       /* And implicit 1792 0 bits.  */)),
  /* 2048 */
  BIL_SET5 (BIL_SET15 (BIL_VAL (0x9e8b3),
		       BIL_PAIR (BIL_VAL (0xb5dc53d5), BIL_VAL (0xde4a74d2)),
		       BIL_PAIR (BIL_VAL (0x8ce329ac), BIL_VAL (0xe526a319)),
		       BIL_PAIR (BIL_VAL (0x7bbebe30), BIL_VAL (0x34f77154)),
		       BIL_PAIR (BIL_VAL (0xce2bcba1), BIL_VAL (0x9648b21c)),
		       BIL_PAIR (BIL_VAL (0x11eb962b), BIL_VAL (0x1b61b93c)),
		       BIL_PAIR (BIL_VAL (0xf2ee5ca6), BIL_VAL (0xf7e928e6)),
		       BIL_PAIR (BIL_VAL (0x1d08e2d6), BIL_VAL (0x94222771)),
		       BIL_PAIR (BIL_VAL (0xe50f3027), BIL_VAL (0x8c983623)),
		       BIL_PAIR (BIL_VAL (0x0af908b4), BIL_VAL (0x0a753b7d)),
		       BIL_PAIR (BIL_VAL (0x77cd8c6b), BIL_VAL (0xe7151aab)),
		       BIL_PAIR (BIL_VAL (0x4efac5dc), BIL_VAL (0xd83e49d6)),
		       BIL_PAIR (BIL_VAL (0x907855ee), BIL_VAL (0xb028af62)),
		       BIL_PAIR (BIL_VAL (0x3f6f7024), BIL_VAL (0xd2c36fa9)),
		       BIL_PAIR (BIL_VAL (0xce9d04a4), BIL_VAL (0x87fa1fb9))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x92be221e), BIL_VAL (0xf1bd0ad5)),
		       BIL_PAIR (BIL_VAL (0xf775677c), BIL_VAL (0xe0de0840)),
		       BIL_PAIR (BIL_VAL (0x2ad3fa14), BIL_VAL (0x0eac7d56)),
		       BIL_PAIR (BIL_VAL (0xc7c9dee0), BIL_VAL (0xbedd8a6c)),
		       BIL_PAIR (BIL_VAL (0x038f9245), BIL_VAL (0xb2e87c34)),
		       BIL_PAIR (BIL_VAL (0x8ad803ec), BIL_VAL (0xca8f0070)),
		       BIL_PAIR (BIL_VAL (0xf8dbb57a), BIL_VAL (0x6a445f27)),
		       BIL_PAIR (BIL_VAL (0x8b3d5cf4), BIL_VAL (0x2915e818)),
		       BIL_PAIR (BIL_VAL (0x415c7f3e), BIL_VAL (0xf82df846)),
		       BIL_PAIR (BIL_VAL (0x58ccf45c), BIL_VAL (0xfad37943)),
		       BIL_PAIR (BIL_VAL (0x3f3389a4), BIL_VAL (0x408f43c5)),
		       BIL_PAIR (BIL_VAL (0x13ef5a83), BIL_VAL (0xfb8886fb)),
		       BIL_PAIR (BIL_VAL (0xf56d9d4b), BIL_VAL (0xd5f86079)),
		       BIL_PAIR (BIL_VAL (0x2e55ecee), BIL_VAL (0x70beb181)),
		       BIL_PAIR (BIL_VAL (0x0d76ce39), BIL_VAL (0xde9ec24b))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xcf99d019), BIL_VAL (0x53761abd)),
		       BIL_PAIR (BIL_VAL (0x9d7389c0), BIL_VAL (0xa244de3c)),
		       BIL_PAIR (BIL_VAL (0x195355d8), BIL_VAL (0x4eeebeee)),
		       BIL_PAIR (BIL_VAL (0x6f46eadb), BIL_VAL (0x56c6815b)),
		       BIL_PAIR (BIL_VAL (0x785ce6b7), BIL_VAL (0xb125ac8e)),
		       BIL_PAIR (BIL_VAL (0xdb0708fd), BIL_VAL (0x8f6cae5f)),
		       BIL_PAIR (BIL_VAL (0x5715f791), BIL_VAL (0x5b33eb41)),
		       BIL_PAIR (BIL_VAL (0x7bf03c19), BIL_VAL (0xd7917c7b)),
		       BIL_PAIR (BIL_VAL (0xa1fc6b96), BIL_VAL (0x81428c85)),
		       BIL_PAIR (BIL_VAL (0x744695f0), BIL_VAL (0xe866d7ef)),
		       BIL_PAIR (BIL_VAL (0xc9ac375d), BIL_VAL (0x77c1a42f)),
		       BIL_PAIR (BIL_VAL (0x40660460), BIL_VAL (0x944545ff)),
		       BIL_PAIR (BIL_VAL (0x87a7dc62), BIL_VAL (0xd752f7a6)),
		       BIL_PAIR (BIL_VAL (0x6a57b1ab), BIL_VAL (0x730f203c)),
		       BIL_PAIR (BIL_VAL (0x1aa9f444), BIL_VAL (0x84d80e2e))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x5fc5a047), BIL_VAL (0x79c56b8a)),
		       BIL_PAIR (BIL_VAL (0x9e110c7b), BIL_VAL (0xcbea4ca7)),
		       BIL_PAIR (BIL_VAL (0x982da466), BIL_VAL (0x3cfe491d)),
		       BIL_PAIR (BIL_VAL (0x0dbd21fe), BIL_VAL (0xab498697)),
		       BIL_PAIR (BIL_VAL (0x33554c36), BIL_VAL (0x685e5510)),
		       BIL_PAIR (BIL_VAL (0xc4a65665), BIL_VAL (0x4419bd43)),
		       BIL_PAIR (BIL_VAL (0x8e48ff35), BIL_VAL (0xd6c7d6ab)),
		       BIL_PAIR (BIL_VAL (0x91bac974), BIL_VAL (0xfb1264b4)),
		       BIL_PAIR (BIL_VAL (0xf111821f), BIL_VAL (0xa2bca416)),
		       BIL_PAIR (BIL_VAL (0xafe609c3), BIL_VAL (0x13b41e44)),
		       BIL_PAIR (BIL_VAL (0x9952fbed), BIL_VAL (0x5a151440)),
		       BIL_PAIR (BIL_VAL (0x967abbb3), BIL_VAL (0xa8281ed6)),
		       BIL_PAIR (BIL_VAL (0xa8f16f92), BIL_VAL (0x10c17f94)),
		       BIL_PAIR (BIL_VAL (0xe3892ee9), BIL_VAL (0x8074ff01)),
		       BIL_PAIR (BIL_VAL (0xe3cb64f3), BIL_VAL (0x2dbb6643))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xa7a8289c), BIL_VAL (0x8c6c54de)),
		       BIL_PAIR (BIL_VAL (0x34c10134), BIL_VAL (0x9713b449)),
		       BIL_PAIR (BIL_VAL (0x38209ce1), BIL_VAL (0xf3861ce0)),
		       BIL_PAIR (BIL_VAL (0xfb7fedcc), BIL_VAL (0x235552eb)),
		       BIL_PAIR (BIL_VAL (0x57a7842d), BIL_VAL (0x71c7fd8f)),
		       BIL_PAIR (BIL_VAL (0x66912e4a), BIL_VAL (0xd2f869c2)),
		       BIL_PAIR (BIL_VAL (0x92794987), BIL_VAL (0x19342c12)),
		       BIL_PAIR (BIL_VAL (0x866ed6f1), BIL_VAL (0xc850dabc)),
		       BIL_PAIR (BIL_VAL (0x98342c9e), BIL_VAL (0x51b78db2)),
		       BIL_PAIR (BIL_VAL (0xea50d142), BIL_VAL (0xfd827773)),
		       BIL_PAIR (BIL_VAL (0x2ed56d55), BIL_VAL (0xa5e5a191)),
		       BIL_PAIR (BIL_VAL (0x368b8abb), BIL_VAL (0xb6067584)),
		       BIL_PAIR (BIL_VAL (0xee87e354), BIL_VAL (0xec2e4721)),
		       BIL_PAIR (BIL_VAL (0x49e28dcf), BIL_VAL (0xb27d4d3f)),
		       BIL_PAIR (BIL_VAL (0xe3096865), BIL_VAL (0x1333e001))
		       /* And implicit 2048 0 bits.  */)),
  /* 2304 */
  BIL_SET6 (BIL_SET9 (BIL_PAIR (BIL_VAL (0x34), BIL_VAL (0xcb880c90)),
		      BIL_PAIR (BIL_VAL (0x7d201bcf), BIL_VAL (0xd4320081)),
		      BIL_PAIR (BIL_VAL (0x03d33300), BIL_VAL (0xeea8bce3)),
		      BIL_PAIR (BIL_VAL (0x8d5193f9), BIL_VAL (0xc07def23)),
		      BIL_PAIR (BIL_VAL (0x4680e0c6), BIL_VAL (0xffb7ce9c)),
		      BIL_PAIR (BIL_VAL (0xb1bf30a5), BIL_VAL (0xc73dfef3)),
		      BIL_PAIR (BIL_VAL (0xbcb0518f), BIL_VAL (0x42e286b0)),
		      BIL_PAIR (BIL_VAL (0x196c42d0), BIL_VAL (0x0f46fe9a)),
		      BIL_PAIR (BIL_VAL (0x7511fe3a), BIL_VAL (0x1e7a832c))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x9d81f57a), BIL_VAL (0x0a906d25)),
		       BIL_PAIR (BIL_VAL (0xe52bf109), BIL_VAL (0x72eabf2d)),
		       BIL_PAIR (BIL_VAL (0xfb95cf56), BIL_VAL (0x0355657a)),
		       BIL_PAIR (BIL_VAL (0x8b6cc09b), BIL_VAL (0x2a3ac9be)),
		       BIL_PAIR (BIL_VAL (0x4ab4b7c8), BIL_VAL (0x651b3553)),
		       BIL_PAIR (BIL_VAL (0xe11d6e90), BIL_VAL (0x20fab5f6)),
		       BIL_PAIR (BIL_VAL (0x95e17161), BIL_VAL (0x641e3900)),
		       BIL_PAIR (BIL_VAL (0xf11e1869), BIL_VAL (0x9b291853)),
		       BIL_PAIR (BIL_VAL (0xfe620e37), BIL_VAL (0xe3f47190)),
		       BIL_PAIR (BIL_VAL (0xd65b3246), BIL_VAL (0x88fa6386)),
		       BIL_PAIR (BIL_VAL (0x284f1227), BIL_VAL (0x104dc99a)),
		       BIL_PAIR (BIL_VAL (0x7df567b5), BIL_VAL (0x976aeef5)),
		       BIL_PAIR (BIL_VAL (0xcd089594), BIL_VAL (0xb00846b1)),
		       BIL_PAIR (BIL_VAL (0xa9629db1), BIL_VAL (0xd2a55f01)),
		       BIL_PAIR (BIL_VAL (0x6cbf7fc8), BIL_VAL (0xc06f489a))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x56ea406c), BIL_VAL (0x53ec72c5)),
		       BIL_PAIR (BIL_VAL (0x926864ed), BIL_VAL (0x10d73eaa)),
		       BIL_PAIR (BIL_VAL (0x51928250), BIL_VAL (0x1857fd85)),
		       BIL_PAIR (BIL_VAL (0x27c0a81e), BIL_VAL (0xa1cba808)),
		       BIL_PAIR (BIL_VAL (0x193b9bbf), BIL_VAL (0x5dbc75f3)),
		       BIL_PAIR (BIL_VAL (0x060b28bb), BIL_VAL (0x7d0fd457)),
		       BIL_PAIR (BIL_VAL (0xc0425477), BIL_VAL (0x761a721d)),
		       BIL_PAIR (BIL_VAL (0x935076fb), BIL_VAL (0x3c9db62d)),
		       BIL_PAIR (BIL_VAL (0xea214b51), BIL_VAL (0x836a999c)),
		       BIL_PAIR (BIL_VAL (0xe06b37f1), BIL_VAL (0xc521f1e9)),
		       BIL_PAIR (BIL_VAL (0x93e93786), BIL_VAL (0x6d73ef51)),
		       BIL_PAIR (BIL_VAL (0xacdfb22e), BIL_VAL (0x9a927af6)),
		       BIL_PAIR (BIL_VAL (0x72b0f83f), BIL_VAL (0x6966eadd)),
		       BIL_PAIR (BIL_VAL (0x43ba932e), BIL_VAL (0x61fef6de)),
		       BIL_PAIR (BIL_VAL (0xdfcb8ce6), BIL_VAL (0xc518c82b))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xdcdefba6), BIL_VAL (0xba97bf9c)),
		       BIL_PAIR (BIL_VAL (0xe43b0263), BIL_VAL (0x83837162)),
		       BIL_PAIR (BIL_VAL (0xebe9ce8a), BIL_VAL (0x22c02a53)),
		       BIL_PAIR (BIL_VAL (0x2c8bcee5), BIL_VAL (0x50c43d01)),
		       BIL_PAIR (BIL_VAL (0x53214d25), BIL_VAL (0xffbefa1a)),
		       BIL_PAIR (BIL_VAL (0x895aae1e), BIL_VAL (0xadb76207)),
		       BIL_PAIR (BIL_VAL (0xfc64aac9), BIL_VAL (0xb4e1e81c)),
		       BIL_PAIR (BIL_VAL (0x5ea03038), BIL_VAL (0x81170563)),
		       BIL_PAIR (BIL_VAL (0xeab79988), BIL_VAL (0x05f0da63)),
		       BIL_PAIR (BIL_VAL (0x7d614f38), BIL_VAL (0x83bc098c)),
		       BIL_PAIR (BIL_VAL (0x52063782), BIL_VAL (0x61264494)),
		       BIL_PAIR (BIL_VAL (0x0afc7236), BIL_VAL (0x88e9d2c8)),
		       BIL_PAIR (BIL_VAL (0x32174a13), BIL_VAL (0x00da1e96)),
		       BIL_PAIR (BIL_VAL (0xd4ccb5f2), BIL_VAL (0x97194a26)),
		       BIL_PAIR (BIL_VAL (0x65766540), BIL_VAL (0xfe45700d))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x97315cd9), BIL_VAL (0xd8dfa795)),
		       BIL_PAIR (BIL_VAL (0x84514014), BIL_VAL (0x4163e663)),
		       BIL_PAIR (BIL_VAL (0x50412afc), BIL_VAL (0x0e0fb34f)),
		       BIL_PAIR (BIL_VAL (0x93faf6ec), BIL_VAL (0x899eaf24)),
		       BIL_PAIR (BIL_VAL (0x48c18d6e), BIL_VAL (0x38455e4b)),
		       BIL_PAIR (BIL_VAL (0xf43fb722), BIL_VAL (0x7383fd8c)),
		       BIL_PAIR (BIL_VAL (0x136432b1), BIL_VAL (0x67a6164b)),
		       BIL_PAIR (BIL_VAL (0x69484be1), BIL_VAL (0xe7460fbe)),
		       BIL_PAIR (BIL_VAL (0x66f7ae23), BIL_VAL (0xe3d7f4e6)),
		       BIL_PAIR (BIL_VAL (0xe52dd8e1), BIL_VAL (0x44935bda)),
		       BIL_PAIR (BIL_VAL (0xbeabb2e1), BIL_VAL (0xe6dbe8f4)),
		       BIL_PAIR (BIL_VAL (0x10c605e2), BIL_VAL (0xb07d70a6)),
		       BIL_PAIR (BIL_VAL (0x0954b160), BIL_VAL (0xc0a9bae8)),
		       BIL_PAIR (BIL_VAL (0x0718077a), BIL_VAL (0x2e1c5d82)),
		       BIL_PAIR (BIL_VAL (0xecd6dcef), BIL_VAL (0x70d0afd0))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x77366ed3), BIL_VAL (0x7e65e399)),
		       BIL_PAIR (BIL_VAL (0xec024bed), BIL_VAL (0xa51c7308)),
		       BIL_PAIR (BIL_VAL (0x9463c691), BIL_VAL (0xbc6e47c5)),
		       BIL_PAIR (BIL_VAL (0x63eaf238), BIL_VAL (0xd41f02cf)),
		       BIL_PAIR (BIL_VAL (0x92bd2286), BIL_VAL (0x08fbc01f)),
		       BIL_PAIR (BIL_VAL (0x25071f78), BIL_VAL (0x300b8383)),
		       BIL_PAIR (BIL_VAL (0xb278290a), BIL_VAL (0xfccbb4a9)),
		       BIL_PAIR (BIL_VAL (0x5978c187), BIL_VAL (0xc8090e6e)),
		       BIL_PAIR (BIL_VAL (0x1b82af61), BIL_VAL (0x24f8ddff)),
		       BIL_PAIR (BIL_VAL (0x12d6ac40), BIL_VAL (0x66910f8e)),
		       BIL_PAIR (BIL_VAL (0x7f3fb5d2), BIL_VAL (0xb3b84d5a)),
		       BIL_PAIR (BIL_VAL (0xcf65d529), BIL_VAL (0x1b109858)),
		       BIL_PAIR (BIL_VAL (0x4e44d682), BIL_VAL (0x34b71b84)),
		       BIL_PAIR (BIL_VAL (0x40c882c2), BIL_VAL (0x6c38bd67)),
		       BIL_PAIR (BIL_VAL (0xc48ec560), BIL_VAL (0x0be25c01))
		       /* And implicit 2304 0 bits.  */)),
  /* 2560 */
  BIL_SET7 (BIL_SET3 (BIL_PAIR (BIL_VAL (0x1194aa9), BIL_VAL (0x804143e1)),
		      BIL_PAIR (BIL_VAL (0x4cbbfda1), BIL_VAL (0x3244d014)),
		      BIL_PAIR (BIL_VAL (0x0d5df073), BIL_VAL (0x514fed42))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x9824da71), BIL_VAL (0x0c4b2c1a)),
		       BIL_PAIR (BIL_VAL (0xa0747805), BIL_VAL (0x2eebe177)),
		       BIL_PAIR (BIL_VAL (0x8f97026c), BIL_VAL (0xc079502b)),
		       BIL_PAIR (BIL_VAL (0xc21c83ce), BIL_VAL (0x6efba8c2)),
		       BIL_PAIR (BIL_VAL (0xcd14ab73), BIL_VAL (0x39f02dd6)),
		       BIL_PAIR (BIL_VAL (0xf9bb529b), BIL_VAL (0xe53dbde4)),
		       BIL_PAIR (BIL_VAL (0x478dbba0), BIL_VAL (0x6622410f)),
		       BIL_PAIR (BIL_VAL (0x49e9fe94), BIL_VAL (0x8017b8a1)),
		       BIL_PAIR (BIL_VAL (0xdb198464), BIL_VAL (0xba9c248c)),
		       BIL_PAIR (BIL_VAL (0x3561bd27), BIL_VAL (0xb4b00664)),
		       BIL_PAIR (BIL_VAL (0xd2f864a6), BIL_VAL (0x9d48140d)),
		       BIL_PAIR (BIL_VAL (0xd64f679d), BIL_VAL (0x5350f943)),
		       BIL_PAIR (BIL_VAL (0xdbdb6eb7), BIL_VAL (0x0788a27a)),
		       BIL_PAIR (BIL_VAL (0x3cd45fea), BIL_VAL (0xb809ce3c)),
		       BIL_PAIR (BIL_VAL (0x7d548eac), BIL_VAL (0x013857ab))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x445c1e34), BIL_VAL (0xdb0481fd)),
		       BIL_PAIR (BIL_VAL (0x6c66f379), BIL_VAL (0xd9274811)),
		       BIL_PAIR (BIL_VAL (0x8e626c67), BIL_VAL (0x57fdc73a)),
		       BIL_PAIR (BIL_VAL (0xc220efb9), BIL_VAL (0xa62d0c22)),
		       BIL_PAIR (BIL_VAL (0xe83c46e5), BIL_VAL (0x1091c0a2)),
		       BIL_PAIR (BIL_VAL (0x86b93ed5), BIL_VAL (0x552a599a)),
		       BIL_PAIR (BIL_VAL (0xef3ddb40), BIL_VAL (0xc7245537)),
		       BIL_PAIR (BIL_VAL (0x9d1639c1), BIL_VAL (0x6b25c2b7)),
		       BIL_PAIR (BIL_VAL (0xeb342eed), BIL_VAL (0x1b0071c9)),
		       BIL_PAIR (BIL_VAL (0x855cc822), BIL_VAL (0xfef1ae46)),
		       BIL_PAIR (BIL_VAL (0xd50dccce), BIL_VAL (0x57eb588d)),
		       BIL_PAIR (BIL_VAL (0xd5f5a822), BIL_VAL (0xb21e0c8f)),
		       BIL_PAIR (BIL_VAL (0xaf8f57ef), BIL_VAL (0xa8feb1b5)),
		       BIL_PAIR (BIL_VAL (0xc96f9043), BIL_VAL (0x3433c4f3)),
		       BIL_PAIR (BIL_VAL (0x53c3bc12), BIL_VAL (0x207ba5a5))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xadd6c8e9), BIL_VAL (0xfb2d3c87)),
		       BIL_PAIR (BIL_VAL (0xe0be7f40), BIL_VAL (0x74871b0f)),
		       BIL_PAIR (BIL_VAL (0xd0c177ed), BIL_VAL (0x5812e317)),
		       BIL_PAIR (BIL_VAL (0xed5eea60), BIL_VAL (0x2ef39839)),
		       BIL_PAIR (BIL_VAL (0xa09dc0ad), BIL_VAL (0xd9ef6b42)),
		       BIL_PAIR (BIL_VAL (0x716dfce6), BIL_VAL (0xe40bc1d9)),
		       BIL_PAIR (BIL_VAL (0x965b4a2a), BIL_VAL (0xfe7c13b6)),
		       BIL_PAIR (BIL_VAL (0x4e07ac17), BIL_VAL (0x3eb2c323)),
		       BIL_PAIR (BIL_VAL (0x814f27e2), BIL_VAL (0xb850e477)),
		       BIL_PAIR (BIL_VAL (0x5f0329c4), BIL_VAL (0x8494e2b6)),
		       BIL_PAIR (BIL_VAL (0xd78d3921), BIL_VAL (0xdf842580)),
		       BIL_PAIR (BIL_VAL (0xee91638d), BIL_VAL (0x7bd756f4)),
		       BIL_PAIR (BIL_VAL (0xca800d31), BIL_VAL (0x360af188)),
		       BIL_PAIR (BIL_VAL (0xcfbe9b6e), BIL_VAL (0xfb256a72)),
		       BIL_PAIR (BIL_VAL (0x5449eaa6), BIL_VAL (0xccdb51ad))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x9eac6efb), BIL_VAL (0x0b18b34f)),
		       BIL_PAIR (BIL_VAL (0xa8d7f2fe), BIL_VAL (0x1efdaa39)),
		       BIL_PAIR (BIL_VAL (0x74c1eb49), BIL_VAL (0xf842ceab)),
		       BIL_PAIR (BIL_VAL (0x7e75e95c), BIL_VAL (0xc639b5fb)),
		       BIL_PAIR (BIL_VAL (0xa0d9d371), BIL_VAL (0x59695126)),
		       BIL_PAIR (BIL_VAL (0x2ee7bd62), BIL_VAL (0xf615c3e7)),
		       BIL_PAIR (BIL_VAL (0x1b14640e), BIL_VAL (0x3a120eec)),
		       BIL_PAIR (BIL_VAL (0x671e8068), BIL_VAL (0x44de867a)),
		       BIL_PAIR (BIL_VAL (0x056f25ef), BIL_VAL (0xb6c8d686)),
		       BIL_PAIR (BIL_VAL (0xdee0e58c), BIL_VAL (0x0916def7)),
		       BIL_PAIR (BIL_VAL (0x83d0391c), BIL_VAL (0x21a328b9)),
		       BIL_PAIR (BIL_VAL (0x610451f1), BIL_VAL (0x177a9ad4)),
		       BIL_PAIR (BIL_VAL (0xf5b156e6), BIL_VAL (0x98797568)),
		       BIL_PAIR (BIL_VAL (0x5bd56f76), BIL_VAL (0xb3d9c773)),
		       BIL_PAIR (BIL_VAL (0x6062b4f0), BIL_VAL (0x579321eb))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x1c72d201), BIL_VAL (0x486e8b15)),
		       BIL_PAIR (BIL_VAL (0xeb29c744), BIL_VAL (0xa512a978)),
		       BIL_PAIR (BIL_VAL (0x78e27f38), BIL_VAL (0xd6e767e7)),
		       BIL_PAIR (BIL_VAL (0x7428b3e5), BIL_VAL (0xeb0b552c)),
		       BIL_PAIR (BIL_VAL (0x3814dcf3), BIL_VAL (0x77427e29)),
		       BIL_PAIR (BIL_VAL (0x6db0cbe7), BIL_VAL (0xe0430821)),
		       BIL_PAIR (BIL_VAL (0x5112ed63), BIL_VAL (0xadc7aa37)),
		       BIL_PAIR (BIL_VAL (0xf37888ae), BIL_VAL (0xe8dfdfd8)),
		       BIL_PAIR (BIL_VAL (0x7bc7b69e), BIL_VAL (0x6a5daf9f)),
		       BIL_PAIR (BIL_VAL (0xa5946d37), BIL_VAL (0xad9a0cf9)),
		       BIL_PAIR (BIL_VAL (0x7e3c3eab), BIL_VAL (0x372eeb4c)),
		       BIL_PAIR (BIL_VAL (0x633abdf2), BIL_VAL (0x3faa18f3)),
		       BIL_PAIR (BIL_VAL (0xa8b5ae00), BIL_VAL (0x807e3e35)),
		       BIL_PAIR (BIL_VAL (0x43e69e9d), BIL_VAL (0x45f5bcac)),
		       BIL_PAIR (BIL_VAL (0xc634f09e), BIL_VAL (0x53b502ed))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x750db8e3), BIL_VAL (0xe4b5028d)),
		       BIL_PAIR (BIL_VAL (0x96fe55bf), BIL_VAL (0x195d39aa)),
		       BIL_PAIR (BIL_VAL (0x9eb366a3), BIL_VAL (0x62104aad)),
		       BIL_PAIR (BIL_VAL (0xe5fac609), BIL_VAL (0x3550f1bd)),
		       BIL_PAIR (BIL_VAL (0x3d5b5882), BIL_VAL (0x6eb67749)),
		       BIL_PAIR (BIL_VAL (0x31996732), BIL_VAL (0x56ded7d7)),
		       BIL_PAIR (BIL_VAL (0xf40cce4b), BIL_VAL (0xdd1b6017)),
		       BIL_PAIR (BIL_VAL (0x306cd21a), BIL_VAL (0x11526091)),
		       BIL_PAIR (BIL_VAL (0x54494373), BIL_VAL (0xe3f5d106)),
		       BIL_PAIR (BIL_VAL (0x977550c9), BIL_VAL (0x716fcc3e)),
		       BIL_PAIR (BIL_VAL (0xa4a76759), BIL_VAL (0xaef1808f)),
		       BIL_PAIR (BIL_VAL (0x5024906a), BIL_VAL (0x2e42f235)),
		       BIL_PAIR (BIL_VAL (0x0a6acb0e), BIL_VAL (0xafb72192)),
		       BIL_PAIR (BIL_VAL (0xd1b926b8), BIL_VAL (0x63ed4a2a)),
		       BIL_PAIR (BIL_VAL (0x95480fc9), BIL_VAL (0xd0a0d801))
		       /* And implicit 2560 0 bits.  */)),
  /* 2816 */
  BIL_SET7 (BIL_SET13 (BIL_VAL (0x5da),
		       BIL_PAIR (BIL_VAL (0xb854d4de), BIL_VAL (0xcbbe6264)),
		       BIL_PAIR (BIL_VAL (0x043a9dd9), BIL_VAL (0x17f7c37e)),
		       BIL_PAIR (BIL_VAL (0x2c0166f0), BIL_VAL (0x59939087)),
		       BIL_PAIR (BIL_VAL (0x4c050e06), BIL_VAL (0x67ec1921)),
		       BIL_PAIR (BIL_VAL (0x518f4971), BIL_VAL (0xc4b18c3a)),
		       BIL_PAIR (BIL_VAL (0x4f89346d), BIL_VAL (0x38653182)),
		       BIL_PAIR (BIL_VAL (0x314c173c), BIL_VAL (0xdfb1e687)),
		       BIL_PAIR (BIL_VAL (0x80767379), BIL_VAL (0x1ee83794)),
		       BIL_PAIR (BIL_VAL (0x7dcac2fa), BIL_VAL (0xc979fb9f)),
		       BIL_PAIR (BIL_VAL (0xce5764bc), BIL_VAL (0x9b8189bc)),
		       BIL_PAIR (BIL_VAL (0x768bb7bf), BIL_VAL (0xc9db1f22)),
		       BIL_PAIR (BIL_VAL (0xd8d3ef7f), BIL_VAL (0x794bf244))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x9e928b63), BIL_VAL (0x1232548f)),
		       BIL_PAIR (BIL_VAL (0xe1ae14be), BIL_VAL (0xd59106e2)),
		       BIL_PAIR (BIL_VAL (0x7f6ef220), BIL_VAL (0xd5472457)),
		       BIL_PAIR (BIL_VAL (0x4d85f8d4), BIL_VAL (0xd77eb94c)),
		       BIL_PAIR (BIL_VAL (0x010e3314), BIL_VAL (0x0f2edff4)),
		       BIL_PAIR (BIL_VAL (0xa00a849d), BIL_VAL (0xeab2f2ef)),
		       BIL_PAIR (BIL_VAL (0xf0ed3ebe), BIL_VAL (0x53d9ae49)),
		       BIL_PAIR (BIL_VAL (0xbead7189), BIL_VAL (0xfd40690c)),
		       BIL_PAIR (BIL_VAL (0x126878c5), BIL_VAL (0xe57813bc)),
		       BIL_PAIR (BIL_VAL (0x8a81bb33), BIL_VAL (0x31654271)),
		       BIL_PAIR (BIL_VAL (0xc6bab6c5), BIL_VAL (0x0a9af342)),
		       BIL_PAIR (BIL_VAL (0x75017575), BIL_VAL (0x1da01d1a)),
		       BIL_PAIR (BIL_VAL (0xeb13e3ab), BIL_VAL (0x9b5ef740)),
		       BIL_PAIR (BIL_VAL (0x7d8bb4a8), BIL_VAL (0x36f49f66)),
		       BIL_PAIR (BIL_VAL (0xe5d4d344), BIL_VAL (0xdfd4e608))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xad807df4), BIL_VAL (0x12fa4067)),
		       BIL_PAIR (BIL_VAL (0xacf0adf0), BIL_VAL (0x00a3210b)),
		       BIL_PAIR (BIL_VAL (0xd83970e5), BIL_VAL (0x3a8cba67)),
		       BIL_PAIR (BIL_VAL (0x3f19d409), BIL_VAL (0xfda8f179)),
		       BIL_PAIR (BIL_VAL (0x379b0d11), BIL_VAL (0xa4c6dc56)),
		       BIL_PAIR (BIL_VAL (0xe5417a4d), BIL_VAL (0xf8cf0081)),
		       BIL_PAIR (BIL_VAL (0x5ad562eb), BIL_VAL (0xbf436366)),
		       BIL_PAIR (BIL_VAL (0x4f78b44b), BIL_VAL (0xb3a2d324)),
		       BIL_PAIR (BIL_VAL (0x91ad7f18), BIL_VAL (0x5dbb2905)),
		       BIL_PAIR (BIL_VAL (0x176b1a02), BIL_VAL (0xfc1e125c)),
		       BIL_PAIR (BIL_VAL (0xbe970551), BIL_VAL (0xba210b83)),
		       BIL_PAIR (BIL_VAL (0x43754408), BIL_VAL (0x799499f4)),
		       BIL_PAIR (BIL_VAL (0x741c41fd), BIL_VAL (0x0c82a712)),
		       BIL_PAIR (BIL_VAL (0x1f7a5b55), BIL_VAL (0xcf75a9dd)),
		       BIL_PAIR (BIL_VAL (0xda83ac65), BIL_VAL (0x42715d75))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xe015c646), BIL_VAL (0x36b0b522)),
		       BIL_PAIR (BIL_VAL (0x6b5f1226), BIL_VAL (0x4cbcd72b)),
		       BIL_PAIR (BIL_VAL (0x7a047fd0), BIL_VAL (0x87c18cfc)),
		       BIL_PAIR (BIL_VAL (0xca2166fa), BIL_VAL (0x26dec6a3)),
		       BIL_PAIR (BIL_VAL (0x0e182d63), BIL_VAL (0xab489d72)),
		       BIL_PAIR (BIL_VAL (0x41ca5ec0), BIL_VAL (0xdd53460a)),
		       BIL_PAIR (BIL_VAL (0x15df6c4d), BIL_VAL (0x74f25191)),
		       BIL_PAIR (BIL_VAL (0x767c69fa), BIL_VAL (0x169ea304)),
		       BIL_PAIR (BIL_VAL (0xff80f859), BIL_VAL (0x4a18418b)),
		       BIL_PAIR (BIL_VAL (0x3465a393), BIL_VAL (0x3abebe23)),
		       BIL_PAIR (BIL_VAL (0x317b6aa3), BIL_VAL (0x8aa4523b)),
		       BIL_PAIR (BIL_VAL (0xd979261c), BIL_VAL (0xc51cae26)),
		       BIL_PAIR (BIL_VAL (0xb6a2e5f1), BIL_VAL (0xfa3b1e69)),
		       BIL_PAIR (BIL_VAL (0x2057c3f3), BIL_VAL (0x9d20b280)),
		       BIL_PAIR (BIL_VAL (0x560c6a44), BIL_VAL (0x374fa32e))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x6e73e83c), BIL_VAL (0x98b2f696)),
		       BIL_PAIR (BIL_VAL (0xe322b6d8), BIL_VAL (0xd5e2b4a3)),
		       BIL_PAIR (BIL_VAL (0xb4be68b3), BIL_VAL (0x4dbbb2fc)),
		       BIL_PAIR (BIL_VAL (0x9ec62319), BIL_VAL (0x5da34db5)),
		       BIL_PAIR (BIL_VAL (0x3e3d8033), BIL_VAL (0xcde168ce)),
		       BIL_PAIR (BIL_VAL (0xdd9f57c3), BIL_VAL (0x51a5880d)),
		       BIL_PAIR (BIL_VAL (0xe6c67b64), BIL_VAL (0xf0c4f700)),
		       BIL_PAIR (BIL_VAL (0xa381a39d), BIL_VAL (0x2f3b9d83)),
		       BIL_PAIR (BIL_VAL (0x7d2c33cf), BIL_VAL (0xe48493c6)),
		       BIL_PAIR (BIL_VAL (0x93abd390), BIL_VAL (0x24c61457)),
		       BIL_PAIR (BIL_VAL (0xe7047cfe), BIL_VAL (0x95aca52b)),
		       BIL_PAIR (BIL_VAL (0xbbd8c16c), BIL_VAL (0xdaaf5256)),
		       BIL_PAIR (BIL_VAL (0x43126da5), BIL_VAL (0x2b5f0964)),
		       BIL_PAIR (BIL_VAL (0xb3114e82), BIL_VAL (0xe648a02d)),
		       BIL_PAIR (BIL_VAL (0x0184ee43), BIL_VAL (0xf753e8cb))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xf8c658b0), BIL_VAL (0x17ee8f03)),
		       BIL_PAIR (BIL_VAL (0xfcc49c84), BIL_VAL (0x34a67665)),
		       BIL_PAIR (BIL_VAL (0x96a2d53f), BIL_VAL (0xb4ec6fbe)),
		       BIL_PAIR (BIL_VAL (0x7bf15c9d), BIL_VAL (0x9d6cf77e)),
		       BIL_PAIR (BIL_VAL (0xdf74251c), BIL_VAL (0x2005a36c)),
		       BIL_PAIR (BIL_VAL (0x3e0acde4), BIL_VAL (0xb6d2a0b1)),
		       BIL_PAIR (BIL_VAL (0x20a8b77c), BIL_VAL (0x3d6057e9)),
		       BIL_PAIR (BIL_VAL (0xbc2cacdb), BIL_VAL (0xc5128afb)),
		       BIL_PAIR (BIL_VAL (0x5f50e041), BIL_VAL (0x575822e7)),
		       BIL_PAIR (BIL_VAL (0x041b948c), BIL_VAL (0x7ba033b5)),
		       BIL_PAIR (BIL_VAL (0x9fc59600), BIL_VAL (0xe3745598)),
		       BIL_PAIR (BIL_VAL (0x9c26f352), BIL_VAL (0x7cac8f8a)),
		       BIL_PAIR (BIL_VAL (0xabf7e327), BIL_VAL (0x194d1051)),
		       BIL_PAIR (BIL_VAL (0xbe604839), BIL_VAL (0x67a3ea6a)),
		       BIL_PAIR (BIL_VAL (0xbcbf1540), BIL_VAL (0x6dd1714c))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x468f0c14), BIL_VAL (0x0229c878)),
		       BIL_PAIR (BIL_VAL (0x9bb75819), BIL_VAL (0x95573482)),
		       BIL_PAIR (BIL_VAL (0x3cf4b053), BIL_VAL (0x70c3dafc)),
		       BIL_PAIR (BIL_VAL (0x444949b7), BIL_VAL (0x562cd40e)),
		       BIL_PAIR (BIL_VAL (0xc323ff21), BIL_VAL (0xf63eacaa)),
		       BIL_PAIR (BIL_VAL (0x2b634690), BIL_VAL (0x8b32bdf0)),
		       BIL_PAIR (BIL_VAL (0x0120f2eb), BIL_VAL (0x8181d13f)),
		       BIL_PAIR (BIL_VAL (0xcf3372fc), BIL_VAL (0x0a46c705)),
		       BIL_PAIR (BIL_VAL (0x0acb5048), BIL_VAL (0x8981f7d4)),
		       BIL_PAIR (BIL_VAL (0x7a5ceaf4), BIL_VAL (0x463813b3)),
		       BIL_PAIR (BIL_VAL (0xd13d1aa4), BIL_VAL (0x84acd60a)),
		       BIL_PAIR (BIL_VAL (0x81f0266c), BIL_VAL (0x08329c17)),
		       BIL_PAIR (BIL_VAL (0x6f6a2168), BIL_VAL (0x05f05640)),
		       BIL_PAIR (BIL_VAL (0x90d9ae56), BIL_VAL (0x8be4b4e2)),
		       BIL_PAIR (BIL_VAL (0xe8f91d5a), BIL_VAL (0x216f5401))
		       /* And implicit 2816 0 bits.  */)),
  /* 3072 */
  BIL_SET8 (BIL_SET7 (BIL_VAL (0x1f312ba4),
		      BIL_PAIR (BIL_VAL (0xbb116b51), BIL_VAL (0x5fba1189)),
		      BIL_PAIR (BIL_VAL (0xb426cabd), BIL_VAL (0x9e059216)),
		      BIL_PAIR (BIL_VAL (0xf096844f), BIL_VAL (0x4f926c3c)),
		      BIL_PAIR (BIL_VAL (0x1f56da12), BIL_VAL (0x2f36ce13)),
		      BIL_PAIR (BIL_VAL (0x9dd1636c), BIL_VAL (0x6436e398)),
		      BIL_PAIR (BIL_VAL (0x67abac89), BIL_VAL (0x0a2a19bb))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x9e01912b), BIL_VAL (0x5d56ee31)),
		       BIL_PAIR (BIL_VAL (0xb52d3aae), BIL_VAL (0x0b1d8563)),
		       BIL_PAIR (BIL_VAL (0xd7ef29c1), BIL_VAL (0xc2366cc0)),
		       BIL_PAIR (BIL_VAL (0x92adeb68), BIL_VAL (0x010c2c35)),
		       BIL_PAIR (BIL_VAL (0x00d52904), BIL_VAL (0x98e07735)),
		       BIL_PAIR (BIL_VAL (0x92817c18), BIL_VAL (0x0c000279)),
		       BIL_PAIR (BIL_VAL (0x6563f3aa), BIL_VAL (0xf8f271f1)),
		       BIL_PAIR (BIL_VAL (0x7168525d), BIL_VAL (0x1aad1c88)),
		       BIL_PAIR (BIL_VAL (0x88b72aaf), BIL_VAL (0x57962181)),
		       BIL_PAIR (BIL_VAL (0x408f4325), BIL_VAL (0xa740aa11)),
		       BIL_PAIR (BIL_VAL (0x6afcaad3), BIL_VAL (0x4fc5ef91)),
		       BIL_PAIR (BIL_VAL (0xf5978daa), BIL_VAL (0x10458c1a)),
		       BIL_PAIR (BIL_VAL (0x5832678b), BIL_VAL (0xc5d04c93)),
		       BIL_PAIR (BIL_VAL (0x9e0679bc), BIL_VAL (0x0628c43d)),
		       BIL_PAIR (BIL_VAL (0x1bbe426a), BIL_VAL (0xce9de2de))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x81bf6792), BIL_VAL (0xbaee096e)),
		       BIL_PAIR (BIL_VAL (0x8b553892), BIL_VAL (0x9823ff64)),
		       BIL_PAIR (BIL_VAL (0x72b7d504), BIL_VAL (0x07285866)),
		       BIL_PAIR (BIL_VAL (0x2e37161d), BIL_VAL (0x5422ba12)),
		       BIL_PAIR (BIL_VAL (0xb561c10a), BIL_VAL (0xff8862fb)),
		       BIL_PAIR (BIL_VAL (0x70b76956), BIL_VAL (0x89b420bc)),
		       BIL_PAIR (BIL_VAL (0xc339f567), BIL_VAL (0x97d13e81)),
		       BIL_PAIR (BIL_VAL (0x27557c46), BIL_VAL (0x3caf5417)),
		       BIL_PAIR (BIL_VAL (0xc8a5a023), BIL_VAL (0x27478270)),
		       BIL_PAIR (BIL_VAL (0x2851e273), BIL_VAL (0xb9d6e30f)),
		       BIL_PAIR (BIL_VAL (0x05e84e72), BIL_VAL (0x2d40ccfe)),
		       BIL_PAIR (BIL_VAL (0x64820950), BIL_VAL (0xb96c6879)),
		       BIL_PAIR (BIL_VAL (0xb87d7d8c), BIL_VAL (0xa145b5cf)),
		       BIL_PAIR (BIL_VAL (0xe7d5aa33), BIL_VAL (0x574f7ea8)),
		       BIL_PAIR (BIL_VAL (0x487d7162), BIL_VAL (0xd0b1ba17))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xc39ff4a3), BIL_VAL (0x329a39c9)),
		       BIL_PAIR (BIL_VAL (0x61482438), BIL_VAL (0x97e3c7f1)),
		       BIL_PAIR (BIL_VAL (0x952da6fc), BIL_VAL (0x1c850cd3)),
		       BIL_PAIR (BIL_VAL (0xcb7f03e8), BIL_VAL (0x07ac6772)),
		       BIL_PAIR (BIL_VAL (0xcf44893e), BIL_VAL (0xfdcedbdc)),
		       BIL_PAIR (BIL_VAL (0x9e5f4e48), BIL_VAL (0x1417a90d)),
		       BIL_PAIR (BIL_VAL (0x28e7dbda), BIL_VAL (0x837e9183)),
		       BIL_PAIR (BIL_VAL (0x20566be2), BIL_VAL (0x096add15)),
		       BIL_PAIR (BIL_VAL (0x28940e90), BIL_VAL (0xbfb2a20d)),
		       BIL_PAIR (BIL_VAL (0x38744abc), BIL_VAL (0x03ba8cec)),
		       BIL_PAIR (BIL_VAL (0x23b36972), BIL_VAL (0x621e470d)),
		       BIL_PAIR (BIL_VAL (0xe71a3155), BIL_VAL (0xb7d1c2d4)),
		       BIL_PAIR (BIL_VAL (0x22b31cdd), BIL_VAL (0x9484f44a)),
		       BIL_PAIR (BIL_VAL (0x5b8371e4), BIL_VAL (0x28ea4199)),
		       BIL_PAIR (BIL_VAL (0x4310de34), BIL_VAL (0x97681712))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xf5b3ee5e), BIL_VAL (0x9388c6b2)),
		       BIL_PAIR (BIL_VAL (0xc3dcb52e), BIL_VAL (0x4b74bbbf)),
		       BIL_PAIR (BIL_VAL (0xfc09aac5), BIL_VAL (0xcfd58e83)),
		       BIL_PAIR (BIL_VAL (0x561f9695), BIL_VAL (0x0910f9bb)),
		       BIL_PAIR (BIL_VAL (0xdfd5456f), BIL_VAL (0x83e1c48d)),
		       BIL_PAIR (BIL_VAL (0x43071fcd), BIL_VAL (0x1a324f0a)),
		       BIL_PAIR (BIL_VAL (0x8b4598fc), BIL_VAL (0x53873290)),
		       BIL_PAIR (BIL_VAL (0x4214228a), BIL_VAL (0xee881bb2)),
		       BIL_PAIR (BIL_VAL (0xf00599d8), BIL_VAL (0x52ebefe7)),
		       BIL_PAIR (BIL_VAL (0x7f6a8479), BIL_VAL (0x453c762d)),
		       BIL_PAIR (BIL_VAL (0xb41cdad0), BIL_VAL (0x35aa7127)),
		       BIL_PAIR (BIL_VAL (0xa514845f), BIL_VAL (0xb7a64acf)),
		       BIL_PAIR (BIL_VAL (0xa6d09338), BIL_VAL (0x9fe1abd8)),
		       BIL_PAIR (BIL_VAL (0x42135bb1), BIL_VAL (0xc4da1365)),
		       BIL_PAIR (BIL_VAL (0x45326c4d), BIL_VAL (0x60aa51b8))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x469784a7), BIL_VAL (0xdd3272fc)),
		       BIL_PAIR (BIL_VAL (0x0d44d00f), BIL_VAL (0x65dd4ac5)),
		       BIL_PAIR (BIL_VAL (0xd208e0ee), BIL_VAL (0x8c7dd4f8)),
		       BIL_PAIR (BIL_VAL (0xe4a077b8), BIL_VAL (0x6a43c685)),
		       BIL_PAIR (BIL_VAL (0xc03073a1), BIL_VAL (0x1518e68b)),
		       BIL_PAIR (BIL_VAL (0x6c90b34f), BIL_VAL (0xdc64b813)),
		       BIL_PAIR (BIL_VAL (0x0ff96316), BIL_VAL (0x13a3411d)),
		       BIL_PAIR (BIL_VAL (0xe325697c), BIL_VAL (0x6b424bdf)),
		       BIL_PAIR (BIL_VAL (0xa4847791), BIL_VAL (0xcf490814)),
		       BIL_PAIR (BIL_VAL (0x1b7ec5e8), BIL_VAL (0x3a635a00)),
		       BIL_PAIR (BIL_VAL (0xf38ff405), BIL_VAL (0xc2b874c8)),
		       BIL_PAIR (BIL_VAL (0x919a9dfc), BIL_VAL (0xfd8418f3)),
		       BIL_PAIR (BIL_VAL (0x962779b5), BIL_VAL (0x94a321e7)),
		       BIL_PAIR (BIL_VAL (0xf5291578), BIL_VAL (0x8383464a)),
		       BIL_PAIR (BIL_VAL (0x72250678), BIL_VAL (0xef94eb6b))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xd27e67d0), BIL_VAL (0x93308672)),
		       BIL_PAIR (BIL_VAL (0x240c4c90), BIL_VAL (0x0d81df3f)),
		       BIL_PAIR (BIL_VAL (0x5309e565), BIL_VAL (0xed2f0e51)),
		       BIL_PAIR (BIL_VAL (0xa58752f6), BIL_VAL (0xa897ab50)),
		       BIL_PAIR (BIL_VAL (0x7f75b586), BIL_VAL (0x9eaf72cd)),
		       BIL_PAIR (BIL_VAL (0x2d55f72a), BIL_VAL (0xc6faa92d)),
		       BIL_PAIR (BIL_VAL (0x0cb939c4), BIL_VAL (0xbdfef796)),
		       BIL_PAIR (BIL_VAL (0x1bf153e1), BIL_VAL (0x5e72aa64)),
		       BIL_PAIR (BIL_VAL (0xf84433f3), BIL_VAL (0x5927e3d7)),
		       BIL_PAIR (BIL_VAL (0xe0dbc043), BIL_VAL (0x7dfa41b5)),
		       BIL_PAIR (BIL_VAL (0x7627cfe5), BIL_VAL (0x33600e48)),
		       BIL_PAIR (BIL_VAL (0x3bc1d86c), BIL_VAL (0x0c28a686)),
		       BIL_PAIR (BIL_VAL (0x8a0c1e60), BIL_VAL (0x34084ef5)),
		       BIL_PAIR (BIL_VAL (0xb08ee59b), BIL_VAL (0xa1dbc468)),
		       BIL_PAIR (BIL_VAL (0x4301a047), BIL_VAL (0xe26265f8))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x06b8a3e5), BIL_VAL (0xf1c01547)),
		       BIL_PAIR (BIL_VAL (0xf5f98c22), BIL_VAL (0xcbdc536a)),
		       BIL_PAIR (BIL_VAL (0x8e7c4e64), BIL_VAL (0xb0ae5e1e)),
		       BIL_PAIR (BIL_VAL (0x063c1dbf), BIL_VAL (0x2bb0b405)),
		       BIL_PAIR (BIL_VAL (0x9440357b), BIL_VAL (0xac3aac5d)),
		       BIL_PAIR (BIL_VAL (0x301f0c1e), BIL_VAL (0x7b43e24d)),
		       BIL_PAIR (BIL_VAL (0x47719d3e), BIL_VAL (0x9813356f)),
		       BIL_PAIR (BIL_VAL (0xcc6d5186), BIL_VAL (0xbdc746bf)),
		       BIL_PAIR (BIL_VAL (0xab4304f8), BIL_VAL (0xf0bf77a5)),
		       BIL_PAIR (BIL_VAL (0x9e264e4f), BIL_VAL (0x3fdfaf6c)),
		       BIL_PAIR (BIL_VAL (0x62519d84), BIL_VAL (0xee8c8543)),
		       BIL_PAIR (BIL_VAL (0xa7c3df1c), BIL_VAL (0x622c53e1)),
		       BIL_PAIR (BIL_VAL (0x3ff321eb), BIL_VAL (0xdca1947c)),
		       BIL_PAIR (BIL_VAL (0xfb8435e5), BIL_VAL (0xe9579124)),
		       BIL_PAIR (BIL_VAL (0xefef44c8), BIL_VAL (0xbe4dd001))
		       /* And implicit 3072 0 bits.  */)),
  /* 3328 */
  BIL_SET9 (BIL_PAIR (BIL_VAL (0xa630), BIL_VAL (0xef7d5699)),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xfe4550e3), BIL_VAL (0x66023541)),
		       BIL_PAIR (BIL_VAL (0x0f98fca8), BIL_VAL (0x1f202c5d)),
		       BIL_PAIR (BIL_VAL (0x111a0c7a), BIL_VAL (0x3cbe3d82)),
		       BIL_PAIR (BIL_VAL (0xa0426930), BIL_VAL (0x38e326f3)),
		       BIL_PAIR (BIL_VAL (0x94eeaa96), BIL_VAL (0x27d4a07c)),
		       BIL_PAIR (BIL_VAL (0x3e08406c), BIL_VAL (0x0514f25a)),
		       BIL_PAIR (BIL_VAL (0x42c250d2), BIL_VAL (0xbfe0dc5c)),
		       BIL_PAIR (BIL_VAL (0x3215b6ee), BIL_VAL (0xe50ab59b)),
		       BIL_PAIR (BIL_VAL (0x6cd18c99), BIL_VAL (0x6111a8aa)),
		       BIL_PAIR (BIL_VAL (0x51282c56), BIL_VAL (0x157d6581)),
		       BIL_PAIR (BIL_VAL (0x6df5fc44), BIL_VAL (0x6ac5235e)),
		       BIL_PAIR (BIL_VAL (0xa6087073), BIL_VAL (0xad897a4c)),
		       BIL_PAIR (BIL_VAL (0x286e4a6c), BIL_VAL (0x215b9af0)),
		       BIL_PAIR (BIL_VAL (0x638caeaf), BIL_VAL (0xfe090246)),
		       BIL_PAIR (BIL_VAL (0x8f2036bd), BIL_VAL (0x115fc336))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xa322a575), BIL_VAL (0x80488756)),
		       BIL_PAIR (BIL_VAL (0xa6b4b9e5), BIL_VAL (0x703ecac8)),
		       BIL_PAIR (BIL_VAL (0x8656ef04), BIL_VAL (0xc8f44f49)),
		       BIL_PAIR (BIL_VAL (0xa2141c8c), BIL_VAL (0x2d660d5a)),
		       BIL_PAIR (BIL_VAL (0xbc219b1b), BIL_VAL (0x93150e0e)),
		       BIL_PAIR (BIL_VAL (0x98fc671a), BIL_VAL (0xd7a5bc7f)),
		       BIL_PAIR (BIL_VAL (0x6557e523), BIL_VAL (0xd13e1b0c)),
		       BIL_PAIR (BIL_VAL (0xf7e03658), BIL_VAL (0x50f1732a)),
		       BIL_PAIR (BIL_VAL (0x38225383), BIL_VAL (0x723458ab)),
		       BIL_PAIR (BIL_VAL (0x6211f2db), BIL_VAL (0x8fc93b09)),
		       BIL_PAIR (BIL_VAL (0x46182e91), BIL_VAL (0x14504835)),
		       BIL_PAIR (BIL_VAL (0xce033f9a), BIL_VAL (0x276ed27c)),
		       BIL_PAIR (BIL_VAL (0x89b14eef), BIL_VAL (0x690b1b93)),
		       BIL_PAIR (BIL_VAL (0x466cf053), BIL_VAL (0x01b22170)),
		       BIL_PAIR (BIL_VAL (0x2135a3bf), BIL_VAL (0xad577996))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x1ae29dfa), BIL_VAL (0x90e9c87e)),
		       BIL_PAIR (BIL_VAL (0x4640c84b), BIL_VAL (0xc18480b6)),
		       BIL_PAIR (BIL_VAL (0x1eeb3d52), BIL_VAL (0x1fd318a7)),
		       BIL_PAIR (BIL_VAL (0xe245b414), BIL_VAL (0xb244745b)),
		       BIL_PAIR (BIL_VAL (0x92285ec4), BIL_VAL (0xa978340a)),
		       BIL_PAIR (BIL_VAL (0xbb8737e2), BIL_VAL (0xffc37ccc)),
		       BIL_PAIR (BIL_VAL (0xec4ab099), BIL_VAL (0xb9bb02fa)),
		       BIL_PAIR (BIL_VAL (0x16783cf3), BIL_VAL (0x419cbf6f)),
		       BIL_PAIR (BIL_VAL (0x4061562e), BIL_VAL (0xd2d24dbe)),
		       BIL_PAIR (BIL_VAL (0x70658b57), BIL_VAL (0xdcccf004)),
		       BIL_PAIR (BIL_VAL (0x6c340613), BIL_VAL (0x73e17c39)),
		       BIL_PAIR (BIL_VAL (0xcbba8ac3), BIL_VAL (0xcfb02148)),
		       BIL_PAIR (BIL_VAL (0x2f7f3d81), BIL_VAL (0x880b12b1)),
		       BIL_PAIR (BIL_VAL (0x85a39af5), BIL_VAL (0x07ab5131)),
		       BIL_PAIR (BIL_VAL (0xb41b6a54), BIL_VAL (0x04b1fecc))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x6d277130), BIL_VAL (0xf47d3349)),
		       BIL_PAIR (BIL_VAL (0x0a3fbbf2), BIL_VAL (0xad2da23c)),
		       BIL_PAIR (BIL_VAL (0x316167a0), BIL_VAL (0x9c13aa74)),
		       BIL_PAIR (BIL_VAL (0x2f6ff9ce), BIL_VAL (0x3ad91b9a)),
		       BIL_PAIR (BIL_VAL (0x3ddbca61), BIL_VAL (0x1e1cb1e9)),
		       BIL_PAIR (BIL_VAL (0x112fe28b), BIL_VAL (0xf1fd33eb)),
		       BIL_PAIR (BIL_VAL (0x29f3c87f), BIL_VAL (0x456272a7)),
		       BIL_PAIR (BIL_VAL (0x1150d2fc), BIL_VAL (0x91df9bcd)),
		       BIL_PAIR (BIL_VAL (0xf60e0318), BIL_VAL (0xeca67829)),
		       BIL_PAIR (BIL_VAL (0xe853e733), BIL_VAL (0xfb9b7f30)),
		       BIL_PAIR (BIL_VAL (0xdcb45b7f), BIL_VAL (0xd674cba0)),
		       BIL_PAIR (BIL_VAL (0xe95704aa), BIL_VAL (0xd35afc75)),
		       BIL_PAIR (BIL_VAL (0x529a5db1), BIL_VAL (0x08694726)),
		       BIL_PAIR (BIL_VAL (0x38cda302), BIL_VAL (0xcdda33e0)),
		       BIL_PAIR (BIL_VAL (0xbf8f3f5f), BIL_VAL (0x294ff2ac))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x8ab12e9c), BIL_VAL (0x0152181a)),
		       BIL_PAIR (BIL_VAL (0x6be284b0), BIL_VAL (0xa0c15074)),
		       BIL_PAIR (BIL_VAL (0x79e4519b), BIL_VAL (0x3c681575)),
		       BIL_PAIR (BIL_VAL (0xab8cd14e), BIL_VAL (0x0e5f5a06)),
		       BIL_PAIR (BIL_VAL (0x76292c16), BIL_VAL (0x1f3d3a91)),
		       BIL_PAIR (BIL_VAL (0xab4ba9d3), BIL_VAL (0xe5abd7b7)),
		       BIL_PAIR (BIL_VAL (0x95ab0c77), BIL_VAL (0x5d7c8342)),
		       BIL_PAIR (BIL_VAL (0x946d9adb), BIL_VAL (0x0e7454d3)),
		       BIL_PAIR (BIL_VAL (0xf1d31631), BIL_VAL (0x494625f5)),
		       BIL_PAIR (BIL_VAL (0x6af35cd1), BIL_VAL (0x775eea0a)),
		       BIL_PAIR (BIL_VAL (0xbd4a7fca), BIL_VAL (0xb43c0520)),
		       BIL_PAIR (BIL_VAL (0x54f42d53), BIL_VAL (0xb4508b26)),
		       BIL_PAIR (BIL_VAL (0xe1e4d2a0), BIL_VAL (0x3e6ec89c)),
		       BIL_PAIR (BIL_VAL (0x6b6dba0e), BIL_VAL (0xc9b1f19c)),
		       BIL_PAIR (BIL_VAL (0x1f3205a8), BIL_VAL (0xfaa9b476))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xa9e8b22c), BIL_VAL (0x13a9ad27)),
		       BIL_PAIR (BIL_VAL (0xb443d552), BIL_VAL (0x6931bbdf)),
		       BIL_PAIR (BIL_VAL (0x4a181460), BIL_VAL (0x07100007)),
		       BIL_PAIR (BIL_VAL (0x11abf4ad), BIL_VAL (0xfdecbc94)),
		       BIL_PAIR (BIL_VAL (0xad50f1eb), BIL_VAL (0x540cd19b)),
		       BIL_PAIR (BIL_VAL (0x9c774a36), BIL_VAL (0xf92acda8)),
		       BIL_PAIR (BIL_VAL (0x7a926b1e), BIL_VAL (0x93e6952e)),
		       BIL_PAIR (BIL_VAL (0x5a588409), BIL_VAL (0x64088535)),
		       BIL_PAIR (BIL_VAL (0x186254f4), BIL_VAL (0xc2b2a8f6)),
		       BIL_PAIR (BIL_VAL (0x78c36403), BIL_VAL (0x6740d081)),
		       BIL_PAIR (BIL_VAL (0x89530148), BIL_VAL (0xe7aac967)),
		       BIL_PAIR (BIL_VAL (0x3e18171a), BIL_VAL (0x0b412fce)),
		       BIL_PAIR (BIL_VAL (0x269524e1), BIL_VAL (0x9a5cc05f)),
		       BIL_PAIR (BIL_VAL (0x198e7c0e), BIL_VAL (0x01e4d292)),
		       BIL_PAIR (BIL_VAL (0x82e1665b), BIL_VAL (0xbe5c4b67))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x62bab888), BIL_VAL (0xc5b534ba)),
		       BIL_PAIR (BIL_VAL (0xba4734b0), BIL_VAL (0xee033a1d)),
		       BIL_PAIR (BIL_VAL (0xae31b8d1), BIL_VAL (0xa39db170)),
		       BIL_PAIR (BIL_VAL (0x7533763c), BIL_VAL (0xec3d7fab)),
		       BIL_PAIR (BIL_VAL (0x5baea250), BIL_VAL (0x4c74a1be)),
		       BIL_PAIR (BIL_VAL (0xd9d798c1), BIL_VAL (0x82687a05)),
		       BIL_PAIR (BIL_VAL (0xf8cc1664), BIL_VAL (0x56e36839)),
		       BIL_PAIR (BIL_VAL (0xb1000a12), BIL_VAL (0x61962264)),
		       BIL_PAIR (BIL_VAL (0x4a213da6), BIL_VAL (0xfabd5910)),
		       BIL_PAIR (BIL_VAL (0x86f2b700), BIL_VAL (0xf5f88608)),
		       BIL_PAIR (BIL_VAL (0xd21a2dfc), BIL_VAL (0x1135e868)),
		       BIL_PAIR (BIL_VAL (0x47868030), BIL_VAL (0x77bb9801)),
		       BIL_PAIR (BIL_VAL (0xa460a689), BIL_VAL (0x92d7ab82)),
		       BIL_PAIR (BIL_VAL (0xc44335d6), BIL_VAL (0xeab754d6)),
		       BIL_PAIR (BIL_VAL (0x098b8975), BIL_VAL (0xa0b0789e))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x60413ccd), BIL_VAL (0x40e150bd)),
		       BIL_PAIR (BIL_VAL (0x0dd4abe1), BIL_VAL (0x2d26ef47)),
		       BIL_PAIR (BIL_VAL (0x57f2da73), BIL_VAL (0x7c815b8f)),
		       BIL_PAIR (BIL_VAL (0x194f3842), BIL_VAL (0x14d4ae36)),
		       BIL_PAIR (BIL_VAL (0x41fc090c), BIL_VAL (0x9ad07ef0)),
		       BIL_PAIR (BIL_VAL (0x6690e793), BIL_VAL (0x28c92841)),
		       BIL_PAIR (BIL_VAL (0x9ae5590b), BIL_VAL (0xa3c8fee6)),
		       BIL_PAIR (BIL_VAL (0x5397f52a), BIL_VAL (0xee62ac54)),
		       BIL_PAIR (BIL_VAL (0x0a29f17d), BIL_VAL (0xaad2e60b)),
		       BIL_PAIR (BIL_VAL (0xcf5bbfc0), BIL_VAL (0x9c0cbfe5)),
		       BIL_PAIR (BIL_VAL (0x4f54f415), BIL_VAL (0x1a55d229)),
		       BIL_PAIR (BIL_VAL (0x67b6e254), BIL_VAL (0xe21f1d45)),
		       BIL_PAIR (BIL_VAL (0xe3eb4d9b), BIL_VAL (0x370dc5a8)),
		       BIL_PAIR (BIL_VAL (0x4bfa0f55), BIL_VAL (0xb874ccde)),
		       BIL_PAIR (BIL_VAL (0x3f7d5dcd), BIL_VAL (0x673c4c01))
		       /* And implicit 3328 0 bits.  */)),
  /* 3584 */
  BIL_SET9 (BIL_SET11 (BIL_VAL (0x3),
		       BIL_PAIR (BIL_VAL (0x7577228a), BIL_VAL (0xfc9fcfde)),
		       BIL_PAIR (BIL_VAL (0x56a8463b), BIL_VAL (0x07420c5e)),
		       BIL_PAIR (BIL_VAL (0x24279092), BIL_VAL (0x844a8f34)),
		       BIL_PAIR (BIL_VAL (0x4d3299e9), BIL_VAL (0x9e6e12b8)),
		       BIL_PAIR (BIL_VAL (0xeb15af76), BIL_VAL (0x0d09dcb8)),
		       BIL_PAIR (BIL_VAL (0xd60d6604), BIL_VAL (0xd517b214)),
		       BIL_PAIR (BIL_VAL (0x286e22be), BIL_VAL (0x37f4e855)),
		       BIL_PAIR (BIL_VAL (0x8c7b5235), BIL_VAL (0xc36007bb)),
		       BIL_PAIR (BIL_VAL (0xeefd9149), BIL_VAL (0xc624c6e7)),
		       BIL_PAIR (BIL_VAL (0xbb42659d), BIL_VAL (0xf2325f0f))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x15fd926b), BIL_VAL (0x74374096)),
		       BIL_PAIR (BIL_VAL (0xd34aeccd), BIL_VAL (0x0aebc4a2)),
		       BIL_PAIR (BIL_VAL (0xb43d99a0), BIL_VAL (0x36ffcff4)),
		       BIL_PAIR (BIL_VAL (0xda17b567), BIL_VAL (0x6b6c22a4)),
		       BIL_PAIR (BIL_VAL (0x5a0cef26), BIL_VAL (0x10aa47cc)),
		       BIL_PAIR (BIL_VAL (0x434ef84e), BIL_VAL (0x912dcebd)),
		       BIL_PAIR (BIL_VAL (0xcf0bcaf8), BIL_VAL (0x86753e24)),
		       BIL_PAIR (BIL_VAL (0xa697adcf), BIL_VAL (0x9a8400a3)),
		       BIL_PAIR (BIL_VAL (0x5cecb230), BIL_VAL (0x3de00675)),
		       BIL_PAIR (BIL_VAL (0xa7c2fef8), BIL_VAL (0x2dae2e8d)),
		       BIL_PAIR (BIL_VAL (0x62044793), BIL_VAL (0xe1675056)),
		       BIL_PAIR (BIL_VAL (0xfaef6598), BIL_VAL (0xb29348d5)),
		       BIL_PAIR (BIL_VAL (0x270baba0), BIL_VAL (0xc2848bd9)),
		       BIL_PAIR (BIL_VAL (0x9f5b9bc3), BIL_VAL (0xbf98377b)),
		       BIL_PAIR (BIL_VAL (0xbd76548c), BIL_VAL (0x31972aa1))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x520e2ff6), BIL_VAL (0xe346aa61)),
		       BIL_PAIR (BIL_VAL (0x173a0844), BIL_VAL (0xbf00c2e6)),
		       BIL_PAIR (BIL_VAL (0x9ceab83e), BIL_VAL (0x9e07ffab)),
		       BIL_PAIR (BIL_VAL (0x960806b7), BIL_VAL (0x479d0624)),
		       BIL_PAIR (BIL_VAL (0x4a2390ac), BIL_VAL (0xd5840752)),
		       BIL_PAIR (BIL_VAL (0x360d3d59), BIL_VAL (0x3d473472)),
		       BIL_PAIR (BIL_VAL (0x3230366b), BIL_VAL (0x204b83b6)),
		       BIL_PAIR (BIL_VAL (0xdf79b7cb), BIL_VAL (0x8f73819b)),
		       BIL_PAIR (BIL_VAL (0xb4733f62), BIL_VAL (0xc103a4ce)),
		       BIL_PAIR (BIL_VAL (0xbb5de214), BIL_VAL (0x99b73a32)),
		       BIL_PAIR (BIL_VAL (0x4cee16fe), BIL_VAL (0xa5ed2eaf)),
		       BIL_PAIR (BIL_VAL (0x33fd04c1), BIL_VAL (0x7dbdf9c9)),
		       BIL_PAIR (BIL_VAL (0x19d6934c), BIL_VAL (0x4fc856b8)),
		       BIL_PAIR (BIL_VAL (0x65e88de3), BIL_VAL (0x1496cb81)),
		       BIL_PAIR (BIL_VAL (0x09ac3c25), BIL_VAL (0x79654b7e))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xfbf00801), BIL_VAL (0x95bc9266)),
		       BIL_PAIR (BIL_VAL (0xe4ac3223), BIL_VAL (0xf030a158)),
		       BIL_PAIR (BIL_VAL (0x40d581a1), BIL_VAL (0xca94de60)),
		       BIL_PAIR (BIL_VAL (0xfb6f9d63), BIL_VAL (0xec594938)),
		       BIL_PAIR (BIL_VAL (0xb2d64b96), BIL_VAL (0x9fbc9ab4)),
		       BIL_PAIR (BIL_VAL (0x59ad8e0b), BIL_VAL (0x39340040)),
		       BIL_PAIR (BIL_VAL (0x8b712955), BIL_VAL (0xe4f9836d)),
		       BIL_PAIR (BIL_VAL (0xafdf6047), BIL_VAL (0xefa658ea)),
		       BIL_PAIR (BIL_VAL (0x6df0cd55), BIL_VAL (0x99d5d980)),
		       BIL_PAIR (BIL_VAL (0xa2924dd6), BIL_VAL (0x604fe8af)),
		       BIL_PAIR (BIL_VAL (0xccd0c4b1), BIL_VAL (0x74d72464)),
		       BIL_PAIR (BIL_VAL (0x5735d444), BIL_VAL (0x9b58a1e2)),
		       BIL_PAIR (BIL_VAL (0xfdc2b352), BIL_VAL (0x670fe2db)),
		       BIL_PAIR (BIL_VAL (0x6d66e0ff), BIL_VAL (0xd8ba18d3)),
		       BIL_PAIR (BIL_VAL (0x5c31ecb8), BIL_VAL (0xe3707d11))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xe99bfd85), BIL_VAL (0xd8779da7)),
		       BIL_PAIR (BIL_VAL (0xba4e6b5a), BIL_VAL (0x8a33b5a8)),
		       BIL_PAIR (BIL_VAL (0xbfd431d8), BIL_VAL (0x54693ebb)),
		       BIL_PAIR (BIL_VAL (0x11c3e810), BIL_VAL (0x1a142886)),
		       BIL_PAIR (BIL_VAL (0xc3efebd9), BIL_VAL (0xbfc9639d)),
		       BIL_PAIR (BIL_VAL (0x073bfb59), BIL_VAL (0xa32fcc9c)),
		       BIL_PAIR (BIL_VAL (0x27ae3c37), BIL_VAL (0x7eb9039a)),
		       BIL_PAIR (BIL_VAL (0x76e2046a), BIL_VAL (0xaee50b05)),
		       BIL_PAIR (BIL_VAL (0x4dc404e5), BIL_VAL (0xd438af6d)),
		       BIL_PAIR (BIL_VAL (0xa3f09927), BIL_VAL (0x8c313e9c)),
		       BIL_PAIR (BIL_VAL (0xcb625814), BIL_VAL (0x8e764384)),
		       BIL_PAIR (BIL_VAL (0x3e1ab45f), BIL_VAL (0x0fd840f0)),
		       BIL_PAIR (BIL_VAL (0xd0ada886), BIL_VAL (0x52f62532)),
		       BIL_PAIR (BIL_VAL (0x1fc2e381), BIL_VAL (0x285cf537)),
		       BIL_PAIR (BIL_VAL (0x0aef78cf), BIL_VAL (0x96d750b9))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x26518c2f), BIL_VAL (0x19c34808)),
		       BIL_PAIR (BIL_VAL (0xb98c2b8d), BIL_VAL (0x1a2e2bca)),
		       BIL_PAIR (BIL_VAL (0x0df7a13d), BIL_VAL (0x2f0d3a8a)),
		       BIL_PAIR (BIL_VAL (0x8a7a9e83), BIL_VAL (0xb737d4c6)),
		       BIL_PAIR (BIL_VAL (0xe42cf246), BIL_VAL (0xa610f1f9)),
		       BIL_PAIR (BIL_VAL (0xb1195af9), BIL_VAL (0x27afaf39)),
		       BIL_PAIR (BIL_VAL (0x7054b32c), BIL_VAL (0xaac2349f)),
		       BIL_PAIR (BIL_VAL (0x1ed8b6f9), BIL_VAL (0x9c78ac9a)),
		       BIL_PAIR (BIL_VAL (0x4e519bdd), BIL_VAL (0x8811de36)),
		       BIL_PAIR (BIL_VAL (0x9060a412), BIL_VAL (0x4d5feb69)),
		       BIL_PAIR (BIL_VAL (0xd1054a07), BIL_VAL (0x5dd4ebb2)),
		       BIL_PAIR (BIL_VAL (0xd0358b0c), BIL_VAL (0xd7f8f7b2)),
		       BIL_PAIR (BIL_VAL (0x125cacdf), BIL_VAL (0xb910df15)),
		       BIL_PAIR (BIL_VAL (0x8b125c2d), BIL_VAL (0x06a5e99f)),
		       BIL_PAIR (BIL_VAL (0x65e33c70), BIL_VAL (0xef843c1e))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0xd5ff7df3), BIL_VAL (0xa0547daa)),
		       BIL_PAIR (BIL_VAL (0x2b7db509), BIL_VAL (0x64f2c672)),
		       BIL_PAIR (BIL_VAL (0x8eb55416), BIL_VAL (0xb44731e9)),
		       BIL_PAIR (BIL_VAL (0x185dae90), BIL_VAL (0x11b6e3bb)),
		       BIL_PAIR (BIL_VAL (0x7388b238), BIL_VAL (0x112b1e42)),
		       BIL_PAIR (BIL_VAL (0x5552604e), BIL_VAL (0x0cf2b418)),
		       BIL_PAIR (BIL_VAL (0x751dd65d), BIL_VAL (0xb9978e07)),
		       BIL_PAIR (BIL_VAL (0x5a16628f), BIL_VAL (0x1eddad3c)),
		       BIL_PAIR (BIL_VAL (0x3cf3089e), BIL_VAL (0xc2ba0237)),
		       BIL_PAIR (BIL_VAL (0x5e646180), BIL_VAL (0xffda3ea2)),
		       BIL_PAIR (BIL_VAL (0x59255135), BIL_VAL (0x7e2b4ffc)),
		       BIL_PAIR (BIL_VAL (0xde8d3f14), BIL_VAL (0x425ba385)),
		       BIL_PAIR (BIL_VAL (0x459e5859), BIL_VAL (0x8113a59e)),
		       BIL_PAIR (BIL_VAL (0xbd9bd174), BIL_VAL (0x8bfd9727)),
		       BIL_PAIR (BIL_VAL (0x327587b6), BIL_VAL (0x919efccd))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x9cd516e8), BIL_VAL (0x45cf5564)),
		       BIL_PAIR (BIL_VAL (0x3c1de688), BIL_VAL (0x2f551e85)),
		       BIL_PAIR (BIL_VAL (0x7c7b11c3), BIL_VAL (0x1571a375)),
		       BIL_PAIR (BIL_VAL (0x59750c30), BIL_VAL (0xadb29f0d)),
		       BIL_PAIR (BIL_VAL (0x4e3bee76), BIL_VAL (0x45da566c)),
		       BIL_PAIR (BIL_VAL (0x03c1ee9e), BIL_VAL (0x45d54f3a)),
		       BIL_PAIR (BIL_VAL (0x7b26d2bb), BIL_VAL (0x473da861)),
		       BIL_PAIR (BIL_VAL (0xe996c669), BIL_VAL (0xca6a4952)),
		       BIL_PAIR (BIL_VAL (0xe5efbe51), BIL_VAL (0x0a344834)),
		       BIL_PAIR (BIL_VAL (0xac968634), BIL_VAL (0x162be174)),
		       BIL_PAIR (BIL_VAL (0xe5aa9913), BIL_VAL (0xe56214dd)),
		       BIL_PAIR (BIL_VAL (0xb50da1c3), BIL_VAL (0xfc4662b6)),
		       BIL_PAIR (BIL_VAL (0x564d8158), BIL_VAL (0xc53b90f0)),
		       BIL_PAIR (BIL_VAL (0x69c38365), BIL_VAL (0xf3bbb28d)),
		       BIL_PAIR (BIL_VAL (0x0d6f6b1b), BIL_VAL (0xa70b5c76))),
	    BIL_SET15 (BIL_PAIR (BIL_VAL (0x3efef072), BIL_VAL (0x1d4ed3d1)),
		       BIL_PAIR (BIL_VAL (0xeb899ac0), BIL_VAL (0x1cec4ddb)),
		       BIL_PAIR (BIL_VAL (0xdc85aa78), BIL_VAL (0x218058aa)),
		       BIL_PAIR (BIL_VAL (0x44078a3b), BIL_VAL (0x849c2811)),
		       BIL_PAIR (BIL_VAL (0x6b272681), BIL_VAL (0x4d918668)),
		       BIL_PAIR (BIL_VAL (0xcdc87bd6), BIL_VAL (0xf7210f61)),
		       BIL_PAIR (BIL_VAL (0x836275e3), BIL_VAL (0x912718da)),
		       BIL_PAIR (BIL_VAL (0xdc363b4f), BIL_VAL (0x16c166d6)),
		       BIL_PAIR (BIL_VAL (0x2997eef4), BIL_VAL (0x646c52a4)),
		       BIL_PAIR (BIL_VAL (0xaada4c04), BIL_VAL (0x9fdda7a4)),
		       BIL_PAIR (BIL_VAL (0x9fef03e9), BIL_VAL (0xb8ad2fb6)),
		       BIL_PAIR (BIL_VAL (0xa7407dd1), BIL_VAL (0x69c35434)),
		       BIL_PAIR (BIL_VAL (0x9245c370), BIL_VAL (0xfa95a2b5)),
		       BIL_PAIR (BIL_VAL (0xd0527818), BIL_VAL (0x332c43d9)),
		       BIL_PAIR (BIL_VAL (0xaa77c11f), BIL_VAL (0xdc3ac801))
		       /* And implicit 3584 0 bits.  */)),
  /* 3840 */
  BIL_SET10 (BIL_SET5 (BIL_VAL (0x126dc0),
		       BIL_PAIR (BIL_VAL (0xee6fb8c9), BIL_VAL (0xedb188e9)),
		       BIL_PAIR (BIL_VAL (0x76c13e80), BIL_VAL (0x50fa5fd4)),
		       BIL_PAIR (BIL_VAL (0x9fb2afd4), BIL_VAL (0x31cdeeaa)),
		       BIL_PAIR (BIL_VAL (0x52a8ddd1), BIL_VAL (0x6b2e1191))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x4e5df1b1), BIL_VAL (0xfa897198)),
			BIL_PAIR (BIL_VAL (0x20c58542), BIL_VAL (0xe54ae697)),
			BIL_PAIR (BIL_VAL (0xedb67dab), BIL_VAL (0x78e597b6)),
			BIL_PAIR (BIL_VAL (0xa1ad5f89), BIL_VAL (0x10c1a247)),
			BIL_PAIR (BIL_VAL (0x93a8fbae), BIL_VAL (0x322dcf41)),
			BIL_PAIR (BIL_VAL (0x615f8991), BIL_VAL (0xccfacd1f)),
			BIL_PAIR (BIL_VAL (0x5438f06a), BIL_VAL (0xdc67a5cb)),
			BIL_PAIR (BIL_VAL (0x644c7ed3), BIL_VAL (0xf51a1d1a)),
			BIL_PAIR (BIL_VAL (0xbcebfe43), BIL_VAL (0x37b867e4)),
			BIL_PAIR (BIL_VAL (0x1ef26154), BIL_VAL (0xd87f23b5)),
			BIL_PAIR (BIL_VAL (0x5dde9164), BIL_VAL (0xfd83a2df)),
			BIL_PAIR (BIL_VAL (0x1c907aeb), BIL_VAL (0xf9e3b1d7)),
			BIL_PAIR (BIL_VAL (0xcace62cf), BIL_VAL (0xaeed92df)),
			BIL_PAIR (BIL_VAL (0x844056cb), BIL_VAL (0x907126ac)),
			BIL_PAIR (BIL_VAL (0x17d45abd), BIL_VAL (0x9838ab76))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xbeec99bb), BIL_VAL (0x26f8c432)),
			BIL_PAIR (BIL_VAL (0xfbebe126), BIL_VAL (0xb61f7ec7)),
			BIL_PAIR (BIL_VAL (0x272464c6), BIL_VAL (0x8b6a76a1)),
			BIL_PAIR (BIL_VAL (0x9fe5278f), BIL_VAL (0x420e4f64)),
			BIL_PAIR (BIL_VAL (0x1cb9475d), BIL_VAL (0xb4fb34d5)),
			BIL_PAIR (BIL_VAL (0x5e67d045), BIL_VAL (0x8ce1b767)),
			BIL_PAIR (BIL_VAL (0xfd2e829d), BIL_VAL (0x99dc6015)),
			BIL_PAIR (BIL_VAL (0x82f78258), BIL_VAL (0xdb738694)),
			BIL_PAIR (BIL_VAL (0xc84b9931), BIL_VAL (0xb4730937)),
			BIL_PAIR (BIL_VAL (0x863de1cc), BIL_VAL (0xe7299661)),
			BIL_PAIR (BIL_VAL (0x5e5c6f30), BIL_VAL (0xfc10c110)),
			BIL_PAIR (BIL_VAL (0x0ae053a2), BIL_VAL (0xbb6974d2)),
			BIL_PAIR (BIL_VAL (0x98f167ec), BIL_VAL (0x3f15f990)),
			BIL_PAIR (BIL_VAL (0xeebc88b6), BIL_VAL (0xc01de240)),
			BIL_PAIR (BIL_VAL (0xf5fa1a16), BIL_VAL (0x7325503c))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xe30ab81c), BIL_VAL (0x0c0bd60c)),
			BIL_PAIR (BIL_VAL (0x7a8150fd), BIL_VAL (0x1e37a6b4)),
			BIL_PAIR (BIL_VAL (0xf3d140d8), BIL_VAL (0x173bf954)),
			BIL_PAIR (BIL_VAL (0x54c915a7), BIL_VAL (0x7133d361)),
			BIL_PAIR (BIL_VAL (0x8db6affe), BIL_VAL (0xc4350628)),
			BIL_PAIR (BIL_VAL (0xebee9026), BIL_VAL (0x4f62b99c)),
			BIL_PAIR (BIL_VAL (0x14079b81), BIL_VAL (0xfb3f8868)),
			BIL_PAIR (BIL_VAL (0xa2bed873), BIL_VAL (0xdf550a92)),
			BIL_PAIR (BIL_VAL (0x85ba3cb4), BIL_VAL (0xf7ee637f)),
			BIL_PAIR (BIL_VAL (0x90383ab9), BIL_VAL (0x06385e59)),
			BIL_PAIR (BIL_VAL (0xb5aec306), BIL_VAL (0xb1d9779d)),
			BIL_PAIR (BIL_VAL (0x6e2571f6), BIL_VAL (0xcad6a76e)),
			BIL_PAIR (BIL_VAL (0x7e0e2694), BIL_VAL (0xe4390b4e)),
			BIL_PAIR (BIL_VAL (0x18a3c68e), BIL_VAL (0xc0a43e05)),
			BIL_PAIR (BIL_VAL (0xee592324), BIL_VAL (0xf713bc8c))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x8d120876), BIL_VAL (0x3ab6db01)),
			BIL_PAIR (BIL_VAL (0x4398b588), BIL_VAL (0x59909529)),
			BIL_PAIR (BIL_VAL (0x4f4f756f), BIL_VAL (0x7509165d)),
			BIL_PAIR (BIL_VAL (0xc38299f0), BIL_VAL (0x0de0c7b4)),
			BIL_PAIR (BIL_VAL (0x1a4ee5c2), BIL_VAL (0x27216c8a)),
			BIL_PAIR (BIL_VAL (0x3fa4aa76), BIL_VAL (0x8cec3150)),
			BIL_PAIR (BIL_VAL (0xd4b46d9e), BIL_VAL (0x16397fb3)),
			BIL_PAIR (BIL_VAL (0x4974e450), BIL_VAL (0x87e5f47a)),
			BIL_PAIR (BIL_VAL (0x26745210), BIL_VAL (0x87841381)),
			BIL_PAIR (BIL_VAL (0x44168fbe), BIL_VAL (0x845619c0)),
			BIL_PAIR (BIL_VAL (0x60bef830), BIL_VAL (0xb1488584)),
			BIL_PAIR (BIL_VAL (0x5837f107), BIL_VAL (0xf65c309c)),
			BIL_PAIR (BIL_VAL (0xe1750ba5), BIL_VAL (0xa4e2a6b5)),
			BIL_PAIR (BIL_VAL (0x6eadae57), BIL_VAL (0xc5213587)),
			BIL_PAIR (BIL_VAL (0x59182415), BIL_VAL (0x7d56ad8e))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xd80fa348), BIL_VAL (0x84e9d4c8)),
			BIL_PAIR (BIL_VAL (0x51a90c89), BIL_VAL (0x260c204f)),
			BIL_PAIR (BIL_VAL (0xd0747651), BIL_VAL (0x8020077f)),
			BIL_PAIR (BIL_VAL (0x73b8bfd2), BIL_VAL (0x630e6ac9)),
			BIL_PAIR (BIL_VAL (0x37c42093), BIL_VAL (0x470ff93e)),
			BIL_PAIR (BIL_VAL (0x1416ac72), BIL_VAL (0x7d0f5160)),
			BIL_PAIR (BIL_VAL (0xcb123ad4), BIL_VAL (0x0f41ca1e)),
			BIL_PAIR (BIL_VAL (0x5d193030), BIL_VAL (0x41da373e)),
			BIL_PAIR (BIL_VAL (0xc4aae7d2), BIL_VAL (0x7504522a)),
			BIL_PAIR (BIL_VAL (0x70e753a7), BIL_VAL (0xd815da90)),
			BIL_PAIR (BIL_VAL (0x567626d9), BIL_VAL (0xfcc26e85)),
			BIL_PAIR (BIL_VAL (0x83fa929a), BIL_VAL (0xf30c4890)),
			BIL_PAIR (BIL_VAL (0xac8c270a), BIL_VAL (0x4a8b4a39)),
			BIL_PAIR (BIL_VAL (0x727f6b29), BIL_VAL (0xfc62fdee)),
			BIL_PAIR (BIL_VAL (0x2dcbb962), BIL_VAL (0x58ee1cf7))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xdf7d4db0), BIL_VAL (0x55b214c4)),
			BIL_PAIR (BIL_VAL (0x58b1f6e7), BIL_VAL (0xd068fa53)),
			BIL_PAIR (BIL_VAL (0xf08572aa), BIL_VAL (0x0a81d57c)),
			BIL_PAIR (BIL_VAL (0xf9b4f8f5), BIL_VAL (0x4d5de38f)),
			BIL_PAIR (BIL_VAL (0x8c87ad8f), BIL_VAL (0x38069985)),
			BIL_PAIR (BIL_VAL (0xb7fb846f), BIL_VAL (0x2541797c)),
			BIL_PAIR (BIL_VAL (0xffc097c8), BIL_VAL (0x263bcb9d)),
			BIL_PAIR (BIL_VAL (0x90264c1a), BIL_VAL (0xd665627b)),
			BIL_PAIR (BIL_VAL (0x116b276b), BIL_VAL (0x82ac9bd7)),
			BIL_PAIR (BIL_VAL (0xaded151c), BIL_VAL (0x6d5ea764)),
			BIL_PAIR (BIL_VAL (0x5cf47735), BIL_VAL (0x8bea1718)),
			BIL_PAIR (BIL_VAL (0xda97b544), BIL_VAL (0x9ed76940)),
			BIL_PAIR (BIL_VAL (0x87c0bf23), BIL_VAL (0x51910718)),
			BIL_PAIR (BIL_VAL (0xce4f2ac6), BIL_VAL (0x43ce3e01)),
			BIL_PAIR (BIL_VAL (0xaf4a5cf2), BIL_VAL (0x3d903fbf))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x90c7f98b), BIL_VAL (0xc57047c1)),
			BIL_PAIR (BIL_VAL (0xfad2a1f0), BIL_VAL (0xbcedb8b2)),
			BIL_PAIR (BIL_VAL (0xaadd8035), BIL_VAL (0x7759156d)),
			BIL_PAIR (BIL_VAL (0x94e403cb), BIL_VAL (0x2adc50bd)),
			BIL_PAIR (BIL_VAL (0xed457333), BIL_VAL (0xf9aa1df8)),
			BIL_PAIR (BIL_VAL (0x2d92e27a), BIL_VAL (0x247ec686)),
			BIL_PAIR (BIL_VAL (0xdf9e7b90), BIL_VAL (0x04d7315b)),
			BIL_PAIR (BIL_VAL (0xaf6af789), BIL_VAL (0xbf2b6b2e)),
			BIL_PAIR (BIL_VAL (0x2bffd459), BIL_VAL (0x09566c37)),
			BIL_PAIR (BIL_VAL (0xf7cc8ac2), BIL_VAL (0xc879b804)),
			BIL_PAIR (BIL_VAL (0xdf5e297c), BIL_VAL (0x4f89cda4)),
			BIL_PAIR (BIL_VAL (0x4e2b95d4), BIL_VAL (0x865acada)),
			BIL_PAIR (BIL_VAL (0x5aa8c892), BIL_VAL (0xe4166ead)),
			BIL_PAIR (BIL_VAL (0x39982bb5), BIL_VAL (0x589d9e5d)),
			BIL_PAIR (BIL_VAL (0xadc9ac73), BIL_VAL (0x613812c1))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x0d1b6f54), BIL_VAL (0x8d5e27cf)),
			BIL_PAIR (BIL_VAL (0x982fceeb), BIL_VAL (0xef0e57c3)),
			BIL_PAIR (BIL_VAL (0xdcab2919), BIL_VAL (0x979f0cc6)),
			BIL_PAIR (BIL_VAL (0x352db417), BIL_VAL (0xee97b638)),
			BIL_PAIR (BIL_VAL (0xa554f984), BIL_VAL (0xb764dc5a)),
			BIL_PAIR (BIL_VAL (0xede53d28), BIL_VAL (0x165e991d)),
			BIL_PAIR (BIL_VAL (0x1c41ed93), BIL_VAL (0x9c1b653a)),
			BIL_PAIR (BIL_VAL (0x0fa25a78), BIL_VAL (0x2a9d1556)),
			BIL_PAIR (BIL_VAL (0x9bc6f1ac), BIL_VAL (0x47b9f1f2)),
			BIL_PAIR (BIL_VAL (0x04ebad73), BIL_VAL (0x591f6bb3)),
			BIL_PAIR (BIL_VAL (0xcbd401e5), BIL_VAL (0x68192c9c)),
			BIL_PAIR (BIL_VAL (0x022d13e1), BIL_VAL (0x22d5c74b)),
			BIL_PAIR (BIL_VAL (0x0b55ca3e), BIL_VAL (0x9ebcf268)),
			BIL_PAIR (BIL_VAL (0x7c5201e9), BIL_VAL (0x2c7170be)),
			BIL_PAIR (BIL_VAL (0x44e462c8), BIL_VAL (0xbd5aeb63))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x4571dcf0), BIL_VAL (0x9f2f7632)),
			BIL_PAIR (BIL_VAL (0x6c63341c), BIL_VAL (0xaea35317)),
			BIL_PAIR (BIL_VAL (0xa4d3fd0b), BIL_VAL (0x2f44ed15)),
			BIL_PAIR (BIL_VAL (0x7e221d7b), BIL_VAL (0xe2931547)),
			BIL_PAIR (BIL_VAL (0xd3a202ac), BIL_VAL (0xa20cbc75)),
			BIL_PAIR (BIL_VAL (0xeda15588), BIL_VAL (0x845801ac)),
			BIL_PAIR (BIL_VAL (0xc51d7ce8), BIL_VAL (0x757059be)),
			BIL_PAIR (BIL_VAL (0xb608240e), BIL_VAL (0xf245c7d8)),
			BIL_PAIR (BIL_VAL (0x72468e40), BIL_VAL (0x8d9c1018)),
			BIL_PAIR (BIL_VAL (0x27f45032), BIL_VAL (0x37a8b2f8)),
			BIL_PAIR (BIL_VAL (0x0168be7b), BIL_VAL (0x1244ca1b)),
			BIL_PAIR (BIL_VAL (0xfb4c275f), BIL_VAL (0x176617b6)),
			BIL_PAIR (BIL_VAL (0x13bb2d31), BIL_VAL (0x1c0f6c53)),
			BIL_PAIR (BIL_VAL (0xfe90ac81), BIL_VAL (0x99bbb667)),
			BIL_PAIR (BIL_VAL (0x29b04877), BIL_VAL (0xdd494401))
			/* And implicit 3840 0 bits.  */)),
  /* 4096 */
  BIL_SET10 (BIL_SET14 (BIL_PAIR (BIL_VAL (0x62), BIL_VAL (0x30290145)),
			BIL_PAIR (BIL_VAL (0x104bcd64), BIL_VAL (0xa60a9fc0)),
			BIL_PAIR (BIL_VAL (0x25254932), BIL_VAL (0xbb0fd922)),
			BIL_PAIR (BIL_VAL (0x271133ee), BIL_VAL (0xae7be4a2)),
			BIL_PAIR (BIL_VAL (0xf9151fff), BIL_VAL (0xf868e970)),
			BIL_PAIR (BIL_VAL (0xc234d8f5), BIL_VAL (0x1c5563f4)),
			BIL_PAIR (BIL_VAL (0x8bd2b496), BIL_VAL (0xd868b275)),
			BIL_PAIR (BIL_VAL (0x18ae4240), BIL_VAL (0x4964046f)),
			BIL_PAIR (BIL_VAL (0x87cc1d21), BIL_VAL (0x3d5d0b54)),
			BIL_PAIR (BIL_VAL (0xf74eb928), BIL_VAL (0x1bb6c6e4)),
			BIL_PAIR (BIL_VAL (0x35fcb457), BIL_VAL (0x200c03a5)),
			BIL_PAIR (BIL_VAL (0xbca35f77), BIL_VAL (0x92959da2)),
			BIL_PAIR (BIL_VAL (0x2e8d623b), BIL_VAL (0x3e7b21e2)),
			BIL_PAIR (BIL_VAL (0xb6100fab), BIL_VAL (0x123cd8a1))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xa75409f2), BIL_VAL (0x3956d4b9)),
			BIL_PAIR (BIL_VAL (0x41c759f8), BIL_VAL (0x3557de06)),
			BIL_PAIR (BIL_VAL (0x8edd2d00), BIL_VAL (0xbcdd9d4a)),
			BIL_PAIR (BIL_VAL (0x52ec8721), BIL_VAL (0xac7867f9)),
			BIL_PAIR (BIL_VAL (0xe974996f), BIL_VAL (0xb03d7ecd)),
			BIL_PAIR (BIL_VAL (0x2fdc6349), BIL_VAL (0xaf06940d)),
			BIL_PAIR (BIL_VAL (0x48741a6c), BIL_VAL (0x2ed4684e)),
			BIL_PAIR (BIL_VAL (0x5ab8d9c7), BIL_VAL (0xbd7991dc)),
			BIL_PAIR (BIL_VAL (0x03b4f63b), BIL_VAL (0x8afd6b25)),
			BIL_PAIR (BIL_VAL (0xff66e42c), BIL_VAL (0xaeee333b)),
			BIL_PAIR (BIL_VAL (0x7000a519), BIL_VAL (0x87ec7038)),
			BIL_PAIR (BIL_VAL (0xaec29e6e), BIL_VAL (0xe8cac982)),
			BIL_PAIR (BIL_VAL (0xa4ba4744), BIL_VAL (0x0496fcbe)),
			BIL_PAIR (BIL_VAL (0x00d313d5), BIL_VAL (0x84e857fd)),
			BIL_PAIR (BIL_VAL (0x214495bb), BIL_VAL (0xdf373f41))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xfd86fe49), BIL_VAL (0xb70a5c7d)),
			BIL_PAIR (BIL_VAL (0x2b17e0b2), BIL_VAL (0x544f10cd)),
			BIL_PAIR (BIL_VAL (0x4d8bfa89), BIL_VAL (0xd0d73df2)),
			BIL_PAIR (BIL_VAL (0x9d0176cc), BIL_VAL (0xa7c234f4)),
			BIL_PAIR (BIL_VAL (0xe6d27671), BIL_VAL (0x13fd01c8)),
			BIL_PAIR (BIL_VAL (0xc1a08a13), BIL_VAL (0x8c4ef804)),
			BIL_PAIR (BIL_VAL (0x56c02d9a), BIL_VAL (0x0ff4f1d4)),
			BIL_PAIR (BIL_VAL (0xe3e51cb9), BIL_VAL (0x25585832)),
			BIL_PAIR (BIL_VAL (0x5ed8d239), BIL_VAL (0x9faddd9e)),
			BIL_PAIR (BIL_VAL (0x9985a2df), BIL_VAL (0x904ff6bf)),
			BIL_PAIR (BIL_VAL (0x5c4f2ef0), BIL_VAL (0x650ebc69)),
			BIL_PAIR (BIL_VAL (0x2c5508c2), BIL_VAL (0xcbd66670)),
			BIL_PAIR (BIL_VAL (0x97aced8e), BIL_VAL (0x437b3d7f)),
			BIL_PAIR (BIL_VAL (0xe03b2b63), BIL_VAL (0x41a4c954)),
			BIL_PAIR (BIL_VAL (0x108b89bc), BIL_VAL (0x108f19ad))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xe5b53345), BIL_VAL (0x8e0dd75a)),
			BIL_PAIR (BIL_VAL (0x53400d03), BIL_VAL (0x11953407)),
			BIL_PAIR (BIL_VAL (0x4e89541b), BIL_VAL (0xae9641fd)),
			BIL_PAIR (BIL_VAL (0xd6266a3f), BIL_VAL (0xdcbf7789)),
			BIL_PAIR (BIL_VAL (0x00fc509b), BIL_VAL (0xa674343d)),
			BIL_PAIR (BIL_VAL (0xd6769f3b), BIL_VAL (0x72b882e7)),
			BIL_PAIR (BIL_VAL (0x282566fb), BIL_VAL (0xc6cc3f8d)),
			BIL_PAIR (BIL_VAL (0x6b0dd9bc), BIL_VAL (0x96119b31)),
			BIL_PAIR (BIL_VAL (0xa96ddeff), BIL_VAL (0x35e836b5)),
			BIL_PAIR (BIL_VAL (0xd298f999), BIL_VAL (0x4b8c9091)),
			BIL_PAIR (BIL_VAL (0x8e7b9a73), BIL_VAL (0x49126080)),
			BIL_PAIR (BIL_VAL (0x6f233b7c), BIL_VAL (0x94ab6feb)),
			BIL_PAIR (BIL_VAL (0xa2ebd6c1), BIL_VAL (0xd9960e2d)),
			BIL_PAIR (BIL_VAL (0x73a130d8), BIL_VAL (0x4c4a74fd)),
			BIL_PAIR (BIL_VAL (0xe9ce4724), BIL_VAL (0xed5bf546))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xa03f40a8), BIL_VAL (0xfb126ab1)),
			BIL_PAIR (BIL_VAL (0xc32da383), BIL_VAL (0x38eb3acc)),
			BIL_PAIR (BIL_VAL (0x1a67778c), BIL_VAL (0xfbe8b12a)),
			BIL_PAIR (BIL_VAL (0xcf1b2350), BIL_VAL (0x4dcd6cd9)),
			BIL_PAIR (BIL_VAL (0x95aca6a8), BIL_VAL (0xb492ed8a)),
			BIL_PAIR (BIL_VAL (0xa19adb95), BIL_VAL (0x48497187)),
			BIL_PAIR (BIL_VAL (0x0239f4ce), BIL_VAL (0xa6e9cfda)),
			BIL_PAIR (BIL_VAL (0x20c33857), BIL_VAL (0xb32c450c)),
			BIL_PAIR (BIL_VAL (0x3fecb534), BIL_VAL (0xb71bd1a4)),
			BIL_PAIR (BIL_VAL (0x5b060904), BIL_VAL (0x788f6e50)),
			BIL_PAIR (BIL_VAL (0xfe78d682), BIL_VAL (0x3613c850)),
			BIL_PAIR (BIL_VAL (0x9ee3352c), BIL_VAL (0x90ca19cf)),
			BIL_PAIR (BIL_VAL (0xe90afb77), BIL_VAL (0x9eea37c8)),
			BIL_PAIR (BIL_VAL (0xab8db59a), BIL_VAL (0x0a80627c)),
			BIL_PAIR (BIL_VAL (0xe41d3cc4), BIL_VAL (0x25971d58))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x2dfe6d97), BIL_VAL (0xee63302b)),
			BIL_PAIR (BIL_VAL (0x8e13e25f), BIL_VAL (0xeeaf19e6)),
			BIL_PAIR (BIL_VAL (0x3d326a7e), BIL_VAL (0xb6d1c7bf)),
			BIL_PAIR (BIL_VAL (0x2608c4cf), BIL_VAL (0x1cc939c1)),
			BIL_PAIR (BIL_VAL (0x307641d9), BIL_VAL (0xb2c39497)),
			BIL_PAIR (BIL_VAL (0xa8fcd8e0), BIL_VAL (0xcd9e8d7c)),
			BIL_PAIR (BIL_VAL (0x3172826a), BIL_VAL (0xc9df13cb)),
			BIL_PAIR (BIL_VAL (0x3d04e8d2), BIL_VAL (0xfca26a9f)),
			BIL_PAIR (BIL_VAL (0xf7d8b57e), BIL_VAL (0x27ecf57b)),
			BIL_PAIR (BIL_VAL (0xbb9373f4), BIL_VAL (0x6fee7aab)),
			BIL_PAIR (BIL_VAL (0x86deb3f0), BIL_VAL (0x78787e2a)),
			BIL_PAIR (BIL_VAL (0xb608b895), BIL_VAL (0x72dac789)),
			BIL_PAIR (BIL_VAL (0xbf627ede), BIL_VAL (0x440b3f25)),
			BIL_PAIR (BIL_VAL (0x1f2b2322), BIL_VAL (0xab312bb9)),
			BIL_PAIR (BIL_VAL (0x5893d4b8), BIL_VAL (0x50be10e0))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x2d240820), BIL_VAL (0x6e7bb827)),
			BIL_PAIR (BIL_VAL (0x2181327e), BIL_VAL (0xc8fa2e8a)),
			BIL_PAIR (BIL_VAL (0x37a2d439), BIL_VAL (0x0caea134)),
			BIL_PAIR (BIL_VAL (0xc53c0adf), BIL_VAL (0x9462ea75)),
			BIL_PAIR (BIL_VAL (0xecf9b5d0), BIL_VAL (0xed4d542d)),
			BIL_PAIR (BIL_VAL (0xc19e1faf), BIL_VAL (0x7a872e74)),
			BIL_PAIR (BIL_VAL (0xf984d83e), BIL_VAL (0x2dd8d925)),
			BIL_PAIR (BIL_VAL (0x80152f18), BIL_VAL (0x390a2b29)),
			BIL_PAIR (BIL_VAL (0x5138753d), BIL_VAL (0x1fa8fd5d)),
			BIL_PAIR (BIL_VAL (0x59c89f1b), BIL_VAL (0x095edc16)),
			BIL_PAIR (BIL_VAL (0x2e2690f3), BIL_VAL (0xcd8f62ff)),
			BIL_PAIR (BIL_VAL (0x42923bbd), BIL_VAL (0x87d1cde8)),
			BIL_PAIR (BIL_VAL (0x40b464a0), BIL_VAL (0xe137d5e9)),
			BIL_PAIR (BIL_VAL (0xa4eb8f8c), BIL_VAL (0xde35c88b)),
			BIL_PAIR (BIL_VAL (0xaf63b712), BIL_VAL (0x92baf1de))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xeca19beb), BIL_VAL (0x77fb8af6)),
			BIL_PAIR (BIL_VAL (0x176ca776), BIL_VAL (0x743074fa)),
			BIL_PAIR (BIL_VAL (0x7021b97a), BIL_VAL (0x1e0a6817)),
			BIL_PAIR (BIL_VAL (0x3c20ee69), BIL_VAL (0xe79dadf7)),
			BIL_PAIR (BIL_VAL (0xeb83cadb), BIL_VAL (0xdfea5242)),
			BIL_PAIR (BIL_VAL (0xa8329761), BIL_VAL (0xffe06205)),
			BIL_PAIR (BIL_VAL (0x3ccb5b92), BIL_VAL (0xac50b9c1)),
			BIL_PAIR (BIL_VAL (0x75a697b2), BIL_VAL (0xb5341743)),
			BIL_PAIR (BIL_VAL (0xc994a450), BIL_VAL (0x3b9af26b)),
			BIL_PAIR (BIL_VAL (0x398c6fed), BIL_VAL (0x037d19ee)),
			BIL_PAIR (BIL_VAL (0xf4090ee8), BIL_VAL (0xae0725b1)),
			BIL_PAIR (BIL_VAL (0x655fec30), BIL_VAL (0x3297cd0c)),
			BIL_PAIR (BIL_VAL (0x2bd9cc11), BIL_VAL (0x10c4e996)),
			BIL_PAIR (BIL_VAL (0x8738b909), BIL_VAL (0x454eb2a0)),
			BIL_PAIR (BIL_VAL (0xdcfe388f), BIL_VAL (0x15b8c898))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xd3967a1b), BIL_VAL (0x6dc3a5b4)),
			BIL_PAIR (BIL_VAL (0x811a4f04), BIL_VAL (0xf3618ac0)),
			BIL_PAIR (BIL_VAL (0x280f4d32), BIL_VAL (0x95a842bc)),
			BIL_PAIR (BIL_VAL (0xfd82373a), BIL_VAL (0x3f8ec72a)),
			BIL_PAIR (BIL_VAL (0xf2acd507), BIL_VAL (0x1a8309cb)),
			BIL_PAIR (BIL_VAL (0x2130504d), BIL_VAL (0xd97d9556)),
			BIL_PAIR (BIL_VAL (0xa1ebcad7), BIL_VAL (0x947e0d0e)),
			BIL_PAIR (BIL_VAL (0x30c7ae41), BIL_VAL (0xeb659fb8)),
			BIL_PAIR (BIL_VAL (0x78f06181), BIL_VAL (0x4f6cea9c)),
			BIL_PAIR (BIL_VAL (0x441c2d47), BIL_VAL (0x3bfe167b)),
			BIL_PAIR (BIL_VAL (0x1a1c304e), BIL_VAL (0x7613b224)),
			BIL_PAIR (BIL_VAL (0x54ab9c41), BIL_VAL (0xff0b0905)),
			BIL_PAIR (BIL_VAL (0xbc131761), BIL_VAL (0x68dde6d4)),
			BIL_PAIR (BIL_VAL (0x88052f8c), BIL_VAL (0xf8169c84)),
			BIL_PAIR (BIL_VAL (0xcb4bf982), BIL_VAL (0x87009701))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x2c234811), BIL_VAL (0x61959127)),
			BIL_PAIR (BIL_VAL (0x142e0e80), BIL_VAL (0xcab3e6d7)),
			BIL_PAIR (BIL_VAL (0xaf6a2574), BIL_VAL (0x3dbeabcd)),
			BIL_PAIR (BIL_VAL (0x0f237f1a), BIL_VAL (0x016b67b2)),
			BIL_PAIR (BIL_VAL (0xc2dfae78), BIL_VAL (0xe341be10)),
			BIL_PAIR (BIL_VAL (0xd6bfdf75), BIL_VAL (0x9b8ba1e8)),
			BIL_PAIR (BIL_VAL (0x1d1f4cce), BIL_VAL (0x7c4823da)),
			BIL_PAIR (BIL_VAL (0x7e1e7c34), BIL_VAL (0xc0591cc2)),
			BIL_PAIR (BIL_VAL (0x45155e93), BIL_VAL (0xb86ae5be)),
			BIL_PAIR (BIL_VAL (0x806c0ed3), BIL_VAL (0xf0da6146)),
			BIL_PAIR (BIL_VAL (0xe599574e), BIL_VAL (0xfb29b172)),
			BIL_PAIR (BIL_VAL (0x506be829), BIL_VAL (0x13b1bb51)),
			BIL_PAIR (BIL_VAL (0x54e05154), BIL_VAL (0xef084117)),
			BIL_PAIR (BIL_VAL (0xf89a1e90), BIL_VAL (0x8efe7ae7)),
			BIL_PAIR (BIL_VAL (0xd4724e8d), BIL_VAL (0x2a67c001))
			/* And implicit 4096 0 bits.  */)),
  /* 4352 */
  BIL_SET11 (BIL_SET8 (BIL_PAIR (BIL_VAL (0x20b254b), BIL_VAL (0x8def8472)),
		       BIL_PAIR (BIL_VAL (0xd1b9b04a), BIL_VAL (0xa80ae687)),
		       BIL_PAIR (BIL_VAL (0xb14e159e), BIL_VAL (0xfef82c45)),
		       BIL_PAIR (BIL_VAL (0xe9dca4e7), BIL_VAL (0xdccda7bf)),
		       BIL_PAIR (BIL_VAL (0x094c2e3e), BIL_VAL (0xc0a68bef)),
		       BIL_PAIR (BIL_VAL (0x5fb6084f), BIL_VAL (0x869034fe)),
		       BIL_PAIR (BIL_VAL (0x9e692e62), BIL_VAL (0xbae03766)),
		       BIL_PAIR (BIL_VAL (0xfe3cbc8f), BIL_VAL (0x65db0482))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xe2dd0349), BIL_VAL (0xa42e47ff)),
			BIL_PAIR (BIL_VAL (0x3643bc35), BIL_VAL (0xfd778b48)),
			BIL_PAIR (BIL_VAL (0x8adf90ef), BIL_VAL (0xcf17eed3)),
			BIL_PAIR (BIL_VAL (0x83386f2a), BIL_VAL (0xd0729406)),
			BIL_PAIR (BIL_VAL (0x3a34a75e), BIL_VAL (0xba4aa84d)),
			BIL_PAIR (BIL_VAL (0xf7165cb0), BIL_VAL (0x11d91826)),
			BIL_PAIR (BIL_VAL (0xa681b9da), BIL_VAL (0x24f4233a)),
			BIL_PAIR (BIL_VAL (0x5c60c316), BIL_VAL (0xbd172b82)),
			BIL_PAIR (BIL_VAL (0xd22e4e9d), BIL_VAL (0xbff9958d)),
			BIL_PAIR (BIL_VAL (0xa2da9193), BIL_VAL (0x8efcb8f0)),
			BIL_PAIR (BIL_VAL (0xa61c42f8), BIL_VAL (0x49ff35ca)),
			BIL_PAIR (BIL_VAL (0x7df13330), BIL_VAL (0xf1201c64)),
			BIL_PAIR (BIL_VAL (0x0a2ff3d2), BIL_VAL (0x101fed53)),
			BIL_PAIR (BIL_VAL (0x6c6960f3), BIL_VAL (0xcb0b87a7)),
			BIL_PAIR (BIL_VAL (0x0eb1abfe), BIL_VAL (0x9817590d))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x0c72d281), BIL_VAL (0x5378f699)),
			BIL_PAIR (BIL_VAL (0x44f02029), BIL_VAL (0xb0f5eba9)),
			BIL_PAIR (BIL_VAL (0xa6308b17), BIL_VAL (0xb15c398a)),
			BIL_PAIR (BIL_VAL (0x0c03f038), BIL_VAL (0x6d00d4a0)),
			BIL_PAIR (BIL_VAL (0x5247571c), BIL_VAL (0x291d0121)),
			BIL_PAIR (BIL_VAL (0xe96dd907), BIL_VAL (0xbd390957)),
			BIL_PAIR (BIL_VAL (0x75c1464e), BIL_VAL (0x1d7cc220)),
			BIL_PAIR (BIL_VAL (0xf7d193d9), BIL_VAL (0xc0291178)),
			BIL_PAIR (BIL_VAL (0xd3bd0afb), BIL_VAL (0x759f7e89)),
			BIL_PAIR (BIL_VAL (0x04bec35d), BIL_VAL (0xb1788cfb)),
			BIL_PAIR (BIL_VAL (0x94e27abe), BIL_VAL (0x7d249789)),
			BIL_PAIR (BIL_VAL (0x3c41c1ee), BIL_VAL (0x5905c28d)),
			BIL_PAIR (BIL_VAL (0x89a24a20), BIL_VAL (0x77612f46)),
			BIL_PAIR (BIL_VAL (0x3ff725d2), BIL_VAL (0xe6fadc69)),
			BIL_PAIR (BIL_VAL (0x97ec72c0), BIL_VAL (0xf95a6e8b))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x7aa5b391), BIL_VAL (0x4732c0eb)),
			BIL_PAIR (BIL_VAL (0x0970275e), BIL_VAL (0x40d72bc0)),
			BIL_PAIR (BIL_VAL (0x06c4f380), BIL_VAL (0xad25ea9f)),
			BIL_PAIR (BIL_VAL (0x35c1b28f), BIL_VAL (0x67c16135)),
			BIL_PAIR (BIL_VAL (0x03368728), BIL_VAL (0x1a353447)),
			BIL_PAIR (BIL_VAL (0x992b6b95), BIL_VAL (0x94c7caf3)),
			BIL_PAIR (BIL_VAL (0xf5daf77e), BIL_VAL (0x54774e0b)),
			BIL_PAIR (BIL_VAL (0xeb41da22), BIL_VAL (0xcd528193)),
			BIL_PAIR (BIL_VAL (0x68818a83), BIL_VAL (0x5317befd)),
			BIL_PAIR (BIL_VAL (0x58bc0ee8), BIL_VAL (0xc9d03df6)),
			BIL_PAIR (BIL_VAL (0xcc3cbb30), BIL_VAL (0x73abd935)),
			BIL_PAIR (BIL_VAL (0xcd458429), BIL_VAL (0xe5f84f1c)),
			BIL_PAIR (BIL_VAL (0x946301ed), BIL_VAL (0xfd0ce211)),
			BIL_PAIR (BIL_VAL (0x81e43a55), BIL_VAL (0x863fbf2c)),
			BIL_PAIR (BIL_VAL (0x865a490d), BIL_VAL (0xf8a2f82b))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x7df80102), BIL_VAL (0x5ce33571)),
			BIL_PAIR (BIL_VAL (0xf523080a), BIL_VAL (0xf3ac631f)),
			BIL_PAIR (BIL_VAL (0xed97c788), BIL_VAL (0xe6d734f6)),
			BIL_PAIR (BIL_VAL (0x5c0926a5), BIL_VAL (0xfa45c44b)),
			BIL_PAIR (BIL_VAL (0x6129a223), BIL_VAL (0xebdd4d18)),
			BIL_PAIR (BIL_VAL (0x4d2be365), BIL_VAL (0xb150997e)),
			BIL_PAIR (BIL_VAL (0x307b4863), BIL_VAL (0x1ec88f00)),
			BIL_PAIR (BIL_VAL (0xdf6a61e9), BIL_VAL (0x59c5ca61)),
			BIL_PAIR (BIL_VAL (0xe857856f), BIL_VAL (0xba4be52b)),
			BIL_PAIR (BIL_VAL (0xb3d5c00d), BIL_VAL (0x1f34e5ec)),
			BIL_PAIR (BIL_VAL (0x0989e604), BIL_VAL (0xe6a2ee6a)),
			BIL_PAIR (BIL_VAL (0x722702c9), BIL_VAL (0x38b002f0)),
			BIL_PAIR (BIL_VAL (0xd6fcacee), BIL_VAL (0x916335c3)),
			BIL_PAIR (BIL_VAL (0xfcb87856), BIL_VAL (0xce8b906b)),
			BIL_PAIR (BIL_VAL (0xfc29e722), BIL_VAL (0x4a586b35))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xf2525112), BIL_VAL (0x596e1d98)),
			BIL_PAIR (BIL_VAL (0x065bfeda), BIL_VAL (0x7dfe7bfd)),
			BIL_PAIR (BIL_VAL (0xb1b6c4a1), BIL_VAL (0x05feafb5)),
			BIL_PAIR (BIL_VAL (0x75da43b3), BIL_VAL (0xe5790dc4)),
			BIL_PAIR (BIL_VAL (0x4091fdf7), BIL_VAL (0xc97467ad)),
			BIL_PAIR (BIL_VAL (0x75850c21), BIL_VAL (0x1ca075f8)),
			BIL_PAIR (BIL_VAL (0xe1604c6e), BIL_VAL (0x19349a2c)),
			BIL_PAIR (BIL_VAL (0x4c854dfc), BIL_VAL (0x5558a281)),
			BIL_PAIR (BIL_VAL (0x2dd05c45), BIL_VAL (0x5b257d1d)),
			BIL_PAIR (BIL_VAL (0xd50ab79f), BIL_VAL (0x82c04dfc)),
			BIL_PAIR (BIL_VAL (0xb08f76ae), BIL_VAL (0x1080c34e)),
			BIL_PAIR (BIL_VAL (0x48567ad5), BIL_VAL (0xc0739155)),
			BIL_PAIR (BIL_VAL (0xed70ceef), BIL_VAL (0xc91da846)),
			BIL_PAIR (BIL_VAL (0xb30b4138), BIL_VAL (0xf915402a)),
			BIL_PAIR (BIL_VAL (0xbb833171), BIL_VAL (0x8b967426))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x68d65761), BIL_VAL (0x0b837fa5)),
			BIL_PAIR (BIL_VAL (0x4c56bad6), BIL_VAL (0x6d68d4fe)),
			BIL_PAIR (BIL_VAL (0x81adec55), BIL_VAL (0xadbb8022)),
			BIL_PAIR (BIL_VAL (0x49c90bc4), BIL_VAL (0x94c84726)),
			BIL_PAIR (BIL_VAL (0xe579f32c), BIL_VAL (0x0a5e8623)),
			BIL_PAIR (BIL_VAL (0x2b34d3f6), BIL_VAL (0xcf444ec5)),
			BIL_PAIR (BIL_VAL (0xe8d82754), BIL_VAL (0xd63da459)),
			BIL_PAIR (BIL_VAL (0x8c394447), BIL_VAL (0x2b38df2c)),
			BIL_PAIR (BIL_VAL (0xc73a3fc8), BIL_VAL (0xe6de1525)),
			BIL_PAIR (BIL_VAL (0x16aa227e), BIL_VAL (0x28c76eac)),
			BIL_PAIR (BIL_VAL (0x649b18d8), BIL_VAL (0xc0123bfb)),
			BIL_PAIR (BIL_VAL (0xc76f2279), BIL_VAL (0xf9aa5662)),
			BIL_PAIR (BIL_VAL (0x29f3987b), BIL_VAL (0x303be91c)),
			BIL_PAIR (BIL_VAL (0x173cd800), BIL_VAL (0x8f8d88d3)),
			BIL_PAIR (BIL_VAL (0x95eb91bb), BIL_VAL (0x4b1a9444))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x0df9d84d), BIL_VAL (0xf387013e)),
			BIL_PAIR (BIL_VAL (0x7e26df67), BIL_VAL (0x993c92d8)),
			BIL_PAIR (BIL_VAL (0x0271ca2b), BIL_VAL (0xfa05e674)),
			BIL_PAIR (BIL_VAL (0x5afeaa5e), BIL_VAL (0x14e0c928)),
			BIL_PAIR (BIL_VAL (0xa93472a7), BIL_VAL (0xf5b62ff4)),
			BIL_PAIR (BIL_VAL (0x2cb4ff95), BIL_VAL (0xd4e56f14)),
			BIL_PAIR (BIL_VAL (0xbca0763d), BIL_VAL (0xf5dab395)),
			BIL_PAIR (BIL_VAL (0xfeb40da4), BIL_VAL (0xdc20e48e)),
			BIL_PAIR (BIL_VAL (0xe3f904fb), BIL_VAL (0x7466c446)),
			BIL_PAIR (BIL_VAL (0x24ac37f8), BIL_VAL (0x6e272792)),
			BIL_PAIR (BIL_VAL (0x0411e082), BIL_VAL (0x7a5499f9)),
			BIL_PAIR (BIL_VAL (0x82588f8f), BIL_VAL (0x877b368c)),
			BIL_PAIR (BIL_VAL (0x48ac2481), BIL_VAL (0x7cf91b01)),
			BIL_PAIR (BIL_VAL (0x96325672), BIL_VAL (0x015bd643)),
			BIL_PAIR (BIL_VAL (0x9ead1f72), BIL_VAL (0xb992ef04))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xd4ecd130), BIL_VAL (0x2cf77336)),
			BIL_PAIR (BIL_VAL (0x5c07023a), BIL_VAL (0x56cc8e8d)),
			BIL_PAIR (BIL_VAL (0x06a492be), BIL_VAL (0x64112006)),
			BIL_PAIR (BIL_VAL (0xcbbce33d), BIL_VAL (0x63a56ffd)),
			BIL_PAIR (BIL_VAL (0xa47e37e6), BIL_VAL (0x700ababa)),
			BIL_PAIR (BIL_VAL (0x5b74a9de), BIL_VAL (0x38afbc3f)),
			BIL_PAIR (BIL_VAL (0xd48c5c21), BIL_VAL (0x74d3d0f6)),
			BIL_PAIR (BIL_VAL (0x601ee10a), BIL_VAL (0xa82f1316)),
			BIL_PAIR (BIL_VAL (0xfe877eef), BIL_VAL (0x5ad75abf)),
			BIL_PAIR (BIL_VAL (0x727b0467), BIL_VAL (0x3a347ee3)),
			BIL_PAIR (BIL_VAL (0x19cef9ea), BIL_VAL (0xdefb258e)),
			BIL_PAIR (BIL_VAL (0xbf330136), BIL_VAL (0xa79510f3)),
			BIL_PAIR (BIL_VAL (0x270fd78d), BIL_VAL (0x38f89486)),
			BIL_PAIR (BIL_VAL (0x64118f6d), BIL_VAL (0x9f31ca69)),
			BIL_PAIR (BIL_VAL (0x802e2ed8), BIL_VAL (0xf584b1f4))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x7b797e06), BIL_VAL (0xceb41fb8)),
			BIL_PAIR (BIL_VAL (0xfbf19451), BIL_VAL (0xa7c721d3)),
			BIL_PAIR (BIL_VAL (0x9b42395a), BIL_VAL (0x7ec1fe8e)),
			BIL_PAIR (BIL_VAL (0x83000e87), BIL_VAL (0x67f06772)),
			BIL_PAIR (BIL_VAL (0x8b565616), BIL_VAL (0x8cf2e894)),
			BIL_PAIR (BIL_VAL (0xdd6fe737), BIL_VAL (0xd495d47f)),
			BIL_PAIR (BIL_VAL (0x35b37bd8), BIL_VAL (0x8b17181f)),
			BIL_PAIR (BIL_VAL (0x017cbd29), BIL_VAL (0xbbbbcdf7)),
			BIL_PAIR (BIL_VAL (0x304710fa), BIL_VAL (0x9732a682)),
			BIL_PAIR (BIL_VAL (0x1e318c76), BIL_VAL (0x7871b779)),
			BIL_PAIR (BIL_VAL (0xc40f140e), BIL_VAL (0xac731d3c)),
			BIL_PAIR (BIL_VAL (0xe8275360), BIL_VAL (0x7e68951a)),
			BIL_PAIR (BIL_VAL (0xe9e82809), BIL_VAL (0x6c6a7d57)),
			BIL_PAIR (BIL_VAL (0x3d7c8a35), BIL_VAL (0x54cffad2)),
			BIL_PAIR (BIL_VAL (0x7220e4d6), BIL_VAL (0x6a04c76e))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x15babe10), BIL_VAL (0xc26d400c)),
			BIL_PAIR (BIL_VAL (0x8498d9fa), BIL_VAL (0xd1728acf)),
			BIL_PAIR (BIL_VAL (0x4e09b5c3), BIL_VAL (0x20445633)),
			BIL_PAIR (BIL_VAL (0xcdf4aa4d), BIL_VAL (0xafbbe800)),
			BIL_PAIR (BIL_VAL (0xde679315), BIL_VAL (0x55472b08)),
			BIL_PAIR (BIL_VAL (0xc050359f), BIL_VAL (0x891fb025)),
			BIL_PAIR (BIL_VAL (0x879a9da8), BIL_VAL (0xe3ab7d4e)),
			BIL_PAIR (BIL_VAL (0x0f9464d8), BIL_VAL (0x9d0ae0c3)),
			BIL_PAIR (BIL_VAL (0xe8cbd7b6), BIL_VAL (0xe9eac4c8)),
			BIL_PAIR (BIL_VAL (0x80eb8014), BIL_VAL (0x654c6730)),
			BIL_PAIR (BIL_VAL (0x611b945d), BIL_VAL (0x8d3f1379)),
			BIL_PAIR (BIL_VAL (0x7a0a5c7c), BIL_VAL (0xd00b1cd5)),
			BIL_PAIR (BIL_VAL (0x35c8fa6e), BIL_VAL (0x09740c7a)),
			BIL_PAIR (BIL_VAL (0xdc7c6428), BIL_VAL (0xc98141fd)),
			BIL_PAIR (BIL_VAL (0xe8feaf17), BIL_VAL (0x83963c01))
			/* And implicit 4352 0 bits.  */)),
  /* 4608 */
  BIL_SET12 (BIL_SET3 (BIL_VAL (0xae3),
		       BIL_PAIR (BIL_VAL (0x511626ed), BIL_VAL (0x559f07ef)),
		       BIL_PAIR (BIL_VAL (0x5f8c1b3a), BIL_VAL (0x0771c5a4))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x3d43795f), BIL_VAL (0x92ea268d)),
			BIL_PAIR (BIL_VAL (0x759e7a3f), BIL_VAL (0xff997806)),
			BIL_PAIR (BIL_VAL (0x7c40f1c6), BIL_VAL (0x92f3d22e)),
			BIL_PAIR (BIL_VAL (0x6c855b8c), BIL_VAL (0x44fbbf53)),
			BIL_PAIR (BIL_VAL (0x497c7ef9), BIL_VAL (0x17890db0)),
			BIL_PAIR (BIL_VAL (0x84a6784d), BIL_VAL (0xbb915fa0)),
			BIL_PAIR (BIL_VAL (0xe317da89), BIL_VAL (0x86604f59)),
			BIL_PAIR (BIL_VAL (0xbbf9146b), BIL_VAL (0x89ef815a)),
			BIL_PAIR (BIL_VAL (0xe8a7a780), BIL_VAL (0x29e7136f)),
			BIL_PAIR (BIL_VAL (0xe7526a95), BIL_VAL (0xc38cf143)),
			BIL_PAIR (BIL_VAL (0xf86589c9), BIL_VAL (0x4740b173)),
			BIL_PAIR (BIL_VAL (0x1b7400e5), BIL_VAL (0x0ab5e90b)),
			BIL_PAIR (BIL_VAL (0x060228ac), BIL_VAL (0x157cd1e6)),
			BIL_PAIR (BIL_VAL (0x1c60443e), BIL_VAL (0x14730f0d)),
			BIL_PAIR (BIL_VAL (0x041d84d2), BIL_VAL (0x06c82add))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x84fa5359), BIL_VAL (0xb2f464dd)),
			BIL_PAIR (BIL_VAL (0xac6b4247), BIL_VAL (0x992ac4cc)),
			BIL_PAIR (BIL_VAL (0x01e40d01), BIL_VAL (0x5945d33d)),
			BIL_PAIR (BIL_VAL (0xc387f7d8), BIL_VAL (0x09248432)),
			BIL_PAIR (BIL_VAL (0x77d84f29), BIL_VAL (0xe1b6d481)),
			BIL_PAIR (BIL_VAL (0xa693d350), BIL_VAL (0xd8ab92d7)),
			BIL_PAIR (BIL_VAL (0x52783498), BIL_VAL (0x4fedbd75)),
			BIL_PAIR (BIL_VAL (0xe9608e9a), BIL_VAL (0xa3c0a1e9)),
			BIL_PAIR (BIL_VAL (0xacf5da42), BIL_VAL (0x0ac6e6c8)),
			BIL_PAIR (BIL_VAL (0xbec90871), BIL_VAL (0x90719715)),
			BIL_PAIR (BIL_VAL (0x0b946029), BIL_VAL (0x3c90b1d2)),
			BIL_PAIR (BIL_VAL (0xc8473eef), BIL_VAL (0xa10e2427)),
			BIL_PAIR (BIL_VAL (0x24c08387), BIL_VAL (0x4c7b1b42)),
			BIL_PAIR (BIL_VAL (0xd212c2b6), BIL_VAL (0xdeb379cd)),
			BIL_PAIR (BIL_VAL (0xcb806a2f), BIL_VAL (0xad68c2cd))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xf73b3c8c), BIL_VAL (0x77a6ee9b)),
			BIL_PAIR (BIL_VAL (0x642687fd), BIL_VAL (0xb77e32e5)),
			BIL_PAIR (BIL_VAL (0x5dfa7919), BIL_VAL (0x0c7be47e)),
			BIL_PAIR (BIL_VAL (0x92772c67), BIL_VAL (0x74406904)),
			BIL_PAIR (BIL_VAL (0xde98843d), BIL_VAL (0xf33ab3cc)),
			BIL_PAIR (BIL_VAL (0x2aedb306), BIL_VAL (0xb2ec5dad)),
			BIL_PAIR (BIL_VAL (0xb3a4879f), BIL_VAL (0xac646c84)),
			BIL_PAIR (BIL_VAL (0x3dc16333), BIL_VAL (0x611c2451)),
			BIL_PAIR (BIL_VAL (0x43ea8d52), BIL_VAL (0x3648e405)),
			BIL_PAIR (BIL_VAL (0x2b6b4955), BIL_VAL (0x5b303e0c)),
			BIL_PAIR (BIL_VAL (0x6b0f4a9a), BIL_VAL (0x521a6580)),
			BIL_PAIR (BIL_VAL (0xfb6761b5), BIL_VAL (0xd3d26e40)),
			BIL_PAIR (BIL_VAL (0x207978c4), BIL_VAL (0x6ad16c97)),
			BIL_PAIR (BIL_VAL (0x60d10fea), BIL_VAL (0xbb010d91)),
			BIL_PAIR (BIL_VAL (0x827a5f04), BIL_VAL (0xec49142c))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xca7a622b), BIL_VAL (0x25afed45)),
			BIL_PAIR (BIL_VAL (0xd6cb29f9), BIL_VAL (0x0dcb7bf7)),
			BIL_PAIR (BIL_VAL (0xc01cc53d), BIL_VAL (0x8de6a7e6)),
			BIL_PAIR (BIL_VAL (0x65bf0bc3), BIL_VAL (0x355a8ff2)),
			BIL_PAIR (BIL_VAL (0xd1de534c), BIL_VAL (0xda503bea)),
			BIL_PAIR (BIL_VAL (0x2e64f077), BIL_VAL (0x9b741e90)),
			BIL_PAIR (BIL_VAL (0x9922784e), BIL_VAL (0x7861dfea)),
			BIL_PAIR (BIL_VAL (0x3b8255c1), BIL_VAL (0xb03d1a5b)),
			BIL_PAIR (BIL_VAL (0x66a7b6af), BIL_VAL (0xaf38522c)),
			BIL_PAIR (BIL_VAL (0x96d97422), BIL_VAL (0xa32cc31b)),
			BIL_PAIR (BIL_VAL (0x1145bb70), BIL_VAL (0xc661852e)),
			BIL_PAIR (BIL_VAL (0xe319c9ac), BIL_VAL (0x122e8b8d)),
			BIL_PAIR (BIL_VAL (0x77f6a74a), BIL_VAL (0x64494ad7)),
			BIL_PAIR (BIL_VAL (0x3dda7fca), BIL_VAL (0x4ccd49e6)),
			BIL_PAIR (BIL_VAL (0x72707151), BIL_VAL (0x3134cbdc))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x93e65761), BIL_VAL (0xf1cbb880)),
			BIL_PAIR (BIL_VAL (0x2094eb48), BIL_VAL (0x5181a94a)),
			BIL_PAIR (BIL_VAL (0xebd93a4e), BIL_VAL (0x1397d4e7)),
			BIL_PAIR (BIL_VAL (0x8dc2b5c2), BIL_VAL (0x828e3aa5)),
			BIL_PAIR (BIL_VAL (0x1795de82), BIL_VAL (0xeefa1589)),
			BIL_PAIR (BIL_VAL (0xa359cd71), BIL_VAL (0xa7189317)),
			BIL_PAIR (BIL_VAL (0xad3179cf), BIL_VAL (0x212ad91b)),
			BIL_PAIR (BIL_VAL (0xf4b02a58), BIL_VAL (0xb7fb86bb)),
			BIL_PAIR (BIL_VAL (0x9eff22e8), BIL_VAL (0x8c578146)),
			BIL_PAIR (BIL_VAL (0xf682e850), BIL_VAL (0xc49d24b2)),
			BIL_PAIR (BIL_VAL (0x76e143fa), BIL_VAL (0xb4f4f9f8)),
			BIL_PAIR (BIL_VAL (0x0ea716bc), BIL_VAL (0x98e124e4)),
			BIL_PAIR (BIL_VAL (0xd9ea168d), BIL_VAL (0xacf17994)),
			BIL_PAIR (BIL_VAL (0xf835fe30), BIL_VAL (0xa5e789dd)),
			BIL_PAIR (BIL_VAL (0x383ecc3f), BIL_VAL (0xab41a5f5))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x895b6279), BIL_VAL (0x3dac8cd6)),
			BIL_PAIR (BIL_VAL (0x38fa25a2), BIL_VAL (0x4c2c6855)),
			BIL_PAIR (BIL_VAL (0x494cd9ab), BIL_VAL (0xad9a5931)),
			BIL_PAIR (BIL_VAL (0xfee518e4), BIL_VAL (0x114a76bf)),
			BIL_PAIR (BIL_VAL (0x050b79d6), BIL_VAL (0x19ff2206)),
			BIL_PAIR (BIL_VAL (0xc9cee77a), BIL_VAL (0xc04720a7)),
			BIL_PAIR (BIL_VAL (0x2e883e5c), BIL_VAL (0xd9d94b12)),
			BIL_PAIR (BIL_VAL (0xa113c9ff), BIL_VAL (0x9f32f880)),
			BIL_PAIR (BIL_VAL (0x4dd07575), BIL_VAL (0xfa2c9b09)),
			BIL_PAIR (BIL_VAL (0xb4c51385), BIL_VAL (0xdc7d2d2f)),
			BIL_PAIR (BIL_VAL (0x650d5138), BIL_VAL (0x86d434ba)),
			BIL_PAIR (BIL_VAL (0x731aa759), BIL_VAL (0xd7b2bdb2)),
			BIL_PAIR (BIL_VAL (0xee2064ab), BIL_VAL (0x43f872a7)),
			BIL_PAIR (BIL_VAL (0xfc52893b), BIL_VAL (0xd7f8ef35)),
			BIL_PAIR (BIL_VAL (0x14d8ac6b), BIL_VAL (0x0337c604))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x1e52c4da), BIL_VAL (0x490010be)),
			BIL_PAIR (BIL_VAL (0x158f64ce), BIL_VAL (0x27d27f9d)),
			BIL_PAIR (BIL_VAL (0xc2b741c6), BIL_VAL (0xd9b1b6ae)),
			BIL_PAIR (BIL_VAL (0xf0adeaa5), BIL_VAL (0xe11b524d)),
			BIL_PAIR (BIL_VAL (0x07198130), BIL_VAL (0x50ab6a6f)),
			BIL_PAIR (BIL_VAL (0x2e32b413), BIL_VAL (0x739481cc)),
			BIL_PAIR (BIL_VAL (0xbc2c1d98), BIL_VAL (0xe64344ee)),
			BIL_PAIR (BIL_VAL (0x4a9a6b66), BIL_VAL (0xd61f9c10)),
			BIL_PAIR (BIL_VAL (0x9847fb8c), BIL_VAL (0x804c9bf6)),
			BIL_PAIR (BIL_VAL (0x539914c6), BIL_VAL (0x7205a67e)),
			BIL_PAIR (BIL_VAL (0x16232d1e), BIL_VAL (0xdd36ccb4)),
			BIL_PAIR (BIL_VAL (0x44fe3bfb), BIL_VAL (0x571c78ef)),
			BIL_PAIR (BIL_VAL (0x7f514e25), BIL_VAL (0xa9e09a48)),
			BIL_PAIR (BIL_VAL (0x5df68c62), BIL_VAL (0x98125dd5)),
			BIL_PAIR (BIL_VAL (0x25425d47), BIL_VAL (0x3d4244c0))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x562b0c6a), BIL_VAL (0x123364d0)),
			BIL_PAIR (BIL_VAL (0x066c744f), BIL_VAL (0x16d810e5)),
			BIL_PAIR (BIL_VAL (0x410a49d0), BIL_VAL (0xc9b818c3)),
			BIL_PAIR (BIL_VAL (0xfa510257), BIL_VAL (0x8900f435)),
			BIL_PAIR (BIL_VAL (0x96d0113c), BIL_VAL (0x6106d9e6)),
			BIL_PAIR (BIL_VAL (0x2aec33fb), BIL_VAL (0x61928ab1)),
			BIL_PAIR (BIL_VAL (0xc63fe6b9), BIL_VAL (0x3f3232c5)),
			BIL_PAIR (BIL_VAL (0x48418579), BIL_VAL (0x971f1284)),
			BIL_PAIR (BIL_VAL (0x1013ea81), BIL_VAL (0x016e17b3)),
			BIL_PAIR (BIL_VAL (0x8f197ff5), BIL_VAL (0x4b665fab)),
			BIL_PAIR (BIL_VAL (0x042a5baf), BIL_VAL (0xbc2eb120)),
			BIL_PAIR (BIL_VAL (0x49217bcc), BIL_VAL (0xa99b3d12)),
			BIL_PAIR (BIL_VAL (0x98d818b8), BIL_VAL (0x4b34bf80)),
			BIL_PAIR (BIL_VAL (0x50d84bc8), BIL_VAL (0xe36e4d0f)),
			BIL_PAIR (BIL_VAL (0x9c9f41d7), BIL_VAL (0x27bdd99a))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x44284d41), BIL_VAL (0x8c4e2f93)),
			BIL_PAIR (BIL_VAL (0xcff05ad0), BIL_VAL (0xee077255)),
			BIL_PAIR (BIL_VAL (0xfd9f8d69), BIL_VAL (0x9f1ec826)),
			BIL_PAIR (BIL_VAL (0x29289a4e), BIL_VAL (0x410c0d4d)),
			BIL_PAIR (BIL_VAL (0x4e27706b), BIL_VAL (0xb4a38e2e)),
			BIL_PAIR (BIL_VAL (0xfb65bea3), BIL_VAL (0x930e8c9c)),
			BIL_PAIR (BIL_VAL (0xe1125df3), BIL_VAL (0x8d89c9ed)),
			BIL_PAIR (BIL_VAL (0x042c81a4), BIL_VAL (0xfeb6317a)),
			BIL_PAIR (BIL_VAL (0xbb24d559), BIL_VAL (0x63cb7d3d)),
			BIL_PAIR (BIL_VAL (0xd11324a4), BIL_VAL (0xf5abe2a2)),
			BIL_PAIR (BIL_VAL (0x915a4923), BIL_VAL (0x92a703c1)),
			BIL_PAIR (BIL_VAL (0xf23553d8), BIL_VAL (0x7011e9df)),
			BIL_PAIR (BIL_VAL (0x027e010c), BIL_VAL (0x88bd44ae)),
			BIL_PAIR (BIL_VAL (0x26ba013f), BIL_VAL (0xa6f3fee5)),
			BIL_PAIR (BIL_VAL (0x558bc272), BIL_VAL (0x7d4089be))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xd8fee73c), BIL_VAL (0x4c073655)),
			BIL_PAIR (BIL_VAL (0xa0bc28f8), BIL_VAL (0xb9652ddd)),
			BIL_PAIR (BIL_VAL (0x0be42c45), BIL_VAL (0x34d4837a)),
			BIL_PAIR (BIL_VAL (0x962c69a3), BIL_VAL (0xcc48382e)),
			BIL_PAIR (BIL_VAL (0xe440d1e7), BIL_VAL (0xf5ccd3dd)),
			BIL_PAIR (BIL_VAL (0x49b043a0), BIL_VAL (0x5e1da8e6)),
			BIL_PAIR (BIL_VAL (0x985620d0), BIL_VAL (0x988db96a)),
			BIL_PAIR (BIL_VAL (0xc1cf8166), BIL_VAL (0x7dccdb62)),
			BIL_PAIR (BIL_VAL (0x626b558a), BIL_VAL (0xf118b76c)),
			BIL_PAIR (BIL_VAL (0x94424330), BIL_VAL (0xee028601)),
			BIL_PAIR (BIL_VAL (0xdbcfba7f), BIL_VAL (0x67bd2e7f)),
			BIL_PAIR (BIL_VAL (0x324dd54c), BIL_VAL (0x24e25b0c)),
			BIL_PAIR (BIL_VAL (0x88540bbc), BIL_VAL (0x2f4dbe7b)),
			BIL_PAIR (BIL_VAL (0x2521f2a1), BIL_VAL (0x954c757a)),
			BIL_PAIR (BIL_VAL (0x95c308d0), BIL_VAL (0xf13b59e5))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x3f4f873d), BIL_VAL (0xbf3dd88f)),
			BIL_PAIR (BIL_VAL (0x9d9c6a0c), BIL_VAL (0x33674f74)),
			BIL_PAIR (BIL_VAL (0xfad20fa0), BIL_VAL (0x94138119)),
			BIL_PAIR (BIL_VAL (0x48abc459), BIL_VAL (0x33195e86)),
			BIL_PAIR (BIL_VAL (0x76a0e98f), BIL_VAL (0xa875b1fa)),
			BIL_PAIR (BIL_VAL (0xee57be9e), BIL_VAL (0x896aa1d5)),
			BIL_PAIR (BIL_VAL (0xf3bd1cb5), BIL_VAL (0x67f02dc7)),
			BIL_PAIR (BIL_VAL (0x2b7b304e), BIL_VAL (0x413c67ff)),
			BIL_PAIR (BIL_VAL (0x0c34a008), BIL_VAL (0xe411031e)),
			BIL_PAIR (BIL_VAL (0x14b2b298), BIL_VAL (0x2d5886fb)),
			BIL_PAIR (BIL_VAL (0x43b2b4c0), BIL_VAL (0x2d55129c)),
			BIL_PAIR (BIL_VAL (0x0751e41e), BIL_VAL (0xb19d761f)),
			BIL_PAIR (BIL_VAL (0xadc8c0a0), BIL_VAL (0x3e825fa6)),
			BIL_PAIR (BIL_VAL (0x1f5e38dd), BIL_VAL (0x855c4520)),
			BIL_PAIR (BIL_VAL (0xe507c6ce), BIL_VAL (0xa8d4b801))
			/* And implicit 4608 0 bits.  */)),
  /* 4864 */
  BIL_SET12 (BIL_SET12 (BIL_VAL (0x3a02ce1f),
			BIL_PAIR (BIL_VAL (0xee451b5b), BIL_VAL (0x29aa67b8)),
			BIL_PAIR (BIL_VAL (0x56bfb794), BIL_VAL (0xf9cabcfe)),
			BIL_PAIR (BIL_VAL (0xbe0114f3), BIL_VAL (0x852626f9)),
			BIL_PAIR (BIL_VAL (0x088b744d), BIL_VAL (0xdecc0bdf)),
			BIL_PAIR (BIL_VAL (0xa9becfb4), BIL_VAL (0xbdcc19d3)),
			BIL_PAIR (BIL_VAL (0x30de7f6d), BIL_VAL (0x7c6b91f7)),
			BIL_PAIR (BIL_VAL (0x31d8a8c3), BIL_VAL (0xdbd0f56e)),
			BIL_PAIR (BIL_VAL (0xbb3067df), BIL_VAL (0x85b1dd07)),
			BIL_PAIR (BIL_VAL (0xbad4f7b0), BIL_VAL (0xb6a39a4a)),
			BIL_PAIR (BIL_VAL (0xaf6bc6b9), BIL_VAL (0x62ca8c15)),
			BIL_PAIR (BIL_VAL (0x6fe4dab6), BIL_VAL (0xf10773f3))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x7fe84b9d), BIL_VAL (0x4dbc0af1)),
			BIL_PAIR (BIL_VAL (0xea4e88ba), BIL_VAL (0x690879fe)),
			BIL_PAIR (BIL_VAL (0x3503ec6a), BIL_VAL (0x13042c42)),
			BIL_PAIR (BIL_VAL (0x26d8d941), BIL_VAL (0x16f55daf)),
			BIL_PAIR (BIL_VAL (0x4a0d17b5), BIL_VAL (0x54347ce8)),
			BIL_PAIR (BIL_VAL (0x200556b7), BIL_VAL (0xb63690b1)),
			BIL_PAIR (BIL_VAL (0x073c6717), BIL_VAL (0xbcff75e9)),
			BIL_PAIR (BIL_VAL (0x00541130), BIL_VAL (0x11885702)),
			BIL_PAIR (BIL_VAL (0xe22fd631), BIL_VAL (0x7fcbbad3)),
			BIL_PAIR (BIL_VAL (0x506970e4), BIL_VAL (0xeae57975)),
			BIL_PAIR (BIL_VAL (0xe85a2848), BIL_VAL (0x85da438a)),
			BIL_PAIR (BIL_VAL (0x1b1afea5), BIL_VAL (0xb9bf010a)),
			BIL_PAIR (BIL_VAL (0x943aa7d6), BIL_VAL (0x0384ac8a)),
			BIL_PAIR (BIL_VAL (0x90a21240), BIL_VAL (0x2c59cf09)),
			BIL_PAIR (BIL_VAL (0x3b8da621), BIL_VAL (0x1eb5fabd))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x47a69c01), BIL_VAL (0x2dc47cc5)),
			BIL_PAIR (BIL_VAL (0x60d1fd4d), BIL_VAL (0xa46c7d9d)),
			BIL_PAIR (BIL_VAL (0x2a2d739c), BIL_VAL (0xef2d32e1)),
			BIL_PAIR (BIL_VAL (0x7ef59000), BIL_VAL (0x1d558134)),
			BIL_PAIR (BIL_VAL (0x5d39f19c), BIL_VAL (0x32e812d9)),
			BIL_PAIR (BIL_VAL (0xa32da95b), BIL_VAL (0xbd804238)),
			BIL_PAIR (BIL_VAL (0x23679ac6), BIL_VAL (0xa3a8e6db)),
			BIL_PAIR (BIL_VAL (0xa6757401), BIL_VAL (0x3468dd4d)),
			BIL_PAIR (BIL_VAL (0xd4d1d0fd), BIL_VAL (0xc56193ba)),
			BIL_PAIR (BIL_VAL (0x365113ce), BIL_VAL (0x528ccb55)),
			BIL_PAIR (BIL_VAL (0x400bcf20), BIL_VAL (0xbf0765ed)),
			BIL_PAIR (BIL_VAL (0x53d510d5), BIL_VAL (0x2be8384f)),
			BIL_PAIR (BIL_VAL (0xfc69a86a), BIL_VAL (0xb422b6a6)),
			BIL_PAIR (BIL_VAL (0xf51b1fbf), BIL_VAL (0x3e98b3a1)),
			BIL_PAIR (BIL_VAL (0x522adb52), BIL_VAL (0xfcaa1aa7))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x6894aea4), BIL_VAL (0x85719472)),
			BIL_PAIR (BIL_VAL (0x3dd8d93a), BIL_VAL (0xe82425da)),
			BIL_PAIR (BIL_VAL (0x57f7163c), BIL_VAL (0xaffebe0e)),
			BIL_PAIR (BIL_VAL (0xf8b54a31), BIL_VAL (0x3492e860)),
			BIL_PAIR (BIL_VAL (0x11bbacb7), BIL_VAL (0x467b1965)),
			BIL_PAIR (BIL_VAL (0x05dd832a), BIL_VAL (0xb8464288)),
			BIL_PAIR (BIL_VAL (0xbcb64c11), BIL_VAL (0x03fef89a)),
			BIL_PAIR (BIL_VAL (0x299ebd3f), BIL_VAL (0xbbd2a802)),
			BIL_PAIR (BIL_VAL (0x95b4297b), BIL_VAL (0xbe845657)),
			BIL_PAIR (BIL_VAL (0x7e0d7b8b), BIL_VAL (0x3991ea7c)),
			BIL_PAIR (BIL_VAL (0x1ce9a697), BIL_VAL (0x1e34e1d4)),
			BIL_PAIR (BIL_VAL (0xe2f94dbf), BIL_VAL (0x9a5c1cb8)),
			BIL_PAIR (BIL_VAL (0x5022fc09), BIL_VAL (0x4055abd4)),
			BIL_PAIR (BIL_VAL (0x69344930), BIL_VAL (0xbfcc16f3)),
			BIL_PAIR (BIL_VAL (0x088c5628), BIL_VAL (0xdbeb498f))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xccfbffdd), BIL_VAL (0x058c40b6)),
			BIL_PAIR (BIL_VAL (0xcd4ba7a9), BIL_VAL (0x9aaa4eb5)),
			BIL_PAIR (BIL_VAL (0x17a78040), BIL_VAL (0x4bd4f236)),
			BIL_PAIR (BIL_VAL (0xa83e76df), BIL_VAL (0x61021d46)),
			BIL_PAIR (BIL_VAL (0x3fd733eb), BIL_VAL (0x03ce11fe)),
			BIL_PAIR (BIL_VAL (0xcc104c80), BIL_VAL (0x7ebd353f)),
			BIL_PAIR (BIL_VAL (0x82e39816), BIL_VAL (0x64a896c7)),
			BIL_PAIR (BIL_VAL (0xe7af724b), BIL_VAL (0x686fe303)),
			BIL_PAIR (BIL_VAL (0xfdcdc4ca), BIL_VAL (0x5bb17301)),
			BIL_PAIR (BIL_VAL (0x5de44be9), BIL_VAL (0x2e922a7a)),
			BIL_PAIR (BIL_VAL (0x04193ac2), BIL_VAL (0xec362b62)),
			BIL_PAIR (BIL_VAL (0x64279091), BIL_VAL (0x709411f7)),
			BIL_PAIR (BIL_VAL (0x0205e1ca), BIL_VAL (0xfbf6c79d)),
			BIL_PAIR (BIL_VAL (0x0091837f), BIL_VAL (0x199f824f)),
			BIL_PAIR (BIL_VAL (0x5bfac3d2), BIL_VAL (0x2b947dac))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xc2774c3d), BIL_VAL (0x919e0284)),
			BIL_PAIR (BIL_VAL (0x3dd8a300), BIL_VAL (0x908c6e84)),
			BIL_PAIR (BIL_VAL (0x464d13f7), BIL_VAL (0x44c937d9)),
			BIL_PAIR (BIL_VAL (0x4f3848ab), BIL_VAL (0x41c472b0)),
			BIL_PAIR (BIL_VAL (0xe0d4c1c8), BIL_VAL (0x361060f9)),
			BIL_PAIR (BIL_VAL (0x16746578), BIL_VAL (0xa61440f1)),
			BIL_PAIR (BIL_VAL (0xc04e40e0), BIL_VAL (0x5346d375)),
			BIL_PAIR (BIL_VAL (0x9318d398), BIL_VAL (0x6c8266d8)),
			BIL_PAIR (BIL_VAL (0xd4a024f5), BIL_VAL (0x29764961)),
			BIL_PAIR (BIL_VAL (0xea98427d), BIL_VAL (0x03c04d62)),
			BIL_PAIR (BIL_VAL (0x0dd5a667), BIL_VAL (0xd485b325)),
			BIL_PAIR (BIL_VAL (0x07a3f162), BIL_VAL (0x601936ed)),
			BIL_PAIR (BIL_VAL (0x8a154572), BIL_VAL (0x1b883f99)),
			BIL_PAIR (BIL_VAL (0x1782efc4), BIL_VAL (0x85458919)),
			BIL_PAIR (BIL_VAL (0x592ca8f3), BIL_VAL (0xc31f3829))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xaafd28b1), BIL_VAL (0xda71860a)),
			BIL_PAIR (BIL_VAL (0x0570e86e), BIL_VAL (0xadf3f528)),
			BIL_PAIR (BIL_VAL (0xa826b981), BIL_VAL (0xc617e2ae)),
			BIL_PAIR (BIL_VAL (0x84a2c76b), BIL_VAL (0xeb7f5e60)),
			BIL_PAIR (BIL_VAL (0x918aa854), BIL_VAL (0x835a7149)),
			BIL_PAIR (BIL_VAL (0x100f7402), BIL_VAL (0xa9e85c34)),
			BIL_PAIR (BIL_VAL (0xc8c7cb72), BIL_VAL (0x1bfde347)),
			BIL_PAIR (BIL_VAL (0x44bc19a1), BIL_VAL (0xff0b9751)),
			BIL_PAIR (BIL_VAL (0xa9de0af2), BIL_VAL (0xd1f6fc99)),
			BIL_PAIR (BIL_VAL (0x13905d25), BIL_VAL (0x8f4acee9)),
			BIL_PAIR (BIL_VAL (0x95ef32ff), BIL_VAL (0xb2863c89)),
			BIL_PAIR (BIL_VAL (0x0b715a18), BIL_VAL (0xd2686150)),
			BIL_PAIR (BIL_VAL (0x8a68b01a), BIL_VAL (0xafa200b7)),
			BIL_PAIR (BIL_VAL (0x41e0a1a6), BIL_VAL (0x250959e2)),
			BIL_PAIR (BIL_VAL (0x297f978e), BIL_VAL (0x2dbf0b80))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xe0913c9d), BIL_VAL (0x5e819d1f)),
			BIL_PAIR (BIL_VAL (0x9f5d5a96), BIL_VAL (0x4c68531d)),
			BIL_PAIR (BIL_VAL (0x44cdcf07), BIL_VAL (0x75c31a01)),
			BIL_PAIR (BIL_VAL (0x1735637e), BIL_VAL (0x58c19c37)),
			BIL_PAIR (BIL_VAL (0x925a4577), BIL_VAL (0xface42a7)),
			BIL_PAIR (BIL_VAL (0x21d13f28), BIL_VAL (0x71e53d25)),
			BIL_PAIR (BIL_VAL (0x1222ed91), BIL_VAL (0xa4da6c80)),
			BIL_PAIR (BIL_VAL (0xb61278ae), BIL_VAL (0xa7bbc7f9)),
			BIL_PAIR (BIL_VAL (0xa9945ca6), BIL_VAL (0x76e220e0)),
			BIL_PAIR (BIL_VAL (0x679b517b), BIL_VAL (0x6981afd3)),
			BIL_PAIR (BIL_VAL (0x249af884), BIL_VAL (0x7b36c221)),
			BIL_PAIR (BIL_VAL (0x40540ea9), BIL_VAL (0xa9dcbc76)),
			BIL_PAIR (BIL_VAL (0x164b42aa), BIL_VAL (0xbf347f83)),
			BIL_PAIR (BIL_VAL (0x64c1055a), BIL_VAL (0x62c3891b)),
			BIL_PAIR (BIL_VAL (0xa58fc176), BIL_VAL (0xbb32e291))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x64bd4921), BIL_VAL (0x53292641)),
			BIL_PAIR (BIL_VAL (0x3b252a9d), BIL_VAL (0x9a8d69db)),
			BIL_PAIR (BIL_VAL (0x94aa05cf), BIL_VAL (0xa51f4bc3)),
			BIL_PAIR (BIL_VAL (0x44fe80b1), BIL_VAL (0x1357386a)),
			BIL_PAIR (BIL_VAL (0xb944f9e3), BIL_VAL (0x38741b40)),
			BIL_PAIR (BIL_VAL (0x600fa952), BIL_VAL (0xcbe6c3d0)),
			BIL_PAIR (BIL_VAL (0x0d0ebaf6), BIL_VAL (0x5bc30bf9)),
			BIL_PAIR (BIL_VAL (0xc762fe00), BIL_VAL (0xf0dd26e6)),
			BIL_PAIR (BIL_VAL (0x70f4de1c), BIL_VAL (0xfc217bf3)),
			BIL_PAIR (BIL_VAL (0x6aa53788), BIL_VAL (0x9c3cd017)),
			BIL_PAIR (BIL_VAL (0xa5995d69), BIL_VAL (0xbcca3bf5)),
			BIL_PAIR (BIL_VAL (0x1730a460), BIL_VAL (0xf086b3da)),
			BIL_PAIR (BIL_VAL (0x1d819d27), BIL_VAL (0xe9ac5140)),
			BIL_PAIR (BIL_VAL (0x9940d3e1), BIL_VAL (0xfc899512)),
			BIL_PAIR (BIL_VAL (0x8b48469c), BIL_VAL (0x45fe2ba3))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x6a1d896f), BIL_VAL (0xa24d6e15)),
			BIL_PAIR (BIL_VAL (0xfb0a0012), BIL_VAL (0x7dac7e73)),
			BIL_PAIR (BIL_VAL (0xfcb3d13e), BIL_VAL (0x4aa57623)),
			BIL_PAIR (BIL_VAL (0xd82b3264), BIL_VAL (0xd4abdb9c)),
			BIL_PAIR (BIL_VAL (0xbd1f6aa0), BIL_VAL (0xc683cc58)),
			BIL_PAIR (BIL_VAL (0x6979bbbc), BIL_VAL (0xef7ec97b)),
			BIL_PAIR (BIL_VAL (0xd57cacad), BIL_VAL (0x4fb60b58)),
			BIL_PAIR (BIL_VAL (0x1d194842), BIL_VAL (0x37fae907)),
			BIL_PAIR (BIL_VAL (0xb1d7727d), BIL_VAL (0x6067ac9c)),
			BIL_PAIR (BIL_VAL (0xce601a11), BIL_VAL (0xeaff2c80)),
			BIL_PAIR (BIL_VAL (0x165523be), BIL_VAL (0xac93554a)),
			BIL_PAIR (BIL_VAL (0x6a513344), BIL_VAL (0x0339180c)),
			BIL_PAIR (BIL_VAL (0xefa0ede7), BIL_VAL (0x772d0d57)),
			BIL_PAIR (BIL_VAL (0x68c7f589), BIL_VAL (0x4c513c4b)),
			BIL_PAIR (BIL_VAL (0xd4225d39), BIL_VAL (0x6013ccb3))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xc19a7a7e), BIL_VAL (0xa59f9af9)),
			BIL_PAIR (BIL_VAL (0x88d87a57), BIL_VAL (0xa2199eae)),
			BIL_PAIR (BIL_VAL (0x9bd6f51b), BIL_VAL (0xcb710c68)),
			BIL_PAIR (BIL_VAL (0xa701bc99), BIL_VAL (0xb412c1ae)),
			BIL_PAIR (BIL_VAL (0xd114d2d0), BIL_VAL (0xde9f8b41)),
			BIL_PAIR (BIL_VAL (0x0b991941), BIL_VAL (0x115dce91)),
			BIL_PAIR (BIL_VAL (0xeb77fc9c), BIL_VAL (0xdfc534e9)),
			BIL_PAIR (BIL_VAL (0x1f761a43), BIL_VAL (0x9e1cbfeb)),
			BIL_PAIR (BIL_VAL (0xb5cd9af4), BIL_VAL (0xa4ad43dc)),
			BIL_PAIR (BIL_VAL (0x9019ca6d), BIL_VAL (0x401470af)),
			BIL_PAIR (BIL_VAL (0x8b6aca79), BIL_VAL (0x8cbea82e)),
			BIL_PAIR (BIL_VAL (0x1ebded34), BIL_VAL (0x4aa1b2f0)),
			BIL_PAIR (BIL_VAL (0xd1c17ede), BIL_VAL (0x2168264e)),
			BIL_PAIR (BIL_VAL (0x27354943), BIL_VAL (0x3f80cd8c)),
			BIL_PAIR (BIL_VAL (0xd15ed683), BIL_VAL (0x1f4e7cc2))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x842e07eb), BIL_VAL (0x6ba8a455)),
			BIL_PAIR (BIL_VAL (0x09da6cc4), BIL_VAL (0x574d1526)),
			BIL_PAIR (BIL_VAL (0x8ab8a5c8), BIL_VAL (0x2edb7fc2)),
			BIL_PAIR (BIL_VAL (0x8bcd5516), BIL_VAL (0xc5201ca6)),
			BIL_PAIR (BIL_VAL (0x0dd5daae), BIL_VAL (0x3f1f7213)),
			BIL_PAIR (BIL_VAL (0xb5f52a9a), BIL_VAL (0xd44124a9)),
			BIL_PAIR (BIL_VAL (0x089fa60c), BIL_VAL (0x2996b37c)),
			BIL_PAIR (BIL_VAL (0x12c92f51), BIL_VAL (0xdc0c17ca)),
			BIL_PAIR (BIL_VAL (0x4d7c4a3f), BIL_VAL (0x0ae13c74)),
			BIL_PAIR (BIL_VAL (0x7d5d63b3), BIL_VAL (0x8ab84312)),
			BIL_PAIR (BIL_VAL (0x7027a308), BIL_VAL (0x5b0a2d60)),
			BIL_PAIR (BIL_VAL (0x4a6e9805), BIL_VAL (0x9024404c)),
			BIL_PAIR (BIL_VAL (0x3e0ba104), BIL_VAL (0x76d2fb55)),
			BIL_PAIR (BIL_VAL (0xebdb6d80), BIL_VAL (0x09d73755)),
			BIL_PAIR (BIL_VAL (0xae2d736a), BIL_VAL (0x5a233401))
			/* And implicit 4864 0 bits.  */)),
  /* 5120 */
  BIL_SET13 (BIL_SET6 (BIL_PAIR (BIL_VAL (0x13514), BIL_VAL (0xfde1fda7)),
		       BIL_PAIR (BIL_VAL (0x5645a90b), BIL_VAL (0xa1db147f)),
		       BIL_PAIR (BIL_VAL (0x51825fc2), BIL_VAL (0x263ff010)),
		       BIL_PAIR (BIL_VAL (0xb0af9f54), BIL_VAL (0xdaf1cbc7)),
		       BIL_PAIR (BIL_VAL (0x2a46b53e), BIL_VAL (0x0d0ccf61)),
		       BIL_PAIR (BIL_VAL (0xc12ed152), BIL_VAL (0xfd388abb))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x94e3f8a1), BIL_VAL (0x06b5c530)),
			BIL_PAIR (BIL_VAL (0xa088f982), BIL_VAL (0xf76f2185)),
			BIL_PAIR (BIL_VAL (0x8f98f525), BIL_VAL (0xbb2d2728)),
			BIL_PAIR (BIL_VAL (0x6a231bbf), BIL_VAL (0x821b0abe)),
			BIL_PAIR (BIL_VAL (0x85f7803d), BIL_VAL (0x5c64326a)),
			BIL_PAIR (BIL_VAL (0xcb01cbf4), BIL_VAL (0xaee907e1)),
			BIL_PAIR (BIL_VAL (0xd454d8b2), BIL_VAL (0x73a362fd)),
			BIL_PAIR (BIL_VAL (0xd5c2ba77), BIL_VAL (0xc97c626d)),
			BIL_PAIR (BIL_VAL (0x91e1d943), BIL_VAL (0x3fbe9a94)),
			BIL_PAIR (BIL_VAL (0xcedcc74b), BIL_VAL (0xc663bb11)),
			BIL_PAIR (BIL_VAL (0xe6bdb2d2), BIL_VAL (0x39f16fff)),
			BIL_PAIR (BIL_VAL (0xa1694564), BIL_VAL (0x84006fba)),
			BIL_PAIR (BIL_VAL (0x319cf969), BIL_VAL (0x10b311e9)),
			BIL_PAIR (BIL_VAL (0xb6408583), BIL_VAL (0x09a6d314)),
			BIL_PAIR (BIL_VAL (0xd51c5ab1), BIL_VAL (0x9e8214ef))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x6fbd4ca9), BIL_VAL (0x7ae24246)),
			BIL_PAIR (BIL_VAL (0xd6dfb22d), BIL_VAL (0x27b481f8)),
			BIL_PAIR (BIL_VAL (0x96772505), BIL_VAL (0x62be17b6)),
			BIL_PAIR (BIL_VAL (0xdc20f58b), BIL_VAL (0xea91499c)),
			BIL_PAIR (BIL_VAL (0x129322b7), BIL_VAL (0x27868aac)),
			BIL_PAIR (BIL_VAL (0x0d199420), BIL_VAL (0xe568a9b3)),
			BIL_PAIR (BIL_VAL (0xf5d9606a), BIL_VAL (0x8a265c4c)),
			BIL_PAIR (BIL_VAL (0xa2af78c7), BIL_VAL (0xbae5e715)),
			BIL_PAIR (BIL_VAL (0x1653427c), BIL_VAL (0x1583026e)),
			BIL_PAIR (BIL_VAL (0x4fd630c2), BIL_VAL (0x0804a7fa)),
			BIL_PAIR (BIL_VAL (0xaaf2eedc), BIL_VAL (0xfb414890)),
			BIL_PAIR (BIL_VAL (0xf3ae4892), BIL_VAL (0x0e985551)),
			BIL_PAIR (BIL_VAL (0x2f63e83f), BIL_VAL (0x11215b6a)),
			BIL_PAIR (BIL_VAL (0xc67eb682), BIL_VAL (0x26791623)),
			BIL_PAIR (BIL_VAL (0x59335a8e), BIL_VAL (0x60095bcf))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xe1a7ac36), BIL_VAL (0x1af768fa)),
			BIL_PAIR (BIL_VAL (0x29191bfd), BIL_VAL (0xad7879f6)),
			BIL_PAIR (BIL_VAL (0xe9e8d551), BIL_VAL (0x918ef613)),
			BIL_PAIR (BIL_VAL (0x2cf4c7fc), BIL_VAL (0x012842d4)),
			BIL_PAIR (BIL_VAL (0x4c65c27b), BIL_VAL (0x2a4b26bc)),
			BIL_PAIR (BIL_VAL (0xe6d8a2ad), BIL_VAL (0x70d21aa2)),
			BIL_PAIR (BIL_VAL (0xcc1710b4), BIL_VAL (0xe78985f2)),
			BIL_PAIR (BIL_VAL (0x5a12b261), BIL_VAL (0x9f5d242d)),
			BIL_PAIR (BIL_VAL (0x80811b8e), BIL_VAL (0x9b106271)),
			BIL_PAIR (BIL_VAL (0x1045b6ce), BIL_VAL (0x3562bc33)),
			BIL_PAIR (BIL_VAL (0xfbc5ee9f), BIL_VAL (0x817050dc)),
			BIL_PAIR (BIL_VAL (0x994563e3), BIL_VAL (0x9e497267)),
			BIL_PAIR (BIL_VAL (0x0a8a2c77), BIL_VAL (0x2abc9ef2)),
			BIL_PAIR (BIL_VAL (0xd1e42f6d), BIL_VAL (0xb128fc68)),
			BIL_PAIR (BIL_VAL (0xab97b160), BIL_VAL (0xc7170745))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xc624ed55), BIL_VAL (0x9c692b6e)),
			BIL_PAIR (BIL_VAL (0xd2b053b0), BIL_VAL (0xc7021499)),
			BIL_PAIR (BIL_VAL (0x9a96d655), BIL_VAL (0x65385f01)),
			BIL_PAIR (BIL_VAL (0xa80d3204), BIL_VAL (0x74e5a113)),
			BIL_PAIR (BIL_VAL (0x5fd8c1f9), BIL_VAL (0xc13da5cb)),
			BIL_PAIR (BIL_VAL (0xca3ccddf), BIL_VAL (0xddc62d5f)),
			BIL_PAIR (BIL_VAL (0x950b7fee), BIL_VAL (0x5ff59efd)),
			BIL_PAIR (BIL_VAL (0xa0536e8a), BIL_VAL (0xdfac6dba)),
			BIL_PAIR (BIL_VAL (0x9d1662e2), BIL_VAL (0x3af99f3b)),
			BIL_PAIR (BIL_VAL (0x56ee628e), BIL_VAL (0x8648ffa0)),
			BIL_PAIR (BIL_VAL (0x6b0c00d0), BIL_VAL (0xc8513aff)),
			BIL_PAIR (BIL_VAL (0x333613d6), BIL_VAL (0x375895d5)),
			BIL_PAIR (BIL_VAL (0xd8011875), BIL_VAL (0x5a1bcec3)),
			BIL_PAIR (BIL_VAL (0x39bcac45), BIL_VAL (0xfbe2bf28)),
			BIL_PAIR (BIL_VAL (0xb8174acc), BIL_VAL (0x27599f8d))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xbcd25ed4), BIL_VAL (0x3075c466)),
			BIL_PAIR (BIL_VAL (0x50d5ebcc), BIL_VAL (0x61fa44c6)),
			BIL_PAIR (BIL_VAL (0x16d03284), BIL_VAL (0x1d7c0a14)),
			BIL_PAIR (BIL_VAL (0x0904a154), BIL_VAL (0xa280d9a1)),
			BIL_PAIR (BIL_VAL (0x93a642a8), BIL_VAL (0x21816799)),
			BIL_PAIR (BIL_VAL (0x5d0df943), BIL_VAL (0x208f2c1b)),
			BIL_PAIR (BIL_VAL (0x5a41a8a0), BIL_VAL (0x61f9813b)),
			BIL_PAIR (BIL_VAL (0x34c9cbae), BIL_VAL (0xece90af6)),
			BIL_PAIR (BIL_VAL (0x9c6307d1), BIL_VAL (0x870cbdc4)),
			BIL_PAIR (BIL_VAL (0x30becc0b), BIL_VAL (0x1204b39a)),
			BIL_PAIR (BIL_VAL (0x59959958), BIL_VAL (0x1b521f62)),
			BIL_PAIR (BIL_VAL (0x96b8ecc1), BIL_VAL (0xc561ef2d)),
			BIL_PAIR (BIL_VAL (0xca963fc6), BIL_VAL (0xf17e8281)),
			BIL_PAIR (BIL_VAL (0x27d66b91), BIL_VAL (0x005da141)),
			BIL_PAIR (BIL_VAL (0xbd7d66d7), BIL_VAL (0xacda490c))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x76fd4447), BIL_VAL (0x0c7d33e5)),
			BIL_PAIR (BIL_VAL (0xeb4f1077), BIL_VAL (0xdf9aa0fb)),
			BIL_PAIR (BIL_VAL (0xf7655ad0), BIL_VAL (0xf535ec74)),
			BIL_PAIR (BIL_VAL (0xbd9030f5), BIL_VAL (0x931bd979)),
			BIL_PAIR (BIL_VAL (0x5653db83), BIL_VAL (0xcb31e567)),
			BIL_PAIR (BIL_VAL (0x770202a1), BIL_VAL (0x99fa7c25)),
			BIL_PAIR (BIL_VAL (0x6cc7b71f), BIL_VAL (0x2f0f074f)),
			BIL_PAIR (BIL_VAL (0x3f070d40), BIL_VAL (0xd3e5c31a)),
			BIL_PAIR (BIL_VAL (0x6567f47b), BIL_VAL (0x538b9206)),
			BIL_PAIR (BIL_VAL (0xc3b6791a), BIL_VAL (0xfdcd8fba)),
			BIL_PAIR (BIL_VAL (0x8360cfb4), BIL_VAL (0x6ae27267)),
			BIL_PAIR (BIL_VAL (0x93ddd0db), BIL_VAL (0x17416c08)),
			BIL_PAIR (BIL_VAL (0xe5154ec7), BIL_VAL (0x392a6293)),
			BIL_PAIR (BIL_VAL (0x50dfa8ee), BIL_VAL (0xdf21ba24)),
			BIL_PAIR (BIL_VAL (0x019f0c01), BIL_VAL (0x16687045))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xcc36ed6a), BIL_VAL (0x9c7a2b0b)),
			BIL_PAIR (BIL_VAL (0x30b86a29), BIL_VAL (0xbb982743)),
			BIL_PAIR (BIL_VAL (0x5ce69efd), BIL_VAL (0x645c0788)),
			BIL_PAIR (BIL_VAL (0x73741554), BIL_VAL (0xf89df791)),
			BIL_PAIR (BIL_VAL (0x9c7086f3), BIL_VAL (0xb465f564)),
			BIL_PAIR (BIL_VAL (0x20a2cf01), BIL_VAL (0x3353e655)),
			BIL_PAIR (BIL_VAL (0xedef677b), BIL_VAL (0x085233ef)),
			BIL_PAIR (BIL_VAL (0x33d37e25), BIL_VAL (0xc2708d24)),
			BIL_PAIR (BIL_VAL (0xf4302bd0), BIL_VAL (0x3db267aa)),
			BIL_PAIR (BIL_VAL (0x4434766f), BIL_VAL (0x4faef8e1)),
			BIL_PAIR (BIL_VAL (0xfafd7dc7), BIL_VAL (0x20907840)),
			BIL_PAIR (BIL_VAL (0x446c129c), BIL_VAL (0x70cbe819)),
			BIL_PAIR (BIL_VAL (0x02259b10), BIL_VAL (0x3c7bbc69)),
			BIL_PAIR (BIL_VAL (0xc302ddb7), BIL_VAL (0xa9d401b4)),
			BIL_PAIR (BIL_VAL (0x43bb1ce6), BIL_VAL (0xfa0d75f0))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xba752674), BIL_VAL (0xbf83693c)),
			BIL_PAIR (BIL_VAL (0xf584c208), BIL_VAL (0x92983d24)),
			BIL_PAIR (BIL_VAL (0xb8cbb8da), BIL_VAL (0xcdc8d588)),
			BIL_PAIR (BIL_VAL (0xd6e6784a), BIL_VAL (0xd0eda615)),
			BIL_PAIR (BIL_VAL (0x867d5f17), BIL_VAL (0x82215f1c)),
			BIL_PAIR (BIL_VAL (0xd40d1e5a), BIL_VAL (0xcd4a12e7)),
			BIL_PAIR (BIL_VAL (0x47ee52cd), BIL_VAL (0xcf7a3556)),
			BIL_PAIR (BIL_VAL (0x0feb0a2b), BIL_VAL (0xf1aa7c92)),
			BIL_PAIR (BIL_VAL (0xd63e9959), BIL_VAL (0x2340f98b)),
			BIL_PAIR (BIL_VAL (0xb075c90f), BIL_VAL (0xd0f7e682)),
			BIL_PAIR (BIL_VAL (0x5276f23a), BIL_VAL (0xf678c76d)),
			BIL_PAIR (BIL_VAL (0xe5187dab), BIL_VAL (0x616ea2ab)),
			BIL_PAIR (BIL_VAL (0x145ee01f), BIL_VAL (0xc192e54a)),
			BIL_PAIR (BIL_VAL (0x5eb1250b), BIL_VAL (0x60e4fe41)),
			BIL_PAIR (BIL_VAL (0x18e9b9a7), BIL_VAL (0x9fc3476c))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xdc3e7d0f), BIL_VAL (0xaa802add)),
			BIL_PAIR (BIL_VAL (0x4158ca3b), BIL_VAL (0xf791e21f)),
			BIL_PAIR (BIL_VAL (0xd68e123c), BIL_VAL (0xbaa51055)),
			BIL_PAIR (BIL_VAL (0x4d8f528d), BIL_VAL (0xe12b0834)),
			BIL_PAIR (BIL_VAL (0xc14a0694), BIL_VAL (0xb7730787)),
			BIL_PAIR (BIL_VAL (0xd62613ab), BIL_VAL (0x37e9a9f2)),
			BIL_PAIR (BIL_VAL (0x59087ad8), BIL_VAL (0x9d99e891)),
			BIL_PAIR (BIL_VAL (0xdb774345), BIL_VAL (0x10dc7753)),
			BIL_PAIR (BIL_VAL (0xcb138468), BIL_VAL (0x06092514)),
			BIL_PAIR (BIL_VAL (0x51cd2c4b), BIL_VAL (0x4856e00e)),
			BIL_PAIR (BIL_VAL (0xa479086f), BIL_VAL (0x71abe6f5)),
			BIL_PAIR (BIL_VAL (0xfb7a4751), BIL_VAL (0x3ad868dc)),
			BIL_PAIR (BIL_VAL (0xad45e5e1), BIL_VAL (0x40cbf39c)),
			BIL_PAIR (BIL_VAL (0xf3da17d7), BIL_VAL (0xefb45640)),
			BIL_PAIR (BIL_VAL (0x4e1e3b2d), BIL_VAL (0x8a223c3c))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x53daec11), BIL_VAL (0x4e5df0fe)),
			BIL_PAIR (BIL_VAL (0x34e0b523), BIL_VAL (0x6378317b)),
			BIL_PAIR (BIL_VAL (0x234c6100), BIL_VAL (0x47419896)),
			BIL_PAIR (BIL_VAL (0x9bd8b1cf), BIL_VAL (0xe6ddde46)),
			BIL_PAIR (BIL_VAL (0x1ba6ce49), BIL_VAL (0x60cda6b9)),
			BIL_PAIR (BIL_VAL (0x7504ecb1), BIL_VAL (0x99e269b9)),
			BIL_PAIR (BIL_VAL (0xe50007a1), BIL_VAL (0xf5dc1d4f)),
			BIL_PAIR (BIL_VAL (0x7fb125ea), BIL_VAL (0xe4aa039a)),
			BIL_PAIR (BIL_VAL (0x3105927a), BIL_VAL (0x00c0c4a0)),
			BIL_PAIR (BIL_VAL (0x7c351784), BIL_VAL (0x9ee1fd37)),
			BIL_PAIR (BIL_VAL (0x4d1a8096), BIL_VAL (0xfdf005d4)),
			BIL_PAIR (BIL_VAL (0x95cadfe7), BIL_VAL (0x9a2fa776)),
			BIL_PAIR (BIL_VAL (0xc61b2bb6), BIL_VAL (0xab9b1d09)),
			BIL_PAIR (BIL_VAL (0x1724af87), BIL_VAL (0x86187e6a)),
			BIL_PAIR (BIL_VAL (0x8208275b), BIL_VAL (0xc294610d))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xde82dbea), BIL_VAL (0xc59331e6)),
			BIL_PAIR (BIL_VAL (0x47124c46), BIL_VAL (0x83dce2c2)),
			BIL_PAIR (BIL_VAL (0x8331e5d2), BIL_VAL (0x0766bb75)),
			BIL_PAIR (BIL_VAL (0xab22ee6c), BIL_VAL (0xe4ca0a7b)),
			BIL_PAIR (BIL_VAL (0xdfd15fef), BIL_VAL (0x08c344c7)),
			BIL_PAIR (BIL_VAL (0xc9a2dde1), BIL_VAL (0x0fe2ecb7)),
			BIL_PAIR (BIL_VAL (0xb31688cc), BIL_VAL (0x53832243)),
			BIL_PAIR (BIL_VAL (0x9b4a0112), BIL_VAL (0x99c989e3)),
			BIL_PAIR (BIL_VAL (0x4d8c293e), BIL_VAL (0x49b3c367)),
			BIL_PAIR (BIL_VAL (0x7cd512e5), BIL_VAL (0x4d04ebd6)),
			BIL_PAIR (BIL_VAL (0xba87bd43), BIL_VAL (0x73d103c6)),
			BIL_PAIR (BIL_VAL (0xa878541b), BIL_VAL (0x44dc1d5c)),
			BIL_PAIR (BIL_VAL (0xcc8aa1cf), BIL_VAL (0x3c13f77b)),
			BIL_PAIR (BIL_VAL (0xba75fde7), BIL_VAL (0x94163cb8)),
			BIL_PAIR (BIL_VAL (0xb52bb705), BIL_VAL (0xf7832ccd))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x7eb5e3bd), BIL_VAL (0xedddb5d4)),
			BIL_PAIR (BIL_VAL (0x6d42b06a), BIL_VAL (0x01f75df4)),
			BIL_PAIR (BIL_VAL (0xbc9efed9), BIL_VAL (0xaff05268)),
			BIL_PAIR (BIL_VAL (0x301989ce), BIL_VAL (0x9368afe5)),
			BIL_PAIR (BIL_VAL (0x9c70d9f4), BIL_VAL (0x846b16f7)),
			BIL_PAIR (BIL_VAL (0x16f5726c), BIL_VAL (0x925045f5)),
			BIL_PAIR (BIL_VAL (0xe3eb19fb), BIL_VAL (0x59268b48)),
			BIL_PAIR (BIL_VAL (0x793686fb), BIL_VAL (0x079b05ef)),
			BIL_PAIR (BIL_VAL (0xa44a7227), BIL_VAL (0xcce33570)),
			BIL_PAIR (BIL_VAL (0x78e3c47e), BIL_VAL (0x1d5a87fa)),
			BIL_PAIR (BIL_VAL (0x30c43ecd), BIL_VAL (0x9573d6c0)),
			BIL_PAIR (BIL_VAL (0xe4ef3393), BIL_VAL (0x241f1da3)),
			BIL_PAIR (BIL_VAL (0x2c717e23), BIL_VAL (0x4afc315f)),
			BIL_PAIR (BIL_VAL (0xc9a44fcf), BIL_VAL (0xf8db4fca)),
			BIL_PAIR (BIL_VAL (0xca7913a2), BIL_VAL (0x5781b001))
			/* And implicit 5120 0 bits.  */)),
  /* 5376 */
  BIL_SET14 (BIL_VAL (0x6),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x6ec96eb8), BIL_VAL (0xb8572f28)),
			BIL_PAIR (BIL_VAL (0x6ce9824d), BIL_VAL (0x9506690c)),
			BIL_PAIR (BIL_VAL (0x33a97a54), BIL_VAL (0xb56fcaf7)),
			BIL_PAIR (BIL_VAL (0x0ccb6860), BIL_VAL (0xe6e7ce18)),
			BIL_PAIR (BIL_VAL (0x17791b5f), BIL_VAL (0xc4a55822)),
			BIL_PAIR (BIL_VAL (0xb5c711cb), BIL_VAL (0x0ead50f7)),
			BIL_PAIR (BIL_VAL (0xd5bab258), BIL_VAL (0x175560a8)),
			BIL_PAIR (BIL_VAL (0x3d3ef274), BIL_VAL (0xa38eeb78)),
			BIL_PAIR (BIL_VAL (0x0daf8634), BIL_VAL (0xb2b9f60f)),
			BIL_PAIR (BIL_VAL (0x2eb41292), BIL_VAL (0xd49b007a)),
			BIL_PAIR (BIL_VAL (0x0982eab6), BIL_VAL (0xbc2dac4c)),
			BIL_PAIR (BIL_VAL (0xe57ed552), BIL_VAL (0xff2687d0)),
			BIL_PAIR (BIL_VAL (0xb6f72c25), BIL_VAL (0x19b9b0ae)),
			BIL_PAIR (BIL_VAL (0x362f2a28), BIL_VAL (0x8fc01015)),
			BIL_PAIR (BIL_VAL (0xa765975e), BIL_VAL (0x23afc8a5))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xb8113e83), BIL_VAL (0xa147a532)),
			BIL_PAIR (BIL_VAL (0x15e803bf), BIL_VAL (0x7c692ceb)),
			BIL_PAIR (BIL_VAL (0x595500f1), BIL_VAL (0xb7c9d231)),
			BIL_PAIR (BIL_VAL (0xc46af402), BIL_VAL (0xf0f7a7e7)),
			BIL_PAIR (BIL_VAL (0x29e8279a), BIL_VAL (0xa559e04c)),
			BIL_PAIR (BIL_VAL (0xae6da345), BIL_VAL (0x7c95a882)),
			BIL_PAIR (BIL_VAL (0x4696b8c4), BIL_VAL (0xbb3666d9)),
			BIL_PAIR (BIL_VAL (0x31071a79), BIL_VAL (0x8b832f0c)),
			BIL_PAIR (BIL_VAL (0x35d9d2f0), BIL_VAL (0x6777e9d3)),
			BIL_PAIR (BIL_VAL (0x20676b58), BIL_VAL (0xac35e60d)),
			BIL_PAIR (BIL_VAL (0x4360c427), BIL_VAL (0x328e622e)),
			BIL_PAIR (BIL_VAL (0x7519c692), BIL_VAL (0x83732c76)),
			BIL_PAIR (BIL_VAL (0xd6f60356), BIL_VAL (0x76fd1d4c)),
			BIL_PAIR (BIL_VAL (0xf535e933), BIL_VAL (0x7490bc7e)),
			BIL_PAIR (BIL_VAL (0xc5c29857), BIL_VAL (0x9348deaf))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x403f6cdb), BIL_VAL (0xa25060f3)),
			BIL_PAIR (BIL_VAL (0x04a312b5), BIL_VAL (0x61c3662a)),
			BIL_PAIR (BIL_VAL (0x21819332), BIL_VAL (0xde47dbd0)),
			BIL_PAIR (BIL_VAL (0xdc61ffcf), BIL_VAL (0x6dcc587a)),
			BIL_PAIR (BIL_VAL (0xd43ad3a6), BIL_VAL (0x376d095d)),
			BIL_PAIR (BIL_VAL (0x9637e47d), BIL_VAL (0x85948771)),
			BIL_PAIR (BIL_VAL (0x904f19e9), BIL_VAL (0x4fb3b31c)),
			BIL_PAIR (BIL_VAL (0x113c3892), BIL_VAL (0xb1049392)),
			BIL_PAIR (BIL_VAL (0x882a2d0f), BIL_VAL (0x18a6ad0b)),
			BIL_PAIR (BIL_VAL (0xccc2242f), BIL_VAL (0xc5133854)),
			BIL_PAIR (BIL_VAL (0xafbe0ed8), BIL_VAL (0xafebce5a)),
			BIL_PAIR (BIL_VAL (0xa5e3b769), BIL_VAL (0xb0242ffd)),
			BIL_PAIR (BIL_VAL (0x1bc52d0a), BIL_VAL (0xb8c132fb)),
			BIL_PAIR (BIL_VAL (0xd42ad880), BIL_VAL (0x0a1b85dd)),
			BIL_PAIR (BIL_VAL (0xe96ed5d8), BIL_VAL (0xf26951d3))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xf7abd9bb), BIL_VAL (0xd89f824d)),
			BIL_PAIR (BIL_VAL (0xf2a861b7), BIL_VAL (0x612ec255)),
			BIL_PAIR (BIL_VAL (0x5a9055a0), BIL_VAL (0x78ae65b4)),
			BIL_PAIR (BIL_VAL (0x80159cf4), BIL_VAL (0x1a26fb0e)),
			BIL_PAIR (BIL_VAL (0x8f81eb8b), BIL_VAL (0x3c4972e7)),
			BIL_PAIR (BIL_VAL (0x70026ce1), BIL_VAL (0x980704a1)),
			BIL_PAIR (BIL_VAL (0xdfcaceb5), BIL_VAL (0x052f0b27)),
			BIL_PAIR (BIL_VAL (0xfc62f04e), BIL_VAL (0xd9500c93)),
			BIL_PAIR (BIL_VAL (0xb6b03cfd), BIL_VAL (0xd3654f0d)),
			BIL_PAIR (BIL_VAL (0x22bf4673), BIL_VAL (0x19f81232)),
			BIL_PAIR (BIL_VAL (0x07c41f66), BIL_VAL (0x49434d9b)),
			BIL_PAIR (BIL_VAL (0x9cdb3c03), BIL_VAL (0x52327cb2)),
			BIL_PAIR (BIL_VAL (0xc2312382), BIL_VAL (0x63418bf0)),
			BIL_PAIR (BIL_VAL (0x36f44283), BIL_VAL (0x39846d13)),
			BIL_PAIR (BIL_VAL (0x34c0946a), BIL_VAL (0xa848006e))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xfba19fe3), BIL_VAL (0x36cdebdf)),
			BIL_PAIR (BIL_VAL (0x8cdff6b1), BIL_VAL (0x2beb4284)),
			BIL_PAIR (BIL_VAL (0x6da1ee8f), BIL_VAL (0xdc239466)),
			BIL_PAIR (BIL_VAL (0xbd5bffc1), BIL_VAL (0x13c4c16e)),
			BIL_PAIR (BIL_VAL (0xebc887ce), BIL_VAL (0x9c18c2dc)),
			BIL_PAIR (BIL_VAL (0xbd7edaee), BIL_VAL (0x8a34223f)),
			BIL_PAIR (BIL_VAL (0xdf31047d), BIL_VAL (0x03602870)),
			BIL_PAIR (BIL_VAL (0x609ac8b5), BIL_VAL (0xc88a2683)),
			BIL_PAIR (BIL_VAL (0x3028bb8e), BIL_VAL (0xdf1facb8)),
			BIL_PAIR (BIL_VAL (0x1c9abe80), BIL_VAL (0x67800d2c)),
			BIL_PAIR (BIL_VAL (0x93bd6e32), BIL_VAL (0xf38f2426)),
			BIL_PAIR (BIL_VAL (0xd106f01d), BIL_VAL (0x05ff4fee)),
			BIL_PAIR (BIL_VAL (0xf7ccdd62), BIL_VAL (0x8420d4cf)),
			BIL_PAIR (BIL_VAL (0x2c1a55ac), BIL_VAL (0x3c72834c)),
			BIL_PAIR (BIL_VAL (0x6464ccda), BIL_VAL (0x66e7a8ad))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x179281bd), BIL_VAL (0x8d7c6ff6)),
			BIL_PAIR (BIL_VAL (0x5df006ff), BIL_VAL (0xa9638ec8)),
			BIL_PAIR (BIL_VAL (0x67d32e23), BIL_VAL (0xe854b68e)),
			BIL_PAIR (BIL_VAL (0x156aa124), BIL_VAL (0xf61c249f)),
			BIL_PAIR (BIL_VAL (0xce8d33fd), BIL_VAL (0xabf0a8e8)),
			BIL_PAIR (BIL_VAL (0xfb6c187c), BIL_VAL (0xb632f418)),
			BIL_PAIR (BIL_VAL (0x4400c386), BIL_VAL (0x4175da01)),
			BIL_PAIR (BIL_VAL (0x19639820), BIL_VAL (0x594b3a05)),
			BIL_PAIR (BIL_VAL (0x53949d10), BIL_VAL (0xe053044f)),
			BIL_PAIR (BIL_VAL (0x94bb1d16), BIL_VAL (0xfb3b9c14)),
			BIL_PAIR (BIL_VAL (0x4afbea65), BIL_VAL (0xe2864a19)),
			BIL_PAIR (BIL_VAL (0x4d7ba00b), BIL_VAL (0x8963fb89)),
			BIL_PAIR (BIL_VAL (0x2dca2792), BIL_VAL (0x62edcb62)),
			BIL_PAIR (BIL_VAL (0xa1668304), BIL_VAL (0x37c8d012)),
			BIL_PAIR (BIL_VAL (0xf45b83d7), BIL_VAL (0xa97e2350))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xade32f89), BIL_VAL (0x9bd068ca)),
			BIL_PAIR (BIL_VAL (0x231f7871), BIL_VAL (0xc4189982)),
			BIL_PAIR (BIL_VAL (0x01d87d77), BIL_VAL (0xf5e658b0)),
			BIL_PAIR (BIL_VAL (0x95e1f056), BIL_VAL (0xa7024f3d)),
			BIL_PAIR (BIL_VAL (0xe941629c), BIL_VAL (0x515fbf01)),
			BIL_PAIR (BIL_VAL (0x21e6df09), BIL_VAL (0x898015dd)),
			BIL_PAIR (BIL_VAL (0x5cac7a50), BIL_VAL (0xcba66225)),
			BIL_PAIR (BIL_VAL (0x1fdb1f40), BIL_VAL (0xbd992a69)),
			BIL_PAIR (BIL_VAL (0x649b2ea7), BIL_VAL (0x81a9c1b9)),
			BIL_PAIR (BIL_VAL (0x87e8f08f), BIL_VAL (0xa034a766)),
			BIL_PAIR (BIL_VAL (0x883ad30b), BIL_VAL (0x2cc0735f)),
			BIL_PAIR (BIL_VAL (0xe6d7fbe1), BIL_VAL (0x6ef501d3)),
			BIL_PAIR (BIL_VAL (0x295ee41d), BIL_VAL (0x0b4b6d2a)),
			BIL_PAIR (BIL_VAL (0xf55c723f), BIL_VAL (0x3626d72b)),
			BIL_PAIR (BIL_VAL (0xe78a229c), BIL_VAL (0xdc229684))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x954a92da), BIL_VAL (0x28cffd6f)),
			BIL_PAIR (BIL_VAL (0x4e0d0031), BIL_VAL (0x89b688b8)),
			BIL_PAIR (BIL_VAL (0x301a1fff), BIL_VAL (0x3dc42fe7)),
			BIL_PAIR (BIL_VAL (0xbd8035ae), BIL_VAL (0x6d9278dc)),
			BIL_PAIR (BIL_VAL (0x06d71643), BIL_VAL (0x1fd967d9)),
			BIL_PAIR (BIL_VAL (0xcb67d223), BIL_VAL (0xfe057a4c)),
			BIL_PAIR (BIL_VAL (0xddf08b0e), BIL_VAL (0xc58f9bf6)),
			BIL_PAIR (BIL_VAL (0xdc61b501), BIL_VAL (0xf66c0a5c)),
			BIL_PAIR (BIL_VAL (0xe8d5873c), BIL_VAL (0x5e2469f4)),
			BIL_PAIR (BIL_VAL (0xb977bd3a), BIL_VAL (0x89f1b3a6)),
			BIL_PAIR (BIL_VAL (0x71b1bbfa), BIL_VAL (0x17fcc265)),
			BIL_PAIR (BIL_VAL (0x895edcf4), BIL_VAL (0x152af33a)),
			BIL_PAIR (BIL_VAL (0xf6637be8), BIL_VAL (0x01f101d5)),
			BIL_PAIR (BIL_VAL (0xbc0ab6f6), BIL_VAL (0xcba9c2cd)),
			BIL_PAIR (BIL_VAL (0x77b3f6e2), BIL_VAL (0x53ec437a))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x5527e87b), BIL_VAL (0x5af23203)),
			BIL_PAIR (BIL_VAL (0xdc5d4e00), BIL_VAL (0x90f5c8f5)),
			BIL_PAIR (BIL_VAL (0xa4e98562), BIL_VAL (0x65ea2d92)),
			BIL_PAIR (BIL_VAL (0x37cd2335), BIL_VAL (0x706e722e)),
			BIL_PAIR (BIL_VAL (0x50e25e72), BIL_VAL (0x5e2c57ba)),
			BIL_PAIR (BIL_VAL (0x279b323e), BIL_VAL (0xac788e46)),
			BIL_PAIR (BIL_VAL (0x5169badc), BIL_VAL (0x4ac6548a)),
			BIL_PAIR (BIL_VAL (0x6ff0fda5), BIL_VAL (0x89024ebc)),
			BIL_PAIR (BIL_VAL (0x6d95fde4), BIL_VAL (0xe5725d28)),
			BIL_PAIR (BIL_VAL (0x98da6a2f), BIL_VAL (0x7736fdf4)),
			BIL_PAIR (BIL_VAL (0x246a2b72), BIL_VAL (0x2bf76fca)),
			BIL_PAIR (BIL_VAL (0x651548b3), BIL_VAL (0xeddbaa1e)),
			BIL_PAIR (BIL_VAL (0xdd974c75), BIL_VAL (0x639c8be5)),
			BIL_PAIR (BIL_VAL (0x8c02e5dc), BIL_VAL (0xbdaba423)),
			BIL_PAIR (BIL_VAL (0x290a5719), BIL_VAL (0x1a8db2a1))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x3391c1ec), BIL_VAL (0x2eecf719)),
			BIL_PAIR (BIL_VAL (0xb7b380af), BIL_VAL (0x86d3529f)),
			BIL_PAIR (BIL_VAL (0x11d9ba06), BIL_VAL (0x292ca3b3)),
			BIL_PAIR (BIL_VAL (0x319371e0), BIL_VAL (0x74aa0b92)),
			BIL_PAIR (BIL_VAL (0xe86c2cc1), BIL_VAL (0x1119acb5)),
			BIL_PAIR (BIL_VAL (0xfc9e3943), BIL_VAL (0x59afe7e7)),
			BIL_PAIR (BIL_VAL (0xb19264f9), BIL_VAL (0x8724785a)),
			BIL_PAIR (BIL_VAL (0x551f4e55), BIL_VAL (0x837b1cb0)),
			BIL_PAIR (BIL_VAL (0x3a1661b5), BIL_VAL (0xc53c8e44)),
			BIL_PAIR (BIL_VAL (0x019e98a7), BIL_VAL (0x2c1232c0)),
			BIL_PAIR (BIL_VAL (0xd931ad45), BIL_VAL (0x1cd8b775)),
			BIL_PAIR (BIL_VAL (0x1fd2384e), BIL_VAL (0x8ea571c5)),
			BIL_PAIR (BIL_VAL (0x0949d4e4), BIL_VAL (0x71d99116)),
			BIL_PAIR (BIL_VAL (0x0ee318c4), BIL_VAL (0xa94a2700)),
			BIL_PAIR (BIL_VAL (0x4d0b4596), BIL_VAL (0x7f272ca9))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xe3608c3a), BIL_VAL (0x38738e94)),
			BIL_PAIR (BIL_VAL (0x2a35c4f4), BIL_VAL (0x75c66e0f)),
			BIL_PAIR (BIL_VAL (0x028512cf), BIL_VAL (0x3ff0c109)),
			BIL_PAIR (BIL_VAL (0xf1a9e538), BIL_VAL (0x193791d1)),
			BIL_PAIR (BIL_VAL (0xef1f628a), BIL_VAL (0x67375e40)),
			BIL_PAIR (BIL_VAL (0xb21a4713), BIL_VAL (0x5888ad68)),
			BIL_PAIR (BIL_VAL (0x35104c67), BIL_VAL (0xa6ca49d6)),
			BIL_PAIR (BIL_VAL (0x3338fa2a), BIL_VAL (0x337be3c1)),
			BIL_PAIR (BIL_VAL (0x187f64f7), BIL_VAL (0x1e37710e)),
			BIL_PAIR (BIL_VAL (0xbc4e4621), BIL_VAL (0x248e0f4a)),
			BIL_PAIR (BIL_VAL (0xe1b4148f), BIL_VAL (0x578c7fd7)),
			BIL_PAIR (BIL_VAL (0xf4859218), BIL_VAL (0xf601e92f)),
			BIL_PAIR (BIL_VAL (0x77ee9f9c), BIL_VAL (0x96c83b5e)),
			BIL_PAIR (BIL_VAL (0x2043840e), BIL_VAL (0x4cdbda0f)),
			BIL_PAIR (BIL_VAL (0x4fb59deb), BIL_VAL (0x44045577))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x7086d59e), BIL_VAL (0xb6025d59)),
			BIL_PAIR (BIL_VAL (0x0d90219c), BIL_VAL (0x82cc0893)),
			BIL_PAIR (BIL_VAL (0x0dd507df), BIL_VAL (0x59c03664)),
			BIL_PAIR (BIL_VAL (0x7d120602), BIL_VAL (0x7ffb5055)),
			BIL_PAIR (BIL_VAL (0x37943cd2), BIL_VAL (0x17475b41)),
			BIL_PAIR (BIL_VAL (0x915fe523), BIL_VAL (0x98c681bd)),
			BIL_PAIR (BIL_VAL (0xa2b06680), BIL_VAL (0xaf213582)),
			BIL_PAIR (BIL_VAL (0x66317842), BIL_VAL (0x091a96a4)),
			BIL_PAIR (BIL_VAL (0x352e4dc4), BIL_VAL (0x58372d7c)),
			BIL_PAIR (BIL_VAL (0x8e8ff571), BIL_VAL (0x36af1cfc)),
			BIL_PAIR (BIL_VAL (0x82f8e46a), BIL_VAL (0xc505a1e1)),
			BIL_PAIR (BIL_VAL (0xe8c9ab9c), BIL_VAL (0x710d3c94)),
			BIL_PAIR (BIL_VAL (0xa148468e), BIL_VAL (0xe229e24a)),
			BIL_PAIR (BIL_VAL (0xf8b0f1ea), BIL_VAL (0x58e9b984)),
			BIL_PAIR (BIL_VAL (0xfd66826d), BIL_VAL (0x2a264561))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xc6210fa2), BIL_VAL (0xb01d6c78)),
			BIL_PAIR (BIL_VAL (0x781a2429), BIL_VAL (0x09e9ea03)),
			BIL_PAIR (BIL_VAL (0xf44e80e0), BIL_VAL (0xaefe5a16)),
			BIL_PAIR (BIL_VAL (0x079b4212), BIL_VAL (0x628f06be)),
			BIL_PAIR (BIL_VAL (0xd254ed67), BIL_VAL (0xeaeaab77)),
			BIL_PAIR (BIL_VAL (0x6dd5597e), BIL_VAL (0xa2567f97)),
			BIL_PAIR (BIL_VAL (0x2b53367c), BIL_VAL (0xbd4c2791)),
			BIL_PAIR (BIL_VAL (0xeca3b4c7), BIL_VAL (0x779acef0)),
			BIL_PAIR (BIL_VAL (0x22469708), BIL_VAL (0x930d3215)),
			BIL_PAIR (BIL_VAL (0xb69b53b4), BIL_VAL (0x10388a67)),
			BIL_PAIR (BIL_VAL (0xb5869a49), BIL_VAL (0xb445405a)),
			BIL_PAIR (BIL_VAL (0x4528bda7), BIL_VAL (0xf0c50955)),
			BIL_PAIR (BIL_VAL (0x7da99556), BIL_VAL (0xb67f79d2)),
			BIL_PAIR (BIL_VAL (0x093932f6), BIL_VAL (0xfd38c618)),
			BIL_PAIR (BIL_VAL (0xa8d9872e), BIL_VAL (0x60f02c01))
			/* And implicit 5376 0 bits.  */)),
  /* 5632 */
  BIL_SET14 (BIL_SET10 (BIL_VAL (0x224611),
			BIL_PAIR (BIL_VAL (0xc5854d85), BIL_VAL (0x1830a03b)),
			BIL_PAIR (BIL_VAL (0x29062425), BIL_VAL (0x649d1019)),
			BIL_PAIR (BIL_VAL (0x60f18f93), BIL_VAL (0x6b266eb0)),
			BIL_PAIR (BIL_VAL (0x43e21844), BIL_VAL (0xe3052106)),
			BIL_PAIR (BIL_VAL (0x4ae94552), BIL_VAL (0xf216987a)),
			BIL_PAIR (BIL_VAL (0xfdff4d0e), BIL_VAL (0x652f98ed)),
			BIL_PAIR (BIL_VAL (0xb33ab0a6), BIL_VAL (0x92678193)),
			BIL_PAIR (BIL_VAL (0xf689679c), BIL_VAL (0xd9e3ab52)),
			BIL_PAIR (BIL_VAL (0xef781b22), BIL_VAL (0x63740f51))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x6973b59d), BIL_VAL (0x47b7001d)),
			BIL_PAIR (BIL_VAL (0xe7f0fb08), BIL_VAL (0x9fefc350)),
			BIL_PAIR (BIL_VAL (0x61e73108), BIL_VAL (0xbab77d75)),
			BIL_PAIR (BIL_VAL (0xf58d16f7), BIL_VAL (0x1f68d8a1)),
			BIL_PAIR (BIL_VAL (0x22192873), BIL_VAL (0x1fdbb5f5)),
			BIL_PAIR (BIL_VAL (0x02f4a286), BIL_VAL (0x4dc70d62)),
			BIL_PAIR (BIL_VAL (0x6657c472), BIL_VAL (0x91980115)),
			BIL_PAIR (BIL_VAL (0x0428e8ba), BIL_VAL (0x62292d51)),
			BIL_PAIR (BIL_VAL (0x3f13e05b), BIL_VAL (0x3adaf585)),
			BIL_PAIR (BIL_VAL (0xb58306a4), BIL_VAL (0xf8d19ef3)),
			BIL_PAIR (BIL_VAL (0xd80b16e9), BIL_VAL (0xeee6d7e8)),
			BIL_PAIR (BIL_VAL (0x5fc08dd6), BIL_VAL (0xe65f01b3)),
			BIL_PAIR (BIL_VAL (0x9d8fa6aa), BIL_VAL (0x15365c80)),
			BIL_PAIR (BIL_VAL (0x26145450), BIL_VAL (0x5deea602)),
			BIL_PAIR (BIL_VAL (0x910e5850), BIL_VAL (0x473412d6))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xf6c38efa), BIL_VAL (0xdb6c5db4)),
			BIL_PAIR (BIL_VAL (0x0c514d2d), BIL_VAL (0x59f43e5f)),
			BIL_PAIR (BIL_VAL (0x249a5829), BIL_VAL (0x856b3e92)),
			BIL_PAIR (BIL_VAL (0xb7d35890), BIL_VAL (0xee1d9a4b)),
			BIL_PAIR (BIL_VAL (0x77b4ee05), BIL_VAL (0x371b6610)),
			BIL_PAIR (BIL_VAL (0x38705cc7), BIL_VAL (0xa4ca9e95)),
			BIL_PAIR (BIL_VAL (0x5c175abb), BIL_VAL (0x85c33f19)),
			BIL_PAIR (BIL_VAL (0xc2f2e569), BIL_VAL (0xf5ffcd9d)),
			BIL_PAIR (BIL_VAL (0x834ead3b), BIL_VAL (0x52ac077b)),
			BIL_PAIR (BIL_VAL (0x8e4c07d1), BIL_VAL (0x866fd4c3)),
			BIL_PAIR (BIL_VAL (0x3f0a8808), BIL_VAL (0x3ad0ef8a)),
			BIL_PAIR (BIL_VAL (0x0cc83fa1), BIL_VAL (0x25d598e4)),
			BIL_PAIR (BIL_VAL (0xc0d81c14), BIL_VAL (0x2ba0e06c)),
			BIL_PAIR (BIL_VAL (0xf51fbf2b), BIL_VAL (0xe17f395c)),
			BIL_PAIR (BIL_VAL (0x8999bee7), BIL_VAL (0x289a3d19))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x74f0fca3), BIL_VAL (0xcc18cb6a)),
			BIL_PAIR (BIL_VAL (0x095d8994), BIL_VAL (0x55915069)),
			BIL_PAIR (BIL_VAL (0x38388c4d), BIL_VAL (0x98b1a8e2)),
			BIL_PAIR (BIL_VAL (0x27ed41b0), BIL_VAL (0x9a6a3ab1)),
			BIL_PAIR (BIL_VAL (0x07725e84), BIL_VAL (0x700904bb)),
			BIL_PAIR (BIL_VAL (0x067133a7), BIL_VAL (0x0ab2c7de)),
			BIL_PAIR (BIL_VAL (0xae9a5201), BIL_VAL (0xb0706c12)),
			BIL_PAIR (BIL_VAL (0xa9740be6), BIL_VAL (0x95cb11bb)),
			BIL_PAIR (BIL_VAL (0x79ef1b1b), BIL_VAL (0xb990d5fb)),
			BIL_PAIR (BIL_VAL (0xc95a190d), BIL_VAL (0x4c1f9277)),
			BIL_PAIR (BIL_VAL (0xee227b7d), BIL_VAL (0xb6ca903e)),
			BIL_PAIR (BIL_VAL (0x8f70a8ac), BIL_VAL (0x5c6ee938)),
			BIL_PAIR (BIL_VAL (0xf218a25d), BIL_VAL (0x8a50278e)),
			BIL_PAIR (BIL_VAL (0x23fc60c8), BIL_VAL (0x46a90e78)),
			BIL_PAIR (BIL_VAL (0x648c04f5), BIL_VAL (0xf57d1e0c))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x689fd665), BIL_VAL (0x71bce824)),
			BIL_PAIR (BIL_VAL (0x5f8f1cf2), BIL_VAL (0xf38475b6)),
			BIL_PAIR (BIL_VAL (0x6c3c7ec9), BIL_VAL (0x4538912f)),
			BIL_PAIR (BIL_VAL (0x2ee877ca), BIL_VAL (0xaa9d1104)),
			BIL_PAIR (BIL_VAL (0xa730cc23), BIL_VAL (0x1907127d)),
			BIL_PAIR (BIL_VAL (0x5e7b42c2), BIL_VAL (0x6afcdf87)),
			BIL_PAIR (BIL_VAL (0xf4c1880f), BIL_VAL (0x3d98e658)),
			BIL_PAIR (BIL_VAL (0xfda08d04), BIL_VAL (0x7d4fe6fb)),
			BIL_PAIR (BIL_VAL (0xf4565473), BIL_VAL (0x028670a3)),
			BIL_PAIR (BIL_VAL (0xece04cb2), BIL_VAL (0x6d5a5140)),
			BIL_PAIR (BIL_VAL (0xda859f3f), BIL_VAL (0xec51a981)),
			BIL_PAIR (BIL_VAL (0x1961309b), BIL_VAL (0x05e1d3af)),
			BIL_PAIR (BIL_VAL (0xc6d4be87), BIL_VAL (0x82bc8f2f)),
			BIL_PAIR (BIL_VAL (0x56ac70e9), BIL_VAL (0x9d73bfc7)),
			BIL_PAIR (BIL_VAL (0x12160aba), BIL_VAL (0xfc279daa))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x857805a5), BIL_VAL (0x4380fbaa)),
			BIL_PAIR (BIL_VAL (0xbe82f9d6), BIL_VAL (0xf5bfcb64)),
			BIL_PAIR (BIL_VAL (0x47719264), BIL_VAL (0x35b0c2e6)),
			BIL_PAIR (BIL_VAL (0x5c7fec41), BIL_VAL (0x9c3768e3)),
			BIL_PAIR (BIL_VAL (0x3e3bd5fb), BIL_VAL (0x38bc3e5d)),
			BIL_PAIR (BIL_VAL (0x34d4f3ba), BIL_VAL (0xb29f110a)),
			BIL_PAIR (BIL_VAL (0x5e592e8c), BIL_VAL (0xa6c69d56)),
			BIL_PAIR (BIL_VAL (0xeb2e1b2a), BIL_VAL (0x2d9332d1)),
			BIL_PAIR (BIL_VAL (0x2137a169), BIL_VAL (0x878242a3)),
			BIL_PAIR (BIL_VAL (0x1a0492a4), BIL_VAL (0xbdc9de31)),
			BIL_PAIR (BIL_VAL (0x28a76ad6), BIL_VAL (0x44d29afa)),
			BIL_PAIR (BIL_VAL (0x153e9624), BIL_VAL (0x5e6f4e44)),
			BIL_PAIR (BIL_VAL (0xe8e29412), BIL_VAL (0x1859c55e)),
			BIL_PAIR (BIL_VAL (0x0e44968a), BIL_VAL (0xb24da705)),
			BIL_PAIR (BIL_VAL (0x3ceae3a1), BIL_VAL (0xaed83cb9))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x30a86acd), BIL_VAL (0xffcc2285)),
			BIL_PAIR (BIL_VAL (0x90dce19b), BIL_VAL (0x9c199dc1)),
			BIL_PAIR (BIL_VAL (0xbe880cec), BIL_VAL (0xc52750cf)),
			BIL_PAIR (BIL_VAL (0xc328856e), BIL_VAL (0xe3afa9ed)),
			BIL_PAIR (BIL_VAL (0xa7137ce3), BIL_VAL (0xe0501600)),
			BIL_PAIR (BIL_VAL (0x8022151a), BIL_VAL (0x2dc31a08)),
			BIL_PAIR (BIL_VAL (0xf901220a), BIL_VAL (0x99220a34)),
			BIL_PAIR (BIL_VAL (0x1692f79e), BIL_VAL (0x2813c945)),
			BIL_PAIR (BIL_VAL (0x1f825830), BIL_VAL (0x0096598e)),
			BIL_PAIR (BIL_VAL (0x0c154132), BIL_VAL (0xdb00c005)),
			BIL_PAIR (BIL_VAL (0x1cadc641), BIL_VAL (0x5883a620)),
			BIL_PAIR (BIL_VAL (0x2f26e4ea), BIL_VAL (0x18945888)),
			BIL_PAIR (BIL_VAL (0xe505ffd1), BIL_VAL (0xc823ebe7)),
			BIL_PAIR (BIL_VAL (0x4a1e6345), BIL_VAL (0x7046538e)),
			BIL_PAIR (BIL_VAL (0x34ba87b3), BIL_VAL (0x8e5f4e27))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xaf4d7c28), BIL_VAL (0x4a6ee0a0)),
			BIL_PAIR (BIL_VAL (0x03580a19), BIL_VAL (0x4eedc35e)),
			BIL_PAIR (BIL_VAL (0xb8add60a), BIL_VAL (0x31597e32)),
			BIL_PAIR (BIL_VAL (0x701cb142), BIL_VAL (0xa9dc6f2d)),
			BIL_PAIR (BIL_VAL (0x6558c1ab), BIL_VAL (0x478cffcf)),
			BIL_PAIR (BIL_VAL (0x3cc783a3), BIL_VAL (0xdb8e696a)),
			BIL_PAIR (BIL_VAL (0xfd03ec6f), BIL_VAL (0x5742987a)),
			BIL_PAIR (BIL_VAL (0x03c8b055), BIL_VAL (0x436e3d08)),
			BIL_PAIR (BIL_VAL (0xa48a857d), BIL_VAL (0xd18dd2c6)),
			BIL_PAIR (BIL_VAL (0xa29277ba), BIL_VAL (0xd2b2afc3)),
			BIL_PAIR (BIL_VAL (0x8a1963c2), BIL_VAL (0x9b6bda73)),
			BIL_PAIR (BIL_VAL (0x7f1974ac), BIL_VAL (0xc3a11a16)),
			BIL_PAIR (BIL_VAL (0x58d29915), BIL_VAL (0x5d14c454)),
			BIL_PAIR (BIL_VAL (0x542bb043), BIL_VAL (0x5b05cb25)),
			BIL_PAIR (BIL_VAL (0x4951333e), BIL_VAL (0x4c387095))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x6fbc8d86), BIL_VAL (0x298fda21)),
			BIL_PAIR (BIL_VAL (0x68bbf68a), BIL_VAL (0xa0982715)),
			BIL_PAIR (BIL_VAL (0xb06a75e4), BIL_VAL (0x20c87bf2)),
			BIL_PAIR (BIL_VAL (0xa9ab6fc3), BIL_VAL (0x4aa3e2a8)),
			BIL_PAIR (BIL_VAL (0x8d3a8f3d), BIL_VAL (0xa64bbe64)),
			BIL_PAIR (BIL_VAL (0x45ebf828), BIL_VAL (0x4ddca23c)),
			BIL_PAIR (BIL_VAL (0xfa5819be), BIL_VAL (0xd6a51541)),
			BIL_PAIR (BIL_VAL (0x96802289), BIL_VAL (0x061fb4ad)),
			BIL_PAIR (BIL_VAL (0x7b3965e8), BIL_VAL (0x36a7fd59)),
			BIL_PAIR (BIL_VAL (0x02320d2d), BIL_VAL (0x079dffbb)),
			BIL_PAIR (BIL_VAL (0x531add3a), BIL_VAL (0xa62ce433)),
			BIL_PAIR (BIL_VAL (0xfc550dc4), BIL_VAL (0x9eae49b5)),
			BIL_PAIR (BIL_VAL (0x1be766c2), BIL_VAL (0x63538568)),
			BIL_PAIR (BIL_VAL (0x3ba00603), BIL_VAL (0x29b6c45a)),
			BIL_PAIR (BIL_VAL (0xe38bceda), BIL_VAL (0xc0da63e5))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x6e5acc42), BIL_VAL (0xd44fe620)),
			BIL_PAIR (BIL_VAL (0x78f460aa), BIL_VAL (0x232c7a3f)),
			BIL_PAIR (BIL_VAL (0x35e87bec), BIL_VAL (0x90244273)),
			BIL_PAIR (BIL_VAL (0x09668bce), BIL_VAL (0x5f995e37)),
			BIL_PAIR (BIL_VAL (0xf8af85b2), BIL_VAL (0xeed6dca2)),
			BIL_PAIR (BIL_VAL (0x3d85a418), BIL_VAL (0xdf92bbe7)),
			BIL_PAIR (BIL_VAL (0x82cd7a94), BIL_VAL (0xd3714389)),
			BIL_PAIR (BIL_VAL (0xa38205e3), BIL_VAL (0x5c101afa)),
			BIL_PAIR (BIL_VAL (0xa66fd3cd), BIL_VAL (0xd0d66873)),
			BIL_PAIR (BIL_VAL (0x6eb82347), BIL_VAL (0x42fc81c3)),
			BIL_PAIR (BIL_VAL (0x1bd0d662), BIL_VAL (0x2e1afa37)),
			BIL_PAIR (BIL_VAL (0x5115612d), BIL_VAL (0x53b5cee2)),
			BIL_PAIR (BIL_VAL (0xb03c85c6), BIL_VAL (0x4ac311d8)),
			BIL_PAIR (BIL_VAL (0x4908573e), BIL_VAL (0x32e9e141)),
			BIL_PAIR (BIL_VAL (0x61a46a90), BIL_VAL (0xbde97339))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x1c23c7b6), BIL_VAL (0xf359df5c)),
			BIL_PAIR (BIL_VAL (0x9fce7d70), BIL_VAL (0x5aa28d3b)),
			BIL_PAIR (BIL_VAL (0x42f92afe), BIL_VAL (0xda0aaeb8)),
			BIL_PAIR (BIL_VAL (0xeeddc616), BIL_VAL (0x27867923)),
			BIL_PAIR (BIL_VAL (0x1aa03f21), BIL_VAL (0x48def2ea)),
			BIL_PAIR (BIL_VAL (0xa7f2ea80), BIL_VAL (0xe0eaecd0)),
			BIL_PAIR (BIL_VAL (0x284d69cd), BIL_VAL (0xe2b6cb71)),
			BIL_PAIR (BIL_VAL (0xf211d8e1), BIL_VAL (0x65d1131b)),
			BIL_PAIR (BIL_VAL (0x76c5f38c), BIL_VAL (0xacd1da0c)),
			BIL_PAIR (BIL_VAL (0xf873780b), BIL_VAL (0x502a4657)),
			BIL_PAIR (BIL_VAL (0x02f7083c), BIL_VAL (0xfc50768e)),
			BIL_PAIR (BIL_VAL (0xcad280d8), BIL_VAL (0x0c2fd094)),
			BIL_PAIR (BIL_VAL (0xf1225e0d), BIL_VAL (0x2ef10751)),
			BIL_PAIR (BIL_VAL (0x32c67f08), BIL_VAL (0x9da7e189)),
			BIL_PAIR (BIL_VAL (0x35413aff), BIL_VAL (0xd12bc27c))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x888ac652), BIL_VAL (0x3f20dd4c)),
			BIL_PAIR (BIL_VAL (0xa0854b12), BIL_VAL (0xfe80f887)),
			BIL_PAIR (BIL_VAL (0x35eb81e4), BIL_VAL (0xb340f758)),
			BIL_PAIR (BIL_VAL (0x617bce8f), BIL_VAL (0xb6badfc1)),
			BIL_PAIR (BIL_VAL (0xde6881c3), BIL_VAL (0x9d849ad7)),
			BIL_PAIR (BIL_VAL (0x7695a1eb), BIL_VAL (0xdc42c300)),
			BIL_PAIR (BIL_VAL (0xd6e0304a), BIL_VAL (0x8aa5b484)),
			BIL_PAIR (BIL_VAL (0xb0cf9037), BIL_VAL (0xa8f26ef4)),
			BIL_PAIR (BIL_VAL (0x66f8b022), BIL_VAL (0xfb699240)),
			BIL_PAIR (BIL_VAL (0x8f5bcc7c), BIL_VAL (0x6754ff70)),
			BIL_PAIR (BIL_VAL (0x83d12676), BIL_VAL (0x415e075d)),
			BIL_PAIR (BIL_VAL (0xf68c0beb), BIL_VAL (0xee399ddd)),
			BIL_PAIR (BIL_VAL (0x20af61de), BIL_VAL (0xe96b5097)),
			BIL_PAIR (BIL_VAL (0x732819fe), BIL_VAL (0x2e213507)),
			BIL_PAIR (BIL_VAL (0x7980e129), BIL_VAL (0xcc947259))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x86c6c4a5), BIL_VAL (0xb0a83c59)),
			BIL_PAIR (BIL_VAL (0x7451da67), BIL_VAL (0x748b1e42)),
			BIL_PAIR (BIL_VAL (0x72b63dae), BIL_VAL (0x845a7164)),
			BIL_PAIR (BIL_VAL (0x3b1ee8d1), BIL_VAL (0x112449b5)),
			BIL_PAIR (BIL_VAL (0x6628fb0b), BIL_VAL (0x0b1fdbea)),
			BIL_PAIR (BIL_VAL (0xbcc5b9b1), BIL_VAL (0x5a1771cf)),
			BIL_PAIR (BIL_VAL (0xa45a3923), BIL_VAL (0xebe20258)),
			BIL_PAIR (BIL_VAL (0xcd8e6fa2), BIL_VAL (0x2fdc050b)),
			BIL_PAIR (BIL_VAL (0x3323abac), BIL_VAL (0x81f1c603)),
			BIL_PAIR (BIL_VAL (0x8a277d96), BIL_VAL (0xbe1b64d3)),
			BIL_PAIR (BIL_VAL (0x0fdb1ec9), BIL_VAL (0x02f236e5)),
			BIL_PAIR (BIL_VAL (0x6297e059), BIL_VAL (0xff9b1c49)),
			BIL_PAIR (BIL_VAL (0x81ab0116), BIL_VAL (0x8557d004)),
			BIL_PAIR (BIL_VAL (0xe70b09e6), BIL_VAL (0x51b0d5ff)),
			BIL_PAIR (BIL_VAL (0x7fb0acf2), BIL_VAL (0xbafb2397))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x05c0888d), BIL_VAL (0x25512a50)),
			BIL_PAIR (BIL_VAL (0x7204fffd), BIL_VAL (0x4583a151)),
			BIL_PAIR (BIL_VAL (0x01056e0f), BIL_VAL (0x10f6176a)),
			BIL_PAIR (BIL_VAL (0xfda18615), BIL_VAL (0xa4103397)),
			BIL_PAIR (BIL_VAL (0xb119b33d), BIL_VAL (0xf4a0c422)),
			BIL_PAIR (BIL_VAL (0x4249adb7), BIL_VAL (0x8534981b)),
			BIL_PAIR (BIL_VAL (0x341fe960), BIL_VAL (0xc28eb015)),
			BIL_PAIR (BIL_VAL (0xbff6ab02), BIL_VAL (0x02e855bf)),
			BIL_PAIR (BIL_VAL (0x5956e080), BIL_VAL (0x06ecbb57)),
			BIL_PAIR (BIL_VAL (0xed03ee43), BIL_VAL (0xbda5fb81)),
			BIL_PAIR (BIL_VAL (0x0418e2af), BIL_VAL (0x5b67f484)),
			BIL_PAIR (BIL_VAL (0xcea6e916), BIL_VAL (0x91a74df1)),
			BIL_PAIR (BIL_VAL (0xd64c259e), BIL_VAL (0x80a83a19)),
			BIL_PAIR (BIL_VAL (0xfcad49f7), BIL_VAL (0xc7c617e5)),
			BIL_PAIR (BIL_VAL (0xf99f2ec6), BIL_VAL (0x366ea801))
			/* And implicit 5632 0 bits.  */)),
  /* 5888 */
  BIL_SET15 (BIL_SET4 (BIL_PAIR (BIL_VAL (0xb6), BIL_VAL (0x9c2f0f5f)),
		       BIL_PAIR (BIL_VAL (0x3a0b54df), BIL_VAL (0x874de552)),
		       BIL_PAIR (BIL_VAL (0xfc578936), BIL_VAL (0x3e72b00a)),
		       BIL_PAIR (BIL_VAL (0xe0f17bfc), BIL_VAL (0x86e27c0b))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xf3dfaed9), BIL_VAL (0x6c0195b2)),
			BIL_PAIR (BIL_VAL (0x670bc090), BIL_VAL (0x6095339b)),
			BIL_PAIR (BIL_VAL (0x3e504cf0), BIL_VAL (0xd2129fb6)),
			BIL_PAIR (BIL_VAL (0x53a4da9f), BIL_VAL (0xa13f3ccc)),
			BIL_PAIR (BIL_VAL (0x9347090e), BIL_VAL (0x24030512)),
			BIL_PAIR (BIL_VAL (0xfb20335a), BIL_VAL (0x345c18a9)),
			BIL_PAIR (BIL_VAL (0xdf61191b), BIL_VAL (0x4f7c601e)),
			BIL_PAIR (BIL_VAL (0xcc328739), BIL_VAL (0x90f87126)),
			BIL_PAIR (BIL_VAL (0xdf54b40c), BIL_VAL (0xbaed4e8a)),
			BIL_PAIR (BIL_VAL (0x267def57), BIL_VAL (0x357514bb)),
			BIL_PAIR (BIL_VAL (0x8160bf4b), BIL_VAL (0xb290ae76)),
			BIL_PAIR (BIL_VAL (0xe5e7f565), BIL_VAL (0x0661a615)),
			BIL_PAIR (BIL_VAL (0xe9c872eb), BIL_VAL (0xe4cc46cb)),
			BIL_PAIR (BIL_VAL (0x48dc9fb9), BIL_VAL (0x7c462050)),
			BIL_PAIR (BIL_VAL (0x429ed245), BIL_VAL (0xf1a07d84))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x7c07d157), BIL_VAL (0x1ee51f55)),
			BIL_PAIR (BIL_VAL (0xdff55caa), BIL_VAL (0x9cdd0227)),
			BIL_PAIR (BIL_VAL (0xbcf35566), BIL_VAL (0xe49968b2)),
			BIL_PAIR (BIL_VAL (0xfee6a274), BIL_VAL (0xcceae998)),
			BIL_PAIR (BIL_VAL (0xd2247dc6), BIL_VAL (0xc8bd26ef)),
			BIL_PAIR (BIL_VAL (0x274297cb), BIL_VAL (0xac8741d8)),
			BIL_PAIR (BIL_VAL (0xc6b3dd94), BIL_VAL (0x2ad0a509)),
			BIL_PAIR (BIL_VAL (0x903b8a53), BIL_VAL (0x9e022b6a)),
			BIL_PAIR (BIL_VAL (0x18870e45), BIL_VAL (0x7225b6aa)),
			BIL_PAIR (BIL_VAL (0x55a22483), BIL_VAL (0xe540b6c1)),
			BIL_PAIR (BIL_VAL (0xcc085e0b), BIL_VAL (0xf68253d8)),
			BIL_PAIR (BIL_VAL (0x4db686a3), BIL_VAL (0x6ae3ffe4)),
			BIL_PAIR (BIL_VAL (0x4009afc8), BIL_VAL (0x848ac80a)),
			BIL_PAIR (BIL_VAL (0xb62abbc6), BIL_VAL (0x4f248623)),
			BIL_PAIR (BIL_VAL (0xe26c3a47), BIL_VAL (0x7ec69732))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x822d819b), BIL_VAL (0x03e952dd)),
			BIL_PAIR (BIL_VAL (0x0d84b07c), BIL_VAL (0xc34e4257)),
			BIL_PAIR (BIL_VAL (0x88f5ecf4), BIL_VAL (0x0a84250b)),
			BIL_PAIR (BIL_VAL (0x7e5e5b84), BIL_VAL (0x0e026f69)),
			BIL_PAIR (BIL_VAL (0x144ec6cf), BIL_VAL (0x210d7864)),
			BIL_PAIR (BIL_VAL (0xc614d606), BIL_VAL (0xe93f0416)),
			BIL_PAIR (BIL_VAL (0x11f3860a), BIL_VAL (0x930fc0fa)),
			BIL_PAIR (BIL_VAL (0xe8f7422e), BIL_VAL (0xf03cc7b9)),
			BIL_PAIR (BIL_VAL (0x07f97237), BIL_VAL (0xe0683326)),
			BIL_PAIR (BIL_VAL (0x7941c334), BIL_VAL (0x8e33e751)),
			BIL_PAIR (BIL_VAL (0x55954fed), BIL_VAL (0x34b1ffa6)),
			BIL_PAIR (BIL_VAL (0x39752a67), BIL_VAL (0x496cc888)),
			BIL_PAIR (BIL_VAL (0xb9d11490), BIL_VAL (0x7989a821)),
			BIL_PAIR (BIL_VAL (0x2c6f4de1), BIL_VAL (0x35db807b)),
			BIL_PAIR (BIL_VAL (0x3a7ed38d), BIL_VAL (0x7cb22201))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xf507034d), BIL_VAL (0x53138333)),
			BIL_PAIR (BIL_VAL (0xd5ffe9d5), BIL_VAL (0xaac605fe)),
			BIL_PAIR (BIL_VAL (0x0de44db0), BIL_VAL (0x74f5bd09)),
			BIL_PAIR (BIL_VAL (0x26987a89), BIL_VAL (0x6c8117ef)),
			BIL_PAIR (BIL_VAL (0xdee29ed8), BIL_VAL (0x2487f78d)),
			BIL_PAIR (BIL_VAL (0x38ed3905), BIL_VAL (0x701d6f35)),
			BIL_PAIR (BIL_VAL (0xa2d2443d), BIL_VAL (0x9391ae60)),
			BIL_PAIR (BIL_VAL (0x1fe34152), BIL_VAL (0xadc680c9)),
			BIL_PAIR (BIL_VAL (0x56a49c7b), BIL_VAL (0xb1e317f6)),
			BIL_PAIR (BIL_VAL (0xdc87b300), BIL_VAL (0xa53afc1a)),
			BIL_PAIR (BIL_VAL (0x941331cb), BIL_VAL (0x8d1fd58d)),
			BIL_PAIR (BIL_VAL (0x086885f5), BIL_VAL (0x071dbdbf)),
			BIL_PAIR (BIL_VAL (0xaf6582e4), BIL_VAL (0xe58e508e)),
			BIL_PAIR (BIL_VAL (0xc9df47c5), BIL_VAL (0x4b7a4143)),
			BIL_PAIR (BIL_VAL (0x0eaa28a5), BIL_VAL (0x98ed0d93))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xbcb1297f), BIL_VAL (0x1cbb01b1)),
			BIL_PAIR (BIL_VAL (0x655bd5a7), BIL_VAL (0x578e33a3)),
			BIL_PAIR (BIL_VAL (0x1037cd98), BIL_VAL (0xc42bba93)),
			BIL_PAIR (BIL_VAL (0x4e8b638a), BIL_VAL (0xade264a4)),
			BIL_PAIR (BIL_VAL (0x737fe90b), BIL_VAL (0xf99da471)),
			BIL_PAIR (BIL_VAL (0x7c7dcbe4), BIL_VAL (0xb9474906)),
			BIL_PAIR (BIL_VAL (0xf8041016), BIL_VAL (0xec620e0c)),
			BIL_PAIR (BIL_VAL (0x0af21946), BIL_VAL (0x5a8d2d6c)),
			BIL_PAIR (BIL_VAL (0xb9d814cd), BIL_VAL (0xc6010de4)),
			BIL_PAIR (BIL_VAL (0xe0281f62), BIL_VAL (0x3103cc37)),
			BIL_PAIR (BIL_VAL (0xab4d633e), BIL_VAL (0x10739577)),
			BIL_PAIR (BIL_VAL (0x0853f0dc), BIL_VAL (0x3e7ad4ab)),
			BIL_PAIR (BIL_VAL (0x0d175489), BIL_VAL (0x21f60a63)),
			BIL_PAIR (BIL_VAL (0x44ab0113), BIL_VAL (0x64548d71)),
			BIL_PAIR (BIL_VAL (0x3c057901), BIL_VAL (0xaa8003bf))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x2660df28), BIL_VAL (0x88c4bb58)),
			BIL_PAIR (BIL_VAL (0x3e870811), BIL_VAL (0xdab6a814)),
			BIL_PAIR (BIL_VAL (0x34d7bf36), BIL_VAL (0x6e40c2dc)),
			BIL_PAIR (BIL_VAL (0xbb63038c), BIL_VAL (0xc767b4f8)),
			BIL_PAIR (BIL_VAL (0x1c4bd559), BIL_VAL (0x26297872)),
			BIL_PAIR (BIL_VAL (0x43843e1c), BIL_VAL (0x49641d35)),
			BIL_PAIR (BIL_VAL (0x7f51664c), BIL_VAL (0xdc063fa6)),
			BIL_PAIR (BIL_VAL (0xa686f12b), BIL_VAL (0x29b55e60)),
			BIL_PAIR (BIL_VAL (0x75842790), BIL_VAL (0x5ffad9c1)),
			BIL_PAIR (BIL_VAL (0x6c01d6d8), BIL_VAL (0xa11f5efb)),
			BIL_PAIR (BIL_VAL (0x9f54ce6f), BIL_VAL (0xd7becaa8)),
			BIL_PAIR (BIL_VAL (0xc8177d7d), BIL_VAL (0x2ef9f79a)),
			BIL_PAIR (BIL_VAL (0x89701cb6), BIL_VAL (0x9e7789c2)),
			BIL_PAIR (BIL_VAL (0x0a681df5), BIL_VAL (0x80966623)),
			BIL_PAIR (BIL_VAL (0xf908416a), BIL_VAL (0xca315df5))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x4cc3f685), BIL_VAL (0xbc3e29d5)),
			BIL_PAIR (BIL_VAL (0x5a19e272), BIL_VAL (0x62318fdc)),
			BIL_PAIR (BIL_VAL (0xb91fa145), BIL_VAL (0x3efe94d0)),
			BIL_PAIR (BIL_VAL (0xf3abea58), BIL_VAL (0x892cf5c6)),
			BIL_PAIR (BIL_VAL (0xcf22ae77), BIL_VAL (0x7d8654c2)),
			BIL_PAIR (BIL_VAL (0x4696946c), BIL_VAL (0x68108d91)),
			BIL_PAIR (BIL_VAL (0xb29a59e4), BIL_VAL (0xf21ff450)),
			BIL_PAIR (BIL_VAL (0xd13a0c2b), BIL_VAL (0xfb4a382d)),
			BIL_PAIR (BIL_VAL (0x043435c9), BIL_VAL (0x51b3d2e9)),
			BIL_PAIR (BIL_VAL (0x2197efb1), BIL_VAL (0xb3d8f782)),
			BIL_PAIR (BIL_VAL (0xeedab9aa), BIL_VAL (0x1c522eb7)),
			BIL_PAIR (BIL_VAL (0xe9099ec8), BIL_VAL (0x95964edb)),
			BIL_PAIR (BIL_VAL (0xffd4362e), BIL_VAL (0x3642c206)),
			BIL_PAIR (BIL_VAL (0x49fa105b), BIL_VAL (0xf08e21ec)),
			BIL_PAIR (BIL_VAL (0x7e5aadcb), BIL_VAL (0x7756d510))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x7bbcdcda), BIL_VAL (0xb5cacc68)),
			BIL_PAIR (BIL_VAL (0x7006e753), BIL_VAL (0x3ce15400)),
			BIL_PAIR (BIL_VAL (0x63490c5f), BIL_VAL (0x5593b7b7)),
			BIL_PAIR (BIL_VAL (0x6bd1be87), BIL_VAL (0xde2e3312)),
			BIL_PAIR (BIL_VAL (0x13b3d979), BIL_VAL (0x05cadc60)),
			BIL_PAIR (BIL_VAL (0x948df4eb), BIL_VAL (0xed35a8a9)),
			BIL_PAIR (BIL_VAL (0x07ee724d), BIL_VAL (0x6b8e0594)),
			BIL_PAIR (BIL_VAL (0xc0637779), BIL_VAL (0xb52fbb65)),
			BIL_PAIR (BIL_VAL (0x55507351), BIL_VAL (0xff5aa2ce)),
			BIL_PAIR (BIL_VAL (0xeaaef2c8), BIL_VAL (0x82412ce1)),
			BIL_PAIR (BIL_VAL (0x83117aed), BIL_VAL (0xa0a6348d)),
			BIL_PAIR (BIL_VAL (0x70ba9721), BIL_VAL (0xd6e90d79)),
			BIL_PAIR (BIL_VAL (0x6c516598), BIL_VAL (0x73210902)),
			BIL_PAIR (BIL_VAL (0x5650acc4), BIL_VAL (0x9eb28adc)),
			BIL_PAIR (BIL_VAL (0x23205b36), BIL_VAL (0xdb55eec0))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x3fdba800), BIL_VAL (0x64744377)),
			BIL_PAIR (BIL_VAL (0x8f9e58c0), BIL_VAL (0x165ec14e)),
			BIL_PAIR (BIL_VAL (0x7581b624), BIL_VAL (0xfa8e889f)),
			BIL_PAIR (BIL_VAL (0x0a9fb9ca), BIL_VAL (0x73ad2ea8)),
			BIL_PAIR (BIL_VAL (0xea017cd4), BIL_VAL (0xa0c0f9ac)),
			BIL_PAIR (BIL_VAL (0x247dc112), BIL_VAL (0x2f84312b)),
			BIL_PAIR (BIL_VAL (0xf3042144), BIL_VAL (0xf3d15c68)),
			BIL_PAIR (BIL_VAL (0x0ce9312d), BIL_VAL (0x3c5f786d)),
			BIL_PAIR (BIL_VAL (0xf175a825), BIL_VAL (0xe120ccbc)),
			BIL_PAIR (BIL_VAL (0xfb8f9110), BIL_VAL (0x0b9f1e61)),
			BIL_PAIR (BIL_VAL (0xac706bd5), BIL_VAL (0x4268448c)),
			BIL_PAIR (BIL_VAL (0xcc01efd7), BIL_VAL (0x761d89e4)),
			BIL_PAIR (BIL_VAL (0xcddbe060), BIL_VAL (0x4125b5bb)),
			BIL_PAIR (BIL_VAL (0x8838be28), BIL_VAL (0x986d5971)),
			BIL_PAIR (BIL_VAL (0xb31ab06e), BIL_VAL (0x6b56b12a))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x2bd1a7dc), BIL_VAL (0xd70a422f)),
			BIL_PAIR (BIL_VAL (0xc441e54c), BIL_VAL (0xe6fc9564)),
			BIL_PAIR (BIL_VAL (0xbea0d95e), BIL_VAL (0x8982a21f)),
			BIL_PAIR (BIL_VAL (0xa4bbb914), BIL_VAL (0x6591cd1d)),
			BIL_PAIR (BIL_VAL (0xf0aab4fd), BIL_VAL (0x20e6c665)),
			BIL_PAIR (BIL_VAL (0xfa617aa8), BIL_VAL (0x8c7055dc)),
			BIL_PAIR (BIL_VAL (0xb4571d53), BIL_VAL (0xdc6c4284)),
			BIL_PAIR (BIL_VAL (0xaeb4e341), BIL_VAL (0xa75559ea)),
			BIL_PAIR (BIL_VAL (0x20e9de7f), BIL_VAL (0x9d85fb46)),
			BIL_PAIR (BIL_VAL (0xc08d351b), BIL_VAL (0x9a9b9444)),
			BIL_PAIR (BIL_VAL (0x59f76be6), BIL_VAL (0xc778ccfb)),
			BIL_PAIR (BIL_VAL (0x156f11cc), BIL_VAL (0x189cb45a)),
			BIL_PAIR (BIL_VAL (0x199e5556), BIL_VAL (0x33f6ad26)),
			BIL_PAIR (BIL_VAL (0x4639ff60), BIL_VAL (0x553244de)),
			BIL_PAIR (BIL_VAL (0x30803502), BIL_VAL (0x64667fad))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0x25372141), BIL_VAL (0x79053f93)),
			BIL_PAIR (BIL_VAL (0x5e108092), BIL_VAL (0x46d82e10)),
			BIL_PAIR (BIL_VAL (0x5fc07c0f), BIL_VAL (0xa9b7cf87)),
			BIL_PAIR (BIL_VAL (0x592e9739), BIL_VAL (0x0c0df6a8)),
			BIL_PAIR (BIL_VAL (0x8d2c8c6a), BIL_VAL (0xa7e79970)),
			BIL_PAIR (BIL_VAL (0x5f0f0d6e), BIL_VAL (0xfed62b13)),
			BIL_PAIR (BIL_VAL (0xb5d793eb), BIL_VAL (0xfcff5102)),
			BIL_PAIR (BIL_VAL (0x75deb1df), BIL_VAL (0xa73466cb)),
			BIL_PAIR (BIL_VAL (0x18e3ce4e), BIL_VAL (0x97d128f4)),
			BIL_PAIR (BIL_VAL (0xccfc82d5), BIL_VAL (0x9f60906d)),
			BIL_PAIR (BIL_VAL (0x14817167), BIL_VAL (0x8b51fff1)),
			BIL_PAIR (BIL_VAL (0xe358ea51), BIL_VAL (0x278265cd)),
			BIL_PAIR (BIL_VAL (0xbb2612ac), BIL_VAL (0x5d04f567)),
			BIL_PAIR (BIL_VAL (0x90f464b3), BIL_VAL (0x96343904)),
			BIL_PAIR (BIL_VAL (0x6e951de7), BIL_VAL (0xe1c854e1))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xc072efcb), BIL_VAL (0x6540c04a)),
			BIL_PAIR (BIL_VAL (0x5e4c8689), BIL_VAL (0x08b72393)),
			BIL_PAIR (BIL_VAL (0x308cfe4c), BIL_VAL (0xca4c36d5)),
			BIL_PAIR (BIL_VAL (0xc1a27b0f), BIL_VAL (0x9e4784e0)),
			BIL_PAIR (BIL_VAL (0x14055fa5), BIL_VAL (0x67c1af07)),
			BIL_PAIR (BIL_VAL (0x70ccc621), BIL_VAL (0xedb456cb)),
			BIL_PAIR (BIL_VAL (0x9a107e0e), BIL_VAL (0xae4b6cad)),
			BIL_PAIR (BIL_VAL (0x728839e2), BIL_VAL (0x07f6cea4)),
			BIL_PAIR (BIL_VAL (0xfc6c5347), BIL_VAL (0x77fc3b96)),
			BIL_PAIR (BIL_VAL (0xabdf4309), BIL_VAL (0xc5987182)),
			BIL_PAIR (BIL_VAL (0xb54a823d), BIL_VAL (0x227d572c)),
			BIL_PAIR (BIL_VAL (0x6f6b0d97), BIL_VAL (0x97fdd78f)),
			BIL_PAIR (BIL_VAL (0x86caba74), BIL_VAL (0xbfa00e2b)),
			BIL_PAIR (BIL_VAL (0xb0e7b9cf), BIL_VAL (0x21b9234e)),
			BIL_PAIR (BIL_VAL (0x4cbd1e95), BIL_VAL (0x55951cfb))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xba719851), BIL_VAL (0xcfe084b3)),
			BIL_PAIR (BIL_VAL (0x874bb9dc), BIL_VAL (0x1903f99e)),
			BIL_PAIR (BIL_VAL (0x932aaf77), BIL_VAL (0x83bf173f)),
			BIL_PAIR (BIL_VAL (0x0acf46e1), BIL_VAL (0xbe903963)),
			BIL_PAIR (BIL_VAL (0x78eb625b), BIL_VAL (0xed21681e)),
			BIL_PAIR (BIL_VAL (0x299cd37b), BIL_VAL (0xe3ad7362)),
			BIL_PAIR (BIL_VAL (0x756e7c09), BIL_VAL (0x78c9ed55)),
			BIL_PAIR (BIL_VAL (0xae4a1aa8), BIL_VAL (0x5e13fd5c)),
			BIL_PAIR (BIL_VAL (0x8ea27de1), BIL_VAL (0x973e8da1)),
			BIL_PAIR (BIL_VAL (0x478f96dc), BIL_VAL (0xb29a6212)),
			BIL_PAIR (BIL_VAL (0xc2854b84), BIL_VAL (0xc56bfa1a)),
			BIL_PAIR (BIL_VAL (0x16dc5087), BIL_VAL (0xbba76d21)),
			BIL_PAIR (BIL_VAL (0x12388c0c), BIL_VAL (0x30efce8d)),
			BIL_PAIR (BIL_VAL (0xf5d11211), BIL_VAL (0x0a6b1d70)),
			BIL_PAIR (BIL_VAL (0xb3a6922e), BIL_VAL (0x60d69e6e))),
	     BIL_SET15 (BIL_PAIR (BIL_VAL (0xcb79b7bd), BIL_VAL (0xee9d39a4)),
			BIL_PAIR (BIL_VAL (0xa024daaa), BIL_VAL (0x9ec4b538)),
			BIL_PAIR (BIL_VAL (0x74fee300), BIL_VAL (0x9b187c38)),
			BIL_PAIR (BIL_VAL (0x0fa4d2e1), BIL_VAL (0xc1787658)),
			BIL_PAIR (BIL_VAL (0x6b271020), BIL_VAL (0x0f8b4bb9)),
			BIL_PAIR (BIL_VAL (0xc17559de), BIL_VAL (0xc3891a38)),
			BIL_PAIR (BIL_VAL (0xf2d0fe6d), BIL_VAL (0xe4749dcb)),
			BIL_PAIR (BIL_VAL (0x5066ba0f), BIL_VAL (0x9228562b)),
			BIL_PAIR (BIL_VAL (0x5975dec4), BIL_VAL (0xf279385b)),
			BIL_PAIR (BIL_VAL (0x5a191ac9), BIL_VAL (0xc41800e9)),
			BIL_PAIR (BIL_VAL (0xb01d9559), BIL_VAL (0xb96aee41)),
			BIL_PAIR (BIL_VAL (0x4c1f6ff9), BIL_VAL (0x86032047)),
			BIL_PAIR (BIL_VAL (0xee0377c1), BIL_VAL (0xa4c8af03)),
			BIL_PAIR (BIL_VAL (0xfba3b3f9), BIL_VAL (0x22606fb0)),
			BIL_PAIR (BIL_VAL (0x16f7ec21), BIL_VAL (0x97fd2401))
			/* And implicit 5888 0 bits.  */))
};

static unsigned short pow10_offs[] = {
  /* 0 */ BIL_OFF (0, 0),
  /* 1 */ BIL_OFF (1, 1),
  /* 2 */ BIL_OFF (2, 2),
  /* 3 */ BIL_OFF (3, 3),
  /* 4 */ BIL_OFF (4, 4),
  /* 5 */ BIL_OFF (5, 5),
  /* 6 */ BIL_OFF (6, 6),
  /* 7 */ BIL_OFF (7, 7),
  /* 8 */ BIL_OFF (8, 8),
  /* 9 */ BIL_OFF (9, 9),
  /* 10 */ BIL_OFF (10, 10),
  /* 11 */ BIL_OFF (11, 12),
  /* 12 */ BIL_OFF (12, 14),
  /* 13 */ BIL_OFF (13, 16),
  /* 14 */ BIL_OFF (14, 18),
  /* 15 */ BIL_OFF (15, 20),
  /* 16 */ BIL_OFF (16, 22),
  /* 17 */ BIL_OFF (17, 24),
  /* 18 */ BIL_OFF (18, 26),
  /* 19 */ BIL_OFF (19, 28),
  /* 20 */ BIL_OFF (20, 30),
  /* 21 */ BIL_OFF (22, 33),
  /* 22 */ BIL_OFF (24, 36),
  /* 23 */ BIL_OFF (26, 39),
  /* 24 */ BIL_OFF (28, 42),
  /* 25 */ BIL_OFF (30, 45),
  /* 26 */ BIL_OFF (32, 48),
  /* 27 */ BIL_OFF (34, 51),
  /* 28 */ BIL_OFF (36, 54),
  /* 29 */ BIL_OFF (38, 57),
  /* 30 */ BIL_OFF (40, 61),
  /* 31 */ BIL_OFF (42, 65),
  /* 32 */ BIL_OFF (44, 69),
  /* 33 */ BIL_OFF (46, 73),
  /* 34 */ BIL_OFF (48, 77),
  /* 35 */ BIL_OFF (50, 81),
  /* 36 */ BIL_OFF (52, 85),
  /* 37 */ BIL_OFF (54, 89),
  /* 38 */ BIL_OFF (56, 93),
  /* 39 */ BIL_OFF (58, 97),
  /* 40 */ BIL_OFF (61, 102),
  /* 41 */ BIL_OFF (64, 107),
  /* 42 */ BIL_OFF (67, 112),
  /* 43 */ BIL_OFF (70, 117),
  /* 44 */ BIL_OFF (73, 122),
  /* 45 */ BIL_OFF (76, 127),
  /* 46 */ BIL_OFF (79, 132),
  /* 47 */ BIL_OFF (82, 137),
  /* 48 */ BIL_OFF (85, 142),
  /* 49 */ BIL_OFF (88, 147),
  /* 50 */ BIL_OFF (91, 153),
  /* 51 */ BIL_OFF (94, 159),
  /* 52 */ BIL_OFF (97, 165),
  /* 53 */ BIL_OFF (100, 171),
  /* 54 */ BIL_OFF (103, 177),
  /* 55 */ BIL_OFF (106, 183),
  /* 56 */ BIL_OFF (109, 189),
  /* 57 */ BIL_OFF (112, 195),
  /* 58 */ BIL_OFF (115, 201),
  /* 59 */ BIL_OFF (119, 208),
  /* 60 */ BIL_OFF (123, 215),
  /* 61 */ BIL_OFF (127, 222),
  /* 62 */ BIL_OFF (131, 229),
  /* 63 */ BIL_OFF (135, 236),
  /* 64 */ BIL_OFF (139, 243),
  /* 65 */ BIL_OFF (142, 248),
  /* 66 */ BIL_OFF (145, 253),
  /* 67 */ BIL_OFF (148, 258),
  /* 68 */ BIL_OFF (151, 263),
  /* 69 */ BIL_OFF (154, 269),
  /* 70 */ BIL_OFF (157, 275),
  /* 71 */ BIL_OFF (160, 281),
  /* 72 */ BIL_OFF (163, 287),
  /* 73 */ BIL_OFF (166, 293),
  /* 74 */ BIL_OFF (169, 299),
  /* 75 */ BIL_OFF (172, 305),
  /* 76 */ BIL_OFF (175, 311),
  /* 77 */ BIL_OFF (178, 317),
  /* 78 */ BIL_OFF (181, 323),
  /* 79 */ BIL_OFF (185, 330),
  /* 80 */ BIL_OFF (189, 337),
  /* 81 */ BIL_OFF (193, 344),
  /* 82 */ BIL_OFF (197, 351),
  /* 83 */ BIL_OFF (201, 358),
  /* 84 */ BIL_OFF (205, 365),
  /* 85 */ BIL_OFF (209, 372),
  /* 86 */ BIL_OFF (213, 379),
  /* 87 */ BIL_OFF (217, 386),
  /* 88 */ BIL_OFF (221, 394),
  /* 89 */ BIL_OFF (225, 402),
  /* 90 */ BIL_OFF (229, 410),
  /* 91 */ BIL_OFF (233, 418),
  /* 92 */ BIL_OFF (237, 426),
  /* 93 */ BIL_OFF (241, 434),
  /* 94 */ BIL_OFF (245, 442),
  /* 95 */ BIL_OFF (249, 450),
  /* 96 */ BIL_OFF (253, 458),
  /* 97 */ BIL_OFF (257, 466),
  /* 98 */ BIL_OFF (262, 475),
  /* 99 */ BIL_OFF (267, 484),
  /* 100 */ BIL_OFF (272, 493),
  /* 101 */ BIL_OFF (277, 502),
  /* 102 */ BIL_OFF (282, 511),
  /* 103 */ BIL_OFF (287, 520),
  /* 104 */ BIL_OFF (292, 529),
  /* 105 */ BIL_OFF (297, 538),
  /* 106 */ BIL_OFF (302, 547),
  /* 107 */ BIL_OFF (307, 557),
  /* 108 */ BIL_OFF (312, 567),
  /* 109 */ BIL_OFF (317, 577),
  /* 110 */ BIL_OFF (322, 587),
  /* 111 */ BIL_OFF (327, 597),
  /* 112 */ BIL_OFF (332, 607),
  /* 113 */ BIL_OFF (337, 617),
  /* 114 */ BIL_OFF (342, 627),
  /* 115 */ BIL_OFF (347, 637),
  /* 116 */ BIL_OFF (352, 647),
  /* 117 */ BIL_OFF (358, 658),
  /* 118 */ BIL_OFF (364, 669),
  /* 119 */ BIL_OFF (370, 680),
  /* 120 */ BIL_OFF (376, 691),
  /* 121 */ BIL_OFF (382, 702),
  /* 122 */ BIL_OFF (388, 713),
  /* 123 */ BIL_OFF (394, 724),
  /* 124 */ BIL_OFF (400, 735),
  /* 125 */ BIL_OFF (406, 746),
  /* 126 */ BIL_OFF (412, 757),
  /* 127 */ BIL_OFF (418, 769),
  /* 128 */ BIL_OFF (424, 781),
  /* 129 */ BIL_OFF (429, 791),
  /* 130 */ BIL_OFF (434, 801),
  /* 131 */ BIL_OFF (439, 811),
  /* 132 */ BIL_OFF (444, 821),
  /* 133 */ BIL_OFF (449, 831),
  /* 134 */ BIL_OFF (454, 841),
  /* 135 */ BIL_OFF (459, 851),
  /* 136 */ BIL_OFF (465, 862),
  /* 137 */ BIL_OFF (471, 873),
  /* 138 */ BIL_OFF (477, 884),
  /* 139 */ BIL_OFF (483, 895),
  /* 140 */ BIL_OFF (489, 906),
  /* 141 */ BIL_OFF (495, 917),
  /* 142 */ BIL_OFF (501, 928),
  /* 143 */ BIL_OFF (507, 939),
  /* 144 */ BIL_OFF (513, 950),
  /* 145 */ BIL_OFF (519, 961),
  /* 146 */ BIL_OFF (525, 973),
  /* 147 */ BIL_OFF (531, 985),
  /* 148 */ BIL_OFF (537, 997),
  /* 149 */ BIL_OFF (543, 1009),
  /* 150 */ BIL_OFF (549, 1021),
  /* 151 */ BIL_OFF (555, 1033),
  /* 152 */ BIL_OFF (561, 1045),
  /* 153 */ BIL_OFF (567, 1057),
  /* 154 */ BIL_OFF (573, 1069),
  /* 155 */ BIL_OFF (579, 1081),
  /* 156 */ BIL_OFF (586, 1094),
  /* 157 */ BIL_OFF (593, 1107),
  /* 158 */ BIL_OFF (600, 1120),
  /* 159 */ BIL_OFF (607, 1133),
  /* 160 */ BIL_OFF (614, 1146),
  /* 161 */ BIL_OFF (621, 1159),
  /* 162 */ BIL_OFF (628, 1172),
  /* 163 */ BIL_OFF (635, 1185),
  /* 164 */ BIL_OFF (642, 1198),
  /* 165 */ BIL_OFF (649, 1212),
  /* 166 */ BIL_OFF (656, 1226),
  /* 167 */ BIL_OFF (663, 1240),
  /* 168 */ BIL_OFF (670, 1254),
  /* 169 */ BIL_OFF (677, 1268),
  /* 170 */ BIL_OFF (684, 1282),
  /* 171 */ BIL_OFF (691, 1296),
  /* 172 */ BIL_OFF (698, 1310),
  /* 173 */ BIL_OFF (705, 1324),
  /* 174 */ BIL_OFF (712, 1338),
  /* 175 */ BIL_OFF (720, 1353),
  /* 176 */ BIL_OFF (728, 1368),
  /* 177 */ BIL_OFF (736, 1383),
  /* 178 */ BIL_OFF (744, 1398),
  /* 179 */ BIL_OFF (752, 1413),
  /* 180 */ BIL_OFF (760, 1428),
  /* 181 */ BIL_OFF (768, 1443),
  /* 182 */ BIL_OFF (776, 1458),
  /* 183 */ BIL_OFF (784, 1473),
  /* 184 */ BIL_OFF (792, 1488),
  /* 185 */ BIL_OFF (800, 1504),
  /* 186 */ BIL_OFF (808, 1520),
  /* 187 */ BIL_OFF (816, 1536),
  /* 188 */ BIL_OFF (824, 1552),
  /* 189 */ BIL_OFF (832, 1568),
  /* 190 */ BIL_OFF (840, 1584),
  /* 191 */ BIL_OFF (848, 1600),
  /* 192 */ BIL_OFF (856, 1616),
  /* 193 */ BIL_OFF (863, 1630),
  /* 194 */ BIL_OFF (871, 1645),
  /* 195 */ BIL_OFF (879, 1660),
  /* 196 */ BIL_OFF (887, 1675),
  /* 197 */ BIL_OFF (895, 1690),
  /* 198 */ BIL_OFF (903, 1705),
  /* 199 */ BIL_OFF (911, 1720),
  /* 200 */ BIL_OFF (919, 1735),
  /* 201 */ BIL_OFF (927, 1750),
  /* 202 */ BIL_OFF (935, 1765),
  /* 203 */ BIL_OFF (943, 1780),
  /* 204 */ BIL_OFF (951, 1796),
  /* 205 */ BIL_OFF (959, 1812),
  /* 206 */ BIL_OFF (967, 1828),
  /* 207 */ BIL_OFF (975, 1844),
  /* 208 */ BIL_OFF (983, 1860),
  /* 209 */ BIL_OFF (991, 1876),
  /* 210 */ BIL_OFF (999, 1892),
  /* 211 */ BIL_OFF (1007, 1908),
  /* 212 */ BIL_OFF (1015, 1924),
  /* 213 */ BIL_OFF (1024, 1941),
  /* 214 */ BIL_OFF (1033, 1958),
  /* 215 */ BIL_OFF (1042, 1975),
  /* 216 */ BIL_OFF (1051, 1992),
  /* 217 */ BIL_OFF (1060, 2009),
  /* 218 */ BIL_OFF (1069, 2026),
  /* 219 */ BIL_OFF (1078, 2043),
  /* 220 */ BIL_OFF (1087, 2060),
  /* 221 */ BIL_OFF (1096, 2077),
  /* 222 */ BIL_OFF (1105, 2094),
  /* 223 */ BIL_OFF (1114, 2112),
  /* 224 */ BIL_OFF (1123, 2130),
  /* 225 */ BIL_OFF (1132, 2148),
  /* 226 */ BIL_OFF (1141, 2166),
  /* 227 */ BIL_OFF (1150, 2184),
  /* 228 */ BIL_OFF (1159, 2202),
  /* 229 */ BIL_OFF (1168, 2220),
  /* 230 */ BIL_OFF (1177, 2238),
  /* 231 */ BIL_OFF (1186, 2256),
  /* 232 */ BIL_OFF (1195, 2274),
  /* 233 */ BIL_OFF (1205, 2293),
  /* 234 */ BIL_OFF (1215, 2312),
  /* 235 */ BIL_OFF (1225, 2331),
  /* 236 */ BIL_OFF (1235, 2350),
  /* 237 */ BIL_OFF (1245, 2369),
  /* 238 */ BIL_OFF (1255, 2388),
  /* 239 */ BIL_OFF (1265, 2407),
  /* 240 */ BIL_OFF (1275, 2426),
  /* 241 */ BIL_OFF (1285, 2445),
  /* 242 */ BIL_OFF (1295, 2465),
  /* 243 */ BIL_OFF (1305, 2485),
  /* 244 */ BIL_OFF (1315, 2505),
  /* 245 */ BIL_OFF (1325, 2525),
  /* 246 */ BIL_OFF (1335, 2545),
  /* 247 */ BIL_OFF (1345, 2565),
  /* 248 */ BIL_OFF (1355, 2585),
  /* 249 */ BIL_OFF (1365, 2605),
  /* 250 */ BIL_OFF (1375, 2625),
  /* 251 */ BIL_OFF (1385, 2645),
  /* 252 */ BIL_OFF (1396, 2666),
  /* 253 */ BIL_OFF (1407, 2687),
  /* 254 */ BIL_OFF (1418, 2708),
  /* 255 */ BIL_OFF (1429, 2729),
  /* 256 */ BIL_OFF (1440, 2750),
  /* 512 */ BIL_OFF (1450, 2769),
  /* 768 */ BIL_OFF (1469, 2807),
  /* 1024 */ BIL_OFF (1497, 2863),
  /* 1280 */ BIL_OFF (1535, 2938),
  /* 1536 */ BIL_OFF (1582, 3031),
  /* 1792 */ BIL_OFF (1638, 3143),
  /* 2048 */ BIL_OFF (1704, 3274),
  /* 2304 */ BIL_OFF (1779, 3423),
  /* 2560 */ BIL_OFF (1863, 3591),
  /* 2816 */ BIL_OFF (1956, 3777),
  /* 3072 */ BIL_OFF (2059, 3982),
  /* 3328 */ BIL_OFF (2171, 4205),
  /* 3584 */ BIL_OFF (2292, 4447),
  /* 3840 */ BIL_OFF (2423, 4708),
  /* 4096 */ BIL_OFF (2563, 4987),
  /* 4352 */ BIL_OFF (2712, 5285),
  /* 4608 */ BIL_OFF (2870, 5601),
  /* 4864 */ BIL_OFF (3038, 5936),
  /* 5120 */ BIL_OFF (3215, 6289),
  /* 5376 */ BIL_OFF (3401, 6661),
  /* 5632 */ BIL_OFF (3597, 7052),
  /* 5888 */ BIL_OFF (3802, 7461),
  /* End */ BIL_OFF (4016, 7889)
};
