/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;

class WindowsSecurity {
    static final long processTokenWithDuplicateAccess = WindowsSecurity.openProcessToken(2);
    static final long processTokenWithQueryAccess = WindowsSecurity.openProcessToken(8);

    private WindowsSecurity() {
    }

    private static long openProcessToken(int n) {
        try {
            return WindowsNativeDispatcher.OpenProcessToken(WindowsNativeDispatcher.GetCurrentProcess(), n);
        }
        catch (WindowsException windowsException) {
            return 0L;
        }
    }

    static Privilege enablePrivilege(String string) {
        long l;
        try {
            l = WindowsNativeDispatcher.LookupPrivilegeValue(string);
        }
        catch (WindowsException windowsException) {
            throw new AssertionError((Object)windowsException);
        }
        long l2 = 0L;
        boolean bl = false;
        boolean bl2 = false;
        try {
            l2 = WindowsNativeDispatcher.OpenThreadToken(WindowsNativeDispatcher.GetCurrentThread(), 32, false);
            if (l2 == 0L && processTokenWithDuplicateAccess != 0L) {
                l2 = WindowsNativeDispatcher.DuplicateTokenEx(processTokenWithDuplicateAccess, 36);
                WindowsNativeDispatcher.SetThreadToken(0L, l2);
                bl = true;
            }
            if (l2 != 0L) {
                WindowsNativeDispatcher.AdjustTokenPrivileges(l2, l, 2);
                bl2 = true;
            }
        }
        catch (WindowsException windowsException) {
            // empty catch block
        }
        final long l3 = l2;
        final boolean bl3 = bl;
        final boolean bl4 = bl2;
        return new Privilege(){

            @Override
            public void drop() {
                if (l3 != 0L) {
                    try {
                        if (bl3) {
                            WindowsNativeDispatcher.SetThreadToken(0L, 0L);
                        } else if (bl4) {
                            WindowsNativeDispatcher.AdjustTokenPrivileges(l3, l, 0);
                        }
                    }
                    catch (WindowsException windowsException) {
                        throw new AssertionError((Object)windowsException);
                    }
                    finally {
                        WindowsNativeDispatcher.CloseHandle(l3);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkAccessMask(long l, int n, int n2, int n3, int n4, int n5) throws WindowsException {
        int n6 = 8;
        long l2 = WindowsNativeDispatcher.OpenThreadToken(WindowsNativeDispatcher.GetCurrentThread(), n6, false);
        if (l2 == 0L && processTokenWithDuplicateAccess != 0L) {
            l2 = WindowsNativeDispatcher.DuplicateTokenEx(processTokenWithDuplicateAccess, n6);
        }
        boolean bl = false;
        if (l2 != 0L) {
            try {
                bl = WindowsNativeDispatcher.AccessCheck(l2, l, n, n2, n3, n4, n5);
            }
            finally {
                WindowsNativeDispatcher.CloseHandle(l2);
            }
        }
        return bl;
    }

    static interface Privilege {
        public void drop();
    }
}

