/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Era;
import sun.util.calendar.Gregorian;
import sun.util.calendar.LocalGregorianCalendar;

public abstract class CalendarSystem {
    private static volatile boolean initialized = false;
    private static ConcurrentMap<String, String> names;
    private static ConcurrentMap<String, CalendarSystem> calendars;
    private static final String PACKAGE_NAME = "sun.util.calendar.";
    private static final String[] namePairs;
    private static final Gregorian GREGORIAN_INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNames() {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < namePairs.length; i += 2) {
            stringBuilder.setLength(0);
            String string = stringBuilder.append(PACKAGE_NAME).append(namePairs[i + 1]).toString();
            concurrentHashMap.put(namePairs[i], string);
        }
        Class<CalendarSystem> clazz = CalendarSystem.class;
        synchronized (CalendarSystem.class) {
            if (!initialized) {
                names = concurrentHashMap;
                calendars = new ConcurrentHashMap<String, CalendarSystem>();
                initialized = true;
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public static Gregorian getGregorianCalendar() {
        return GREGORIAN_INSTANCE;
    }

    public static CalendarSystem forName(String string) {
        Object object;
        CalendarSystem calendarSystem;
        if ("gregorian".equals(string)) {
            return GREGORIAN_INSTANCE;
        }
        if (!initialized) {
            CalendarSystem.initNames();
        }
        if ((calendarSystem = (CalendarSystem)calendars.get(string)) != null) {
            return calendarSystem;
        }
        String string2 = (String)names.get(string);
        if (string2 == null) {
            return null;
        }
        if (string2.endsWith("LocalGregorianCalendar")) {
            calendarSystem = LocalGregorianCalendar.getLocalGregorianCalendar(string);
        } else {
            try {
                object = Class.forName(string2);
                calendarSystem = (CalendarSystem)((Class)object).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("internal error", exception);
            }
        }
        if (calendarSystem == null) {
            return null;
        }
        object = calendars.putIfAbsent(string, calendarSystem);
        return object == null ? calendarSystem : object;
    }

    public abstract String getName();

    public abstract CalendarDate getCalendarDate();

    public abstract CalendarDate getCalendarDate(long var1);

    public abstract CalendarDate getCalendarDate(long var1, CalendarDate var3);

    public abstract CalendarDate getCalendarDate(long var1, TimeZone var3);

    public abstract CalendarDate newCalendarDate();

    public abstract CalendarDate newCalendarDate(TimeZone var1);

    public abstract long getTime(CalendarDate var1);

    public abstract int getYearLength(CalendarDate var1);

    public abstract int getYearLengthInMonths(CalendarDate var1);

    public abstract int getMonthLength(CalendarDate var1);

    public abstract int getWeekLength();

    public abstract Era getEra(String var1);

    public abstract Era[] getEras();

    public abstract void setEra(CalendarDate var1, String var2);

    public abstract CalendarDate getNthDayOfWeek(int var1, int var2, CalendarDate var3);

    public abstract CalendarDate setTimeOfDay(CalendarDate var1, int var2);

    public abstract boolean validate(CalendarDate var1);

    public abstract boolean normalize(CalendarDate var1);

    static {
        namePairs = new String[]{"gregorian", "Gregorian", "japanese", "LocalGregorianCalendar", "julian", "JulianCalendar"};
        GREGORIAN_INSTANCE = new Gregorian();
    }
}

