/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KRBPriv {
    public int pvno;
    public int msgType;
    public EncryptedData encPart;

    public KRBPriv(EncryptedData encryptedData) {
        this.pvno = 5;
        this.msgType = 21;
        this.encPart = encryptedData;
    }

    public KRBPriv(byte[] byArray) throws Asn1Exception, KrbApErrException, IOException {
        this.init(new DerValue(byArray));
    }

    public KRBPriv(DerValue derValue) throws Asn1Exception, KrbApErrException, IOException {
        this.init(derValue);
    }

    private void init(DerValue derValue) throws Asn1Exception, KrbApErrException, IOException {
        if ((derValue.getTag() & 0x1F) != 21 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            this.pvno = derValue3.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            this.msgType = derValue3.getData().getBigInteger().intValue();
            if (this.msgType != 21) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.encPart = EncryptedData.parse(derValue2.getData(), (byte)3, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.pvno));
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), this.encPart.asn1Encode());
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, true, (byte)21), derOutputStream);
        return derOutputStream2.toByteArray();
    }
}

