/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;

class WindowsUserPrincipals {
    private WindowsUserPrincipals() {
    }

    static UserPrincipal fromSid(long l) throws IOException {
        int n;
        String string;
        String string2;
        try {
            string2 = WindowsNativeDispatcher.ConvertSidToStringSid(l);
            if (string2 == null) {
                throw new AssertionError();
            }
        }
        catch (WindowsException windowsException) {
            throw new IOException("Unable to convert SID to String: " + windowsException.errorString());
        }
        WindowsNativeDispatcher.Account account = null;
        try {
            account = WindowsNativeDispatcher.LookupAccountSid(l);
            string = account.domain() + "\\" + account.name();
        }
        catch (WindowsException windowsException) {
            string = string2;
        }
        int n2 = n = account == null ? 8 : account.use();
        if (n == 2 || n == 5 || n == 4) {
            return new Group(string2, n, string);
        }
        return new User(string2, n, string);
    }

    static UserPrincipal lookup(String string) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("lookupUserInformation"));
        }
        int n = 0;
        try {
            n = WindowsNativeDispatcher.LookupAccountName(string, 0L, 0);
        }
        catch (WindowsException windowsException) {
            if (windowsException.lastError() == 1332) {
                throw new UserPrincipalNotFoundException(string);
            }
            throw new IOException(string + ": " + windowsException.errorString());
        }
        assert (n > 0);
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(n);
        try {
            int n2 = WindowsNativeDispatcher.LookupAccountName(string, nativeBuffer.address(), n);
            if (n2 != n) {
                throw new AssertionError((Object)"SID change during lookup");
            }
            UserPrincipal userPrincipal = WindowsUserPrincipals.fromSid(nativeBuffer.address());
            return userPrincipal;
        }
        catch (WindowsException windowsException) {
            throw new IOException(string + ": " + windowsException.errorString());
        }
        finally {
            nativeBuffer.release();
        }
    }

    static class Group
    extends User
    implements GroupPrincipal {
        Group(String string, int n, String string2) {
            super(string, n, string2);
        }
    }

    static class User
    implements UserPrincipal {
        private final String sidString;
        private final int sidType;
        private final String accountName;

        User(String string, int n, String string2) {
            this.sidString = string;
            this.sidType = n;
            this.accountName = string2;
        }

        String sidString() {
            return this.sidString;
        }

        @Override
        public String getName() {
            return this.accountName;
        }

        @Override
        public String toString() {
            String string;
            switch (this.sidType) {
                case 1: {
                    string = "User";
                    break;
                }
                case 2: {
                    string = "Group";
                    break;
                }
                case 3: {
                    string = "Domain";
                    break;
                }
                case 4: {
                    string = "Alias";
                    break;
                }
                case 5: {
                    string = "Well-known group";
                    break;
                }
                case 6: {
                    string = "Deleted";
                    break;
                }
                case 7: {
                    string = "Invalid";
                    break;
                }
                case 9: {
                    string = "Computer";
                    break;
                }
                default: {
                    string = "Unknown";
                }
            }
            return this.accountName + " (" + string + ")";
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof User)) {
                return false;
            }
            User user = (User)object;
            return this.sidString.equals(user.sidString);
        }

        @Override
        public int hashCode() {
            return this.sidString.hashCode();
        }
    }
}

