(defn test
  [x]
  (s/conform ::always-seq x))

(s/def ::always-seq (s/and (s/or :seq sequential?
                                 :val (complement sequential?))
                           (s/conformer (fn [[tag x]]
                                          (if (= :seq tag)
                                            x
                                            [x])))))

(s/def ::count (s/and (s/*  ::always-seq)
                      (s/conformer (partial map count))
                      ))

(s/def ::always-seq (s/and (s/or :seq sequential?
                                 :val (complement sequential?))
                           (s/conformer (fn [[tag x]]
                                          (if (= :seq tag)
                                            x
                                            [x])))))

(s/fdef test
        :args ::always-seq)

(s/instrument #'test)

(s/conform ::count [1 2 3 4 5])

(test 4)
(test [3])

(explain-data)

(s/def ::names (s/* (s/and (s/or :string
                                 string?
                                 :ints integer?)
                           (s/conformer second))))

(s/def ::nested
  (s/cat :names-kw #{:names}
         :names (s/spec ::names)
         :nums-kw #{:nums}
         :nums (s/spec (s/* number?))))

(s/conform ::nested [:names ["a" "b"] :nums [1 2 3]])
(s/conform ::nested [:names "a" "b" :nums 1 2 3])
