/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.TypeResolver;
import java.beans.Transient;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class FeatureDescriptor {
    private static final String TRANSIENT = "transient";
    private Reference<? extends Class<?>> classRef;
    private boolean expert;
    private boolean hidden;
    private boolean preferred;
    private String shortDescription;
    private String name;
    private String displayName;
    private Hashtable<String, Object> table;

    public FeatureDescriptor() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.getName();
        }
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean bl) {
        this.expert = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean bl) {
        this.preferred = bl;
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            return this.getDisplayName();
        }
        return this.shortDescription;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    public void setValue(String string, Object object) {
        this.getTable().put(string, object);
    }

    public Object getValue(String string) {
        return this.table != null ? this.table.get(string) : null;
    }

    public Enumeration<String> attributeNames() {
        return this.getTable().keys();
    }

    FeatureDescriptor(FeatureDescriptor featureDescriptor, FeatureDescriptor featureDescriptor2) {
        this.expert = featureDescriptor.expert | featureDescriptor2.expert;
        this.hidden = featureDescriptor.hidden | featureDescriptor2.hidden;
        this.preferred = featureDescriptor.preferred | featureDescriptor2.preferred;
        this.name = featureDescriptor2.name;
        this.shortDescription = featureDescriptor.shortDescription;
        if (featureDescriptor2.shortDescription != null) {
            this.shortDescription = featureDescriptor2.shortDescription;
        }
        this.displayName = featureDescriptor.displayName;
        if (featureDescriptor2.displayName != null) {
            this.displayName = featureDescriptor2.displayName;
        }
        this.classRef = featureDescriptor.classRef;
        if (featureDescriptor2.classRef != null) {
            this.classRef = featureDescriptor2.classRef;
        }
        this.addTable(featureDescriptor.table);
        this.addTable(featureDescriptor2.table);
    }

    FeatureDescriptor(FeatureDescriptor featureDescriptor) {
        this.expert = featureDescriptor.expert;
        this.hidden = featureDescriptor.hidden;
        this.preferred = featureDescriptor.preferred;
        this.name = featureDescriptor.name;
        this.shortDescription = featureDescriptor.shortDescription;
        this.displayName = featureDescriptor.displayName;
        this.classRef = featureDescriptor.classRef;
        this.addTable(featureDescriptor.table);
    }

    private void addTable(Hashtable<String, Object> hashtable) {
        if (hashtable != null && !hashtable.isEmpty()) {
            this.getTable().putAll(hashtable);
        }
    }

    private Hashtable<String, Object> getTable() {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        return this.table;
    }

    void setTransient(Transient transient_) {
        if (transient_ != null && null == this.getValue(TRANSIENT)) {
            this.setValue(TRANSIENT, transient_.value());
        }
    }

    boolean isTransient() {
        Object object = this.getValue(TRANSIENT);
        return object instanceof Boolean ? (Boolean)object : false;
    }

    void setClass0(Class<?> clazz) {
        this.classRef = FeatureDescriptor.getWeakReference(clazz);
    }

    Class<?> getClass0() {
        return this.classRef != null ? this.classRef.get() : null;
    }

    static <T> Reference<T> getSoftReference(T t) {
        return t != null ? new SoftReference<T>(t) : null;
    }

    static <T> Reference<T> getWeakReference(T t) {
        return t != null ? new WeakReference<T>(t) : null;
    }

    static Class<?> getReturnType(Class<?> clazz, Method method) {
        if (clazz == null) {
            clazz = method.getDeclaringClass();
        }
        return TypeResolver.erase(TypeResolver.resolveInClass(clazz, method.getGenericReturnType()));
    }

    static Class<?>[] getParameterTypes(Class<?> clazz, Method method) {
        if (clazz == null) {
            clazz = method.getDeclaringClass();
        }
        return TypeResolver.erase(TypeResolver.resolveInClass(clazz, method.getGenericParameterTypes()));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append("[name=").append(this.name);
        FeatureDescriptor.appendTo(stringBuilder, "displayName", this.displayName);
        FeatureDescriptor.appendTo(stringBuilder, "shortDescription", this.shortDescription);
        FeatureDescriptor.appendTo(stringBuilder, "preferred", this.preferred);
        FeatureDescriptor.appendTo(stringBuilder, "hidden", this.hidden);
        FeatureDescriptor.appendTo(stringBuilder, "expert", this.expert);
        if (this.table != null && !this.table.isEmpty()) {
            stringBuilder.append("; values={");
            for (Map.Entry<String, Object> entry : this.table.entrySet()) {
                stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("; ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append("}");
        }
        this.appendTo(stringBuilder);
        return stringBuilder.append("]").toString();
    }

    void appendTo(StringBuilder stringBuilder) {
    }

    static void appendTo(StringBuilder stringBuilder, String string, Reference<?> reference) {
        if (reference != null) {
            FeatureDescriptor.appendTo(stringBuilder, string, reference.get());
        }
    }

    static void appendTo(StringBuilder stringBuilder, String string, Object object) {
        if (object != null) {
            stringBuilder.append("; ").append(string).append("=").append(object);
        }
    }

    static void appendTo(StringBuilder stringBuilder, String string, boolean bl) {
        if (bl) {
            stringBuilder.append("; ").append(string);
        }
    }
}

