/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;

final class MAC
extends Authenticator {
    static final MAC NULL = new MAC();
    private static final byte[] nullMAC = new byte[0];
    private final CipherSuite.MacAlg macAlg;
    private final Mac mac;

    private MAC() {
        this.macAlg = CipherSuite.M_NULL;
        this.mac = null;
    }

    MAC(CipherSuite.MacAlg macAlg, ProtocolVersion protocolVersion, SecretKey secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        super(protocolVersion);
        String string;
        boolean bl;
        this.macAlg = macAlg;
        boolean bl2 = bl = protocolVersion.v >= ProtocolVersion.TLS10.v;
        if (macAlg == CipherSuite.M_MD5) {
            string = bl ? "HmacMD5" : "SslMacMD5";
        } else if (macAlg == CipherSuite.M_SHA) {
            string = bl ? "HmacSHA1" : "SslMacSHA1";
        } else if (macAlg == CipherSuite.M_SHA256) {
            string = "HmacSHA256";
        } else if (macAlg == CipherSuite.M_SHA384) {
            string = "HmacSHA384";
        } else {
            throw new RuntimeException("Unknown Mac " + macAlg);
        }
        this.mac = JsseJce.getMac(string);
        this.mac.init(secretKey);
    }

    int MAClen() {
        return this.macAlg.size;
    }

    int hashBlockLen() {
        return this.macAlg.hashBlockSize;
    }

    int minimalPaddingLen() {
        return this.macAlg.minimalPaddingSize;
    }

    final byte[] compute(byte by, byte[] byArray, int n, int n2, boolean bl) {
        if (this.macAlg.size == 0) {
            return nullMAC;
        }
        if (!bl) {
            byte[] byArray2 = this.acquireAuthenticationBytes(by, n2);
            this.mac.update(byArray2);
        }
        this.mac.update(byArray, n, n2);
        return this.mac.doFinal();
    }

    final byte[] compute(byte by, ByteBuffer byteBuffer, boolean bl) {
        if (this.macAlg.size == 0) {
            return nullMAC;
        }
        if (!bl) {
            byte[] byArray = this.acquireAuthenticationBytes(by, byteBuffer.remaining());
            this.mac.update(byArray);
        }
        this.mac.update(byteBuffer);
        return this.mac.doFinal();
    }
}

