/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalSliderUI
extends BasicSliderUI {
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    private int safeLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    private static Icon SAFE_HORIZ_THUMB_ICON;
    private static Icon SAFE_VERT_THUMB_ICON;
    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalSliderUI();
    }

    public MetalSliderUI() {
        super(null);
    }

    private static Icon getHorizThumbIcon() {
        if (System.getSecurityManager() != null) {
            return SAFE_HORIZ_THUMB_ICON;
        }
        return horizThumbIcon;
    }

    private static Icon getVertThumbIcon() {
        if (System.getSecurityManager() != null) {
            return SAFE_VERT_THUMB_ICON;
        }
        return vertThumbIcon;
    }

    @Override
    public void installUI(JComponent jComponent) {
        trackWidth = (Integer)UIManager.get("Slider.trackWidth");
        tickLength = this.safeLength = ((Integer)UIManager.get("Slider.majorTickLength")).intValue();
        horizThumbIcon = SAFE_HORIZ_THUMB_ICON = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = SAFE_VERT_THUMB_ICON = UIManager.getIcon("Slider.verticalThumbIcon");
        super.installUI(jComponent);
        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");
        this.scrollListener.setScrollByBlock(false);
        this.prepareFilledSliderField();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new MetalPropertyListener();
    }

    private void prepareFilledSliderField() {
        this.filledSlider = MetalLookAndFeel.usingOcean();
        Object object = this.slider.getClientProperty("JSlider.isFilled");
        if (object != null) {
            this.filledSlider = (Boolean)object;
        }
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.getOrientation() == 0) {
            MetalSliderUI.getHorizThumbIcon().paintIcon(this.slider, graphics, 0, 0);
        } else {
            MetalSliderUI.getVertThumbIcon().paintIcon(this.slider, graphics, 0, 0);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private Rectangle getPaintTrackRect() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (this.slider.getOrientation() == 0) {
            n2 = this.trackRect.height - 1 - this.getThumbOverhang();
            n4 = n2 - (this.getTrackWidth() - 1);
            n = this.trackRect.width - 1;
        } else {
            if (MetalUtils.isLeftToRight(this.slider)) {
                n3 = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n3 = this.getThumbOverhang();
                n = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n2 = this.trackRect.height - 1;
        }
        return new Rectangle(this.trackRect.x + n3, this.trackRect.y + n4, n - n3, n2 - n4);
    }

    @Override
    public void paintTrack(Graphics graphics) {
        int n;
        int n2;
        if (MetalLookAndFeel.usingOcean()) {
            this.oceanPaintTrack(graphics);
            return;
        }
        ColorUIResource colorUIResource = !this.slider.isEnabled() ? MetalLookAndFeel.getControlShadow() : this.slider.getForeground();
        boolean bl = MetalUtils.isLeftToRight(this.slider);
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n3 = 0;
        int n4 = 0;
        if (this.slider.getOrientation() == 0) {
            n2 = this.trackRect.height - 1 - this.getThumbOverhang();
            n4 = n2 - (this.getTrackWidth() - 1);
            n = this.trackRect.width - 1;
        } else {
            if (bl) {
                n3 = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n3 = this.getThumbOverhang();
                n = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n2 = this.trackRect.height - 1;
        }
        if (this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(n3, n4, n - n3 - 1, n2 - n4 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n3 + 1, n2, n, n2);
            graphics.drawLine(n, n4 + 1, n, n2);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(n3 + 1, n4 + 1, n - 2, n4 + 1);
            graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n2 - 2);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawRect(n3, n4, n - n3 - 1, n2 - n4 - 1);
        }
        if (this.filledSlider) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.slider.getOrientation() == 0) {
                int n9 = this.thumbRect.x + this.thumbRect.width / 2;
                n9 -= this.trackRect.x;
                n8 = !this.slider.isEnabled() ? n4 : n4 + 1;
                int n10 = n7 = !this.slider.isEnabled() ? n2 - 1 : n2 - 2;
                if (!this.drawInverted()) {
                    n6 = !this.slider.isEnabled() ? n3 : n3 + 1;
                    n5 = n9;
                } else {
                    n6 = n9;
                    n5 = !this.slider.isEnabled() ? n - 1 : n - 2;
                }
            } else {
                int n11 = this.thumbRect.y + this.thumbRect.height / 2;
                n11 -= this.trackRect.y;
                n6 = !this.slider.isEnabled() ? n3 : n3 + 1;
                int n12 = n5 = !this.slider.isEnabled() ? n - 1 : n - 2;
                if (!this.drawInverted()) {
                    n8 = n11;
                    n7 = !this.slider.isEnabled() ? n2 - 1 : n2 - 2;
                } else {
                    n8 = !this.slider.isEnabled() ? n4 : n4 + 1;
                    n7 = n11;
                }
            }
            if (this.slider.isEnabled()) {
                graphics.setColor(this.slider.getBackground());
                graphics.drawLine(n6, n8, n5, n8);
                graphics.drawLine(n6, n8, n6, n7);
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n6 + 1, n8 + 1, n5 - n6, n7 - n8);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n6, n8, n5 - n6, n7 - n8);
            }
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    private void oceanPaintTrack(Graphics graphics) {
        boolean bl = MetalUtils.isLeftToRight(this.slider);
        boolean bl2 = this.drawInverted();
        Color color = (Color)UIManager.get("Slider.altTrackColor");
        Rectangle rectangle = this.getPaintTrackRect();
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (this.slider.getOrientation() == 0) {
            int n3 = this.thumbRect.x + this.thumbRect.width / 2 - rectangle.x;
            if (this.slider.isEnabled()) {
                if (n3 > 0) {
                    graphics.setColor(bl2 ? MetalLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getPrimaryControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n2 - 1);
                }
                if (n3 < n) {
                    graphics.setColor(bl2 ? MetalLookAndFeel.getPrimaryControlDarkShadow() : MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(n3, 0, n - n3 - 1, n2 - 1);
                }
                if (this.filledSlider) {
                    int n4;
                    int n5;
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                    if (bl2) {
                        n5 = n3;
                        n4 = n - 2;
                        graphics.drawLine(1, 1, n3, 1);
                    } else {
                        n5 = 1;
                        n4 = n3;
                        graphics.drawLine(n3, 1, n - 1, 1);
                    }
                    if (n2 == 6) {
                        graphics.setColor(MetalLookAndFeel.getWhite());
                        graphics.drawLine(n5, 1, n4, 1);
                        graphics.setColor(color);
                        graphics.drawLine(n5, 2, n4, 2);
                        graphics.setColor(MetalLookAndFeel.getControlShadow());
                        graphics.drawLine(n5, 3, n4, 3);
                        graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                        graphics.drawLine(n5, 4, n4, 4);
                    }
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                if (n3 > 0) {
                    if (!bl2 && this.filledSlider) {
                        graphics.fillRect(0, 0, n3 - 1, n2 - 1);
                    } else {
                        graphics.drawRect(0, 0, n3 - 1, n2 - 1);
                    }
                }
                if (n3 < n) {
                    if (bl2 && this.filledSlider) {
                        graphics.fillRect(n3, 0, n - n3 - 1, n2 - 1);
                    } else {
                        graphics.drawRect(n3, 0, n - n3 - 1, n2 - 1);
                    }
                }
            }
        } else {
            int n6 = this.thumbRect.y + this.thumbRect.height / 2 - rectangle.y;
            if (this.slider.isEnabled()) {
                if (n6 > 0) {
                    graphics.setColor(bl2 ? MetalLookAndFeel.getPrimaryControlDarkShadow() : MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n - 1, n6 - 1);
                }
                if (n6 < n2) {
                    graphics.setColor(bl2 ? MetalLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getPrimaryControlDarkShadow());
                    graphics.drawRect(0, n6, n - 1, n2 - n6 - 1);
                }
                if (this.filledSlider) {
                    int n7;
                    int n8;
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                    if (this.drawInverted()) {
                        n8 = 1;
                        n7 = n6;
                        if (bl) {
                            graphics.drawLine(1, n6, 1, n2 - 1);
                        } else {
                            graphics.drawLine(n - 2, n6, n - 2, n2 - 1);
                        }
                    } else {
                        n8 = n6;
                        n7 = n2 - 2;
                        if (bl) {
                            graphics.drawLine(1, 1, 1, n6);
                        } else {
                            graphics.drawLine(n - 2, 1, n - 2, n6);
                        }
                    }
                    if (n == 6) {
                        graphics.setColor(bl ? MetalLookAndFeel.getWhite() : MetalLookAndFeel.getPrimaryControlShadow());
                        graphics.drawLine(1, n8, 1, n7);
                        graphics.setColor(bl ? color : MetalLookAndFeel.getControlShadow());
                        graphics.drawLine(2, n8, 2, n7);
                        graphics.setColor(bl ? MetalLookAndFeel.getControlShadow() : color);
                        graphics.drawLine(3, n8, 3, n7);
                        graphics.setColor(bl ? MetalLookAndFeel.getPrimaryControlShadow() : MetalLookAndFeel.getWhite());
                        graphics.drawLine(4, n8, 4, n7);
                    }
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                if (n6 > 0) {
                    if (bl2 && this.filledSlider) {
                        graphics.fillRect(0, 0, n - 1, n6 - 1);
                    } else {
                        graphics.drawRect(0, 0, n - 1, n6 - 1);
                    }
                }
                if (n6 < n2) {
                    if (!bl2 && this.filledSlider) {
                        graphics.fillRect(0, n6, n - 1, n2 - n6 - 1);
                    } else {
                        graphics.drawRect(0, n6, n - 1, n2 - n6 - 1);
                    }
                }
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = MetalSliderUI.getVertThumbIcon().getIconWidth();
            dimension.height = MetalSliderUI.getVertThumbIcon().getIconHeight();
        } else {
            dimension.width = MetalSliderUI.getHorizThumbIcon().getIconWidth();
            dimension.height = MetalSliderUI.getHorizThumbIcon().getIconHeight();
        }
        return dimension;
    }

    @Override
    public int getTickLength() {
        return this.slider.getOrientation() == 0 ? this.safeLength + 4 + 1 : this.safeLength + 4 + 3;
    }

    protected int getTrackWidth() {
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }

    protected int getTrackLength() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.width;
        }
        return this.trackRect.height;
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    @Override
    protected void scrollDueToClickInTrack(int n) {
        this.scrollByUnit(n);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n, 4, n, 4 + this.safeLength / 2);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n, 4, n, 4 + (this.safeLength - 1));
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n, 4 + this.safeLength / 2, n);
        } else {
            graphics.drawLine(0, n, this.safeLength / 2, n);
        }
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n, 4 + this.safeLength, n);
        } else {
            graphics.drawLine(0, n, this.safeLength, n);
        }
    }

    protected class MetalPropertyListener
    extends BasicSliderUI.PropertyChangeHandler {
        protected MetalPropertyListener() {
            super(MetalSliderUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (propertyChangeEvent.getPropertyName().equals("JSlider.isFilled")) {
                MetalSliderUI.this.prepareFilledSliderField();
            }
        }
    }
}

