/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import javax.imageio.stream.MemoryCache;

public class MemoryCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private MemoryCache cache = new MemoryCache();

    public MemoryCacheImageOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.stream = outputStream;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int n = this.cache.read(this.streamPos);
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off+len > b.length || off+len < 0!");
        }
        this.bitOffset = 0;
        if (n2 == 0) {
            return 0;
        }
        long l = this.cache.getLength() - this.streamPos;
        if (l <= 0L) {
            return -1;
        }
        n2 = (int)Math.min(l, (long)n2);
        this.cache.read(byArray, n, n2, this.streamPos);
        this.streamPos += (long)n2;
        return n2;
    }

    @Override
    public void write(int n) throws IOException {
        this.flushBits();
        this.cache.write(n, this.streamPos);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.flushBits();
        this.cache.write(byArray, n, n2, this.streamPos);
        this.streamPos += (long)n2;
    }

    @Override
    public long length() {
        try {
            this.checkClosed();
            return this.cache.getLength();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }

    @Override
    public void close() throws IOException {
        long l = this.cache.getLength();
        this.seek(l);
        this.flushBefore(l);
        super.close();
        this.cache.reset();
        this.cache = null;
        this.stream = null;
    }

    @Override
    public void flushBefore(long l) throws IOException {
        long l2 = this.flushedPos;
        super.flushBefore(l);
        long l3 = this.flushedPos - l2;
        this.cache.writeToStream(this.stream, l2, l3);
        this.cache.disposeBefore(this.flushedPos);
        this.stream.flush();
    }
}

