/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class OrientableFlowLayout
extends FlowLayout {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int TOP = 0;
    public static final int BOTTOM = 2;
    int orientation;
    int vAlign;
    int vHGap;
    int vVGap;

    public OrientableFlowLayout() {
        this(0, 1, 1, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int n) {
        this(n, 1, 1, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int n, int n2, int n3) {
        this(n, n2, n3, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n2, n4, n5);
        this.orientation = n;
        this.vAlign = n3;
        this.vHGap = n6;
        this.vVGap = n7;
    }

    public synchronized void orientHorizontally() {
        this.orientation = 0;
    }

    public synchronized void orientVertically() {
        this.orientation = 1;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (this.orientation == 0) {
            return super.preferredLayoutSize(container);
        }
        Dimension dimension = new Dimension(0, 0);
        int n = container.countComponents();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.preferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i > 0) {
                dimension.height += this.vVGap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right + this.vHGap * 2;
        dimension.height += insets.top + insets.bottom + this.vVGap * 2;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        if (this.orientation == 0) {
            return super.minimumLayoutSize(container);
        }
        Dimension dimension = new Dimension(0, 0);
        int n = container.countComponents();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.minimumSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i > 0) {
                dimension.height += this.vVGap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right + this.vHGap * 2;
        dimension.height += insets.top + insets.bottom + this.vVGap * 2;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        if (this.orientation == 0) {
            super.layoutContainer(container);
        } else {
            Insets insets = container.insets();
            Dimension dimension = container.size();
            int n = dimension.height - (insets.top + insets.bottom + this.vVGap * 2);
            int n2 = insets.left + this.vHGap;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = container.countComponents();
            for (int i = 0; i < n6; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.preferredSize();
                component.resize(dimension2.width, dimension2.height);
                if (n3 == 0 || n3 + dimension2.height <= n) {
                    if (n3 > 0) {
                        n3 += this.vVGap;
                    }
                    n3 += dimension2.height;
                    n4 = Math.max(n4, dimension2.width);
                    continue;
                }
                this.moveComponents(container, n2, insets.top + this.vVGap, n4, n - n3, n5, i);
                n2 += this.vHGap + n4;
                n3 = dimension2.width;
                n4 = dimension2.width;
                n5 = i;
            }
            this.moveComponents(container, n2, insets.top + this.vVGap, n4, n - n3, n5, n6);
        }
    }

    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (this.vAlign) {
            case 0: {
                break;
            }
            case 1: {
                n2 += n4 / 2;
                break;
            }
            case 2: {
                n2 += n4;
            }
        }
        for (int i = n5; i < n6; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.size();
            if (!component.isVisible()) continue;
            component.move(n + (n3 - dimension.width) / 2, n2);
            n2 += this.vVGap + dimension.height;
        }
    }

    @Override
    public String toString() {
        String string = "";
        switch (this.orientation) {
            case 0: {
                string = "orientation=horizontal, ";
                break;
            }
            case 1: {
                string = "orientation=vertical, ";
            }
        }
        return this.getClass().getName() + "[" + string + super.toString() + "]";
    }
}

