/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public abstract class QuadCurve2D
implements Shape,
Cloneable {
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    protected QuadCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX();

    public abstract double getCtrlY();

    public abstract Point2D getCtrlPt();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setCurve(double[] dArray, int n) {
        this.setCurve(dArray[n + 0], dArray[n + 1], dArray[n + 2], dArray[n + 3], dArray[n + 4], dArray[n + 5]);
    }

    public void setCurve(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        this.setCurve(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
    }

    public void setCurve(Point2D[] point2DArray, int n) {
        this.setCurve(point2DArray[n + 0].getX(), point2DArray[n + 0].getY(), point2DArray[n + 1].getX(), point2DArray[n + 1].getY(), point2DArray[n + 2].getX(), point2DArray[n + 2].getY());
    }

    public void setCurve(QuadCurve2D quadCurve2D) {
        this.setCurve(quadCurve2D.getX1(), quadCurve2D.getY1(), quadCurve2D.getCtrlX(), quadCurve2D.getCtrlY(), quadCurve2D.getX2(), quadCurve2D.getY2());
    }

    public static double getFlatnessSq(double d, double d2, double d3, double d4, double d5, double d6) {
        return Line2D.ptSegDistSq(d, d2, d5, d6, d3, d4);
    }

    public static double getFlatness(double d, double d2, double d3, double d4, double d5, double d6) {
        return Line2D.ptSegDist(d, d2, d5, d6, d3, d4);
    }

    public static double getFlatnessSq(double[] dArray, int n) {
        return Line2D.ptSegDistSq(dArray[n + 0], dArray[n + 1], dArray[n + 4], dArray[n + 5], dArray[n + 2], dArray[n + 3]);
    }

    public static double getFlatness(double[] dArray, int n) {
        return Line2D.ptSegDist(dArray[n + 0], dArray[n + 1], dArray[n + 4], dArray[n + 5], dArray[n + 2], dArray[n + 3]);
    }

    public double getFlatnessSq() {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public double getFlatness() {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2) {
        QuadCurve2D.subdivide(this, quadCurve2D, quadCurve2D2);
    }

    public static void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2, QuadCurve2D quadCurve2D3) {
        double d = quadCurve2D.getX1();
        double d2 = quadCurve2D.getY1();
        double d3 = quadCurve2D.getCtrlX();
        double d4 = quadCurve2D.getCtrlY();
        double d5 = quadCurve2D.getX2();
        double d6 = quadCurve2D.getY2();
        double d7 = (d + d3) / 2.0;
        double d8 = (d2 + d4) / 2.0;
        double d9 = (d5 + d3) / 2.0;
        double d10 = (d6 + d4) / 2.0;
        d3 = (d7 + d9) / 2.0;
        d4 = (d8 + d10) / 2.0;
        if (quadCurve2D2 != null) {
            quadCurve2D2.setCurve(d, d2, d7, d8, d3, d4);
        }
        if (quadCurve2D3 != null) {
            quadCurve2D3.setCurve(d3, d4, d9, d10, d5, d6);
        }
    }

    public static void subdivide(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double d = dArray[n + 0];
        double d2 = dArray[n + 1];
        double d3 = dArray[n + 2];
        double d4 = dArray[n + 3];
        double d5 = dArray[n + 4];
        double d6 = dArray[n + 5];
        if (dArray2 != null) {
            dArray2[n2 + 0] = d;
            dArray2[n2 + 1] = d2;
        }
        if (dArray3 != null) {
            dArray3[n3 + 4] = d5;
            dArray3[n3 + 5] = d6;
        }
        d = (d + d3) / 2.0;
        d2 = (d2 + d4) / 2.0;
        d5 = (d5 + d3) / 2.0;
        d6 = (d6 + d4) / 2.0;
        d3 = (d + d5) / 2.0;
        d4 = (d2 + d6) / 2.0;
        if (dArray2 != null) {
            dArray2[n2 + 2] = d;
            dArray2[n2 + 3] = d2;
            dArray2[n2 + 4] = d3;
            dArray2[n2 + 5] = d4;
        }
        if (dArray3 != null) {
            dArray3[n3 + 0] = d3;
            dArray3[n3 + 1] = d4;
            dArray3[n3 + 2] = d5;
            dArray3[n3 + 3] = d6;
        }
    }

    public static int solveQuadratic(double[] dArray) {
        return QuadCurve2D.solveQuadratic(dArray, dArray);
    }

    public static int solveQuadratic(double[] dArray, double[] dArray2) {
        double d = dArray[2];
        double d2 = dArray[1];
        double d3 = dArray[0];
        int n = 0;
        if (d == 0.0) {
            if (d2 == 0.0) {
                return -1;
            }
            dArray2[n++] = -d3 / d2;
        } else {
            double d4 = d2 * d2 - 4.0 * d * d3;
            if (d4 < 0.0) {
                return 0;
            }
            d4 = Math.sqrt(d4);
            if (d2 < 0.0) {
                d4 = -d4;
            }
            double d5 = (d2 + d4) / -2.0;
            dArray2[n++] = d5 / d;
            if (d5 != 0.0) {
                dArray2[n++] = d3 / d5;
            }
        }
        return n;
    }

    @Override
    public boolean contains(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = this.getX1();
        double d8 = this.getY1();
        double d9 = this.getCtrlX();
        double d10 = this.getCtrlY();
        double d11 = this.getX2();
        double d12 = d - d7;
        double d13 = this.getY2();
        double d14 = d8 - 2.0 * d10 + d13;
        double d15 = (d12 * d14 - (d6 = d2 - d8) * (d5 = d7 - 2.0 * d9 + d11)) / ((d4 = d11 - d7) * d14 - (d3 = d13 - d8) * d5);
        if (d15 < 0.0 || d15 > 1.0 || d15 != d15) {
            return false;
        }
        double d16 = d5 * d15 * d15 + 2.0 * (d9 - d7) * d15 + d7;
        double d17 = d14 * d15 * d15 + 2.0 * (d10 - d8) * d15 + d8;
        double d18 = d4 * d15 + d7;
        double d19 = d3 * d15 + d8;
        return d >= d16 && d < d18 || d >= d18 && d < d16 || d2 >= d17 && d2 < d19 || d2 >= d19 && d2 < d17;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    private static void fillEqn(double[] dArray, double d, double d2, double d3, double d4) {
        dArray[0] = d2 - d;
        dArray[1] = d3 + d3 - d2 - d2;
        dArray[2] = d2 - d3 - d3 + d4;
    }

    private static int evalQuadratic(double[] dArray, int n, boolean bl, boolean bl2, double[] dArray2, double d, double d2, double d3) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d4 = dArray[i];
            if (!(bl ? d4 >= 0.0 : d4 > 0.0) || !(bl2 ? d4 <= 1.0 : d4 < 1.0) || dArray2 != null && dArray2[1] + 2.0 * dArray2[2] * d4 == 0.0) continue;
            double d5 = 1.0 - d4;
            dArray[n2++] = d * d5 * d5 + 2.0 * d2 * d4 * d5 + d3 * d4 * d4;
        }
        return n2;
    }

    private static int getTag(double d, double d2, double d3) {
        if (d <= d2) {
            return d < d2 ? -2 : -1;
        }
        if (d >= d3) {
            return d > d3 ? 2 : 1;
        }
        return 0;
    }

    private static boolean inwards(int n, int n2, int n3) {
        switch (n) {
            default: {
                return false;
            }
            case -1: {
                return n2 >= 0 || n3 >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return n2 <= 0 || n3 <= 0;
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        int n;
        boolean bl;
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        double d5 = this.getX1();
        double d6 = this.getY1();
        int n2 = QuadCurve2D.getTag(d5, d, d + d3);
        int n3 = QuadCurve2D.getTag(d6, d2, d2 + d4);
        if (n2 == 0 && n3 == 0) {
            return true;
        }
        double d7 = this.getX2();
        double d8 = this.getY2();
        int n4 = QuadCurve2D.getTag(d7, d, d + d3);
        int n5 = QuadCurve2D.getTag(d8, d2, d2 + d4);
        if (n4 == 0 && n5 == 0) {
            return true;
        }
        double d9 = this.getCtrlX();
        double d10 = this.getCtrlY();
        int n6 = QuadCurve2D.getTag(d9, d, d + d3);
        int n7 = QuadCurve2D.getTag(d10, d2, d2 + d4);
        if (n2 < 0 && n4 < 0 && n6 < 0) {
            return false;
        }
        if (n3 < 0 && n5 < 0 && n7 < 0) {
            return false;
        }
        if (n2 > 0 && n4 > 0 && n6 > 0) {
            return false;
        }
        if (n3 > 0 && n5 > 0 && n7 > 0) {
            return false;
        }
        if (QuadCurve2D.inwards(n2, n4, n6) && QuadCurve2D.inwards(n3, n5, n7)) {
            return true;
        }
        if (QuadCurve2D.inwards(n4, n2, n6) && QuadCurve2D.inwards(n5, n3, n7)) {
            return true;
        }
        boolean bl2 = n2 * n4 <= 0;
        boolean bl3 = bl = n3 * n5 <= 0;
        if (n2 == 0 && n4 == 0 && bl) {
            return true;
        }
        if (n3 == 0 && n5 == 0 && bl2) {
            return true;
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        if (!bl) {
            QuadCurve2D.fillEqn(dArray, n3 < 0 ? d2 : d2 + d4, d6, d10, d8);
            return QuadCurve2D.solveQuadratic(dArray, dArray2) == 2 && QuadCurve2D.evalQuadratic(dArray2, 2, true, true, null, d5, d9, d7) == 2 && QuadCurve2D.getTag(dArray2[0], d, d + d3) * QuadCurve2D.getTag(dArray2[1], d, d + d3) <= 0;
        }
        if (!bl2) {
            QuadCurve2D.fillEqn(dArray, n2 < 0 ? d : d + d3, d5, d9, d7);
            return QuadCurve2D.solveQuadratic(dArray, dArray2) == 2 && QuadCurve2D.evalQuadratic(dArray2, 2, true, true, null, d6, d10, d8) == 2 && QuadCurve2D.getTag(dArray2[0], d2, d2 + d4) * QuadCurve2D.getTag(dArray2[1], d2, d2 + d4) <= 0;
        }
        double d11 = d7 - d5;
        double d12 = d8 - d6;
        double d13 = d8 * d5 - d7 * d6;
        int n8 = n3 == 0 ? n2 : QuadCurve2D.getTag((d13 + d11 * (n3 < 0 ? d2 : d2 + d4)) / d12, d, d + d3);
        if (n8 * (n = n5 == 0 ? n4 : QuadCurve2D.getTag((d13 + d11 * (n5 < 0 ? d2 : d2 + d4)) / d12, d, d + d3)) <= 0) {
            return true;
        }
        n8 = n8 * n2 <= 0 ? n3 : n5;
        QuadCurve2D.fillEqn(dArray, n < 0 ? d : d + d3, d5, d9, d7);
        int n9 = QuadCurve2D.solveQuadratic(dArray, dArray2);
        QuadCurve2D.evalQuadratic(dArray2, n9, true, true, null, d6, d10, d8);
        n = QuadCurve2D.getTag(dArray2[0], d2, d2 + d4);
        return n8 * n <= 0;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        return this.contains(d, d2) && this.contains(d + d3, d2) && this.contains(d + d3, d2 + d4) && this.contains(d, d2 + d4);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new QuadIterator(this, affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    public static class Double
    extends QuadCurve2D
    implements Serializable {
        public double x1;
        public double y1;
        public double ctrlx;
        public double ctrly;
        public double x2;
        public double y2;
        private static final long serialVersionUID = 4217149928428559721L;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6) {
            this.setCurve(d, d2, d3, d4, d5, d6);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        @Override
        public double getCtrlX() {
            return this.ctrlx;
        }

        @Override
        public double getCtrlY() {
            return this.ctrly;
        }

        @Override
        public Point2D getCtrlPt() {
            return new Point2D.Double(this.ctrlx, this.ctrly);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        @Override
        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x1 = d;
            this.y1 = d2;
            this.ctrlx = d3;
            this.ctrly = d4;
            this.x2 = d5;
            this.y2 = d6;
        }

        @Override
        public Rectangle2D getBounds2D() {
            double d = Math.min(Math.min(this.x1, this.x2), this.ctrlx);
            double d2 = Math.min(Math.min(this.y1, this.y2), this.ctrly);
            double d3 = Math.max(Math.max(this.x1, this.x2), this.ctrlx);
            double d4 = Math.max(Math.max(this.y1, this.y2), this.ctrly);
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }
    }

    public static class Float
    extends QuadCurve2D
    implements Serializable {
        public float x1;
        public float y1;
        public float ctrlx;
        public float ctrly;
        public float x2;
        public float y2;
        private static final long serialVersionUID = -8511188402130719609L;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6) {
            this.setCurve(f, f2, f3, f4, f5, f6);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        @Override
        public double getCtrlX() {
            return this.ctrlx;
        }

        @Override
        public double getCtrlY() {
            return this.ctrly;
        }

        @Override
        public Point2D getCtrlPt() {
            return new Point2D.Float(this.ctrlx, this.ctrly);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        @Override
        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x1 = (float)d;
            this.y1 = (float)d2;
            this.ctrlx = (float)d3;
            this.ctrly = (float)d4;
            this.x2 = (float)d5;
            this.y2 = (float)d6;
        }

        public void setCurve(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x1 = f;
            this.y1 = f2;
            this.ctrlx = f3;
            this.ctrly = f4;
            this.x2 = f5;
            this.y2 = f6;
        }

        @Override
        public Rectangle2D getBounds2D() {
            float f = Math.min(Math.min(this.x1, this.x2), this.ctrlx);
            float f2 = Math.min(Math.min(this.y1, this.y2), this.ctrly);
            float f3 = Math.max(Math.max(this.x1, this.x2), this.ctrlx);
            float f4 = Math.max(Math.max(this.y1, this.y2), this.ctrly);
            return new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
        }
    }
}

