/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import sun.nio.fs.Globs;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;
import sun.security.action.GetPropertyAction;

abstract class UnixFileSystem
extends FileSystem {
    private final UnixFileSystemProvider provider;
    private final byte[] defaultDirectory;
    private final boolean needToResolveAgainstDefaultDirectory;
    private final UnixPath rootDirectory;
    private static final String GLOB_SYNTAX = "glob";
    private static final String REGEX_SYNTAX = "regex";

    UnixFileSystem(UnixFileSystemProvider unixFileSystemProvider, String string) {
        boolean bl;
        this.provider = unixFileSystemProvider;
        this.defaultDirectory = UnixPath.normalizeAndCheck(string).getBytes();
        if (this.defaultDirectory[0] != 47) {
            throw new RuntimeException("default directory must be absolute");
        }
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.nio.fs.chdirAllowed", "false"));
        boolean bl2 = bl = string2.length() == 0 ? true : Boolean.valueOf(string2);
        if (bl) {
            this.needToResolveAgainstDefaultDirectory = true;
        } else {
            boolean bl3;
            byte[] byArray = UnixNativeDispatcher.getcwd();
            boolean bl4 = bl3 = byArray.length == this.defaultDirectory.length;
            if (bl3) {
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == this.defaultDirectory[i]) continue;
                    bl3 = false;
                    break;
                }
            }
            this.needToResolveAgainstDefaultDirectory = !bl3;
        }
        this.rootDirectory = new UnixPath(this, "/");
    }

    byte[] defaultDirectory() {
        return this.defaultDirectory;
    }

    boolean needToResolveAgainstDefaultDirectory() {
        return this.needToResolveAgainstDefaultDirectory;
    }

    UnixPath rootDirectory() {
        return this.rootDirectory;
    }

    boolean isSolaris() {
        return false;
    }

    static List<String> standardFileAttributeViews() {
        return Arrays.asList("basic", "posix", "unix", "owner");
    }

    @Override
    public final FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public final String getSeparator() {
        return "/";
    }

    @Override
    public final boolean isOpen() {
        return true;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    void copyNonPosixAttributes(int n, int n2) {
    }

    @Override
    public final Iterable<Path> getRootDirectories() {
        final List<Path> list = Collections.unmodifiableList(Arrays.asList(this.rootDirectory));
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                try {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkRead(UnixFileSystem.this.rootDirectory.toString());
                    }
                    return list.iterator();
                }
                catch (SecurityException securityException) {
                    List list2 = Collections.emptyList();
                    return list2.iterator();
                }
            }
        };
    }

    abstract Iterable<UnixMountEntry> getMountEntries();

    abstract FileStore getFileStore(UnixMountEntry var1) throws IOException;

    @Override
    public final Iterable<FileStore> getFileStores() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            }
            catch (SecurityException securityException) {
                return Collections.emptyList();
            }
        }
        return new Iterable<FileStore>(){

            @Override
            public Iterator<FileStore> iterator() {
                return new FileStoreIterator();
            }
        };
    }

    @Override
    public final Path getPath(String string, String ... stringArray) {
        String string2;
        if (stringArray.length == 0) {
            string2 = string;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            for (String string3 : stringArray) {
                if (string3.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(string3);
            }
            string2 = stringBuilder.toString();
        }
        return new UnixPath(this, string2);
    }

    @Override
    public PathMatcher getPathMatcher(String string) {
        String string2;
        int n = string.indexOf(58);
        if (n <= 0 || n == string.length()) {
            throw new IllegalArgumentException();
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        if (string3.equals(GLOB_SYNTAX)) {
            string2 = Globs.toUnixRegexPattern(string4);
        } else if (string3.equals(REGEX_SYNTAX)) {
            string2 = string4;
        } else {
            throw new UnsupportedOperationException("Syntax '" + string3 + "' not recognized");
        }
        final Pattern pattern = this.compilePathMatchPattern(string2);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return pattern.matcher(path.toString()).matches();
            }
        };
    }

    @Override
    public final UserPrincipalLookupService getUserPrincipalLookupService() {
        return LookupService.instance;
    }

    Pattern compilePathMatchPattern(String string) {
        return Pattern.compile(string);
    }

    char[] normalizeNativePath(char[] cArray) {
        return cArray;
    }

    String normalizeJavaPath(String string) {
        return string;
    }

    private static class LookupService {
        static final UserPrincipalLookupService instance = new UserPrincipalLookupService(){

            @Override
            public UserPrincipal lookupPrincipalByName(String string) throws IOException {
                return UnixUserPrincipals.lookupUser(string);
            }

            @Override
            public GroupPrincipal lookupPrincipalByGroupName(String string) throws IOException {
                return UnixUserPrincipals.lookupGroup(string);
            }
        };

        private LookupService() {
        }
    }

    private class FileStoreIterator
    implements Iterator<FileStore> {
        private final Iterator<UnixMountEntry> entries;
        private FileStore next;

        FileStoreIterator() {
            this.entries = UnixFileSystem.this.getMountEntries().iterator();
        }

        private FileStore readNext() {
            assert (Thread.holdsLock(this));
            while (this.entries.hasNext()) {
                UnixMountEntry unixMountEntry = this.entries.next();
                if (unixMountEntry.isIgnored()) continue;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkRead(new String(unixMountEntry.dir()));
                    }
                    catch (SecurityException securityException) {
                        continue;
                    }
                }
                try {
                    return UnixFileSystem.this.getFileStore(unixMountEntry);
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            return null;
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.readNext();
            return this.next != null;
        }

        @Override
        public synchronized FileStore next() {
            if (this.next == null) {
                this.next = this.readNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            FileStore fileStore = this.next;
            this.next = null;
            return fileStore;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

