/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.HeapFloatBufferR;

class HeapFloatBuffer
extends FloatBuffer {
    HeapFloatBuffer(int n, int n2) {
        super(-1, 0, n2, n, new float[n], 0);
    }

    HeapFloatBuffer(float[] fArray, int n, int n2) {
        super(-1, n, n + n2, fArray.length, fArray, 0);
    }

    protected HeapFloatBuffer(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, fArray, n5);
    }

    @Override
    public FloatBuffer slice() {
        return new HeapFloatBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public FloatBuffer duplicate() {
        return new HeapFloatBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new HeapFloatBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    @Override
    public float get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public float get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    @Override
    public FloatBuffer get(float[] fArray, int n, int n2) {
        HeapFloatBuffer.checkBounds(n, n2, fArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), fArray, n, n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public FloatBuffer put(float f) {
        this.hb[this.ix((int)this.nextPutIndex())] = f;
        return this;
    }

    @Override
    public FloatBuffer put(int n, float f) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = f;
        return this;
    }

    @Override
    public FloatBuffer put(float[] fArray, int n, int n2) {
        HeapFloatBuffer.checkBounds(n, n2, fArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(fArray, n, this.hb, this.ix(this.position()), n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer instanceof HeapFloatBuffer) {
            if (floatBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapFloatBuffer heapFloatBuffer = (HeapFloatBuffer)floatBuffer;
            int n = heapFloatBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapFloatBuffer.hb, heapFloatBuffer.ix(heapFloatBuffer.position()), this.hb, this.ix(this.position()), n);
            heapFloatBuffer.position(heapFloatBuffer.position() + n);
            this.position(this.position() + n);
        } else if (floatBuffer.isDirect()) {
            int n = floatBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            floatBuffer.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(floatBuffer);
        }
        return this;
    }

    @Override
    public FloatBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

