/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.jules;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import sun.java2d.jules.IdleTileCache;
import sun.java2d.jules.JulesPathBuf;
import sun.java2d.jules.JulesTile;
import sun.java2d.jules.TileTrapContainer;
import sun.java2d.jules.TileWorker;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.xr.GrowableIntArray;
import sun.java2d.xr.XRUtils;

public class JulesAATileGenerator
implements AATileGenerator {
    static final ExecutorService rasterThreadPool = Executors.newCachedThreadPool();
    static final int CPU_CNT = Runtime.getRuntime().availableProcessors();
    static final boolean ENABLE_THREADING = false;
    static final int THREAD_MIN = 16;
    static final int THREAD_BEGIN = 16;
    IdleTileCache tileCache;
    TileWorker worker;
    boolean threaded = false;
    int rasterTileCnt;
    static final int TILE_SIZE = 32;
    static final int TILE_SIZE_FP = 0x200000;
    int left;
    int right;
    int top;
    int bottom;
    int width;
    int height;
    int leftFP;
    int topFP;
    int tileCnt;
    int tilesX;
    int tilesY;
    int currTilePos = 0;
    TrapezoidList traps;
    TileTrapContainer[] tiledTrapArray;
    JulesTile mainTile;

    public JulesAATileGenerator(Shape shape, AffineTransform affineTransform, Region region, BasicStroke basicStroke, boolean bl, boolean bl2, int[] nArray) {
        JulesPathBuf julesPathBuf = new JulesPathBuf();
        this.traps = basicStroke == null ? julesPathBuf.tesselateFill(shape, affineTransform, region) : julesPathBuf.tesselateStroke(shape, basicStroke, bl, false, true, affineTransform, region);
        this.calculateArea(nArray);
        this.bucketSortTraps();
        this.calculateTypicalAlpha();
        this.threaded = false;
        if (this.threaded) {
            this.tileCache = new IdleTileCache();
            this.worker = new TileWorker(this, 16, this.tileCache);
            rasterThreadPool.execute(this.worker);
        }
        this.mainTile = new JulesTile();
    }

    private static native long rasterizeTrapezoidsNative(long var0, int[] var2, int[] var3, int var4, byte[] var5, int var6, int var7);

    private static native void freePixmanImgPtr(long var0);

    private void calculateArea(int[] nArray) {
        this.tilesX = 0;
        this.tilesY = 0;
        this.tileCnt = 0;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        if (this.traps.getSize() > 0) {
            this.left = this.traps.getLeft();
            this.right = this.traps.getRight();
            this.top = this.traps.getTop();
            this.bottom = this.traps.getBottom();
            this.leftFP = this.left << 16;
            this.topFP = this.top << 16;
            nArray[0] = this.left;
            nArray[1] = this.top;
            nArray[2] = this.right;
            nArray[3] = this.bottom;
            this.width = this.right - this.left;
            this.height = this.bottom - this.top;
            if (this.width > 0 && this.height > 0) {
                this.tilesX = (int)Math.ceil((double)this.width / 32.0);
                this.tilesY = (int)Math.ceil((double)this.height / 32.0);
                this.tileCnt = this.tilesY * this.tilesX;
                this.tiledTrapArray = new TileTrapContainer[this.tileCnt];
            } else {
                this.traps.setSize(0);
            }
        }
    }

    private void bucketSortTraps() {
        for (int i = 0; i < this.traps.getSize(); ++i) {
            int n = this.traps.getTop(i) - XRUtils.XDoubleToFixed(this.top);
            int n2 = this.traps.getBottom(i) - this.topFP;
            int n3 = this.traps.getP1XLeft(i) - this.leftFP;
            int n4 = this.traps.getP2XLeft(i) - this.leftFP;
            int n5 = this.traps.getP1XRight(i) - this.leftFP;
            int n6 = this.traps.getP2XRight(i) - this.leftFP;
            int n7 = Math.min(n3, n4);
            int n8 = Math.max(n5, n6);
            n8 = n8 > 0 ? n8 - 1 : n8;
            n2 = n2 > 0 ? n2 - 1 : n2;
            int n9 = n / 0x200000;
            int n10 = n2 / 0x200000;
            int n11 = n7 / 0x200000;
            int n12 = n8 / 0x200000;
            for (int j = n9; j <= n10; ++j) {
                for (int k = n11; k <= n12; ++k) {
                    int n13 = j * this.tilesX + k;
                    TileTrapContainer tileTrapContainer = this.tiledTrapArray[n13];
                    if (tileTrapContainer == null) {
                        this.tiledTrapArray[n13] = tileTrapContainer = new TileTrapContainer(new GrowableIntArray(1, 16));
                    }
                    tileTrapContainer.getTraps().addInt(i);
                }
            }
        }
    }

    @Override
    public void getAlpha(byte[] byArray, int n, int n2) {
        JulesTile julesTile = null;
        if (this.threaded) {
            julesTile = this.worker.getPreRasterizedTile(this.currTilePos);
        }
        if (julesTile != null) {
            System.arraycopy(julesTile.getImgBuffer(), 0, byArray, 0, byArray.length);
            this.tileCache.releaseTile(julesTile);
        } else {
            this.mainTile.setImgBuffer(byArray);
            this.rasterizeTile(this.currTilePos, this.mainTile);
        }
        this.nextTile();
    }

    public void calculateTypicalAlpha() {
        this.rasterTileCnt = 0;
        for (int i = 0; i < this.tileCnt; ++i) {
            TileTrapContainer tileTrapContainer = this.tiledTrapArray[i];
            if (tileTrapContainer == null) continue;
            GrowableIntArray growableIntArray = tileTrapContainer.getTraps();
            int n = 127;
            if (growableIntArray == null || growableIntArray.getSize() == 0) {
                n = 0;
            } else if (this.doTrapsCoverTile(growableIntArray, i)) {
                n = 255;
            }
            if (n == 127 || n == 255) {
                ++this.rasterTileCnt;
            }
            tileTrapContainer.setTileAlpha(n);
        }
    }

    protected boolean doTrapsCoverTile(GrowableIntArray growableIntArray, int n) {
        if (growableIntArray.getSize() > 32) {
            return false;
        }
        int n2 = this.getXPos(n) * 0x200000 + this.leftFP;
        int n3 = this.getYPos(n) * 0x200000 + this.topFP;
        int n4 = n2 + 0x200000;
        int n5 = n3 + 0x200000;
        int n6 = this.traps.getTop(growableIntArray.getInt(0));
        int n7 = this.traps.getBottom(growableIntArray.getInt(0));
        if (n6 > n3 || n7 < n3) {
            return false;
        }
        int n8 = n6;
        for (int i = 0; i < growableIntArray.getSize(); ++i) {
            int n9 = growableIntArray.getInt(i);
            if (this.traps.getP1XLeft(n9) > n2 || this.traps.getP2XLeft(n9) > n2 || this.traps.getP1XRight(n9) < n4 || this.traps.getP2XRight(n9) < n4 || this.traps.getTop(n9) != n8) {
                return false;
            }
            n8 = this.traps.getBottom(n9);
        }
        return n8 >= n5;
    }

    @Override
    public int getTypicalAlpha() {
        if (this.tiledTrapArray[this.currTilePos] == null) {
            return 0;
        }
        return this.tiledTrapArray[this.currTilePos].getTileAlpha();
    }

    @Override
    public void dispose() {
        JulesAATileGenerator.freePixmanImgPtr(this.mainTile.getPixmanImgPtr());
        if (this.threaded) {
            this.tileCache.disposeConsumerResources();
            this.worker.disposeConsumerResources();
        }
    }

    protected JulesTile rasterizeTile(int n, JulesTile julesTile) {
        int n2 = this.left + this.getXPos(n) * 32;
        int n3 = this.top + this.getYPos(n) * 32;
        TileTrapContainer tileTrapContainer = this.tiledTrapArray[n];
        GrowableIntArray growableIntArray = tileTrapContainer.getTraps();
        if (tileTrapContainer.getTileAlpha() == 127) {
            long l = JulesAATileGenerator.rasterizeTrapezoidsNative(julesTile.getPixmanImgPtr(), this.traps.getTrapArray(), growableIntArray.getArray(), growableIntArray.getSize(), julesTile.getImgBuffer(), n2, n3);
            julesTile.setPixmanImgPtr(l);
        }
        julesTile.setTilePos(n);
        return julesTile;
    }

    protected int getXPos(int n) {
        return n % this.tilesX;
    }

    protected int getYPos(int n) {
        return n / this.tilesX;
    }

    @Override
    public void nextTile() {
        ++this.currTilePos;
    }

    @Override
    public int getTileHeight() {
        return 32;
    }

    @Override
    public int getTileWidth() {
        return 32;
    }

    public int getTileCount() {
        return this.tileCnt;
    }

    public TileTrapContainer getTrapContainer(int n) {
        return this.tiledTrapArray[n];
    }
}

