/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;
import sun.security.action.GetPropertyAction;

public class CMSManager {
    public static ColorSpace GRAYspace;
    public static ColorSpace LINEAR_RGBspace;
    private static PCMM cmmImpl;

    public static synchronized PCMM getModule() {
        if (cmmImpl != null) {
            return cmmImpl;
        }
        cmmImpl = (PCMM)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.CMM");
                ServiceLoader<PCMM> serviceLoader = ServiceLoader.loadInstalled(PCMM.class);
                PCMM pCMM = null;
                Iterator<PCMM> iterator = serviceLoader.iterator();
                while (iterator.hasNext()) {
                    PCMM pCMM2;
                    pCMM = pCMM2 = iterator.next();
                    if (!pCMM2.getClass().getName().equals(string)) continue;
                    break;
                }
                return pCMM;
            }
        });
        if (cmmImpl == null) {
            throw new CMMException("Cannot initialize Color Management System.No CM module found");
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("sun.java2d.cmm.trace");
        String string = AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            cmmImpl = new CMMTracer(cmmImpl);
        }
        return cmmImpl;
    }

    static {
        cmmImpl = null;
    }

    public static class CMMTracer
    implements PCMM {
        PCMM tcmm;
        String cName;

        public CMMTracer(PCMM pCMM) {
            this.tcmm = pCMM;
            this.cName = pCMM.getClass().getName();
        }

        @Override
        public long loadProfile(byte[] byArray) {
            System.err.print(this.cName + ".loadProfile");
            long l = this.tcmm.loadProfile(byArray);
            System.err.printf("(ID=%x)\n", l);
            return l;
        }

        @Override
        public void freeProfile(long l) {
            System.err.printf(this.cName + ".freeProfile(ID=%x)\n", l);
            this.tcmm.freeProfile(l);
        }

        @Override
        public int getProfileSize(long l) {
            System.err.print(this.cName + ".getProfileSize(ID=" + l + ")");
            int n = this.tcmm.getProfileSize(l);
            System.err.println("=" + n);
            return n;
        }

        @Override
        public void getProfileData(long l, byte[] byArray) {
            System.err.print(this.cName + ".getProfileData(ID=" + l + ") ");
            System.err.println("requested " + byArray.length + " byte(s)");
            this.tcmm.getProfileData(l, byArray);
        }

        @Override
        public int getTagSize(long l, int n) {
            System.err.printf(this.cName + ".getTagSize(ID=%x, TagSig=%s)", l, CMMTracer.signatureToString(n));
            int n2 = this.tcmm.getTagSize(l, n);
            System.err.println("=" + n2);
            return n2;
        }

        @Override
        public void getTagData(long l, int n, byte[] byArray) {
            System.err.printf(this.cName + ".getTagData(ID=%x, TagSig=%s)", l, CMMTracer.signatureToString(n));
            System.err.println(" requested " + byArray.length + " byte(s)");
            this.tcmm.getTagData(l, n, byArray);
        }

        @Override
        public void setTagData(long l, int n, byte[] byArray) {
            System.err.print(this.cName + ".setTagData(ID=" + l + ", TagSig=" + n + ")");
            System.err.println(" sending " + byArray.length + " byte(s)");
            this.tcmm.setTagData(l, n, byArray);
        }

        @Override
        public ColorTransform createTransform(ICC_Profile iCC_Profile, int n, int n2) {
            System.err.println(this.cName + ".createTransform(ICC_Profile,int,int)");
            return this.tcmm.createTransform(iCC_Profile, n, n2);
        }

        @Override
        public ColorTransform createTransform(ColorTransform[] colorTransformArray) {
            System.err.println(this.cName + ".createTransform(ColorTransform[])");
            return this.tcmm.createTransform(colorTransformArray);
        }

        private static String signatureToString(int n) {
            return String.format("%c%c%c%c", Character.valueOf((char)(0xFF & n >> 24)), Character.valueOf((char)(0xFF & n >> 16)), Character.valueOf((char)(0xFF & n >> 8)), Character.valueOf((char)(0xFF & n)));
        }
    }
}

