/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Set;
import sun.security.util.Debug;
import sun.security.util.UntrustedCertificates;

public final class UntrustedChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return true;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (UntrustedCertificates.isUntrusted(x509Certificate)) {
            if (debug != null) {
                debug.println("UntrustedChecker: untrusted certificate " + x509Certificate.getSubjectX500Principal());
            }
            throw new CertPathValidatorException("Untrusted certificate: " + x509Certificate.getSubjectX500Principal());
        }
    }
}

