/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.HashMap;
import java.util.Map;
import sun.awt.X11.XAtom;
import sun.awt.X11.XlibWrapper;

public class XPropertyCache {
    private static Map<Long, Map<XAtom, PropertyCacheEntry>> windowToMap = new HashMap<Long, Map<XAtom, PropertyCacheEntry>>();

    public static boolean isCached(long l, XAtom xAtom) {
        Map<XAtom, PropertyCacheEntry> map = windowToMap.get(l);
        if (map != null) {
            return map.containsKey(xAtom);
        }
        return false;
    }

    public static PropertyCacheEntry getCacheEntry(long l, XAtom xAtom) {
        Map<XAtom, PropertyCacheEntry> map = windowToMap.get(l);
        if (map != null) {
            return map.get(xAtom);
        }
        return null;
    }

    public static void storeCache(PropertyCacheEntry propertyCacheEntry, long l, XAtom xAtom) {
        Map<XAtom, PropertyCacheEntry> map = windowToMap.get(l);
        if (map == null) {
            map = new HashMap<XAtom, PropertyCacheEntry>();
            windowToMap.put(l, map);
        }
        map.put(xAtom, propertyCacheEntry);
    }

    public static void clearCache(long l) {
        windowToMap.remove(l);
    }

    public static void clearCache(long l, XAtom xAtom) {
        Map<XAtom, PropertyCacheEntry> map = windowToMap.get(l);
        if (map != null) {
            map.remove(xAtom);
        }
    }

    public static boolean isCachingSupported() {
        return false;
    }

    static class PropertyCacheEntry {
        private final int format;
        private final int numberOfItems;
        private final long bytesAfter;
        private final long data;
        private final int dataLength;

        public PropertyCacheEntry(int n, int n2, long l, long l2, int n3) {
            this.format = n;
            this.numberOfItems = n2;
            this.bytesAfter = l;
            this.data = XlibWrapper.unsafe.allocateMemory(n3);
            this.dataLength = n3;
            XlibWrapper.memcpy(this.data, l2, n3);
        }

        public int getFormat() {
            return this.format;
        }

        public int getNumberOfItems() {
            return this.numberOfItems;
        }

        public long getBytesAfter() {
            return this.bytesAfter;
        }

        public long getData() {
            return this.data;
        }

        public int getDataLength() {
            return this.dataLength;
        }
    }
}

