/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaInternalFrameBorderMetrics;
import com.apple.laf.AquaInternalFrameUI;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import sun.swing.SwingUtilities2;

public class AquaInternalFrameBorder
implements Border,
UIResource {
    private static final int kCloseButton = 0;
    private static final int kIconButton = 1;
    private static final int kGrowButton = 2;
    private static final int sMaxIconWidth = 15;
    private static final int sMaxIconHeight = 15;
    private static final int sAfterButtonPad = 11;
    private static final int sAfterIconPad = 5;
    private static final int sRightSideTitleClip = 0;
    private static final int kContentTester = 100;
    static final AquaUtils.RecyclableSingleton<AquaInternalFrameBorder> documentWindowFrame = new AquaUtils.RecyclableSingleton<AquaInternalFrameBorder>(){

        @Override
        protected AquaInternalFrameBorder getInstance() {
            return new AquaInternalFrameBorder(JRSUIConstants.WindowType.DOCUMENT);
        }
    };
    static final AquaUtils.RecyclableSingleton<AquaInternalFrameBorder> utilityWindowFrame = new AquaUtils.RecyclableSingleton<AquaInternalFrameBorder>(){

        @Override
        protected AquaInternalFrameBorder getInstance() {
            return new AquaInternalFrameBorder(JRSUIConstants.WindowType.UTILITY);
        }
    };
    static final AquaUtils.RecyclableSingleton<AquaInternalFrameBorder> dialogWindowFrame = new AquaUtils.RecyclableSingleton<AquaInternalFrameBorder>(){

        @Override
        protected AquaInternalFrameBorder getInstance() {
            return new AquaInternalFrameBorder(JRSUIConstants.WindowType.DOCUMENT);
        }
    };
    private final AquaInternalFrameBorderMetrics metrics;
    private final int fThisButtonSpan;
    private final int fThisLeftSideTotal;
    private final boolean fIsUtility;
    private final JRSUIConstants.WindowType fWindowKind;
    private Insets fBorderInsets;
    private Color selectedTextColor;
    private Color notSelectedTextColor;
    private Rectangle fInBounds;
    protected final AquaPainter<JRSUIState.TitleBarHeightState> titleBarPainter = AquaPainter.create(JRSUIStateFactory.getTitleBar());
    protected final AquaPainter<JRSUIState> widgetPainter = AquaPainter.create(JRSUIState.getInstance());

    protected static AquaInternalFrameBorder window() {
        return documentWindowFrame.get();
    }

    protected static AquaInternalFrameBorder utility() {
        return utilityWindowFrame.get();
    }

    protected static AquaInternalFrameBorder dialog() {
        return dialogWindowFrame.get();
    }

    protected AquaInternalFrameBorder(JRSUIConstants.WindowType windowType) {
        this.fWindowKind = windowType;
        ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(JRSUIConstants.WindowClipCorners.YES);
        if (this.fWindowKind == JRSUIConstants.WindowType.UTILITY) {
            this.fIsUtility = true;
            this.metrics = AquaInternalFrameBorderMetrics.getMetrics(true);
            ((JRSUIState)this.widgetPainter.state).set(JRSUIConstants.WindowType.UTILITY);
            ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(JRSUIConstants.WindowType.UTILITY);
        } else {
            this.fIsUtility = false;
            this.metrics = AquaInternalFrameBorderMetrics.getMetrics(false);
            ((JRSUIState)this.widgetPainter.state).set(JRSUIConstants.WindowType.DOCUMENT);
            ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(JRSUIConstants.WindowType.DOCUMENT);
        }
        ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).setValue(this.metrics.titleBarHeight);
        ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(JRSUIConstants.WindowTitleBarSeparator.YES);
        ((JRSUIState)this.widgetPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
        this.fThisButtonSpan = this.metrics.buttonWidth * 3 + this.metrics.buttonPadding * 2;
        this.fThisLeftSideTotal = this.metrics.leftSidePadding + this.fThisButtonSpan + 11;
    }

    public void setColors(Color color, Color color2) {
        this.selectedTextColor = color;
        this.notSelectedTextColor = color2;
    }

    protected void setInBounds(int n, int n2, int n3, int n4) {
        if (this.fInBounds == null) {
            this.fInBounds = new Rectangle();
        }
        this.fInBounds.x = n;
        this.fInBounds.y = n2;
        this.fInBounds.width = n3;
        this.fInBounds.height = n4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder((JInternalFrame)component, component, graphics, n, n2, n3, n4);
    }

    protected void paintTitleContents(Graphics graphics, JInternalFrame jInternalFrame, int n, int n2, int n3, int n4) {
        String string;
        boolean bl = jInternalFrame.isSelected();
        Font font = graphics.getFont();
        graphics.setFont(this.metrics.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = (this.metrics.titleBarHeight + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
        int n6 = this.fThisLeftSideTotal + 0;
        int n7 = this.getIconWidth(jInternalFrame);
        if (n7 > 0) {
            n7 += 5;
        }
        int n8 = n3;
        int n9 = n8 - n6 - n7 - 11;
        String string2 = string = jInternalFrame.getTitle();
        int n10 = 0;
        int n11 = this.fThisLeftSideTotal;
        boolean bl2 = false;
        if (string2 != null && !string2.equals("")) {
            n10 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            if (n10 > n9) {
                int n12;
                int n13;
                bl2 = true;
                n10 = SwingUtilities.computeStringWidth(fontMetrics, "\u2026");
                for (n13 = 0; n13 < string2.length() && n10 + (n12 = fontMetrics.charWidth(string2.charAt(n13))) <= n9; ++n13) {
                    n10 += n12;
                }
                string2 = string2.substring(0, n13) + "\u2026";
            }
            if (!bl2 && (n11 = (n8 - (n10 + n7)) / 2) < this.fThisLeftSideTotal) {
                n11 = this.fThisLeftSideTotal;
            }
            if (bl || this.fIsUtility) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.white);
            }
            SwingUtilities2.drawString((JComponent)jInternalFrame, graphics, string2, n + n11 + n7, n2 + n5 + 1);
            if (bl || this.fIsUtility) {
                graphics.setColor(this.selectedTextColor);
            } else {
                graphics.setColor(this.notSelectedTextColor);
            }
            SwingUtilities2.drawString((JComponent)jInternalFrame, graphics, string2, n + n11 + n7, n2 + n5);
            graphics.setFont(font);
        }
        int n14 = (this.metrics.titleBarHeight - this.getIconHeight(jInternalFrame)) / 2;
        this.paintTitleIcon(graphics, jInternalFrame, n + n11, n2 + n14);
    }

    public int getWhichButtonHit(JInternalFrame jInternalFrame, int n, int n2) {
        int n3 = -1;
        Insets insets = jInternalFrame.getInsets();
        int n4 = insets.left + this.metrics.leftSidePadding - 1;
        if (this.isInsideYButtonArea(insets, n2) && n >= n4) {
            if (n <= n4 + this.metrics.buttonWidth) {
                if (jInternalFrame.isClosable()) {
                    n3 = 0;
                }
            } else if (n >= (n4 += this.metrics.buttonWidth + this.metrics.buttonPadding) && n <= n4 + this.metrics.buttonWidth) {
                if (jInternalFrame.isIconifiable()) {
                    n3 = 1;
                }
            } else if (n >= (n4 += this.metrics.buttonWidth + this.metrics.buttonPadding) && n <= n4 + this.metrics.buttonWidth && jInternalFrame.isMaximizable()) {
                n3 = 2;
            }
        }
        return n3;
    }

    public void doButtonAction(JInternalFrame jInternalFrame, int n) {
        switch (n) {
            case 0: {
                jInternalFrame.doDefaultCloseAction();
                break;
            }
            case 1: {
                if (!jInternalFrame.isIconifiable()) break;
                if (!jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                try {
                    jInternalFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            case 2: {
                if (!jInternalFrame.isMaximizable()) break;
                if (!jInternalFrame.isMaximum()) {
                    try {
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                try {
                    jInternalFrame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            default: {
                System.err.println("AquaInternalFrameBorder should never get here!!!!");
                Thread.dumpStack();
            }
        }
    }

    public boolean isInsideYButtonArea(Insets insets, int n) {
        int n2 = insets.top - this.metrics.titleBarHeight / 2 - this.metrics.buttonHeight / 2 - 1;
        int n3 = n2 + this.metrics.buttonHeight;
        return n >= n2 && n <= n3;
    }

    public boolean getWithinRolloverArea(Insets insets, int n, int n2) {
        int n3 = insets.left + this.metrics.leftSidePadding;
        int n4 = n3 + this.fThisButtonSpan;
        return this.isInsideYButtonArea(insets, n2) && n >= n3 && n <= n4;
    }

    protected void paintTitleIcon(Graphics graphics, JInternalFrame jInternalFrame, int n, int n2) {
        Icon icon = jInternalFrame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon == null) {
            return;
        }
        if (icon instanceof ImageIcon && (icon.getIconWidth() > 15 || icon.getIconHeight() > 15)) {
            Image image = ((ImageIcon)icon).getImage();
            ((ImageIcon)icon).setImage(image.getScaledInstance(15, 15, 4));
        }
        icon.paintIcon(jInternalFrame, graphics, n, n2);
    }

    protected int getIconWidth(JInternalFrame jInternalFrame) {
        int n = 0;
        Icon icon = jInternalFrame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon != null && icon instanceof ImageIcon) {
            n = Math.min(icon.getIconWidth(), 15);
        }
        return n;
    }

    protected int getIconHeight(JInternalFrame jInternalFrame) {
        int n = 0;
        Icon icon = jInternalFrame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon != null && icon instanceof ImageIcon) {
            n = Math.min(icon.getIconHeight(), 15);
        }
        return n;
    }

    public void drawWindowTitle(Graphics graphics, JInternalFrame jInternalFrame, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        n8 = this.metrics.titleBarHeight + n4;
        ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(jInternalFrame.isSelected() ? JRSUIConstants.State.ACTIVE : JRSUIConstants.State.INACTIVE);
        this.titleBarPainter.paint(graphics, jInternalFrame, n5, n6, n7, n8);
        this.paintTitleContents(graphics, jInternalFrame, n5, n6, n7, n8);
        this.drawAllWidgets(graphics, jInternalFrame);
    }

    void paintBorder(JInternalFrame jInternalFrame, Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.fBorderInsets == null) {
            this.getBorderInsets(component);
        }
        this.setInBounds(n + this.fBorderInsets.left, n2 + this.fBorderInsets.top, n3 - (this.fBorderInsets.right + this.fBorderInsets.left), n4 - (this.fBorderInsets.top + this.fBorderInsets.bottom));
        this.setMetrics(jInternalFrame, component);
        this.drawWindowTitle(graphics, jInternalFrame, n, n2, n3, n4);
    }

    boolean isDirty(JInternalFrame jInternalFrame) {
        Object object = jInternalFrame.getClientProperty("windowModified");
        return object != null && object != Boolean.FALSE;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (this.fBorderInsets == null) {
            this.fBorderInsets = new Insets(0, 0, 0, 0);
        }
        if (!(component instanceof JInternalFrame)) {
            return this.fBorderInsets;
        }
        JInternalFrame jInternalFrame = (JInternalFrame)component;
        this.setInBounds(0, 0, 100, 100);
        this.setMetrics(jInternalFrame, component);
        this.fBorderInsets.left = 0;
        this.fBorderInsets.top = this.metrics.titleBarHeight;
        this.fBorderInsets.right = 0;
        this.fBorderInsets.bottom = 0;
        return this.fBorderInsets;
    }

    public void repaintButtonArea(JInternalFrame jInternalFrame) {
        Insets insets = jInternalFrame.getInsets();
        int n = insets.left + this.metrics.leftSidePadding;
        int n2 = insets.top - this.metrics.titleBarHeight + 1;
        jInternalFrame.repaint(n, n2, this.fThisButtonSpan, this.metrics.titleBarHeight - 2);
    }

    void drawAllWidgets(Graphics graphics, JInternalFrame jInternalFrame) {
        int n = this.metrics.leftSidePadding;
        int n2 = (this.metrics.titleBarHeight - this.metrics.buttonHeight) / 2 - this.metrics.titleBarHeight;
        Insets insets = jInternalFrame.getInsets();
        n += insets.left;
        n2 += insets.top + this.metrics.downShift;
        AquaInternalFrameUI aquaInternalFrameUI = (AquaInternalFrameUI)jInternalFrame.getUI();
        int n3 = aquaInternalFrameUI.getWhichButtonPressed();
        boolean bl = aquaInternalFrameUI.getMouseOverPressedButton();
        boolean bl2 = aquaInternalFrameUI.getRollover();
        boolean bl3 = jInternalFrame.isSelected() || this.fIsUtility;
        boolean bl4 = bl2 || bl3;
        boolean bl5 = this.isDirty(jInternalFrame);
        this.paintButton(graphics, jInternalFrame, n, n2, 0, n3, bl, jInternalFrame.isClosable(), bl4, bl2, bl5);
        this.paintButton(graphics, jInternalFrame, n += this.metrics.buttonPadding + this.metrics.buttonWidth, n2, 1, n3, bl, jInternalFrame.isIconifiable(), bl4, bl2, false);
        this.paintButton(graphics, jInternalFrame, n += this.metrics.buttonPadding + this.metrics.buttonWidth, n2, 2, n3, bl, jInternalFrame.isMaximizable(), bl4, bl2, false);
    }

    public void paintButton(Graphics graphics, JInternalFrame jInternalFrame, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        ((JRSUIState)this.widgetPainter.state).set(AquaInternalFrameBorder.getWidget(jInternalFrame, n3));
        ((JRSUIState)this.widgetPainter.state).set(AquaInternalFrameBorder.getState(n4 == n3 && bl, bl4, bl3, bl2));
        ((JRSUIState)this.widgetPainter.state).set(bl5 ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        this.widgetPainter.paint(graphics, jInternalFrame, n, n2, this.metrics.buttonWidth, this.metrics.buttonHeight);
    }

    static JRSUIConstants.Widget getWidget(JInternalFrame jInternalFrame, int n) {
        switch (n) {
            case 1: {
                return JRSUIConstants.Widget.TITLE_BAR_COLLAPSE_BOX;
            }
            case 2: {
                return JRSUIConstants.Widget.TITLE_BAR_ZOOM_BOX;
            }
        }
        return JRSUIConstants.Widget.TITLE_BAR_CLOSE_BOX;
    }

    static JRSUIConstants.State getState(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl4) {
            return JRSUIConstants.State.DISABLED;
        }
        if (!bl3) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (bl) {
            return JRSUIConstants.State.PRESSED;
        }
        if (bl2) {
            return JRSUIConstants.State.ROLLOVER;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected void setMetrics(JInternalFrame jInternalFrame, Component component) {
        Icon icon;
        String string = jInternalFrame.getTitle();
        FontMetrics fontMetrics = jInternalFrame.getFontMetrics(UIManager.getFont("InternalFrame.titleFont"));
        int n = 0;
        int n2 = fontMetrics.getAscent();
        if (string != null) {
            n = SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        if ((icon = jInternalFrame.getFrameIcon()) != null) {
            n += icon.getIconWidth();
            n2 = Math.max(n2, icon.getIconHeight());
        }
    }

    protected int getTitleHeight() {
        return this.metrics.titleBarHeight;
    }
}

