/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;

abstract class ChronoLocalDateImpl<D extends ChronoLocalDate>
implements ChronoLocalDate,
Temporal,
TemporalAdjuster,
Serializable {
    private static final long serialVersionUID = 6282433883239719096L;

    static <D extends ChronoLocalDate> D ensureValid(Chronology chronology, Temporal temporal) {
        ChronoLocalDate chronoLocalDate = (ChronoLocalDate)temporal;
        if (!chronology.equals(chronoLocalDate.getChronology())) {
            throw new ClassCastException("Chronology mismatch, expected: " + chronology.getId() + ", actual: " + chronoLocalDate.getChronology().getId());
        }
        return (D)chronoLocalDate;
    }

    ChronoLocalDateImpl() {
    }

    public D with(TemporalAdjuster temporalAdjuster) {
        return (D)ChronoLocalDate.super.with(temporalAdjuster);
    }

    public D with(TemporalField temporalField, long l) {
        return (D)ChronoLocalDate.super.with(temporalField, l);
    }

    public D plus(TemporalAmount temporalAmount) {
        return (D)ChronoLocalDate.super.plus(temporalAmount);
    }

    public D plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            switch (chronoUnit) {
                case DAYS: {
                    return this.plusDays(l);
                }
                case WEEKS: {
                    return this.plusDays(Math.multiplyExact(l, 7L));
                }
                case MONTHS: {
                    return this.plusMonths(l);
                }
                case YEARS: {
                    return this.plusYears(l);
                }
                case DECADES: {
                    return this.plusYears(Math.multiplyExact(l, 10L));
                }
                case CENTURIES: {
                    return this.plusYears(Math.multiplyExact(l, 100L));
                }
                case MILLENNIA: {
                    return this.plusYears(Math.multiplyExact(l, 1000L));
                }
                case ERAS: {
                    return (D)this.with(ChronoField.ERA, Math.addExact(this.getLong(ChronoField.ERA), l));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return (D)ChronoLocalDate.super.plus(l, temporalUnit);
    }

    public D minus(TemporalAmount temporalAmount) {
        return (D)ChronoLocalDate.super.minus(temporalAmount);
    }

    public D minus(long l, TemporalUnit temporalUnit) {
        return (D)ChronoLocalDate.super.minus(l, temporalUnit);
    }

    abstract D plusYears(long var1);

    abstract D plusMonths(long var1);

    D plusWeeks(long l) {
        return this.plusDays(Math.multiplyExact(l, 7L));
    }

    abstract D plusDays(long var1);

    D minusYears(long l) {
        return l == Long.MIN_VALUE ? ((ChronoLocalDateImpl)this.plusYears(Long.MAX_VALUE)).plusYears(1L) : this.plusYears(-l);
    }

    D minusMonths(long l) {
        return l == Long.MIN_VALUE ? ((ChronoLocalDateImpl)this.plusMonths(Long.MAX_VALUE)).plusMonths(1L) : this.plusMonths(-l);
    }

    D minusWeeks(long l) {
        return l == Long.MIN_VALUE ? ((ChronoLocalDateImpl)this.plusWeeks(Long.MAX_VALUE)).plusWeeks(1L) : this.plusWeeks(-l);
    }

    D minusDays(long l) {
        return l == Long.MIN_VALUE ? ((ChronoLocalDateImpl)this.plusDays(Long.MAX_VALUE)).plusDays(1L) : this.plusDays(-l);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        Objects.requireNonNull(temporal, "endExclusive");
        ChronoLocalDate chronoLocalDate = this.getChronology().date(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            switch ((ChronoUnit)temporalUnit) {
                case DAYS: {
                    return this.daysUntil(chronoLocalDate);
                }
                case WEEKS: {
                    return this.daysUntil(chronoLocalDate) / 7L;
                }
                case MONTHS: {
                    return this.monthsUntil(chronoLocalDate);
                }
                case YEARS: {
                    return this.monthsUntil(chronoLocalDate) / 12L;
                }
                case DECADES: {
                    return this.monthsUntil(chronoLocalDate) / 120L;
                }
                case CENTURIES: {
                    return this.monthsUntil(chronoLocalDate) / 1200L;
                }
                case MILLENNIA: {
                    return this.monthsUntil(chronoLocalDate) / 12000L;
                }
                case ERAS: {
                    return chronoLocalDate.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        Objects.requireNonNull(temporalUnit, "unit");
        return temporalUnit.between(this, chronoLocalDate);
    }

    private long daysUntil(ChronoLocalDate chronoLocalDate) {
        return chronoLocalDate.toEpochDay() - this.toEpochDay();
    }

    private long monthsUntil(ChronoLocalDate chronoLocalDate) {
        ValueRange valueRange = this.getChronology().range(ChronoField.MONTH_OF_YEAR);
        if (valueRange.getMaximum() != 12L) {
            throw new IllegalStateException("ChronoLocalDateImpl only supports Chronologies with 12 months per year");
        }
        long l = this.getLong(ChronoField.PROLEPTIC_MONTH) * 32L + (long)this.get(ChronoField.DAY_OF_MONTH);
        long l2 = chronoLocalDate.getLong(ChronoField.PROLEPTIC_MONTH) * 32L + (long)chronoLocalDate.get(ChronoField.DAY_OF_MONTH);
        return (l2 - l) / 32L;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoLocalDate) {
            return this.compareTo((ChronoLocalDate)object) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = this.toEpochDay();
        return this.getChronology().hashCode() ^ (int)(l ^ l >>> 32);
    }

    @Override
    public String toString() {
        long l = this.getLong(ChronoField.YEAR_OF_ERA);
        long l2 = this.getLong(ChronoField.MONTH_OF_YEAR);
        long l3 = this.getLong(ChronoField.DAY_OF_MONTH);
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(this.getChronology().toString()).append(" ").append(this.getEra()).append(" ").append(l).append(l2 < 10L ? "-0" : "-").append(l2).append(l3 < 10L ? "-0" : "-").append(l3);
        return stringBuilder.toString();
    }
}

