/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spnego.SpNegoMechFactory;

public class SpNegoCredElement
implements GSSCredentialSpi {
    private GSSCredentialSpi cred = null;

    public SpNegoCredElement(GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        this.cred = gSSCredentialSpi;
    }

    Oid getInternalMech() {
        return this.cred.getMechanism();
    }

    public GSSCredentialSpi getInternalCred() {
        return this.cred;
    }

    @Override
    public Provider getProvider() {
        return SpNegoMechFactory.PROVIDER;
    }

    @Override
    public void dispose() throws GSSException {
        this.cred.dispose();
    }

    @Override
    public GSSNameSpi getName() throws GSSException {
        return this.cred.getName();
    }

    @Override
    public int getInitLifetime() throws GSSException {
        return this.cred.getInitLifetime();
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        return this.cred.getAcceptLifetime();
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return this.cred.isInitiatorCredential();
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return this.cred.isAcceptorCredential();
    }

    @Override
    public Oid getMechanism() {
        return GSSUtil.GSS_SPNEGO_MECH_OID;
    }

    @Override
    public GSSCredentialSpi impersonate(GSSNameSpi gSSNameSpi) throws GSSException {
        return this.cred.impersonate(gSSNameSpi);
    }
}

