/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import sun.awt.AWTAutoShutdown;
import sun.awt.EventQueueItem;
import sun.awt.SunToolkit;

class PostEventQueue {
    private EventQueueItem queueHead = null;
    private EventQueueItem queueTail = null;
    private final EventQueue eventQueue;
    private volatile boolean isFlushing = false;

    PostEventQueue(EventQueue eventQueue) {
        this.eventQueue = eventQueue;
    }

    public synchronized boolean noEvents() {
        return this.queueHead == null && !this.isFlushing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        EventQueueItem eventQueueItem;
        PostEventQueue postEventQueue = this;
        synchronized (postEventQueue) {
            eventQueueItem = this.queueHead;
            this.queueTail = null;
            this.queueHead = null;
            this.isFlushing = eventQueueItem != null;
        }
        try {
            while (eventQueueItem != null) {
                this.eventQueue.postEvent(eventQueueItem.event);
                eventQueueItem = eventQueueItem.next;
            }
        }
        finally {
            this.isFlushing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postEvent(AWTEvent aWTEvent) {
        EventQueueItem eventQueueItem = new EventQueueItem(aWTEvent);
        PostEventQueue postEventQueue = this;
        synchronized (postEventQueue) {
            if (this.queueHead == null) {
                this.queueHead = this.queueTail = eventQueueItem;
            } else {
                this.queueTail.next = eventQueueItem;
                this.queueTail = eventQueueItem;
            }
        }
        SunToolkit.wakeupEventQueue(this.eventQueue, aWTEvent.getSource() == AWTAutoShutdown.getInstance());
    }
}

