/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Arrays;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNames;
import sun.security.x509.RDN;

public class DistributionPoint {
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int PRIVILEGE_WITHDRAWN = 7;
    public static final int AA_COMPROMISE = 8;
    private static final String[] REASON_STRINGS = new String[]{null, "key compromise", "CA compromise", "affiliation changed", "superseded", "cessation of operation", "certificate hold", "privilege withdrawn", "AA compromise"};
    private static final byte TAG_DIST_PT = 0;
    private static final byte TAG_REASONS = 1;
    private static final byte TAG_ISSUER = 2;
    private static final byte TAG_FULL_NAME = 0;
    private static final byte TAG_REL_NAME = 1;
    private GeneralNames fullName;
    private RDN relativeName;
    private boolean[] reasonFlags;
    private GeneralNames crlIssuer;
    private volatile int hashCode;

    public DistributionPoint(GeneralNames generalNames, boolean[] blArray, GeneralNames generalNames2) {
        if (generalNames == null && generalNames2 == null) {
            throw new IllegalArgumentException("fullName and crlIssuer may not both be null");
        }
        this.fullName = generalNames;
        this.reasonFlags = blArray;
        this.crlIssuer = generalNames2;
    }

    public DistributionPoint(RDN rDN, boolean[] blArray, GeneralNames generalNames) {
        if (rDN == null && generalNames == null) {
            throw new IllegalArgumentException("relativeName and crlIssuer may not both be null");
        }
        this.relativeName = rDN;
        this.reasonFlags = blArray;
        this.crlIssuer = generalNames;
    }

    public DistributionPoint(DerValue derValue) throws IOException {
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding of DistributionPoint.");
        }
        while (derValue.data != null && derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
                if (this.fullName != null || this.relativeName != null) {
                    throw new IOException("Duplicate DistributionPointName in DistributionPoint.");
                }
                DerValue derValue3 = derValue2.data.getDerValue();
                if (derValue3.isContextSpecific((byte)0) && derValue3.isConstructed()) {
                    derValue3.resetTag((byte)48);
                    this.fullName = new GeneralNames(derValue3);
                    continue;
                }
                if (derValue3.isContextSpecific((byte)1) && derValue3.isConstructed()) {
                    derValue3.resetTag((byte)49);
                    this.relativeName = new RDN(derValue3);
                    continue;
                }
                throw new IOException("Invalid DistributionPointName in DistributionPoint");
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                if (this.reasonFlags != null) {
                    throw new IOException("Duplicate Reasons in DistributionPoint.");
                }
                derValue2.resetTag((byte)3);
                this.reasonFlags = derValue2.getUnalignedBitString().toBooleanArray();
                continue;
            }
            if (derValue2.isContextSpecific((byte)2) && derValue2.isConstructed()) {
                if (this.crlIssuer != null) {
                    throw new IOException("Duplicate CRLIssuer in DistributionPoint.");
                }
                derValue2.resetTag((byte)48);
                this.crlIssuer = new GeneralNames(derValue2);
                continue;
            }
            throw new IOException("Invalid encoding of DistributionPoint.");
        }
        if (this.crlIssuer == null && this.fullName == null && this.relativeName == null) {
            throw new IOException("One of fullName, relativeName,  and crlIssuer has to be set");
        }
    }

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getRelativeName() {
        return this.relativeName;
    }

    public boolean[] getReasonFlags() {
        return this.reasonFlags;
    }

    public GeneralNames getCRLIssuer() {
        return this.crlIssuer;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        Object object;
        DerOutputStream derOutputStream2;
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.fullName != null || this.relativeName != null) {
            derOutputStream2 = new DerOutputStream();
            if (this.fullName != null) {
                object = new DerOutputStream();
                this.fullName.encode((DerOutputStream)object);
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), (DerOutputStream)object);
            } else if (this.relativeName != null) {
                object = new DerOutputStream();
                this.relativeName.encode((DerOutputStream)object);
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), (DerOutputStream)object);
            }
            derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        }
        if (this.reasonFlags != null) {
            derOutputStream2 = new DerOutputStream();
            object = new BitArray(this.reasonFlags);
            derOutputStream2.putTruncatedUnalignedBitString((BitArray)object);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream2);
        }
        if (this.crlIssuer != null) {
            derOutputStream2 = new DerOutputStream();
            this.crlIssuer.encode(derOutputStream2);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream3);
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DistributionPoint)) {
            return false;
        }
        DistributionPoint distributionPoint = (DistributionPoint)object;
        boolean bl = DistributionPoint.equals(this.fullName, distributionPoint.fullName) && DistributionPoint.equals(this.relativeName, distributionPoint.relativeName) && DistributionPoint.equals(this.crlIssuer, distributionPoint.crlIssuer) && Arrays.equals(this.reasonFlags, distributionPoint.reasonFlags);
        return bl;
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 1;
            if (this.fullName != null) {
                n += this.fullName.hashCode();
            }
            if (this.relativeName != null) {
                n += this.relativeName.hashCode();
            }
            if (this.crlIssuer != null) {
                n += this.crlIssuer.hashCode();
            }
            if (this.reasonFlags != null) {
                for (int i = 0; i < this.reasonFlags.length; ++i) {
                    if (!this.reasonFlags[i]) continue;
                    n += i;
                }
            }
            this.hashCode = n;
        }
        return n;
    }

    private static String reasonToString(int n) {
        if (n > 0 && n < REASON_STRINGS.length) {
            return REASON_STRINGS[n];
        }
        return "Unknown reason " + n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fullName != null) {
            stringBuilder.append("DistributionPoint:\n     " + this.fullName + "\n");
        }
        if (this.relativeName != null) {
            stringBuilder.append("DistributionPoint:\n     " + this.relativeName + "\n");
        }
        if (this.reasonFlags != null) {
            stringBuilder.append("   ReasonFlags:\n");
            for (int i = 0; i < this.reasonFlags.length; ++i) {
                if (!this.reasonFlags[i]) continue;
                stringBuilder.append("    " + DistributionPoint.reasonToString(i) + "\n");
            }
        }
        if (this.crlIssuer != null) {
            stringBuilder.append("   CRLIssuer:" + this.crlIssuer + "\n");
        }
        return stringBuilder.toString();
    }
}

