#ifndef HAVE_DEFINED_STRIDED_DATA_H
#define HAVE_DEFINED_STRIDED_DATA_H

#include <stdint-gcc.h>
#include <stdbool.h>
#include <stddef.h>

#define N 32
#define TEST_STRIDED_LD_ST_DATA(T)      test_strided_ld_st_##T##_data
#define TEST_STRIDED_LD_ST_DATA_WRAP(T) TEST_STRIDED_LD_ST_DATA(T)

int8_t TEST_STRIDED_LD_ST_DATA(int8_t)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
       127,  127,  127,  127,
       127,  127,  127,  127,
       127,  127,  127,  127,
       127,  127,  127,  127,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
      -128, -128, -128, -128,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
       127, 0, 0, 0,
       127, 0, 0, 0,
       127, 0, 0, 0,
       127, 0, 0, 0,
      -128, 0, 0, 0,
      -128, 0, 0, 0,
      -128, 0, 0, 0,
      -128, 0, 0, 0,
    },
  },
};

int16_t TEST_STRIDED_LD_ST_DATA(int16_t)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
       32767,  32767,  32767,  32767,
       32767,  32767,  32767,  32767,
       32767,  32767,  32767,  32767,
       32767,  32767,  32767,  32767,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
      -32768, -32768, -32768, -32768,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
       32767, 0, 0, 0,
       32767, 0, 0, 0,
       32767, 0, 0, 0,
       32767, 0, 0, 0,
      -32768, 0, 0, 0,
      -32768, 0, 0, 0,
      -32768, 0, 0, 0,
      -32768, 0, 0, 0,
    },
  },
};

int32_t TEST_STRIDED_LD_ST_DATA(int32_t)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
       2147483647,  2147483647,  2147483647,  2147483647,
       2147483647,  2147483647,  2147483647,  2147483647,
       2147483647,  2147483647,  2147483647,  2147483647,
       2147483647,  2147483647,  2147483647,  2147483647,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
      -2147483648, -2147483648, -2147483648, -2147483648,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
       2147483647, 0, 0, 0,
       2147483647, 0, 0, 0,
       2147483647, 0, 0, 0,
       2147483647, 0, 0, 0,
      -2147483648, 0, 0, 0,
      -2147483648, 0, 0, 0,
      -2147483648, 0, 0, 0,
      -2147483648, 0, 0, 0,
    },
  },
};

int64_t TEST_STRIDED_LD_ST_DATA(int64_t)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
        9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,
        9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,
        9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,
        9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,   9223372036854775807ll,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
      -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull, -9223372036854775808ull,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
        9223372036854775807ll, 0, 0, 0,
        9223372036854775807ll, 0, 0, 0,
        9223372036854775807ll, 0, 0, 0,
        9223372036854775807ll, 0, 0, 0,
      -9223372036854775808ull, 0, 0, 0,
      -9223372036854775808ull, 0, 0, 0,
      -9223372036854775808ull, 0, 0, 0,
      -9223372036854775808ull, 0, 0, 0,
    },
  },
};

uint8_t TEST_STRIDED_LD_ST_DATA(uint8_t)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
      255, 255, 255, 255,
      255, 255, 255, 255,
      255, 255, 255, 255,
      255, 255, 255, 255,
      254, 254, 254, 254,
      254, 254, 254, 254,
      254, 254, 254, 254,
      254, 254, 254, 254,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      255, 0, 0, 0,
      255, 0, 0, 0,
      255, 0, 0, 0,
      255, 0, 0, 0,
      254, 0, 0, 0,
      254, 0, 0, 0,
      254, 0, 0, 0,
      254, 0, 0, 0,
    },
  },
};

uint16_t TEST_STRIDED_LD_ST_DATA(uint16_t)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
      65535, 65535, 65535, 65535,
      65535, 65535, 65535, 65535,
      65535, 65535, 65535, 65535,
      65535, 65535, 65535, 65535,
      65534, 65534, 65534, 65534,
      65534, 65534, 65534, 65534,
      65534, 65534, 65534, 65534,
      65534, 65534, 65534, 65534,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      65535, 0, 0, 0,
      65535, 0, 0, 0,
      65535, 0, 0, 0,
      65535, 0, 0, 0,
      65534, 0, 0, 0,
      65534, 0, 0, 0,
      65534, 0, 0, 0,
      65534, 0, 0, 0,
    },
  },
};

uint32_t TEST_STRIDED_LD_ST_DATA(uint32_t)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967294, 4294967294, 4294967294, 4294967294,
      4294967294, 4294967294, 4294967294, 4294967294,
      4294967294, 4294967294, 4294967294, 4294967294,
      4294967294, 4294967294, 4294967294, 4294967294,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      4294967295, 0, 0, 0,
      4294967295, 0, 0, 0,
      4294967295, 0, 0, 0,
      4294967295, 0, 0, 0,
      4294967294, 0, 0, 0,
      4294967294, 0, 0, 0,
      4294967294, 0, 0, 0,
      4294967294, 0, 0, 0,
    },
  },
};

uint64_t TEST_STRIDED_LD_ST_DATA(uint64_t)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
      1, 0, 0, 0,
      0, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
      2, 3, 9, 7,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
      2, 0, 9, 0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
      18446744073709551615ull, 18446744073709551615ull, 18446744073709551615ull, 18446744073709551615ull,
      18446744073709551615ull, 18446744073709551615ull, 18446744073709551615ull, 18446744073709551615ull,
      18446744073709551615ull, 18446744073709551615ull, 18446744073709551615ull, 18446744073709551615ull,
      18446744073709551615ull, 18446744073709551615ull, 18446744073709551615ull, 18446744073709551615ull,
      18446744073709551614ull, 18446744073709551614ull, 18446744073709551614ull, 18446744073709551614ull,
      18446744073709551614ull, 18446744073709551614ull, 18446744073709551614ull, 18446744073709551614ull,
      18446744073709551614ull, 18446744073709551614ull, 18446744073709551614ull, 18446744073709551614ull,
      18446744073709551614ull, 18446744073709551614ull, 18446744073709551614ull, 18446744073709551614ull,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
      18446744073709551615ull, 0, 0, 0,
      18446744073709551615ull, 0, 0, 0,
      18446744073709551615ull, 0, 0, 0,
      18446744073709551615ull, 0, 0, 0,
      18446744073709551614ull, 0, 0, 0,
      18446744073709551614ull, 0, 0, 0,
      18446744073709551614ull, 0, 0, 0,
      18446744073709551614ull, 0, 0, 0,
    },
  },
};

_Float16 TEST_STRIDED_LD_ST_DATA(_Float16)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
    },
    { /* output */
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
    },
    { /* expect */
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
    },
    { /* output */
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
    },
    { /* expect */
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
       127.8,  127.8,  127.8,  127.8,
       127.8,  127.8,  127.8,  127.8,
       127.8,  127.8,  127.8,  127.8,
       127.8,  127.8,  127.8,  127.8,
      -128.2, -128.2, -128.2, -128.2,
      -128.2, -128.2, -128.2, -128.2,
      -128.2, -128.2, -128.2, -128.2,
      -128.2, -128.2, -128.2, -128.2,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
       127.8, 0, 0, 0,
       127.8, 0, 0, 0,
       127.8, 0, 0, 0,
       127.8, 0, 0, 0,
      -128.2, 0, 0, 0,
      -128.2, 0, 0, 0,
      -128.2, 0, 0, 0,
      -128.2, 0, 0, 0,
    },
  },
};

float TEST_STRIDED_LD_ST_DATA(float)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
    },
    { /* output */
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
    },
    { /* expect */
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
    },
    { /* output */
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
    },
    { /* expect */
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
       148885872271752691712.0,  148885872271752691712.0,  148885872271752691712.0,  148885872271752691712.0,
       148885872271752691712.0,  148885872271752691712.0,  148885872271752691712.0,  148885872271752691712.0,
       148885872271752691712.0,  148885872271752691712.0,  148885872271752691712.0,  148885872271752691712.0,
       148885872271752691712.0,  148885872271752691712.0,  148885872271752691712.0,  148885872271752691712.0,
      -639460027801474761417333669888.0, -639460027801474761417333669888.0, -639460027801474761417333669888.0, -639460027801474761417333669888.0,
      -639460027801474761417333669888.0, -639460027801474761417333669888.0, -639460027801474761417333669888.0, -639460027801474761417333669888.0,
      -639460027801474761417333669888.0, -639460027801474761417333669888.0, -639460027801474761417333669888.0, -639460027801474761417333669888.0,
      -639460027801474761417333669888.0, -639460027801474761417333669888.0, -639460027801474761417333669888.0, -639460027801474761417333669888.0,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
       148885872271752691712.0, 0, 0, 0,
       148885872271752691712.0, 0, 0, 0,
       148885872271752691712.0, 0, 0, 0,
       148885872271752691712.0, 0, 0, 0,
      -639460027801474761417333669888.0, 0, 0, 0,
      -639460027801474761417333669888.0, 0, 0, 0,
      -639460027801474761417333669888.0, 0, 0, 0,
      -639460027801474761417333669888.0, 0, 0, 0,
    },
  },
};

double TEST_STRIDED_LD_ST_DATA(double)[][4][N] =
{
  {
    { 1 }, /* stride */
    { /* input */
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
    },
    { /* output */
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
    },
    { /* expect */
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
      1.4, 0.2, 0.8, 0.8,
      0.4, 1.2, 0.8, 0.8,
      0.4, 0.2, 1.8, 0.8,
      0.4, 0.2, 0.8, 1.8,
    },
  },
  {
    { 2 }, /* stride */
    { /* input */
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
      2.6, 3.1, 9.4, 7.8,
    },
    { /* output */
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
    },
    { /* expect */
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
      2.6, 0.0, 9.4, 0.0,
    },
  },
  {
    { 4 }, /* stride */
    { /* input */
       98789784453484056064183762944.0,  98789784453484056064183762944.0,  98789784453484056064183762944.0,  98789784453484056064183762944.0,
       98789784453484056064183762944.0,  98789784453484056064183762944.0,  98789784453484056064183762944.0,  98789784453484056064183762944.0,
       98789784453484056064183762944.0,  98789784453484056064183762944.0,  98789784453484056064183762944.0,  98789784453484056064183762944.0,
       98789784453484056064183762944.0,  98789784453484056064183762944.0,  98789784453484056064183762944.0,  98789784453484056064183762944.0,
      -1507412482505555054690304.0, -1507412482505555054690304.0, -1507412482505555054690304.0, -1507412482505555054690304.0,
      -1507412482505555054690304.0, -1507412482505555054690304.0, -1507412482505555054690304.0, -1507412482505555054690304.0,
      -1507412482505555054690304.0, -1507412482505555054690304.0, -1507412482505555054690304.0, -1507412482505555054690304.0,
      -1507412482505555054690304.0, -1507412482505555054690304.0, -1507412482505555054690304.0, -1507412482505555054690304.0,
    },
    { /* output */
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
      0, 0, 0, 0,
    },
    { /* expect */
       98789784453484056064183762944.0, 0, 0, 0,
       98789784453484056064183762944.0, 0, 0, 0,
       98789784453484056064183762944.0, 0, 0, 0,
       98789784453484056064183762944.0, 0, 0, 0,
      -1507412482505555054690304.0, 0, 0, 0,
      -1507412482505555054690304.0, 0, 0, 0,
      -1507412482505555054690304.0, 0, 0, 0,
      -1507412482505555054690304.0, 0, 0, 0,
    },
  },
};

#endif
