/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KRBError
implements Serializable {
    static final long serialVersionUID = 3643809337475284503L;
    private int pvno;
    private int msgType;
    private KerberosTime cTime;
    private Integer cuSec;
    private KerberosTime sTime;
    private Integer suSec;
    private int errorCode;
    private PrincipalName cname;
    private PrincipalName sname;
    private String eText;
    private byte[] eData;
    private Checksum eCksum;
    private PAData[] pa;
    private static boolean DEBUG = Krb5.DEBUG;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.init(new DerValue((byte[])objectInputStream.readObject()));
            this.parseEData(this.eData);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeObject(this.asn1Encode());
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public KRBError(APOptions aPOptions, KerberosTime kerberosTime, Integer n, KerberosTime kerberosTime2, Integer n2, int n3, PrincipalName principalName, PrincipalName principalName2, String string, byte[] byArray) throws IOException, Asn1Exception {
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = kerberosTime;
        this.cuSec = n;
        this.sTime = kerberosTime2;
        this.suSec = n2;
        this.errorCode = n3;
        this.cname = principalName;
        this.sname = principalName2;
        this.eText = string;
        this.eData = byArray;
        this.parseEData(this.eData);
    }

    public KRBError(APOptions aPOptions, KerberosTime kerberosTime, Integer n, KerberosTime kerberosTime2, Integer n2, int n3, PrincipalName principalName, PrincipalName principalName2, String string, byte[] byArray, Checksum checksum) throws IOException, Asn1Exception {
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = kerberosTime;
        this.cuSec = n;
        this.sTime = kerberosTime2;
        this.suSec = n2;
        this.errorCode = n3;
        this.cname = principalName;
        this.sname = principalName2;
        this.eText = string;
        this.eData = byArray;
        this.eCksum = checksum;
        this.parseEData(this.eData);
    }

    public KRBError(byte[] byArray) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(new DerValue(byArray));
        this.parseEData(this.eData);
    }

    public KRBError(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(derValue);
        this.showDebug();
        this.parseEData(this.eData);
    }

    private void parseEData(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        if (this.errorCode == 25 || this.errorCode == 24) {
            try {
                this.parsePAData(byArray);
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println("Unable to parse eData field of KRB-ERROR:\n" + new HexDumpEncoder().encodeBuffer(byArray));
                }
                IOException iOException = new IOException("Unable to parse eData field of KRB-ERROR");
                iOException.initCause(exception);
                throw iOException;
            }
        } else if (DEBUG) {
            System.out.println("Unknown eData field of KRB-ERROR:\n" + new HexDumpEncoder().encodeBuffer(byArray));
        }
    }

    private void parsePAData(byte[] byArray) throws IOException, Asn1Exception {
        DerValue derValue = new DerValue(byArray);
        ArrayList<PAData> arrayList = new ArrayList<PAData>();
        while (derValue.data.available() > 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            PAData pAData = new PAData(derValue2);
            arrayList.add(pAData);
            if (!DEBUG) continue;
            System.out.println(pAData);
        }
        this.pa = arrayList.toArray(new PAData[arrayList.size()]);
    }

    public final KerberosTime getServerTime() {
        return this.sTime;
    }

    public final KerberosTime getClientTime() {
        return this.cTime;
    }

    public final Integer getServerMicroSeconds() {
        return this.suSec;
    }

    public final Integer getClientMicroSeconds() {
        return this.cuSec;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final PAData[] getPA() {
        return this.pa;
    }

    public final String getErrorString() {
        return this.eText;
    }

    private void init(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((derValue.getTag() & 0x1F) != 30 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            this.pvno = derValue3.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            this.msgType = derValue3.getData().getBigInteger().intValue();
            if (this.msgType != 30) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.cTime = KerberosTime.parse(derValue2.getData(), (byte)2, true);
        if ((derValue2.getData().peekByte() & 0x1F) == 3) {
            derValue3 = derValue2.getData().getDerValue();
            this.cuSec = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.cuSec = null;
        }
        this.sTime = KerberosTime.parse(derValue2.getData(), (byte)4, false);
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 5) {
            throw new Asn1Exception(906);
        }
        this.suSec = new Integer(derValue3.getData().getBigInteger().intValue());
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 6) {
            throw new Asn1Exception(906);
        }
        this.errorCode = derValue3.getData().getBigInteger().intValue();
        Realm realm = Realm.parse(derValue2.getData(), (byte)7, true);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)8, true, realm);
        Realm realm2 = Realm.parse(derValue2.getData(), (byte)9, false);
        this.sname = PrincipalName.parse(derValue2.getData(), (byte)10, false, realm2);
        this.eText = null;
        this.eData = null;
        this.eCksum = null;
        if (derValue2.getData().available() > 0 && (derValue2.getData().peekByte() & 0x1F) == 11) {
            derValue3 = derValue2.getData().getDerValue();
            this.eText = new KerberosString(derValue3.getData().getDerValue()).toString();
        }
        if (derValue2.getData().available() > 0 && (derValue2.getData().peekByte() & 0x1F) == 12) {
            derValue3 = derValue2.getData().getDerValue();
            this.eData = derValue3.getData().getOctetString();
        }
        if (derValue2.getData().available() > 0) {
            this.eCksum = Checksum.parse(derValue2.getData(), (byte)13, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    private void showDebug() {
        if (DEBUG) {
            System.out.println(">>>KRBError:");
            if (this.cTime != null) {
                System.out.println("\t cTime is " + this.cTime.toDate().toString() + " " + this.cTime.toDate().getTime());
            }
            if (this.cuSec != null) {
                System.out.println("\t cuSec is " + this.cuSec);
            }
            System.out.println("\t sTime is " + this.sTime.toDate().toString() + " " + this.sTime.toDate().getTime());
            System.out.println("\t suSec is " + this.suSec);
            System.out.println("\t error code is " + this.errorCode);
            System.out.println("\t error Message is " + Krb5.getErrorMessage(this.errorCode));
            if (this.cname != null) {
                System.out.println("\t cname is " + this.cname.toString());
            }
            if (this.sname != null) {
                System.out.println("\t sname is " + this.sname.toString());
            }
            if (this.eData != null) {
                System.out.println("\t eData provided.");
            }
            if (this.eCksum != null) {
                System.out.println("\t checksum provided.");
            }
            System.out.println("\t msgType is " + this.msgType);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        if (this.cTime != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)2), this.cTime.asn1Encode());
        }
        if (this.cuSec != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.cuSec.intValue()));
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)4), this.sTime.asn1Encode());
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.suSec.intValue()));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)5), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.errorCode));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)6), derOutputStream);
        if (this.cname != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)7), this.cname.getRealm().asn1Encode());
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)8), this.cname.asn1Encode());
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)9), this.sname.getRealm().asn1Encode());
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)10), this.sname.asn1Encode());
        if (this.eText != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putDerValue(new KerberosString(this.eText).toDerValue());
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)11), derOutputStream);
        }
        if (this.eData != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.eData);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)12), derOutputStream);
        }
        if (this.eCksum != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)13), this.eCksum.asn1Encode());
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, true, (byte)30), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KRBError)) {
            return false;
        }
        KRBError kRBError = (KRBError)object;
        return this.pvno == kRBError.pvno && this.msgType == kRBError.msgType && KRBError.isEqual(this.cTime, kRBError.cTime) && KRBError.isEqual(this.cuSec, kRBError.cuSec) && KRBError.isEqual(this.sTime, kRBError.sTime) && KRBError.isEqual(this.suSec, kRBError.suSec) && this.errorCode == kRBError.errorCode && KRBError.isEqual(this.cname, kRBError.cname) && KRBError.isEqual(this.sname, kRBError.sname) && KRBError.isEqual(this.eText, kRBError.eText) && Arrays.equals(this.eData, kRBError.eData) && KRBError.isEqual(this.eCksum, kRBError.eCksum);
    }

    private static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.pvno;
        n = 37 * n + this.msgType;
        if (this.cTime != null) {
            n = 37 * n + this.cTime.hashCode();
        }
        if (this.cuSec != null) {
            n = 37 * n + this.cuSec.hashCode();
        }
        if (this.sTime != null) {
            n = 37 * n + this.sTime.hashCode();
        }
        if (this.suSec != null) {
            n = 37 * n + this.suSec.hashCode();
        }
        n = 37 * n + this.errorCode;
        if (this.cname != null) {
            n = 37 * n + this.cname.hashCode();
        }
        if (this.sname != null) {
            n = 37 * n + this.sname.hashCode();
        }
        if (this.eText != null) {
            n = 37 * n + this.eText.hashCode();
        }
        n = 37 * n + Arrays.hashCode(this.eData);
        if (this.eCksum != null) {
            n = 37 * n + this.eCksum.hashCode();
        }
        return n;
    }
}

