/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;

public class IconInfo {
    private int[] intIconData;
    private long[] longIconData;
    private Image image;
    private final int width;
    private final int height;
    private int scaledWidth;
    private int scaledHeight;
    private int rawLength;

    public IconInfo(int[] nArray) {
        this.intIconData = null == nArray ? null : Arrays.copyOf(nArray, nArray.length);
        this.width = nArray[0];
        this.height = nArray[1];
        this.scaledWidth = this.width;
        this.scaledHeight = this.height;
        this.rawLength = this.width * this.height + 2;
    }

    public IconInfo(long[] lArray) {
        this.longIconData = null == lArray ? null : Arrays.copyOf(lArray, lArray.length);
        this.width = (int)lArray[0];
        this.height = (int)lArray[1];
        this.scaledWidth = this.width;
        this.scaledHeight = this.height;
        this.rawLength = this.width * this.height + 2;
    }

    public IconInfo(Image image) {
        this.image = image;
        if (image instanceof ToolkitImage) {
            ImageRepresentation imageRepresentation = ((ToolkitImage)image).getImageRep();
            imageRepresentation.reconstruct(32);
            this.width = imageRepresentation.getWidth();
            this.height = imageRepresentation.getHeight();
        } else {
            this.width = image.getWidth(null);
            this.height = image.getHeight(null);
        }
        this.scaledWidth = this.width;
        this.scaledHeight = this.height;
        this.rawLength = this.width * this.height + 2;
    }

    public void setScaledSize(int n, int n2) {
        this.scaledWidth = n;
        this.scaledHeight = n2;
        this.rawLength = n * n2 + 2;
    }

    public boolean isValid() {
        return this.width > 0 && this.height > 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return "IconInfo[w=" + this.width + ",h=" + this.height + ",sw=" + this.scaledWidth + ",sh=" + this.scaledHeight + "]";
    }

    public int getRawLength() {
        return this.rawLength;
    }

    public int[] getIntData() {
        if (this.intIconData == null) {
            if (this.longIconData != null) {
                this.intIconData = IconInfo.longArrayToIntArray(this.longIconData);
            } else if (this.image != null) {
                this.intIconData = IconInfo.imageToIntArray(this.image, this.scaledWidth, this.scaledHeight);
            }
        }
        return this.intIconData;
    }

    public long[] getLongData() {
        if (this.longIconData == null) {
            if (this.intIconData != null) {
                this.longIconData = IconInfo.intArrayToLongArray(this.intIconData);
            } else if (this.image != null) {
                int[] nArray = IconInfo.imageToIntArray(this.image, this.scaledWidth, this.scaledHeight);
                this.longIconData = IconInfo.intArrayToLongArray(nArray);
            }
        }
        return this.longIconData;
    }

    public Image getImage() {
        if (this.image == null) {
            if (this.intIconData != null) {
                this.image = IconInfo.intArrayToImage(this.intIconData);
            } else if (this.longIconData != null) {
                int[] nArray = IconInfo.longArrayToIntArray(this.longIconData);
                this.image = IconInfo.intArrayToImage(nArray);
            }
        }
        return this.image;
    }

    private static int[] longArrayToIntArray(long[] lArray) {
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    private static long[] intArrayToLongArray(int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    static Image intArrayToImage(int[] nArray) {
        DirectColorModel directColorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length - 2, 2);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, nArray[0], nArray[1], nArray[0], new int[]{0xFF0000, 65280, 255, -16777216}, null);
        BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    static int[] imageToIntArray(Image image, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        DirectColorModel directColorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        DataBufferInt dataBufferInt = new DataBufferInt(n * n2);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, new int[]{0xFF0000, 65280, 255, -16777216}, null);
        BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, false, null);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, n, n2, null);
        graphics.dispose();
        int[] nArray = dataBufferInt.getData();
        int[] nArray2 = new int[n * n2 + 2];
        nArray2[0] = n;
        nArray2[1] = n2;
        System.arraycopy(nArray, 0, nArray2, 2, n * n2);
        return nArray2;
    }
}

