/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.LayerUI;
import sun.awt.AWTAccessor;

public final class JLayer<V extends Component>
extends JComponent
implements Scrollable,
PropertyChangeListener,
Accessible {
    private V view;
    private LayerUI<? super V> layerUI;
    private JPanel glassPane;
    private long eventMask;
    private transient boolean isPainting;
    private transient boolean isPaintingImmediately;
    private static final LayerEventController eventController = new LayerEventController();

    public JLayer() {
        this(null);
    }

    public JLayer(V v) {
        this(v, new LayerUI());
    }

    public JLayer(V v, LayerUI<V> layerUI) {
        this.setGlassPane(this.createGlassPane());
        this.setView(v);
        this.setUI(layerUI);
    }

    public V getView() {
        return this.view;
    }

    public void setView(V v) {
        V v2 = this.getView();
        if (v2 != null) {
            super.remove((Component)v2);
        }
        if (v != null) {
            super.addImpl((Component)v, null, this.getComponentCount());
        }
        this.view = v;
        this.firePropertyChange("view", v2, v);
        this.revalidate();
        this.repaint();
    }

    public void setUI(LayerUI<? super V> layerUI) {
        this.layerUI = layerUI;
        super.setUI(layerUI);
    }

    public LayerUI<? super V> getUI() {
        return this.layerUI;
    }

    public JPanel getGlassPane() {
        return this.glassPane;
    }

    public void setGlassPane(JPanel jPanel) {
        JPanel jPanel2 = this.getGlassPane();
        boolean bl = false;
        if (jPanel2 != null) {
            bl = jPanel2.isVisible();
            super.remove(jPanel2);
        }
        if (jPanel != null) {
            AWTAccessor.getComponentAccessor().setMixingCutoutShape(jPanel, new Rectangle());
            jPanel.setVisible(bl);
            super.addImpl(jPanel, null, 0);
        }
        this.glassPane = jPanel;
        this.firePropertyChange("glassPane", jPanel2, jPanel);
        this.revalidate();
        this.repaint();
    }

    public JPanel createGlassPane() {
        return new DefaultLayerGlassPane();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager != null) {
            throw new IllegalArgumentException("JLayer.setLayout() not supported");
        }
    }

    @Override
    public void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException("JLayer.setBorder() not supported");
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        throw new UnsupportedOperationException("Adding components to JLayer is not supported, use setView() or setGlassPane() instead");
    }

    @Override
    public void remove(Component component) {
        if (component == null) {
            super.remove(component);
        } else if (component == this.getView()) {
            this.setView(null);
        } else if (component == this.getGlassPane()) {
            this.setGlassPane(null);
        } else {
            super.remove(component);
        }
    }

    @Override
    public void removeAll() {
        if (this.view != null) {
            this.setView(null);
        }
        if (this.glassPane != null) {
            this.setGlassPane(null);
        }
    }

    @Override
    protected boolean isPaintingOrigin() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (!this.isPaintingImmediately && this.getUI() != null) {
            this.isPaintingImmediately = true;
            try {
                this.getUI().paintImmediately(n, n2, n3, n4, this);
            }
            finally {
                this.isPaintingImmediately = false;
            }
        } else {
            super.paintImmediately(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        if (!this.isPainting) {
            this.isPainting = true;
            try {
                super.paintComponent(graphics);
            }
            finally {
                this.isPainting = false;
            }
        } else {
            super.paint(graphics);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.getUI() != null) {
            this.getUI().applyPropertyChange(propertyChangeEvent, this);
        }
    }

    public void setLayerEventMask(long l) {
        long l2 = this.getLayerEventMask();
        this.eventMask = l;
        this.firePropertyChange("layerEventMask", l2, l);
        if (l != l2) {
            this.disableEvents(l2);
            this.enableEvents(this.eventMask);
            if (this.isDisplayable()) {
                JLayer.eventController.updateAWTEventListener(l2, l);
            }
        }
    }

    public long getLayerEventMask() {
        return this.eventMask;
    }

    @Override
    public void updateUI() {
        if (this.getUI() != null) {
            this.getUI().updateUI(this);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getPreferredScrollableViewportSize();
        }
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableBlockIncrement(rectangle, n, n2);
        }
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableTracksViewportHeight();
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableTracksViewportWidth();
        }
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableUnitIncrement(rectangle, n, n2);
        }
        return 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.layerUI != null) {
            this.setUI(this.layerUI);
        }
        if (this.eventMask != 0L) {
            JLayer.eventController.updateAWTEventListener(0L, this.eventMask);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JLayer.eventController.updateAWTEventListener(0L, this.eventMask);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        JLayer.eventController.updateAWTEventListener(this.eventMask, 0L);
    }

    @Override
    public void doLayout() {
        if (this.getUI() != null) {
            this.getUI().doLayout(this);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    private static class DefaultLayerGlassPane
    extends JPanel {
        public DefaultLayerGlassPane() {
            this.setOpaque(false);
        }

        @Override
        public boolean contains(int n, int n2) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                Point point = SwingUtilities.convertPoint(this, new Point(n, n2), component);
                if (!component.isVisible() || !component.contains(point)) continue;
                return true;
            }
            if (this.getMouseListeners().length == 0 && this.getMouseMotionListeners().length == 0 && this.getMouseWheelListeners().length == 0 && !this.isCursorSet()) {
                return false;
            }
            return super.contains(n, n2);
        }
    }

    private static class LayerEventController
    implements AWTEventListener {
        private ArrayList<Long> layerMaskList = new ArrayList();
        private long currentEventMask;
        private static final long ACCEPTED_EVENTS = 231487L;

        private LayerEventController() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                for (Component component = (Component)object; component != null; component = component.getParent()) {
                    JLayer jLayer;
                    LayerUI layerUI;
                    if (!(component instanceof JLayer) || (layerUI = (jLayer = (JLayer)component).getUI()) == null || !this.isEventEnabled(jLayer.getLayerEventMask(), aWTEvent.getID()) || aWTEvent instanceof InputEvent && ((InputEvent)aWTEvent).isConsumed()) continue;
                    layerUI.eventDispatched(aWTEvent, jLayer);
                }
            }
        }

        private void updateAWTEventListener(long l, long l2) {
            if (l != 0L) {
                this.layerMaskList.remove(l);
            }
            if (l2 != 0L) {
                this.layerMaskList.add(l2);
            }
            long l3 = 0L;
            for (Long l4 : this.layerMaskList) {
                l3 |= l4.longValue();
            }
            if ((l3 &= 0x3883FL) == 0L) {
                this.removeAWTEventListener();
            } else if (this.getCurrentEventMask() != l3) {
                this.removeAWTEventListener();
                this.addAWTEventListener(l3);
            }
            this.currentEventMask = l3;
        }

        private long getCurrentEventMask() {
            return this.currentEventMask;
        }

        private void addAWTEventListener(final long l) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(LayerEventController.this, l);
                    return null;
                }
            });
        }

        private void removeAWTEventListener() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(LayerEventController.this);
                    return null;
                }
            });
        }

        private boolean isEventEnabled(long l, int n) {
            return (l & 1L) != 0L && n >= 100 && n <= 103 || (l & 2L) != 0L && n >= 300 && n <= 301 || (l & 4L) != 0L && n >= 1004 && n <= 1005 || (l & 8L) != 0L && n >= 400 && n <= 402 || (l & 0x20000L) != 0L && n == 507 || (l & 0x20L) != 0L && (n == 503 || n == 506) || (l & 0x10L) != 0L && n != 503 && n != 506 && n != 507 && n >= 500 && n <= 507 || (l & 0x800L) != 0L && n >= 1100 && n <= 1101 || (l & 0x8000L) != 0L && n == 1400 || (l & 0x10000L) != 0L && (n == 1401 || n == 1402);
        }
    }
}

