/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;

class GTKStyleFactory
extends SynthStyleFactory {
    private final Map<Object, GTKStyle> stylesCache = new HashMap<Object, GTKStyle>();
    private Font defaultFont;

    GTKStyleFactory() {
    }

    @Override
    public synchronized SynthStyle getStyle(JComponent jComponent, Region region) {
        Object object;
        GTKEngine.WidgetType widgetType = GTKEngine.getWidgetType(jComponent, region);
        Object object2 = null;
        if (region == Region.SCROLL_BAR) {
            if (jComponent != null) {
                object = (JScrollBar)jComponent;
                boolean bl = ((Component)object).getParent() instanceof JScrollPane;
                boolean bl2 = ((JScrollBar)object).getOrientation() == 0;
                boolean bl3 = ((Component)object).getComponentOrientation().isLeftToRight();
                boolean bl4 = ((Component)object).isFocusable();
                object2 = new ComplexKey(widgetType, bl, bl2, bl3, bl4);
            }
        } else if (region == Region.CHECK_BOX || region == Region.RADIO_BUTTON) {
            if (jComponent != null) {
                boolean bl = jComponent.getComponentOrientation().isLeftToRight();
                object2 = new ComplexKey(widgetType, bl);
            }
        } else if (region == Region.BUTTON) {
            if (jComponent != null) {
                object = (JButton)jComponent;
                boolean bl = ((Component)object).getParent() instanceof JToolBar;
                boolean bl5 = ((JButton)object).isDefaultCapable();
                object2 = new ComplexKey(widgetType, bl, bl5);
            }
        } else if (region == Region.MENU && jComponent instanceof JMenu && ((JMenu)jComponent).isTopLevelMenu() && UIManager.getBoolean("Menu.useMenuBarForTopLevelMenus")) {
            widgetType = GTKEngine.WidgetType.MENU_BAR;
        }
        if (object2 == null) {
            object2 = widgetType;
        }
        if ((object = this.stylesCache.get(object2)) == null) {
            object = new GTKStyle(this.defaultFont, widgetType);
            this.stylesCache.put(object2, (GTKStyle)object);
        }
        return object;
    }

    void initStyles(Font font) {
        this.defaultFont = font;
        this.stylesCache.clear();
    }

    private static class ComplexKey {
        private final GTKEngine.WidgetType wt;
        private final Object[] args;

        ComplexKey(GTKEngine.WidgetType widgetType, Object ... objectArray) {
            this.wt = widgetType;
            this.args = objectArray;
        }

        public int hashCode() {
            int n = this.wt.hashCode();
            if (this.args != null) {
                for (Object object : this.args) {
                    n = n * 29 + (object == null ? 0 : object.hashCode());
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComplexKey)) {
                return false;
            }
            ComplexKey complexKey = (ComplexKey)object;
            if (this.wt == complexKey.wt) {
                if (this.args == null && complexKey.args == null) {
                    return true;
                }
                if (this.args != null && complexKey.args != null && this.args.length == complexKey.args.length) {
                    for (int i = 0; i < this.args.length; ++i) {
                        Object object2 = this.args[i];
                        Object object3 = complexKey.args[i];
                        if (object2 != null ? object2.equals(object3) : object3 == null) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            String string = "ComplexKey[wt=" + (Object)((Object)this.wt);
            if (this.args != null) {
                string = string + ",args=[";
                for (int i = 0; i < this.args.length; ++i) {
                    string = string + this.args[i];
                    if (i >= this.args.length - 1) continue;
                    string = string + ",";
                }
                string = string + "]";
            }
            string = string + "]";
            return string;
        }
    }
}

