/*
 * Decompiled with CFR 0.152.
 */
package apple.launcher;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JOptionPane;
import sun.misc.Launcher;
import sun.security.action.LoadLibraryAction;

class JavaAppLauncher
implements Runnable {
    static final String kJavaFailureMainClassNotSpecified = "MainClassNotSpecified";
    static final String kJavaFailureMainClassNotFound = "CannotLoadMainClass";
    static final String kJavaFailureMainClassHasNoMain = "NoMainMethod";
    static final String kJavaFailureMainClassMainNotStatic = "MainNotStatic";
    static final String kJavaFailureMainThrewException = "MainThrewException";
    static final String kJavaFailureMainInitializerException = "MainInitializerException";
    final boolean verbose;
    final Map<String, ?> javaDictionary;

    private static native <T> T nativeConvertAndRelease(long var0);

    private static native void nativeInvokeNonPublic(Class<? extends Method> var0, Method var1, String[] var2);

    static void launch(long l, boolean bl) {
        Map map = (Map)JavaAppLauncher.nativeConvertAndRelease(l);
        new JavaAppLauncher(map, bl).run();
    }

    JavaAppLauncher(Map<String, ?> map, boolean bl) {
        this.verbose = bl;
        this.javaDictionary = map;
    }

    @Override
    public void run() {
        block6: {
            Method method = this.loadMainMethod(this.getMainMethod());
            String string = method.getDeclaringClass().getName() + ".main(String[])";
            try {
                this.log("Calling " + string + " method");
                method.invoke(null, new Object[]{this.getArguments()});
                this.log(string + " has returned");
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    JavaAppLauncher.nativeInvokeNonPublic(method.getClass(), method, this.getArguments());
                }
                catch (Throwable throwable) {
                    JavaAppLauncher.logError(string + " threw an exception:");
                    if (throwable instanceof UnsatisfiedLinkError && throwable.getMessage().equals("nativeInvokeNonPublic")) {
                        JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainThrewException, "nativeInvokeNonPublic not registered");
                        break block6;
                    }
                    throwable.printStackTrace();
                    JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainThrewException, throwable.toString());
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                JavaAppLauncher.logError(string + " threw an exception:");
                invocationTargetException.getTargetException().printStackTrace();
                JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainThrewException, invocationTargetException.getTargetException().toString());
            }
        }
    }

    Method loadMainMethod(String string) {
        try {
            Class<?> clazz = Class.forName(string, true, Launcher.getLauncher().getClassLoader());
            Method method = clazz.getDeclaredMethod("main", String[].class);
            if ((method.getModifiers() & 8) == 0) {
                JavaAppLauncher.logError("The main(String[]) method of class " + string + " is not static!");
                JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainClassMainNotStatic, string);
            }
            return method;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            JavaAppLauncher.logError("The main class \"" + string + "\" had a static initializer throw an exception.");
            exceptionInInitializerError.getException().printStackTrace();
            JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainInitializerException, exceptionInInitializerError.getException().toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            JavaAppLauncher.logError("The main class \"" + string + "\" could not be found.");
            JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainClassNotFound, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            JavaAppLauncher.logError("The main class \"" + string + "\" has no static main(String[]) method.");
            JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainClassHasNoMain, string);
        }
        catch (NullPointerException nullPointerException) {
            JavaAppLauncher.logError("No main class specified");
            JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainClassNotSpecified, null);
        }
        return null;
    }

    String getMainMethod() {
        Object object;
        Object obj = this.javaDictionary.get("Jar");
        if (obj != null) {
            if (!(obj instanceof String)) {
                JavaAppLauncher.logError("'Jar' key in 'Java' sub-dictionary of Info.plist requires a string value");
                return null;
            }
            object = (String)obj;
            if (((String)object).length() == 0) {
                this.log("'Jar' key of sub-dictionary 'Java' of Info.plist key is empty");
            } else {
                String string = this.getMainFromManifest((String)object);
                if (string == null) {
                    JavaAppLauncher.logError("jar file '" + (String)object + "' does not have Main-Class: attribute in its manifest");
                    return null;
                }
                this.log("Main class " + string + " found in jar manifest");
                return string;
            }
        }
        if (!((object = this.javaDictionary.get("MainClass")) instanceof String)) {
            JavaAppLauncher.logError("'MainClass' key in 'Java' sub-dictionary of Info.plist requires a string value");
            return null;
        }
        String string = (String)object;
        if (string.length() == 0) {
            this.log("'MainClass' key of sub-dictionary 'Java' of Info.plist key is empty");
            return null;
        }
        this.log("Main class " + (String)object + " found via 'MainClass' key of sub-dictionary 'Java' of Info.plist key");
        return (String)object;
    }

    String[] getArguments() {
        Object obj = this.javaDictionary.get("Arguments");
        if (obj == null) {
            this.log("No arguments for main(String[]) specified");
            return new String[0];
        }
        if (obj instanceof List) {
            List list = (List)obj;
            int n = list.size();
            this.log("Arguments to main(String[" + n + "]):");
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                if (e instanceof String) {
                    stringArray[i] = (String)e;
                } else {
                    JavaAppLauncher.logError("Found non-string in array");
                }
                this.log("   arg[" + i + "]=" + stringArray[i]);
            }
            return stringArray;
        }
        JavaAppLauncher.logError("'Arguments' key in 'Java' sub-dictionary of Info.plist requires a string value or an array of strings");
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getMainFromManifest(String string) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string2 = attributes.getValue("Main-Class");
            return string2;
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    void log(String string) {
        if (!this.verbose) {
            return;
        }
        System.out.println("[LaunchRunner] " + string);
    }

    static void logError(String string) {
        System.err.println("[LaunchRunner Error] " + string);
    }

    static void showFailureAlertAndKill(String string, String string2) {
        if (string2 == null) {
            string2 = "<<null>>";
        }
        JOptionPane.showMessageDialog(null, JavaAppLauncher.getMessage(string, string2), "", 0);
        System.exit(-1);
    }

    static String getMessage(String string, Object ... objectArray) {
        String string2 = ResourceBundle.getBundle("appLauncherErrors").getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("osx"));
    }
}

