/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import jdk.internal.util.xml.XMLStreamException;

public class XMLWriter {
    private Writer _writer;
    private CharsetEncoder _encoder = null;

    public XMLWriter(OutputStream outputStream, String string, Charset charset) throws XMLStreamException {
        this._encoder = charset.newEncoder();
        try {
            this._writer = this.getWriter(outputStream, string, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XMLStreamException(unsupportedEncodingException);
        }
    }

    public boolean canEncode(char c) {
        if (this._encoder == null) {
            return false;
        }
        return this._encoder.canEncode(c);
    }

    public void write(String string) throws XMLStreamException {
        try {
            this._writer.write(string.toCharArray());
        }
        catch (IOException iOException) {
            throw new XMLStreamException("I/O error", iOException);
        }
    }

    public void write(String string, int n, int n2) throws XMLStreamException {
        try {
            this._writer.write(string, n, n2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException("I/O error", iOException);
        }
    }

    public void write(char[] cArray, int n, int n2) throws XMLStreamException {
        try {
            this._writer.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException("I/O error", iOException);
        }
    }

    void write(int n) throws XMLStreamException {
        try {
            this._writer.write(n);
        }
        catch (IOException iOException) {
            throw new XMLStreamException("I/O error", iOException);
        }
    }

    void flush() throws XMLStreamException {
        try {
            this._writer.flush();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    void close() throws XMLStreamException {
        try {
            this._writer.close();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private void nl() throws XMLStreamException {
        String string = System.getProperty("line.separator");
        try {
            this._writer.write(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException("I/O error", iOException);
        }
    }

    private Writer getWriter(OutputStream outputStream, String string, Charset charset) throws XMLStreamException, UnsupportedEncodingException {
        if (charset != null) {
            return new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), charset);
        }
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), string);
    }
}

