/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XColor
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 12 : 16;
    }

    @Override
    public int getDataSize() {
        return XColor.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XColor(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XColor() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XColor.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public short get_red() {
        log.finest("");
        return Native.getShort(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_red(short s) {
        log.finest("");
        Native.putShort(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), s);
    }

    public short get_green() {
        log.finest("");
        return Native.getShort(this.pData + (long)(XlibWrapper.dataModel == 32 ? 6 : 10));
    }

    public void set_green(short s) {
        log.finest("");
        Native.putShort(this.pData + (long)(XlibWrapper.dataModel == 32 ? 6 : 10), s);
    }

    public short get_blue() {
        log.finest("");
        return Native.getShort(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12));
    }

    public void set_blue(short s) {
        log.finest("");
        Native.putShort(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12), s);
    }

    public byte get_flags() {
        log.finest("");
        return Native.getByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 10 : 14));
    }

    public void set_flags(byte by) {
        log.finest("");
        Native.putByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 10 : 14), by);
    }

    public byte get_pad() {
        log.finest("");
        return Native.getByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 11 : 15));
    }

    public void set_pad(byte by) {
        log.finest("");
        Native.putByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 11 : 15), by);
    }

    @Override
    String getName() {
        return "XColor";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(240);
        stringBuilder.append("pixel = ").append(this.get_pixel()).append(", ");
        stringBuilder.append("red = ").append(this.get_red()).append(", ");
        stringBuilder.append("green = ").append(this.get_green()).append(", ");
        stringBuilder.append("blue = ").append(this.get_blue()).append(", ");
        stringBuilder.append("flags = ").append(this.get_flags()).append(", ");
        stringBuilder.append("pad = ").append(this.get_pad()).append(", ");
        return stringBuilder.toString();
    }
}

