/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.ByteOrder;
import sun.misc.Unsafe;

class NativeObject {
    protected static final Unsafe unsafe = Unsafe.getUnsafe();
    protected long allocationAddress;
    private final long address;
    private static ByteOrder byteOrder = null;
    private static int pageSize = -1;

    NativeObject(long l) {
        this.allocationAddress = l;
        this.address = l;
    }

    NativeObject(long l, long l2) {
        this.allocationAddress = l;
        this.address = l + l2;
    }

    protected NativeObject(int n, boolean bl) {
        if (!bl) {
            this.address = this.allocationAddress = unsafe.allocateMemory(n);
        } else {
            long l;
            int n2 = NativeObject.pageSize();
            this.allocationAddress = l = unsafe.allocateMemory(n + n2);
            this.address = l + (long)n2 - (l & (long)(n2 - 1));
        }
    }

    long address() {
        return this.address;
    }

    long allocationAddress() {
        return this.allocationAddress;
    }

    NativeObject subObject(int n) {
        return new NativeObject((long)n + this.address);
    }

    NativeObject getObject(int n) {
        long l = 0L;
        switch (NativeObject.addressSize()) {
            case 8: {
                l = unsafe.getLong((long)n + this.address);
                break;
            }
            case 4: {
                l = unsafe.getInt((long)n + this.address) & 0xFFFFFFFF;
                break;
            }
            default: {
                throw new InternalError("Address size not supported");
            }
        }
        return new NativeObject(l);
    }

    void putObject(int n, NativeObject nativeObject) {
        switch (NativeObject.addressSize()) {
            case 8: {
                this.putLong(n, nativeObject.address);
                break;
            }
            case 4: {
                this.putInt(n, (int)(nativeObject.address & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            default: {
                throw new InternalError("Address size not supported");
            }
        }
    }

    final byte getByte(int n) {
        return unsafe.getByte((long)n + this.address);
    }

    final void putByte(int n, byte by) {
        unsafe.putByte((long)n + this.address, by);
    }

    final short getShort(int n) {
        return unsafe.getShort((long)n + this.address);
    }

    final void putShort(int n, short s) {
        unsafe.putShort((long)n + this.address, s);
    }

    final char getChar(int n) {
        return unsafe.getChar((long)n + this.address);
    }

    final void putChar(int n, char c) {
        unsafe.putChar((long)n + this.address, c);
    }

    final int getInt(int n) {
        return unsafe.getInt((long)n + this.address);
    }

    final void putInt(int n, int n2) {
        unsafe.putInt((long)n + this.address, n2);
    }

    final long getLong(int n) {
        return unsafe.getLong((long)n + this.address);
    }

    final void putLong(int n, long l) {
        unsafe.putLong((long)n + this.address, l);
    }

    final float getFloat(int n) {
        return unsafe.getFloat((long)n + this.address);
    }

    final void putFloat(int n, float f) {
        unsafe.putFloat((long)n + this.address, f);
    }

    final double getDouble(int n) {
        return unsafe.getDouble((long)n + this.address);
    }

    final void putDouble(int n, double d) {
        unsafe.putDouble((long)n + this.address, d);
    }

    static int addressSize() {
        return unsafe.addressSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ByteOrder byteOrder() {
        if (byteOrder != null) {
            return byteOrder;
        }
        long l = unsafe.allocateMemory(8L);
        try {
            unsafe.putLong(l, 72623859790382856L);
            byte by = unsafe.getByte(l);
            switch (by) {
                case 1: {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    return byteOrder;
                }
                case 8: {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                    return byteOrder;
                }
                default: {
                    assert (false);
                    return byteOrder;
                }
            }
        }
        finally {
            unsafe.freeMemory(l);
        }
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = unsafe.pageSize();
        }
        return pageSize;
    }
}

