/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationService;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupportMBean;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.Role;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;

public class RelationSupport
implements RelationSupportMBean,
MBeanRegistration {
    private String myRelId = null;
    private ObjectName myRelServiceName = null;
    private MBeanServer myRelServiceMBeanServer = null;
    private String myRelTypeName = null;
    private final Map<String, Role> myRoleName2ValueMap = new HashMap<String, Role>();
    private final AtomicBoolean myInRelServFlg = new AtomicBoolean();

    public RelationSupport(String string, ObjectName objectName, String string2, RoleList roleList) throws InvalidRoleValueException, IllegalArgumentException {
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "RelationSupport");
        this.initMembers(string, objectName, null, string2, roleList);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "RelationSupport");
    }

    public RelationSupport(String string, ObjectName objectName, MBeanServer mBeanServer, String string2, RoleList roleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (mBeanServer == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "RelationSupport");
        this.initMembers(string, objectName, mBeanServer, string2, roleList);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "RelationSupport");
    }

    @Override
    public List<ObjectName> getRole(String string) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "getRole", string);
        List list = (List)Util.cast(this.getRoleInt(string, false, null, false));
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "getRole");
        return list;
    }

    @Override
    public RoleResult getRoles(String[] stringArray) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (stringArray == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "getRoles");
        RoleResult roleResult = this.getRolesInt(stringArray, false, null);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "getRoles");
        return roleResult;
    }

    @Override
    public RoleResult getAllRoles() throws RelationServiceNotRegisteredException {
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "getAllRoles");
        RoleResult roleResult = null;
        try {
            roleResult = this.getAllRolesInt(false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "getAllRoles");
        return roleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleList retrieveAllRoles() {
        RoleList roleList;
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "retrieveAllRoles");
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            roleList = new RoleList((List<Role>)new ArrayList<Role>(this.myRoleName2ValueMap.values()));
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "retrieveAllRoles");
        return roleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getRoleCardinality(String string) throws IllegalArgumentException, RoleNotFoundException {
        Role role;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "getRoleCardinality", string);
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            role = this.myRoleName2ValueMap.get(string);
        }
        if (role == null) {
            int n = 1;
            try {
                RelationService.throwRoleProblemException(n, string);
            }
            catch (InvalidRoleValueException invalidRoleValueException) {
                // empty catch block
            }
        }
        List<ObjectName> list = role.getRoleValue();
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "getRoleCardinality");
        return list.size();
    }

    @Override
    public void setRole(Role role) throws IllegalArgumentException, RoleNotFoundException, RelationTypeNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (role == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "setRole", role);
        Object object = this.setRoleInt(role, false, null, false);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "setRole");
    }

    @Override
    public RoleResult setRoles(RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (roleList == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "setRoles", roleList);
        RoleResult roleResult = this.setRolesInt(roleList, false, null);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "setRoles");
        return roleResult;
    }

    @Override
    public void handleMBeanUnregistration(ObjectName objectName, String string) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (objectName == null || string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "handleMBeanUnregistration", new Object[]{objectName, string});
        this.handleMBeanUnregistrationInt(objectName, string, false, null);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "handleMBeanUnregistration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ObjectName, List<String>> getReferencedMBeans() {
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "getReferencedMBeans");
        HashMap<ObjectName, List<String>> hashMap = new HashMap<ObjectName, List<String>>();
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            for (Role role : this.myRoleName2ValueMap.values()) {
                String string = role.getRoleName();
                List<ObjectName> list = role.getRoleValue();
                for (ObjectName objectName : list) {
                    ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(objectName);
                    boolean bl = false;
                    if (arrayList == null) {
                        bl = true;
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string);
                    if (!bl) continue;
                    hashMap.put(objectName, arrayList);
                }
            }
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "getReferencedMBeans");
        return hashMap;
    }

    @Override
    public String getRelationTypeName() {
        return this.myRelTypeName;
    }

    @Override
    public ObjectName getRelationServiceName() {
        return this.myRelServiceName;
    }

    @Override
    public String getRelationId() {
        return this.myRelId;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.myRelServiceMBeanServer = mBeanServer;
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public Boolean isInRelationService() {
        return this.myInRelServFlg.get();
    }

    @Override
    public void setRelationServiceManagementFlag(Boolean bl) throws IllegalArgumentException {
        if (bl == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        this.myInRelServFlg.set(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getRoleInt(String string, boolean bl, RelationService relationService, boolean bl2) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        Role role;
        if (string == null || bl && relationService == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "getRoleInt", string);
        int n = 0;
        Serializable serializable = this.myRoleName2ValueMap;
        synchronized (serializable) {
            role = this.myRoleName2ValueMap.get(string);
        }
        if (role == null) {
            n = 1;
        } else {
            if (bl) {
                try {
                    serializable = relationService.checkRoleReading(string, this.myRelTypeName);
                }
                catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                    throw new RuntimeException(relationTypeNotFoundException.getMessage());
                }
            }
            Object[] objectArray = new Object[]{string, this.myRelTypeName};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
            try {
                serializable = (Integer)this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "checkRoleReading", objectArray, stringArray);
            }
            catch (MBeanException mBeanException) {
                throw new RuntimeException("incorrect relation type");
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
            }
            n = (Integer)serializable;
        }
        if (n == 0) {
            serializable = !bl2 ? new ArrayList<ObjectName>(role.getRoleValue()) : (Role)role.clone();
        } else {
            if (!bl2) {
                try {
                    RelationService.throwRoleProblemException(n, string);
                    return null;
                }
                catch (InvalidRoleValueException invalidRoleValueException) {
                    throw new RuntimeException(invalidRoleValueException.getMessage());
                }
            }
            serializable = new RoleUnresolved(string, null, n);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "getRoleInt");
        return serializable;
    }

    RoleResult getRolesInt(String[] stringArray, boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (stringArray == null || bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "getRolesInt");
        RoleList roleList = new RoleList();
        RoleUnresolvedList roleUnresolvedList = new RoleUnresolvedList();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i];
            try {
                object = this.getRoleInt(string, bl, relationService, true);
            }
            catch (RoleNotFoundException roleNotFoundException) {
                return null;
            }
            if (object instanceof Role) {
                try {
                    roleList.add((Role)object);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException.getMessage());
                }
            }
            if (!(object instanceof RoleUnresolved)) continue;
            try {
                roleUnresolvedList.add((RoleUnresolved)object);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException.getMessage());
            }
        }
        RoleResult roleResult = new RoleResult(roleList, roleUnresolvedList);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "getRolesInt");
        return roleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RoleResult getAllRolesInt(boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "getAllRolesInt");
        String[] stringArray = this.myRoleName2ValueMap;
        synchronized (this.myRoleName2ValueMap) {
            ArrayList<String> arrayList = new ArrayList<String>(this.myRoleName2ValueMap.keySet());
            // ** MonitorExit[var4_5] (shouldn't be in output)
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            RoleResult roleResult = this.getRolesInt(stringArray, bl, relationService);
            ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "getAllRolesInt");
            return roleResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object setRoleInt(Role role, boolean bl, RelationService relationService, boolean bl2) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        Object[] objectArray;
        Serializable serializable;
        Boolean bl3;
        Role role2;
        if (role == null || bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "setRoleInt", new Object[]{role, bl, relationService, bl2});
        String string = role.getRoleName();
        int n = 0;
        ArrayList<ObjectName> arrayList = this.myRoleName2ValueMap;
        synchronized (arrayList) {
            role2 = this.myRoleName2ValueMap.get(string);
        }
        if (role2 == null) {
            bl3 = true;
            arrayList = new ArrayList<ObjectName>();
        } else {
            bl3 = false;
            arrayList = role2.getRoleValue();
        }
        try {
            if (bl) {
                serializable = relationService.checkRoleWriting(role, this.myRelTypeName, bl3);
            } else {
                objectArray = new Object[]{role, this.myRelTypeName, bl3};
                String[] stringArray = new String[]{"javax.management.relation.Role", "java.lang.String", "java.lang.Boolean"};
                serializable = (Integer)this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "checkRoleWriting", objectArray, stringArray);
            }
            n = serializable;
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RelationTypeNotFoundException) {
                throw (RelationTypeNotFoundException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (RelationTypeNotFoundException relationTypeNotFoundException) {
            throw new RuntimeException(relationTypeNotFoundException.getMessage());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
        }
        serializable = null;
        if (n == 0) {
            if (!bl3.booleanValue()) {
                this.sendRoleUpdateNotification(role, arrayList, bl, relationService);
                this.updateRelationServiceMap(role, arrayList, bl, relationService);
            }
            objectArray = this.myRoleName2ValueMap;
            synchronized (objectArray) {
                this.myRoleName2ValueMap.put(string, (Role)role.clone());
            }
            if (bl2) {
                serializable = role;
            }
        } else {
            if (!bl2) {
                RelationService.throwRoleProblemException(n, string);
                return null;
            }
            serializable = new RoleUnresolved(string, role.getRoleValue(), n);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "setRoleInt");
        return serializable;
    }

    private void sendRoleUpdateNotification(Role role, List<ObjectName> list, boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (role == null || list == null || bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "sendRoleUpdateNotification", new Object[]{role, list, bl, relationService});
        if (bl) {
            try {
                relationService.sendRoleUpdateNotification(this.myRelId, role, list);
            }
            catch (RelationNotFoundException relationNotFoundException) {
                throw new RuntimeException(relationNotFoundException.getMessage());
            }
        }
        Object[] objectArray = new Object[]{this.myRelId, role, list};
        String[] stringArray = new String[]{"java.lang.String", "javax.management.relation.Role", "java.util.List"};
        try {
            this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "sendRoleUpdateNotification", objectArray, stringArray);
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RelationNotFoundException) {
                throw (RelationNotFoundException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "sendRoleUpdateNotification");
    }

    private void updateRelationServiceMap(Role role, List<ObjectName> list, boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (role == null || list == null || bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "updateRelationServiceMap", new Object[]{role, list, bl, relationService});
        if (bl) {
            try {
                relationService.updateRoleMap(this.myRelId, role, list);
            }
            catch (RelationNotFoundException relationNotFoundException) {
                throw new RuntimeException(relationNotFoundException.getMessage());
            }
        }
        Object[] objectArray = new Object[]{this.myRelId, role, list};
        String[] stringArray = new String[]{"java.lang.String", "javax.management.relation.Role", "java.util.List"};
        try {
            this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "updateRoleMap", objectArray, stringArray);
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RelationNotFoundException) {
                throw (RelationNotFoundException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "updateRelationServiceMap");
    }

    RoleResult setRolesInt(RoleList roleList, boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (roleList == null || bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "setRolesInt", new Object[]{roleList, bl, relationService});
        RoleList roleList2 = new RoleList();
        RoleUnresolvedList roleUnresolvedList = new RoleUnresolvedList();
        for (Role role : roleList.asList()) {
            Object object = null;
            try {
                object = this.setRoleInt(role, bl, relationService, true);
            }
            catch (RoleNotFoundException roleNotFoundException) {
            }
            catch (InvalidRoleValueException invalidRoleValueException) {
                // empty catch block
            }
            if (object instanceof Role) {
                try {
                    roleList2.add((Role)object);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException.getMessage());
                }
            }
            if (!(object instanceof RoleUnresolved)) continue;
            try {
                roleUnresolvedList.add((RoleUnresolved)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException.getMessage());
            }
        }
        RoleResult roleResult = new RoleResult(roleList2, roleUnresolvedList);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "setRolesInt");
        return roleResult;
    }

    private void initMembers(String string, ObjectName objectName, MBeanServer mBeanServer, String string2, RoleList roleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (string == null || objectName == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "initMembers", new Object[]{string, objectName, mBeanServer, string2, roleList});
        this.myRelId = string;
        this.myRelServiceName = objectName;
        this.myRelServiceMBeanServer = mBeanServer;
        this.myRelTypeName = string2;
        this.initRoleMap(roleList);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "initMembers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRoleMap(RoleList roleList) throws InvalidRoleValueException {
        if (roleList == null) {
            return;
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "initRoleMap", roleList);
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            for (Role role : roleList.asList()) {
                String string = role.getRoleName();
                if (this.myRoleName2ValueMap.containsKey(string)) {
                    StringBuilder stringBuilder = new StringBuilder("Role name ");
                    stringBuilder.append(string);
                    stringBuilder.append(" used for two roles.");
                    throw new InvalidRoleValueException(stringBuilder.toString());
                }
                this.myRoleName2ValueMap.put(string, (Role)role.clone());
            }
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "initRoleMap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMBeanUnregistrationInt(ObjectName objectName, String string, boolean bl, RelationService relationService) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        Role role;
        if (objectName == null || string == null || bl && relationService == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).entering(RelationSupport.class.getName(), "handleMBeanUnregistrationInt", new Object[]{objectName, string, bl, relationService});
        Object object = this.myRoleName2ValueMap;
        synchronized (object) {
            role = this.myRoleName2ValueMap.get(string);
        }
        if (role == null) {
            object = new StringBuilder();
            String string3 = "No role with name ";
            ((StringBuilder)object).append(string3);
            ((StringBuilder)object).append(string);
            throw new RoleNotFoundException(((StringBuilder)object).toString());
        }
        object = role.getRoleValue();
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>((Collection<ObjectName>)object);
        arrayList.remove(objectName);
        Role role2 = new Role(string, arrayList);
        Object object2 = this.setRoleInt(role2, bl, relationService, false);
        ((Logger)((Object)JmxProperties.RELATION_LOGGER)).exiting(RelationSupport.class.getName(), "handleMBeanUnregistrationInt");
    }
}

