/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

public interface Line
extends AutoCloseable {
    public Info getLineInfo();

    public void open() throws LineUnavailableException;

    @Override
    public void close();

    public boolean isOpen();

    public Control[] getControls();

    public boolean isControlSupported(Control.Type var1);

    public Control getControl(Control.Type var1);

    public void addLineListener(LineListener var1);

    public void removeLineListener(LineListener var1);

    public static class Info {
        private final Class lineClass;

        public Info(Class<?> clazz) {
            this.lineClass = clazz == null ? Line.class : clazz;
        }

        public Class<?> getLineClass() {
            return this.lineClass;
        }

        public boolean matches(Info info) {
            if (!this.getClass().isInstance(info)) {
                return false;
            }
            return this.getLineClass().isAssignableFrom(info.getLineClass());
        }

        public String toString() {
            String string = "javax.sound.sampled.";
            String string2 = new String(this.getLineClass().toString());
            int n = string2.indexOf(string);
            String string3 = n != -1 ? string2.substring(0, n) + string2.substring(n + string.length(), string2.length()) : string2;
            return string3;
        }
    }
}

